/**************************************************************************** 
** File: pptp.c
**
** Author: Mike Borella
**
** Comments: Dump PPTP information
**
** $Id: pptp.c,v 1.2 2000/08/17 00:54:39 mborella Exp $
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Library General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "global.h"
#include "protocols.h"

extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_pptp()
**
** Parse PPTP header and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_pptp(packet_t *pkt)
{
  pptp_generic_header_t pptp;
  /* char holder[64]; */

  /*
   * Get the generic header
   */

  if (get_packet_bytes((u_int8_t *) &pptp, pkt, sizeof(pptp_generic_header_t))
      == 0)
    return;

  /* 
   * Conversions
   */

  pptp.length = ntohs(pptp.length);
  pptp.pptp_msg_type = ntohs(pptp.pptp_msg_type);
  pptp.cookie = ntohl(pptp.cookie);
  pptp.control_msg_type = ntohs(pptp.control_msg_type);
  pptp.reserved0 = ntohs(pptp.reserved0);

  /*
   * Minimal mode
   */

  if (my_args->m && !my_args->n)
    {
      display_minimal_string("PPTP ");
    }
  else 
    if (!my_args->n)
      {  
	/* announcement */
	display_header_banner("PPTP Header");
	
	/* dump fields */
      }

  return;
}
