/**************************************************************************** 
** File: sdp.c
**
** Author: Mike Borella
**
** Comments: Dump SDP header information. Like SIP, we just dump the 
** Header contents in plaintext.
**
** Maybe we'll try to "decode" these headers into something intelligble 
** later...
**
*****************************************************************************/

#include <stdio.h>
#include "global.h"

#define LINE_SIZE 256

extern u_char *packet_end;

/*----------------------------------------------------------------------------
**
** dump_sdp()
**
** Parse SDP and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_sdp(packet_t *pkt)
{
  char line[LINE_SIZE];
  int len;

  /* announcement */
  display_header_banner("SDP");

  /* get each line one at a time */
  while(1)
    {
      len = get_packet_line(line, LINE_SIZE, pkt);
      if (len == 0)
	break;
      display("Header", (u_int8_t *) line, len, DISP_STRING);
    }  
}

