/**************************************************************************** 
** File: strmap.c
**
** Author: Mike Borella
**
** Comments: Map IANA numbers to string
**
*****************************************************************************/

#include <stdio.h>
#include "strmap.h"

/*----------------------------------------------------------------------------
**
** map2str()
**
** Convert an IANA protocol number to a descriptive string.  This process
** is slow, so maybe we shouldn't do it in "fast mode"...whatever that may 
** become.
**
** Returns the target string, or "unknown" if we don't find the target.
**
**----------------------------------------------------------------------------
*/

inline char * map2str(strmap_t *sm, u_int32_t index)
{
  int i = 0;

  while(strlen(sm[i].string) != 0)
    {
      if (sm[i].number == index)
	return sm[i].string;
      i++;
    }
  
  return "unknown";
}
