/**************************************************************************** 
** File: strmap.h
**
** Author: Mike Borella
**
** Comments: Header file for mapping IANA numbers to strings
**
*****************************************************************************/

#ifndef STRMAP_H
#define STRMAP_H

#include <sys/types.h>
#include "global.h"

/*
 * This is a way of converting an IANA assigned "protocol number" to a string
 */

typedef struct strmap
{
  u_int32_t number;
  char * string;
} strmap_t;


char * map2str(strmap_t *, u_int32_t);

#endif
