/**************************************************************************** 
** File: udp.h
**
** Author: Mike Borella
**
** Comments: Generic UDP header structure - an attempt at OS independence
**
** $Id: udp.h,v 1.3 2000/08/17 00:54:39 mborella Exp $
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Library General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef UDP_H
#define UDP_H

#include "global.h"

#define L2TP_PORT 1701
#define DHCP_CLIENT_PORT 68
#define DHCP_SERVER_PORT 67
#define SIP_PORT 5060
#define RIP_PORT 520
#define ISAKMP_PORT 500

typedef struct udp_header
{
  u_int16_t src;
  u_int16_t dst;
  u_int16_t length;
  u_int16_t checksum;
} udp_header_t;

void dump_udp(packet_t *);

#endif
