/**************************************************************************** 
** File: isakmp.h
**
** Author: Mike Borella
**
** Comments: Structure of ISAKMP packets
**
** $Id: isakmp.h,v 1.3 2000/08/30 20:23:04 mborella Exp $
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Library General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef ISAKMP_H
#define ISAKMP_H

#include "global.h"
#include "local.h"

#define DOI_IPSEC 1


/*
 * Situation definitions for IPSEC DOI
 */

#define SIT_IDENTITY_ONLY 0x01
#define SIT_SECRECY       0x02
#define SIT_INTEGRITY     0x04


/*
 * Static part of ISAKMP header
 */

typedef struct _ISAKMPHdr
{
  char i_cookie[8];
  char r_cookie[8];
#if defined(WORDS_BIGENDIAN)
  u_int32_t flags:8,
            exchange_type:8,
            min_version:4,
            maj_version:4,
            next_payload:8;
#else
  u_int32_t next_payload:8,
            maj_version:4,
            min_version:4,
            exchange_type:8,
            flags:8;
#endif
  u_int32_t msg_id;
  u_int32_t length;
  
} ISAKMPHdr;

/*
 * ISAKMP Generic Payload Header
 */

typedef struct _ISAKMP_generic_hdr
{
#if defined(WORDS_BIGENDIAN)
  u_int32_t length:16,
            reserved:8,
            next_payload:8;
#else
  u_int32_t next_payload:8,
            reserved:8,
            length:16;
#endif
} ISAKMP_generic_hdr;


void dump_isakmp(u_char *bp, int length);

#endif
