/**************************************************************************** 
**
** File: loopback.c
**
** Author: Mike Borella
**
** Comments: Dump loopback packets
**
** $Id: loopback.c,v 1.3 2000/09/27 19:27:29 mborella Exp $
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Library General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "global.h"
#include "ip_protocols.h"

#define LOOPBACK_FAMILY_INET 524288 /* magic cookie for IP over loopback */

extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_loopback()
**
** Process packets from DLT_NULL device
**
**----------------------------------------------------------------------------
*/

void dump_loopback(packet_t *pkt)
{
  u_int32_t family;

  if (get_packet_bytes((u_int8_t *) &family, pkt, 4) == 0)
    return;

  /* 
   * Dump header 
   */

  if (!my_args->l)
    {
      if (my_args->m)
	{
	  display_minimal_string("LOOPBACK ");
	}
      else
	{
	  /*
	   * Dump header announcement
	   */
	  
	  display_header_banner_ts("Loopback", pkt->timestamp);

	  /*
	   * Dump header field
	   */
  
	  display("Address family", (u_int8_t *) &family, 4, DISP_HEX);
	}

    }

  switch (family)
    {
    case LOOPBACK_FAMILY_INET:
      dump_ip(pkt);
      break;
    default:
      break;
    }

  return;

}

