/******************************************************************************
**
** parse_cl.c
**
** Wed Aug 16 13:53:45 2000
** Linux 2.2.15 (#1 Mon May 29 15:35:00 CDT 2000) i686
** mborella@stratos (Mike Borella)
**
** C file for command line parser
**
** Automatically created by genparse v0.4
**
** See http://www.borella.net/mike/ for details and updates
**
******************************************************************************/

#include <string.h>
#include <malloc.h>
#include <unistd.h>
#include <stdlib.h>
#include <getopt.h>
#include "parse_cl.h"

/*----------------------------------------------------------------------------
**
** usage()
**
** Print out usage information, then exit
**
**--------------------------------------------------------------------------*/

void usage(char *executable)
{
  printf("usage: %s [ -cibplntmxhqv ] \n", executable);
  printf("  [ -c ] ");
  printf("[ --count  ] ");
  printf("Exit after receiving 'count' packets ");
  printf("\n");
  printf("  [ -i ] ");
  printf("[ --interface  ] ");
  printf("Listen on interface 'interface' ");
  printf("\n");
  printf("  [ -b ] ");
  printf("Make stdout buffered ");
  printf("\n");
  printf("  [ -p ] ");
  printf("Dump packet payloads ");
  printf("\n");
  printf("  [ -l ] ");
  printf("Don't print link-layer headers ");
  printf("\n");
  printf("  [ -n ] ");
  printf("Don't print network-layer headers ");
  printf("\n");
  printf("  [ -t ] ");
  printf("Don't print transport-layer headers ");
  printf("\n");
  printf("  [ -m ] ");
  printf("Minimal output ");
  printf("\n");
  printf("  [ -x ] ");
  printf("hex dump of each field ");
  printf("\n");
  printf("  [ -h ] ");
  printf("[ --help  ] ");
  printf("Display help information. ");
  printf(" (default = 0)");
  printf("\n");
  printf("  [ -q ] ");
  printf("[ --quiet  ] ");
  printf("Quiet mode - no on screen output. ");
  printf(" (default = 0)");
  printf("\n");
  printf("  [ -v ] ");
  printf("[ --version  ] ");
  printf("Output version. ");
  printf(" (default = 0)");
  printf("\n");

  exit(1);
}

/*----------------------------------------------------------------------------
**
** free_args()
**
** Call this to free the memory that was dynamically allocated by the parser.
**
**--------------------------------------------------------------------------*/

void free_args(struct arg_t *my_args)
{
  if (my_args->i != NULL) free(my_args->i);
  free(my_args);
}

/*----------------------------------------------------------------------------
**
** Cmdline()
**
** Parse the argv array into the command line structure
**
**--------------------------------------------------------------------------*/

struct arg_t *Cmdline(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int option_index = 0;
  char c;
  struct arg_t *my_args;
  int errflg = 0;

  static struct option long_options[] =
  {
    {"count", 1, 0, 'c'},
    {"interface", 1, 0, 'i'},
    {"", 0, 0, 'b'},
    {"", 0, 0, 'p'},
    {"", 0, 0, 'l'},
    {"", 0, 0, 'n'},
    {"", 0, 0, 't'},
    {"", 0, 0, 'm'},
    {"", 0, 0, 'x'},
    {"help", 0, 0, 'h'},
    {"quiet", 0, 0, 'q'},
    {"version", 0, 0, 'v'},
    {0, 0, 0, 0}
  };

  my_args = (struct arg_t *) malloc (sizeof(struct arg_t));

  my_args->i = NULL;
  my_args->b = false;
  my_args->p = false;
  my_args->l = false;
  my_args->n = false;
  my_args->t = false;
  my_args->m = false;
  my_args->x = false;
  my_args->h = false;
  my_args->q = false;
  my_args->v = false;

  while ((c = getopt_long(argc, argv, "c:i:bplntmxhqv", long_options, &option_index)) != EOF)
    {
      switch(c)
        {
        case 'c': 
          my_args->c = atoi(optarg);
          if (my_args->c < 1)
            {
              fprintf(stderr, "parameter range error: c must be >= 1\n");
              errflg++;
            }
          break;

        case 'i': 
          my_args->i = strdup(optarg);
          break;

        case 'b': 
          my_args->b = true;
          break;

        case 'p': 
          my_args->p = true;
          break;

        case 'l': 
          my_args->l = true;
          break;

        case 'n': 
          my_args->n = true;
          break;

        case 't': 
          my_args->t = true;
          break;

        case 'm': 
          my_args->m = true;
          break;

        case 'x': 
          my_args->x = true;
          break;

        case 'h': 
          my_args->h = true;
          usage(argv[0]);
          break;

        case 'q': 
          my_args->q = true;
          break;

        case 'v': 
          my_args->v = true;
          break;

        default:
          usage(argv[0]);

        }
    } /* while */

  if (errflg)
    usage(argv[0]);

  if (optind >= argc)
    my_args->optind = 0;
  else
    my_args->optind = optind;
  return my_args;
}
