/**************************************************************************** 
** File: payload.c
**
** Author: Mike Borella
**
** Comments: Dump packet payload
**
** $Id: payload.c,v 1.3 2000/08/29 21:59:02 mborella Exp $
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Library General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "global.h"
#include "payload.h"

#define BUF_SIZE 128

extern u_char *packet_end;

/*----------------------------------------------------------------------------
**
** dump_payload()
**
** Dump printable portions of packet payload
**
**----------------------------------------------------------------------------
*/

void dump_payload(packet_t *pkt)
{
  char *buf_ptr, *buf_end;
  int col;
  int i;
  char hexbuf[BUF_SIZE], charbuf[BUF_SIZE];


  printf("-----------------------------------------------------------------\n");

  buf_ptr = pkt->current;
  buf_end = pkt->end;

  do
    {
      col = 0;
      memset(hexbuf, 0, BUF_SIZE);
      memset(charbuf, 0, BUF_SIZE);

      for(i=0;i<16;i++)
	{
	  if(buf_ptr < buf_end)
            {
	      snprintf(hexbuf+(i*3), BUF_SIZE-1,"%.2X ",buf_ptr[0] & 0xFF);
	      
	      if(*buf_ptr > 0x1F && *buf_ptr < 0x7E)
		snprintf(charbuf+i+col, BUF_SIZE-1,"%c",buf_ptr[0]);
	      else
		snprintf(charbuf+i+col, BUF_SIZE-1, ".");
	      
	      buf_ptr++;
            }
	}
      printf("%-48s %s\n",hexbuf,charbuf);
    }
  while(buf_ptr < buf_end);
}
