/**************************************************************************** 
** File: rtp.c
**
** Author: Mike Borella
**
** Comments: Dump RTP header information. 
**
** $Id: rtp.c,v 1.2 2000/08/29 21:59:02 mborella Exp $
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Library General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "global.h"
#include "rtp.h"

/*----------------------------------------------------------------------------
**
** dump_rtp()
**
** Parse RTP packet and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_rtp(u_char *bp, int length)
{
  u_char *ep = bp + length;
  u_char *p;
  rtp_header_t *rtp;
  int i;

  p = bp;

  printf("-----------------------------------------------------------------\n");
  printf("                        RTP Header\n");
  printf("-----------------------------------------------------------------\n");

  rtp = (rtp_header_t *) p;

  printf("Version:                %d\n", (int) rtp->version);
  printf("Padding:                %d\n", (int) rtp->padding);
  printf("Extension:              %d\n", (int) rtp->extension);
  printf("CSRC count:             %d\n", (int) rtp->csrc_count);
  printf("Marker:                 %d\n", (int) rtp->marker);
  printf("Payload type:           %d\n", (int) rtp->payload_type);
  printf("Sequence number:        %d\n", (u_int16_t) rtp->seqno);
  printf("Timestamp:              %d\n", (u_int32_t) rtp->timestamp);
  printf("SSRC:                   %d\n", (u_int32_t) rtp->ssrc);
  p = p + sizeof(rtp_header_t);

  /*
   * Dump contributing sources
   */

  for (i=0; i < rtp->csrc_count; i++)
    {
      printf("CSRC                    %d\n", EXTRACT_32BITS(p));
      p = p + sizeof(u_int32_t);
      if (p > ep) 
	{
	  printf("beyond end of packet\n");
	  return;
	}
    }

}
