/**************************************************************************** 
** File: payload.c
**
** Author: Mike Borella
**
** Comments: Dump packet payload
**
** $Id: payload.c,v 1.5 2001/04/26 23:49:50 mborella Exp $
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Library General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "global.h"
#include "payload.h"

#define PAYLOAD_SIZE  1500
#define BUF_SIZE      128

/*----------------------------------------------------------------------------
**
** dump_payload()
**
** Dump printable portions of packet payload
**
**----------------------------------------------------------------------------
*/

void dump_payload(packet_t *pkt)
{
  int    col;
  int    i;
  char   holder[PAYLOAD_SIZE];
  char   hexbuf[BUF_SIZE];
  char   charbuf[BUF_SIZE];
  char * buf_ptr;
  char * buf_end;
  int    bytes;

  /* display announcement */
  display_header_banner("Payload");

  /* The rest of the packet is payload, so lets grab the whole thing */
  bytes = get_packet_bytesleft(pkt);
  if (bytes <= 0) 
    return;
  if (get_packet_bytes(holder, pkt, bytes) == 0)
    return;

  /* Set the start and end pointers */
  buf_ptr = &holder[0];
  buf_end = &holder[bytes-1];

  /* Scan each subset and display in hex and ascii format */
  do
    {
      col = 0;
      memset(hexbuf, 0, BUF_SIZE);
      memset(charbuf, 0, BUF_SIZE);

      for(i=0;i<16;i++)
	{
	  if(buf_ptr < buf_end)
            {
	      snprintf(hexbuf+(i*3), BUF_SIZE-1,"%.2X ",buf_ptr[0] & 0xFF);
	      
	      if(*buf_ptr > 0x1F && *buf_ptr < 0x7E)
		snprintf(charbuf+i+col, BUF_SIZE-1,"%c",buf_ptr[0]);
	      else
		snprintf(charbuf+i+col, BUF_SIZE-1, ".");
	      
	      buf_ptr++;
            }
	}
      printf("%-48s %s\n",hexbuf,charbuf);
    }
  while(buf_ptr < buf_end);
}
