/**************************************************************************** 
** File: rtp.h
**
** Author: Mike Borella
**
** Comments: Structure of RTP packets
**
** $Id: rtp.h,v 1.3 2000/08/30 20:23:04 mborella Exp $
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Library General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef RTP_H
#define RTP_H

#include "global.h"
#include "local.h"

/*
 * Static part of RTP header
 */

typedef struct rtp_header
{
#if defined(WORDS_BIGENDIAN)
  u_int16_t payload_type:7,
            marker:1,
            csrc_count:4,
            extension:1,
            padding:1,
            version:2;
#else
  u_int16_t version:2,
            padding:1,
            extension:1,
            csrc_count:4,
            marker:1,
            payload_type:7;
#endif
  u_int16_t seqno;
  u_int32_t timestamp;
  u_int32_t ssrc;
  
} rtp_header_t;

#endif

