/**************************************************************************** 
** File: sip.c
**
** Author: Mike Borella
**
** Comments: Dump SIP header information. I didn't try to do anything
** fancy with this - I just dump the plaintext headers.  This makes 
** debugging easier since parsing is such a pain to get right.
**
** $Id: sip.c,v 1.6 2000/08/29 21:59:02 mborella Exp $
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Library General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "global.h"
#include "sip.h"
#include "sdp.h"

#define LINE_SIZE 256
#define FALSE 0
#define TRUE  1

extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_sip()
**
** Parse SIP packet and dump fields.  This code may be really weak... -MB
**
**----------------------------------------------------------------------------
*/

void dump_sip(packet_t *pkt)
{
  char *ptr;
  char line[LINE_SIZE];
  int use_sdp = FALSE;
  int i;
  int len;
  int seen_nonws;

 /* announcement */
  display_header_banner("SIP");

  while(1)
    {
      len = get_packet_line(line, LINE_SIZE, pkt);
      if (len == 0)
	break;

      /*
       * If we have a line of all whitespace, that's the end of the SIP
       * headers.
       */

      seen_nonws = 0;
      for (i=0; i<strlen(line); i++)
	{
	  if (!isspace(line[i]))
	    {
	      seen_nonws = 1;
	      break;
	    }
	}
      if (seen_nonws == 0)
	break;
	  
      /*
       * Display a header
       */

      display("Header", (u_int8_t *) line, strlen(line), DISP_STRING);

      /*
       * Convert each line to lower case for easier parsing.
       */

      for (i=0; i<strlen(line); i++)
	line[i] = tolower(line[i]);

      if (!my_args->m)
	{    
	  if (!strncmp("content-type", line, 12))
	    {
	      ptr = &line[14];
	      while(isspace(*ptr)) 
		ptr++;
	      
	      if (!strncmp("application/sdp", ptr, 15))
		use_sdp = TRUE;
	    }
	}
    }
  
  if (use_sdp)
    dump_sdp(pkt);
}

