#ifndef TARANIS_H_INCLUDED
#define TARANIS_H_INCLUDED

/* Structures and definitions */
enum {
  FALSE = 0,
  TRUE = 1,
  PROMISC = 1,
  ETHERSNAPLEN = 1514,
  POP_PORT = 110,
  IMAP_PORT = 143,
  OSYN = 0xdeadbeef

};

/* pseudo header, for tcp checksum computation */
struct pseudoheader {
  u_int32_t sip;
  u_int32_t dip;
  u_int8_t  protocol[2];
  u_int16_t len;
};

/* Declarations */
void               print_usage(char *name);
char              *ip_ntoa(unsigned long ip);
char              *ether_ntoa(struct ether_addr *addr);
struct ether_addr *ether_aton(char *addr);
struct ether_addr *get_ether_addr(char *interface);
void               capture(u_char *par, struct pcap_pkthdr *hdr, u_char *data);
void               process_ip(u_char *packet, int len);
void              *spoof(void *arg);
void               send_icmp_request(u_int32_t sip, u_int32_t dip,
                                     struct ether_addr *e_src,
                                     struct ether_addr *e_dst);
void               send_icmp_reply(u_int32_t sip, u_int32_t dip,
                                   struct ether_addr *e_src);
void               send_packet(u_char *packet, int len);
void               send_synack(u_char *packet, int len);
void               send_rst(u_char *packet, int len);
void               send_pop_ok(u_char *packet, int len);
void               send_pop_banner(u_char *packet, int len);
void               send_imap_banner(u_char *packet, int len);
void               save_packet_content(u_int32_t *sip, u_int32_t *dip,
                                       u_int16_t sp, u_int16_t dp,
                                       u_char *data, int len);
u_int16_t          jpw_tcp_cksum(u_char *packet, int len, int offset);

#endif /* TARANIS_H_INCLUDED */
