/* Driver's definitions.

Copyright (C) 1999 Politecnico di Torino

This file is part of the NDIS Packet capture driver.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  
*/

#define MAX_PACKET_LENGTH 1514

struct timeval {
        long    tv_sec;         /* seconds */
        long    tv_usec;        /* and microseconds */
};

//OID definitions
#define OID_GEN_CURRENT_LOOKAHEAD		   		0x0001010F
//IOCTLs
#define	 BIOCSETBUFFERSIZE 9592
#define	 BIOCSETF 9030
#define  BIOCGSTATS 9031

/*
 * Alignment macros.  Packet_WORDALIGN rounds up to the next 
 * even multiple of Packet_ALIGNMENT. 
 */
#define Packet_ALIGNMENT sizeof(int)
#define Packet_WORDALIGN(x) (((x)+(Packet_ALIGNMENT-1))&~(Packet_ALIGNMENT-1))

//from BPF
struct bpf_program {
	UINT bf_len;
	struct bpf_insn *bf_insns;
};

struct bpf_insn {
	USHORT	code;
	UCHAR 	jt;
	UCHAR 	jf;
	int k;
};

struct bpf_hdr {
	struct timeval	bh_tstamp;	/* time stamp */
	UINT	bh_caplen;	/* length of captured portion */
	UINT	bh_datalen;	/* original length of packet */
	USHORT		bh_hdrlen;	/* length of bpf header (this struct
					   plus alignment padding) */
};

#define MAX_BUFFER_SPACE MAX_PACKET_LENGTH+sizeof(struct bpf_hdr)



#define  MAX_REQUESTS   4
#ifdef DEBUG
#define	PACKETASSERT(a)		if( !(a) ) { DbgPrint( "Packet: ASSERTION FAILED!\r\n" ); DbgBreakPoint(); }
#else
#define PACKETASSERT(a)
#endif
struct _PACKET_RESERVED 
{
	LIST_ENTRY	ListElement;
	char*		lpBuffer;
	DWORD		cbBuffer;
	DWORD*		lpcbBytesReturned;
	OVERLAPPED*	lpoOverlapped;
	DWORD		hDevice;
	DWORD		tagProcess;
};
typedef struct _PACKET_RESERVED PACKET_RESERVED, *PPACKET_RESERVED;

struct _INTERNAL_REQUEST 
{
	PACKET_RESERVED Reserved;
   NDIS_REQUEST	 Request;
}; 
typedef struct _INTERNAL_REQUEST INTERNAL_REQUEST, *PINTERNAL_REQUEST;


struct _OPEN_INSTANCE 
{
	LIST_ENTRY			ListElement;
	NDIS_STATUS			Status;
	NDIS_HANDLE			AdapterHandle;
	NDIS_HANDLE			PacketPool;
	NDIS_HANDLE			BufferPool;
	NDIS_HANDLE			BindAdapterContext;
	NDIS_SPIN_LOCK		RcvQSpinLock;
	LIST_ENTRY			RcvList;
	NDIS_SPIN_LOCK	    RequestSpinLock;
	LIST_ENTRY			RequestList;
	NDIS_SPIN_LOCK		ResetSpinLock;
	LIST_ENTRY			ResetIrpList;
	INTERNAL_REQUEST	Requests[MAX_REQUESTS];

	PUCHAR				Buffer;
    NDIS_SPIN_LOCK      BufferLock;
	UINT				Dropped;			
	UINT				Received;
	PUCHAR				bpfprogram;  //pointer to the program for the filter
	UINT				bpfprogramlen; //length of the program
	__int64				StartTime;  
	UINT				Bhead;
	UINT				Btail;
	UINT				BufSize;
	UINT				BLastByte;

}; 

typedef struct _OPEN_INSTANCE OPEN_INSTANCE, *POPEN_INSTANCE;



typedef struct _CURRENT_INSTANCE 
{

	LIST_ENTRY		ListElement;
	OPEN_INSTANCE	Open;
	DWORD			tagProcess;

}CURRENT_INSTANCE,*PCURRENT_INSTANCE;


struct _DEVICE_EXTENSION 
{
	PDRIVER_OBJECT		DriverObject;
	NDIS_HANDLE			NdisProtocolHandle;
	LIST_ENTRY			OpenList;
}; 

typedef struct _DEVICE_EXTENSION DEVICE_EXTENSION, *PDEVICE_EXTENSION;
extern PDEVICE_EXTENSION GlobalDeviceExtension;
#define  ETHERNET_HEADER_LENGTH   14
#define RESERVED(_p) ((PPACKET_RESERVED)((_p)->ProtocolReserved))
#define  TRANSMIT_PACKETS    32
extern void YieldExecution( void );



__int64 QuerySystemTime(void);
LARGE_INTEGER GetDate(void);
void EchoStr(void);


int bpf_validate(struct bpf_insn *f,int len);
UINT bpf_filter(register struct bpf_insn *pc,
				register UCHAR *p,
				UINT wirelen,
				register UINT buflen);

UINT bpf_filter_with_2_buffers(register struct bpf_insn *pc,
							   register UCHAR *p,
							   register UCHAR *pd,
							   register int headersize,
							   UINT wirelen,
							   register UINT buflen);

PLIST_ENTRY
PacketRemoveHeadList(
    IN PLIST_ENTRY pListHead
    );
VOID NDIS_API

PacketOpenAdapterComplete(
    IN NDIS_HANDLE  ProtocolBindingContext,
    IN NDIS_STATUS  Status,
    IN NDIS_STATUS  OpenErrorStatus
    );
VOID NDIS_API
PacketUnbindAdapterComplete(
    IN NDIS_HANDLE  ProtocolBindingContext,
    IN NDIS_STATUS  Status
    );
NDIS_STATUS NDIS_API
Packet_tap(
    IN NDIS_HANDLE ProtocolBindingContext,
    IN NDIS_HANDLE MacReceiveContext,
    IN PVOID HeaderBuffer,
    IN UINT HeaderBufferSize,
    IN PVOID LookAheadBuffer,
    IN UINT LookaheadBufferSize,
    IN UINT PacketSize
    );
VOID NDIS_API
PacketReceiveComplete(
    IN NDIS_HANDLE  ProtocolBindingContext
    );
DWORD
PacketRequest( POPEN_INSTANCE		pOpen,
					DWORD  				FunctionCode,
					DWORD  				dwDDB,
               DWORD					hDevice,
               PDIOCPARAMETERS 	pDiocParms
	);
VOID NDIS_API
PacketRequestComplete(
    IN NDIS_HANDLE   ProtocolBindingContext,
    IN PNDIS_REQUEST pRequest,
    IN NDIS_STATUS   Status
    );
VOID NDIS_API
PacketSendComplete(
    IN NDIS_HANDLE   ProtocolBindingContext,
    IN PNDIS_PACKET  pPacket,
    IN NDIS_STATUS   Status
    );
VOID
PacketReset( PNDIS_STATUS		pStatus,
				 POPEN_INSTANCE	pOpen );
VOID NDIS_API
PacketResetComplete(
    IN NDIS_HANDLE  ProtocolBindingContext,
    IN NDIS_STATUS  Status
    );
VOID NDIS_API
PacketStatus(
    IN NDIS_HANDLE   ProtocolBindingContext,
    IN NDIS_STATUS   Status,
    IN PVOID         StatusBuffer,
    IN UINT          StatusBufferSize
    );
VOID NDIS_API
PacketStatusComplete(
    IN NDIS_HANDLE 	ProtocolBindingContext
    );
VOID
PacketAllocatePacketBuffer( PNDIS_STATUS	pStatus,
						 POPEN_INSTANCE		pOpen,
						 PNDIS_PACKET		*lplpPacket,
						 PDIOCPARAMETERS 	pDiocParms,
						 DWORD				FunctionCode );
VOID NDIS_API
PacketTransferDataComplete(
    IN NDIS_HANDLE	ProtocolBindingContext,
    IN PNDIS_PACKET	Packet,
    IN NDIS_STATUS	Status,
    IN UINT 			BytesTransferred
    );
VOID
PacketRemoveReference(
    IN PDEVICE_EXTENSION DeviceExtension
    );
VOID 
PacketFreeResources( POPEN_INSTANCE Open );
VOID
PacketCleanUp( PNDIS_STATUS	Status,
					POPEN_INSTANCE Open );
NTSTATUS NDIS_API
PacketShutdown(
    IN PDEVICE_OBJECT DeviceObject
    );
VOID NDIS_API
PacketUnload();
VOID NDIS_API
PacketBindAdapter( OUT PNDIS_STATUS Status,
				IN  NDIS_HANDLE  BindAdapterContext,
				IN  PNDIS_STRING AdapterName,
				IN  PVOID        SystemSpecific1,
				IN  PVOID        SystemSpecific2 
				);
VOID NDIS_API
PacketUnbindAdapter( OUT PNDIS_STATUS	Status,
				 IN NDIS_HANDLE	ProtocolBindingContext,
				 IN NDIS_HANDLE	UnbindContext
				 );
DWORD
PacketWrite( POPEN_INSTANCE	Open,
				 DWORD  				dwDDB,
             DWORD  				hDevice,
			  	 PDIOCPARAMETERS	pDiocParms
	);

DWORD
PacketOpen( POPEN_INSTANCE		Open,
				DWORD  				dwDDB,
            DWORD  				hDevice,
			  	PDIOCPARAMETERS   pDiocParms
	);

DWORD
PacketClose( POPEN_INSTANCE		Open,
				DWORD  				dwDDB,
            DWORD  				hDevice,
			  	PDIOCPARAMETERS   pDiocParms
	);


DWORD
PacketRead( POPEN_INSTANCE		Open,
				DWORD  				dwDDB,
            DWORD  				hDevice,
			  	PDIOCPARAMETERS   pDiocParms
	);
DWORD _stdcall PacketIOControl( DWORD  			dwService,
                                DWORD  			dwDDB,
                                DWORD  			hDevice,
                                PDIOCPARAMETERS lpDIOCParms );
void VXDINLINE
VWIN32_DIOCCompletionRoutine( DWORD hEvent )
{
	_asm mov ebx, hEvent
	VxDCall( VWIN32_DIOCCompletionRoutine );
}

ULONG strlen( BYTE *s );
BYTE confronta(BYTE *, BYTE *);
#define strcat( d, s )	NdisMoveMemory( d+strlen(d), s, strlen(s) )
#define memset( _S, _C, _N )\
{\
	UCHAR* _pS = _S;\
	ULONG  _I  = _N;\
	while ( _I-- )\
	{\
		*_pS++ = _C;\
	}\
}

//static POPEN_INSTANCE    Open;
static PCURRENT_INSTANCE InstHead=NULL;
