/* interface DLL for the packet.sys driver 

Copyright (C) 1999 Politecnico di Torino

This file is part of the NDIS Packet capture driver.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.
*/

#define UNICODE 1

#include <windows.h>
#include <windowsx.h>

#include "ntddndis.h"
#include "ntddpack.h"
#include "packet32.h"

//---------------------------------------------------------------------------
TCHAR   szWindowTitle[] = TEXT("PACKET.DLL");

#if DBG
#define ODS(_x) OutputDebugString(TEXT(_x))
#else
#define ODS(_x)
#endif

BOOLEAN StartPacketDriver(LPTSTR ServiceName);

//---------------------------------------------------------------------------
BOOL PacketInit(IN PVOID DllHandle,IN ULONG Reason,IN PCONTEXT Context OPTIONAL)

{
    BOOLEAN     Status;

    ODS("Packet32: DllEntry\n");
    switch ( Reason )
    {
        case DLL_PROCESS_ATTACH:
            Status=StartPacketDriver(TEXT("Packet"));
            break;
        case DLL_PROCESS_DETACH:
            break;
        default:
            break;
    }
    return Status;
}

//---------------------------------------------------------------------------

WCHAR* SChar2WChar(char* nome)
{
	int i;
	WCHAR* TmpName;

	TmpName=(WCHAR*) malloc ((strlen(nome)+2)*sizeof(WCHAR));
	for (i=0;i<(signed)strlen(nome)+1; i++)
		TmpName[i]=nome[i];
	TmpName[i]=0;
	return TmpName;
}

//---------------------------------------------------------------------------
BOOLEAN PacketGetNetType (LPADAPTER AdapterObject,NetType *type)
{
    BOOLEAN    Status;
    ULONG      IoCtlBufferLength=(sizeof(PACKET_OID_DATA)+sizeof(ULONG)-1);
    PPACKET_OID_DATA  OidData;

    OidData=GlobalAllocPtr(GMEM_MOVEABLE | GMEM_ZEROINIT,IoCtlBufferLength);
    if (OidData == NULL) {
        return FALSE;
    }
	//get the link-layer type
    OidData->Oid = OID_GEN_MEDIA_IN_USE;
    OidData->Length = sizeof (ULONG);
    Status = PacketRequest(AdapterObject,FALSE,OidData);
    type->LinkType=*((UINT*)OidData->Data);

	//get the link-layer speed
    OidData->Oid = OID_GEN_LINK_SPEED;
    OidData->Length = sizeof (ULONG);
    Status = PacketRequest(AdapterObject,FALSE,OidData);
	type->LinkSpeed=*((UINT*)OidData->Data)*100;
    GlobalFreePtr (OidData);
    return Status;
}
//---------------------------------------------------------------------------
BOOLEAN PacketSetMaxLookaheadsize (LPADAPTER AdapterObject)
{
    BOOLEAN    Status;
    ULONG      IoCtlBufferLength=(sizeof(PACKET_OID_DATA)+sizeof(ULONG)-1);
    PPACKET_OID_DATA  OidData;

    OidData=GlobalAllocPtr(GMEM_MOVEABLE | GMEM_ZEROINIT,IoCtlBufferLength);
    if (OidData == NULL) {
        return FALSE;
    }

	//set the size of the lookahead buffer to the maximum available by the the NIC driver
    OidData->Oid=OID_GEN_MAXIMUM_LOOKAHEAD;
    OidData->Length=sizeof(ULONG);
    Status=PacketRequest(AdapterObject,FALSE,OidData);
    OidData->Oid=OID_GEN_CURRENT_LOOKAHEAD;
    Status=PacketRequest(AdapterObject,TRUE,OidData);
    GlobalFreePtr(OidData);
    return Status;
}
//---------------------------------------------------------------------------

LPADAPTER PacketOpenAdapter(LPTSTR AdapterName)

{
    LPADAPTER  lpAdapter;
    BOOLEAN    Result;
	char	   *Adaptera,*BkStr;
	int i,ii;

	ODS("Packet32: PacketOpenAdapter\n");

	Adaptera=(char*)AdapterName;
	if(Adaptera[1]==0){ //UNICODE
	    lpAdapter=(LPADAPTER)GlobalAllocPtr(GMEM_MOVEABLE | GMEM_ZEROINIT,sizeof(ADAPTER));
	    if (lpAdapter==NULL)
	    {
	        ODS("Packet32: PacketOpenAdapter GlobalAlloc Failed\n");
	        return NULL;
	    }
	    wsprintf(lpAdapter->SymbolicLink,TEXT("\\\\.\\%s%s"),DOSNAMEPREFIX,&AdapterName[8]);
	    Result=DefineDosDevice(DDD_RAW_TARGET_PATH,&lpAdapter->SymbolicLink[4],AdapterName);
	    if (Result)
	    {
	        lpAdapter->hFile=CreateFile(lpAdapter->SymbolicLink,GENERIC_WRITE | GENERIC_READ,
	                                    0,NULL,CREATE_ALWAYS,FILE_FLAG_OVERLAPPED,0);
	        if (lpAdapter->hFile != INVALID_HANDLE_VALUE)
	     {
			 PacketSetMaxLookaheadsize(lpAdapter);
	         return lpAdapter;
	     }
	    }
	    ODS("Packet32: PacketOpenAdapter Could not open adapter\n");
	    GlobalFreePtr(lpAdapter);
		return NULL;
	}

	else{ //ASCII
		//convert to unicode
		Adaptera=(char*)malloc(128);
		BkStr=(char*)AdapterName;
		i=0;
		ii=0;
		while(BkStr[i]!=0){
			Adaptera[ii]=((char*)BkStr)[i];
			Adaptera[ii+1]=0;
			i++;
			ii+=2;
		}
		Adaptera[ii]=0;
		Adaptera[ii+1]=0;

	    lpAdapter=(LPADAPTER)GlobalAllocPtr(GMEM_MOVEABLE | GMEM_ZEROINIT,sizeof(ADAPTER));
	    if (lpAdapter==NULL)
	    {
	        ODS("Packet32: PacketOpenAdapter GlobalAlloc Failed\n");
	        return NULL;
	    }
	    wsprintf(lpAdapter->SymbolicLink,TEXT("\\\\.\\%s%s"),DOSNAMEPREFIX,&((LPTSTR)Adaptera)[8]);
	    Result=DefineDosDevice(DDD_RAW_TARGET_PATH,&lpAdapter->SymbolicLink[4],(LPTSTR)Adaptera);
	    if (Result)
	    {
	        lpAdapter->hFile=CreateFile(lpAdapter->SymbolicLink,GENERIC_WRITE | GENERIC_READ,
	                                    0,NULL,CREATE_ALWAYS,FILE_FLAG_OVERLAPPED,0);
	        if (lpAdapter->hFile != INVALID_HANDLE_VALUE)
			{
				PacketSetMaxLookaheadsize(lpAdapter);
				return lpAdapter;
	        }
	    }
	    ODS("Packet32: PacketOpenAdapter Could not open adapter\n");
	    GlobalFreePtr(lpAdapter);
		return NULL;

	}
}

//---------------------------------------------------------------------------

VOID PacketCloseAdapter(LPADAPTER lpAdapter)
{
    ODS("Packet32: PacketCloseAdapter\n");
    CloseHandle(lpAdapter->hFile);
    GlobalFreePtr(lpAdapter);
}

//---------------------------------------------------------------------------

LPPACKET PacketAllocatePacket(void)
{

    LPPACKET    lpPacket;
    lpPacket=(LPPACKET)GlobalAllocPtr(GMEM_MOVEABLE | GMEM_ZEROINIT,sizeof(PACKET));
    if (lpPacket==NULL)
    {
        ODS("Packet32: PacketAllocateSendPacket: GlobalAlloc Failed\n");
        return NULL;
    }
    lpPacket->OverLapped.hEvent=CreateEvent(NULL,FALSE,FALSE,NULL);
    if (lpPacket->OverLapped.hEvent==NULL)
    {
        ODS("Packet32: PacketAllocateSendPacket: CreateEvent Failed\n");
        GlobalFreePtr(lpPacket);
        return NULL;
    }
    return lpPacket;
}

//---------------------------------------------------------------------------
VOID PacketFreePacket(LPPACKET lpPacket)

{
    CloseHandle(lpPacket->OverLapped.hEvent);
    GlobalFreePtr(lpPacket);
}

//---------------------------------------------------------------------------

VOID PacketInitPacket(LPPACKET lpPacket,PVOID Buffer,UINT Length)

{
    lpPacket->Buffer = Buffer;
    lpPacket->Length = Length;
	lpPacket->ulBytesReceived = 0;
	lpPacket->bIoComplete = FALSE;
}

//---------------------------------------------------------------------------

BOOLEAN PacketSendPacket(LPADAPTER AdapterObject,LPPACKET lpPacket,BOOLEAN Sync)

{
    BOOLEAN      Result;
    DWORD        BytesTransfered;
    
	lpPacket->OverLapped.Offset=0;
    lpPacket->OverLapped.OffsetHigh=0;
    if (!ResetEvent(lpPacket->OverLapped.hEvent))
    {
        return FALSE;
    }
    Result=WriteFile(AdapterObject->hFile,lpPacket->Buffer,lpPacket->ulBytesReceived,&BytesTransfered,&lpPacket->OverLapped);
    if (Sync)
    {
        //  They want to wait
        Result=GetOverlappedResult(AdapterObject->hFile,&lpPacket->OverLapped,&BytesTransfered,TRUE);
		lpPacket->bIoComplete = Result;
    }
    else
    {
        //  They don't want to wait, they will call PacketWaitPacket to get
        //  The real result
        Result=TRUE;
    }
    return Result;
}


//---------------------------------------------------------------------------

BOOLEAN PacketReceivePacket(LPADAPTER   AdapterObject,LPPACKET lpPacket,BOOLEAN Sync)

{

    BOOLEAN      Result;
    lpPacket->OverLapped.Offset=0;
    lpPacket->OverLapped.OffsetHigh=0;
    if (!ResetEvent(lpPacket->OverLapped.hEvent))
    {
        return FALSE;
    }
    Result=ReadFile(AdapterObject->hFile,lpPacket->Buffer,lpPacket->Length, &lpPacket->ulBytesReceived,&lpPacket->OverLapped);
    if (Sync)
    {
        //  They want to wait
        Result=GetOverlappedResult(AdapterObject->hFile,&lpPacket->OverLapped, &lpPacket->ulBytesReceived,TRUE);
		lpPacket->bIoComplete = Result;
    }
    else
    {
        //  They don't want to wait, they will call PacketWaitPacket to get
        //  The real result
        Result=TRUE;
    }
    return Result;
}

//---------------------------------------------------------------------------
/* This function allows to set the dimension of the packet buffer in the driver
parameters:
dim		dimension of the buffer (kilobytes)
*/

BOOLEAN PacketSetBuff(LPADAPTER AdapterObject,int dim)
{
	int BytesReturned;
    return DeviceIoControl(AdapterObject->hFile,pBIOCSETBUFFERSIZE,&dim,4,NULL,0,&BytesReturned,NULL);
}

//---------------------------------------------------------------------------
/* Function to set a bpf filter in the driver
parameters:
fp		the pointer to the beginning of the filtering program
*/

BOOLEAN PacketSetBpf(LPADAPTER AdapterObject,struct bpf_program *fp)
{
	int BytesReturned;
    return DeviceIoControl(AdapterObject->hFile,pBIOCSETF,(char*)fp->bf_insns,fp->bf_len*sizeof(struct bpf_insn),NULL,0,&BytesReturned,NULL);
}

//---------------------------------------------------------------------------
/* Function to get the number of packet received and dropped from the driver
parameters:
s		structure containig 2 int values that will be filled by the driver
*/

BOOLEAN PacketGetStats(LPADAPTER AdapterObject,struct bpf_stat *s)
{
	int BytesReturned;
    return DeviceIoControl(AdapterObject->hFile,pBIOCGSTATS,NULL,0,s,sizeof(struct bpf_stat),&BytesReturned,NULL);
}

//---------------------------------------------------------------------------

BOOLEAN PacketWaitPacket(LPADAPTER AdapterObject,LPPACKET lpPacket)
{
    lpPacket->bIoComplete = GetOverlappedResult(AdapterObject->hFile,&lpPacket->OverLapped,&lpPacket->ulBytesReceived,TRUE);
	return lpPacket->bIoComplete;
}

//---------------------------------------------------------------------------

BOOLEAN PacketResetAdapter(LPADAPTER  AdapterObject)

{
    UINT       BytesReturned;

    DeviceIoControl(AdapterObject->hFile,(DWORD)IOCTL_PROTOCOL_RESET,NULL,0,NULL,0,&BytesReturned,NULL);
    return TRUE;
}

//---------------------------------------------------------------------------

BOOLEAN PacketRequest(LPADAPTER  AdapterObject,BOOLEAN Set,PPACKET_OID_DATA  OidData)
{
    UINT       BytesReturned;
    BOOLEAN    Result;

    Result=DeviceIoControl(AdapterObject->hFile,(DWORD) Set ? IOCTL_PROTOCOL_SET_OID : IOCTL_PROTOCOL_QUERY_OID,
                           OidData,sizeof(PACKET_OID_DATA)-1+OidData->Length,OidData,
                           sizeof(PACKET_OID_DATA)-1+OidData->Length,&BytesReturned,NULL);
    return Result;
}

//---------------------------------------------------------------------------

BOOLEAN PacketSetHwFilter(LPADAPTER  AdapterObject,ULONG Filter)
{
    BOOLEAN    Status;
    ULONG      IoCtlBufferLength=(sizeof(PACKET_OID_DATA)+sizeof(ULONG)-1);
    PPACKET_OID_DATA  OidData;

    OidData=GlobalAllocPtr(GMEM_MOVEABLE | GMEM_ZEROINIT,IoCtlBufferLength);
    if (OidData == NULL) {
        return FALSE;
    }
    OidData->Oid=OID_GEN_CURRENT_PACKET_FILTER;
    OidData->Length=sizeof(ULONG);
    *((PULONG)OidData->Data)=Filter;
    Status=PacketRequest(AdapterObject,TRUE,OidData);
    GlobalFreePtr(OidData);
    return Status;
}

//---------------------------------------------------------------------------

BOOLEAN StartPacketDriver(LPTSTR ServiceName)
{
    BOOLEAN  Status;
    SC_HANDLE  SCManagerHandle;
    SC_HANDLE  SCServiceHandle;

    /* Open a handle to the SC Manager database. */
    SCManagerHandle = OpenSCManager(
                      NULL,                   /* local machine           */
                      NULL,                   /* ServicesActive database */
                      SC_MANAGER_ALL_ACCESS); /* full access rights      */
    if (SCManagerHandle==NULL)
    {
        MessageBox(NULL,TEXT("Could not open SC"),szWindowTitle,MB_OK);
        return FALSE;
    }
    else
    {
        SCServiceHandle=OpenService(SCManagerHandle,ServiceName,SERVICE_START);

        if (SCServiceHandle == NULL)
        {
            MessageBox(NULL,TEXT("Could not open service"),szWindowTitle,MB_OK);
        }
        Status=StartService(SCServiceHandle,0,NULL);
        if (!Status)
        {
            if (GetLastError()==ERROR_SERVICE_ALREADY_RUNNING) {
                ODS("Packet32: Packet service already started\n");
                return TRUE;
            }
        }
        return Status;
    }
    return FALSE;
}

//---------------------------------------------------------------------------

ULONG PacketGetAdapterNames(PTSTR   pStr,PULONG  BufferSize)
{
    HKEY       SystemKey;
    HKEY       ControlSetKey;
    HKEY       ServicesKey;
    HKEY       NdisPerfKey;
    HKEY       LinkageKey;
    LONG       Status;
    DWORD      RegType;

    Status=RegOpenKeyEx(HKEY_LOCAL_MACHINE,TEXT("SYSTEM"),0,KEY_READ,&SystemKey);
    if (Status == ERROR_SUCCESS)
    {
        Status=RegOpenKeyEx(SystemKey,TEXT("CurrentControlSet"),0,KEY_READ,&ControlSetKey);
        if (Status == ERROR_SUCCESS)
        {
            Status=RegOpenKeyEx(ControlSetKey,TEXT("Services"),0,KEY_READ,&ServicesKey);
            if (Status == ERROR_SUCCESS)
            {
                Status=RegOpenKeyEx(ServicesKey,TEXT("Packet"),0,KEY_READ,&NdisPerfKey);
                if (Status == ERROR_SUCCESS)
                {
                    Status=RegOpenKeyEx(NdisPerfKey,TEXT("Linkage"),0,KEY_READ,&LinkageKey);
                    if (Status == ERROR_SUCCESS)
                    {
                        Status=RegQueryValueEx(LinkageKey,TEXT("Export"),NULL,&RegType,(LPBYTE)pStr,BufferSize);
                        RegCloseKey(LinkageKey);
                    }
                    RegCloseKey(NdisPerfKey);
                }
                RegCloseKey(ServicesKey);
            }
            RegCloseKey(ControlSetKey);
        }
        RegCloseKey(SystemKey);
    }
    if (Status==ERROR_SUCCESS) return TRUE;
	else return FALSE;
}

//---------------------------------------------------------------------------

