/*Copyright (C) 1999 Politecnico di Torino

This file is part of the libpcap library for win32.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.
*/

#ifdef WIN32
#include "../Win32-Include/w32_fzs.h"
#include <stdio.h>
#include <signal.h>


int wsockinit()
{
	WORD wVersionRequested;
	WSADATA wsaData;
	int err;
	wVersionRequested = MAKEWORD( 1, 1); 
	err = WSAStartup( wVersionRequested, &wsaData );
	if ( err != 0 )
	{
	
	if (err==WSASYSNOTREADY) 
		printf("\n Indicates that the underlying network subsystem is not ready for network communication. \n");

	if (err==WSAVERNOTSUPPORTED ) 
		printf("\n The version of Windows Sockets support requested is not provided by this particular Windows Sockets implementation. \n");

	if (err==WSAEINPROGRESS ) 
		printf("\n A blocking Windows Sockets 1.1 operation is in progress. \n");

	if (err==WSAEPROCLIM ) 
		printf("\n Limit on the number of tasks supported by the Windows Sockets implementation has been reached. \n");

	if (err==WSAEFAULT ) 
		printf("\n The lpWSAData is not a valid pointer\n");

	/* Tell the user that we couldn't find a usable */
	/* WinSock DLL.                                 */
		return 1;
	}
	return 0;
}

static WCHAR *TmpName=NULL;

extern char* AdapterName1;


WCHAR* SChar2WChar(char* nome)
{
	int i;
	TmpName=(WCHAR*) malloc ((strlen(nome)+2)*sizeof(WCHAR));
	for (i=0;i<(signed)strlen(nome)+1; i++)
		TmpName[i]=nome[i];
	TmpName[i]=0;
	return TmpName;
}

void PrintDeviceList(const char* device)
{
	DWORD dwVersion;
	DWORD dwWindowsMajorVersion;
	const WCHAR* t;
	const char* t95;
	int i=0;

	dwVersion=GetVersion();
	dwWindowsMajorVersion =  (DWORD)(LOBYTE(LOWORD(dwVersion)));
	if (dwVersion >= 0x80000000 && dwWindowsMajorVersion >= 4)			// Windows '95
	{
		t95=(char*)device;
		while (!(t95[i]==0 && t95[i+1]==0))
		{
			if (t95[i]==0 || t95[i]==' ') putchar('\n');
			else putchar(t95[i]);
			i++;
		}
		putchar('\n');
	}
	
	else{		//Windows NT
		t=(WCHAR*)device;
		while (!(t[i]==0 && t[i+1]==0))
		{
			if (t[i]==0) putchar('\n');
			else putchar(t[i]);
			i++;
		}
		putchar('\n');
	}
}

void PrintCapBegins (char* program_name, char* device)
{
	DWORD dwVersion;
	DWORD dwWindowsMajorVersion;
	int ii,jj;
	char dev[128];

	dwVersion=GetVersion();
	dwWindowsMajorVersion =  (DWORD)(LOBYTE(LOWORD(dwVersion)));
	if (dwVersion >= 0x80000000 && dwWindowsMajorVersion >= 4)			// Windows '95
	{
		for(ii=0,jj=0;ii<128;ii++) 
				if (device[ii]=='\0') break; 
				else if (device[ii]!='\0') {dev[jj]=device[ii];jj++;}
		dev[jj]='\0';
		(void)fprintf(stderr, "%s: listening on %s\n",program_name, dev);
		(void)fflush(stderr);
	}

	else
	{
		for(ii=0,jj=0;ii<128;ii++) 
				if (device[ii]=='\0'&& device[ii+1]=='\0') break; 
				else if (device[ii]!='\0') {dev[jj]=device[ii];jj++;}
		dev[jj]='\0';
		(void)fprintf(stderr, "%s: listening on %s\n",program_name, dev);
		(void)fflush(stderr);
	}
}
#endif
