/*++
THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF
ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.
Copyright (c) 1992-1998  Microsoft Corporation

Module Name:  

netevent.h

Abstract:

    Definitions for network events.

Notes: 


--*/
#ifndef _NETEVENT_
#define _NETEVENT_


/////////////////////////////////////////////////////////////////////////
//
// Lanman Server Events (2000 - 2999)
//     2000-2499 are generated by the server driver (kernel mode)
//     2500-2999 are generated by the server service (user mode)
//
/////////////////////////////////////////////////////////////////////////


// Server driver events, issued from kernel mode.  Don't use %1 for
// server-supplied insertion strings -- the I/O system provides the
// first string.

//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//


//
// Define the severity codes
//
#define STATUS_SEVERITY_WARNING          0x2
#define STATUS_SEVERITY_SUCCESS          0x0
#define STATUS_SEVERITY_INFORMATIONAL    0x1
#define STATUS_SEVERITY_ERROR            0x3


//
// MessageId: EVENT_SRV_SERVICE_FAILED
//
// MessageText:
//
//  The server's call to a system service failed unexpectedly.
//
#define EVENT_SRV_SERVICE_FAILED         0xC00007D0L

//
// MessageId: EVENT_SRV_RESOURCE_SHORTAGE
//
// MessageText:
//
//  The server was unable to perform an operation due to a shortage of available resources.
//
#define EVENT_SRV_RESOURCE_SHORTAGE      0xC00007D1L

//
// MessageId: EVENT_SRV_CANT_CREATE_DEVICE
//
// MessageText:
//
//  The server could not create its device.  The server could not be started.
//
#define EVENT_SRV_CANT_CREATE_DEVICE     0xC00007D2L

//
// MessageId: EVENT_SRV_CANT_CREATE_PROCESS
//
// MessageText:
//
//  The server could not create a process.  The server could not be started.
//
#define EVENT_SRV_CANT_CREATE_PROCESS    0xC00007D3L

//
// MessageId: EVENT_SRV_CANT_CREATE_THREAD
//
// MessageText:
//
//  The server could not create a startup thread.  The server could not be started.
//
#define EVENT_SRV_CANT_CREATE_THREAD     0xC00007D4L

//
// MessageId: EVENT_SRV_UNEXPECTED_DISC
//
// MessageText:
//
//  The server received an unexpected disconnection from a client.
//
#define EVENT_SRV_UNEXPECTED_DISC        0xC00007D5L

//
// MessageId: EVENT_SRV_INVALID_REQUEST
//
// MessageText:
//
//  The server received an incorrectly formatted request from %2.
//
#define EVENT_SRV_INVALID_REQUEST        0xC00007D6L

//
// MessageId: EVENT_SRV_CANT_OPEN_NPFS
//
// MessageText:
//
//  The server could not open the named pipe file system.  Remote named pipes are disabled.
//
#define EVENT_SRV_CANT_OPEN_NPFS         0xC00007D7L

//
// MessageId: EVENT_SRV_CANT_GROW_TABLE
//
// MessageText:
//
//  The server could not expand a table because the table reached the maximum size.
//
#define EVENT_SRV_CANT_GROW_TABLE        0xC00007D9L

//
// MessageId: EVENT_SRV_CANT_START_SCAVENGER
//
// MessageText:
//
//  The server could not start the scavenger thread.  The server could not be started.
//
#define EVENT_SRV_CANT_START_SCAVENGER   0xC00007DAL

//
// MessageId: EVENT_SRV_IRP_STACK_SIZE
//
// MessageText:
//
//  The server's configuration parameter "irpstacksize" is too small for the server to use a local device.  Please increase the value of this parameter.
//
#define EVENT_SRV_IRP_STACK_SIZE         0xC00007DBL

//
// MessageId: EVENT_SRV_NETWORK_ERROR
//
// MessageText:
//
//  The server has encountered a network error.
//
#define EVENT_SRV_NETWORK_ERROR          0xC00007DCL

//
// MessageId: EVENT_SRV_DISK_FULL
//
// MessageText:
//
//  The %2 disk is at or near capacity.  You may need to delete some files.
//
#define EVENT_SRV_DISK_FULL              0x800007DDL

//
// MessageId: EVENT_SRV_NO_VIRTUAL_MEMORY
//
// MessageText:
//
//  The server was unable to allocate virtual memory.
//
#define EVENT_SRV_NO_VIRTUAL_MEMORY      0xC00007E0L

//
// MessageId: EVENT_SRV_NONPAGED_POOL_LIMIT
//
// MessageText:
//
//  The server was unable to allocate from the system nonpaged pool because the server reached the configured limit for nonpaged pool allocations.
//
#define EVENT_SRV_NONPAGED_POOL_LIMIT    0xC00007E1L

//
// MessageId: EVENT_SRV_PAGED_POOL_LIMIT
//
// MessageText:
//
//  The server was unable to allocate from the system paged pool because the server reached the configured limit for paged pool allocations.
//
#define EVENT_SRV_PAGED_POOL_LIMIT       0xC00007E2L

//
// MessageId: EVENT_SRV_NO_NONPAGED_POOL
//
// MessageText:
//
//  The server was unable to allocate from the system nonpaged pool because the pool was empty.
//
#define EVENT_SRV_NO_NONPAGED_POOL       0xC00007E3L

//
// MessageId: EVENT_SRV_NO_PAGED_POOL
//
// MessageText:
//
//  The server was unable to allocate from the system paged pool because the pool was empty.
//
#define EVENT_SRV_NO_PAGED_POOL          0xC00007E4L

//
// MessageId: EVENT_SRV_NO_WORK_ITEM
//
// MessageText:
//
//  The server was unable to allocate a work item %2 times in the last %3 seconds.
//
#define EVENT_SRV_NO_WORK_ITEM           0x800007E5L

//
// MessageId: EVENT_SRV_NO_FREE_CONNECTIONS
//
// MessageText:
//
//  The server was unable to find a free connection %2 times in the last %3 seconds.
//
#define EVENT_SRV_NO_FREE_CONNECTIONS    0x800007E6L

//
// MessageId: EVENT_SRV_NO_FREE_RAW_WORK_ITEM
//
// MessageText:
//
//  The server was unable to find a free raw work item %2 times in the last %3 seconds.
//
#define EVENT_SRV_NO_FREE_RAW_WORK_ITEM  0x800007E7L

//
// MessageId: EVENT_SRV_NO_BLOCKING_IO
//
// MessageText:
//
//  The server was unable to allocate resources for blocking I/O %2 times in the last %3 seconds.
//
#define EVENT_SRV_NO_BLOCKING_IO         0x800007E8L


// Server service events, issued from user mode.  %1 is the first
// service-supplied insertion string.

//
// MessageId: EVENT_SRV_KEY_NOT_FOUND
//
// MessageText:
//
//  The server's Registry key %1 was not present.  The server could not start.
//
#define EVENT_SRV_KEY_NOT_FOUND          0xC00009C5L

//
// MessageId: EVENT_SRV_KEY_NOT_CREATED
//
// MessageText:
//
//  The server's Registry key %1 was not present and could not be created.  The server could not start.
//
#define EVENT_SRV_KEY_NOT_CREATED        0xC00009C6L

//
// MessageId: EVENT_SRV_NO_TRANSPORTS_BOUND
//
// MessageText:
//
//  The server did not bind to any transports.  The server could not start.
//
#define EVENT_SRV_NO_TRANSPORTS_BOUND    0xC00009C7L

//
// MessageId: EVENT_SRV_CANT_BIND_TO_TRANSPORT
//
// MessageText:
//
//  The server could not bind to the transport %1.
//
#define EVENT_SRV_CANT_BIND_TO_TRANSPORT 0x800009C8L

//
// MessageId: EVENT_SRV_CANT_BIND_DUP_NAME
//
// MessageText:
//
//  The server could not bind to the transport %1 because another computer on the network has the same name.  The server could not start.
//
#define EVENT_SRV_CANT_BIND_DUP_NAME     0xC00009C9L

//
// MessageId: EVENT_SRV_INVALID_REGISTRY_VALUE
//
// MessageText:
//
//  The value named %1 in the server's Registry key %2 was invalid.  The value was ignored, and processing continued.
//
#define EVENT_SRV_INVALID_REGISTRY_VALUE 0x800009CAL

//
// MessageId: EVENT_SRV_INVALID_SD
//
// MessageText:
//
//  The security descriptor stored in the Registry for the share %1 was invalid.  The share was not automatically recreated.
//
#define EVENT_SRV_INVALID_SD             0x800009CBL

//
// MessageId: EVENT_SRV_CANT_LOAD_DRIVER
//
// MessageText:
//
//  The server service was unable to load the server driver.
//
#define EVENT_SRV_CANT_LOAD_DRIVER       0x800009CCL

//
// MessageId: EVENT_SRV_CANT_UNLOAD_DRIVER
//
// MessageText:
//
//  The server service was unable to unload the server driver.
//
#define EVENT_SRV_CANT_UNLOAD_DRIVER     0x800009CDL

//
// MessageId: EVENT_SRV_CANT_MAP_ERROR
//
// MessageText:
//
//  The server service was unable to map error code %1.
//
#define EVENT_SRV_CANT_MAP_ERROR         0x800009CEL

//
// MessageId: EVENT_SRV_CANT_RECREATE_SHARE
//
// MessageText:
//
//  The server service was unable to recreate the share %1 because the directory %2 no longer exists.
//
#define EVENT_SRV_CANT_RECREATE_SHARE    0x800009CFL


/////////////////////////////////////////////////////////////////////////
//
// Lanman Redirector Events
//
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_RDR_RESOURCE_SHORTAGE
//
// MessageText:
//
//  The redirector was unable to allocate memory.
//
#define EVENT_RDR_RESOURCE_SHORTAGE      0x80000BB9L

//
// MessageId: EVENT_RDR_CANT_CREATE_DEVICE
//
// MessageText:
//
//  The redirector could not create its device.  The redirector could not be started.
//
#define EVENT_RDR_CANT_CREATE_DEVICE     0x80000BBAL

//
// MessageId: EVENT_RDR_CANT_CREATE_THREAD
//
// MessageText:
//
//  The redirector could not create a system thread.
//
#define EVENT_RDR_CANT_CREATE_THREAD     0x80000BBBL

//
// MessageId: EVENT_RDR_CANT_SET_THREAD
//
// MessageText:
//
//  The redirector could not set the priority for a system thread.
//
#define EVENT_RDR_CANT_SET_THREAD        0x80000BBCL

//
// MessageId: EVENT_RDR_INVALID_REPLY
//
// MessageText:
//
//  The redirector received an incorrectly formatted response from %2.
//
#define EVENT_RDR_INVALID_REPLY          0x80000BBDL

//
// MessageId: EVENT_RDR_INVALID_SMB
//
// MessageText:
//
//  The redirector received an SMB that was too short.
//
#define EVENT_RDR_INVALID_SMB            0x80000BBEL

//
// MessageId: EVENT_RDR_INVALID_LOCK_REPLY
//
// MessageText:
//
//  The redirector received an incorrect response from %2 to a lock request.
//
#define EVENT_RDR_INVALID_LOCK_REPLY     0x80000BBFL

//
// MessageId: EVENT_RDR_FAILED_UNLOCK
//
// MessageText:
//
//  The redirector failed to unlock part of a file on server %2.
//
#define EVENT_RDR_FAILED_UNLOCK          0x80000BC1L

//
// MessageId: EVENT_RDR_CLOSE_BEHIND
//
// MessageText:
//
//  The redirector failed to write data to server %2 after the file was closed.
//
#define EVENT_RDR_CLOSE_BEHIND           0x80000BC3L

//
// MessageId: EVENT_RDR_UNEXPECTED_ERROR
//
// MessageText:
//
//  An unexpected network error has occurred on the virtual circuit to %2.
//
#define EVENT_RDR_UNEXPECTED_ERROR       0x80000BC4L

//
// MessageId: EVENT_RDR_TIMEOUT
//
// MessageText:
//
//  The redirector has timed out a request to %2.
//
#define EVENT_RDR_TIMEOUT                0x80000BC5L

//
// MessageId: EVENT_RDR_INVALID_OPLOCK
//
// MessageText:
//
//  The redirector received an invalid oplock level from %2.
//
#define EVENT_RDR_INVALID_OPLOCK         0x80000BC6L

//
// MessageId: EVENT_RDR_CONNECTION_REFERENCE
//
// MessageText:
//
//  The redirector dereferenced a connection through zero.
//
#define EVENT_RDR_CONNECTION_REFERENCE   0x80000BC7L

//
// MessageId: EVENT_RDR_SERVER_REFERENCE
//
// MessageText:
//
//  The redirector dereferenced a server through zero.
//
#define EVENT_RDR_SERVER_REFERENCE       0x80000BC8L

//
// MessageId: EVENT_RDR_SMB_REFERENCE
//
// MessageText:
//
//  The redirector dereferenced the allocated SMB count through zero.
//
#define EVENT_RDR_SMB_REFERENCE          0x80000BC9L

//
// MessageId: EVENT_RDR_ENCRYPT
//
// MessageText:
//
//  The redirector accessed a share-level server that indicates it encrypts passwords.
//  This combination is not supported.
//
#define EVENT_RDR_ENCRYPT                0x80000BCAL

//
// MessageId: EVENT_RDR_CONNECTION
//
// MessageText:
//
//  The redirector failed to determine the connection type.
//
#define EVENT_RDR_CONNECTION             0x80000BCBL

//
// MessageId: EVENT_RDR_MAXCMDS
//
// MessageText:
//
//  The redirector failed to allocate a multiplex table entry.  This indicates that
//  the MAXCMDS parameter to the redirector is insufficient for the users needs.
//
#define EVENT_RDR_MAXCMDS                0x80000BCDL

//
// MessageId: EVENT_RDR_OPLOCK_SMB
//
// MessageText:
//
//  The redirector failed to allocate a buffer for an oplock break.
//
#define EVENT_RDR_OPLOCK_SMB             0x80000BCEL

//
// MessageId: EVENT_RDR_DISPOSITION
//
// MessageText:
//
//  The redirector failed to map the requested file disposition (for NtCreateFile).
//
#define EVENT_RDR_DISPOSITION            0x80000BCFL

//
// MessageId: EVENT_RDR_CONTEXTS
//
// MessageText:
//
//  The redirector is allocating additional resources for input/output request packet contexts.  This is
//  probably caused by a resource leak in the redirector.
//
#define EVENT_RDR_CONTEXTS               0x80000BD0L

//
// MessageId: EVENT_RDR_WRITE_BEHIND_FLUSH_FAILED
//
// MessageText:
//
//  A write-behind operation has failed to the remote server %2.  The data contains the amount requested to write and the amount actually written.
//
#define EVENT_RDR_WRITE_BEHIND_FLUSH_FAILED 0x80000BD1L

//
// MessageId: EVENT_RDR_AT_THREAD_MAX
//
// MessageText:
//
//  The redirector was unable to create a worker thread because it has already created the maximum number of configured work threads.
//
#define EVENT_RDR_AT_THREAD_MAX          0x80000BD2L

//
// MessageId: EVENT_RDR_CANT_READ_REGISTRY
//
// MessageText:
//
//  The redirector was unable to initialize variables from the Registry.
//
#define EVENT_RDR_CANT_READ_REGISTRY     0x80000BD3L

//
// MessageId: EVENT_RDR_TIMEZONE_BIAS_TOO_LARGE
//
// MessageText:
//
//  The time zone bias calculated between %2 and the current workstation is too
//  large.  The data specifies the number of 100ns units between the workstation
//  and server.  Make sure that the time of day on the workstation and server are
//  correct.
//
#define EVENT_RDR_TIMEZONE_BIAS_TOO_LARGE 0x80000BD4L

//
// MessageId: EVENT_RDR_PRIMARY_TRANSPORT_CONNECT_FAILED
//
// MessageText:
//
//  The redirector has failed to connect to the server %2 on the primary transport.  The data contains the error.
//
#define EVENT_RDR_PRIMARY_TRANSPORT_CONNECT_FAILED 0x80000BD5L

//
// MessageId: EVENT_RDR_DELAYED_SET_ATTRIBUTES_FAILED
//
// MessageText:
//
//  The redirector was unable to update the file attributes on a file located on server %2.
//  The data contains the name of the file.
//
#define EVENT_RDR_DELAYED_SET_ATTRIBUTES_FAILED 0x80000BD6L

//
// MessageId: EVENT_RDR_DELETEONCLOSE_FAILED
//
// MessageText:
//
//  The redirector was unable to delete the file specified on server %2 when it was closed by the application.
//  The data contains the name of the file.
//
#define EVENT_RDR_DELETEONCLOSE_FAILED   0x80000BD7L



/////////////////////////////////////////////////////////////////////////
//
// STREAMS Environment Events
//
// Codes 4000 - 4099
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_STREAMS_STRLOG
//
// MessageText:
//
//  %2.
//
#define EVENT_STREAMS_STRLOG             0xC0000FA0L

//
// MessageId: EVENT_STREAMS_ALLOCB_FAILURE
//
// MessageText:
//
//  Unable to allocate a %2 byte message.
//
#define EVENT_STREAMS_ALLOCB_FAILURE     0x80000FA1L

//
// MessageId: EVENT_STREAMS_ALLOCB_FAILURE_CNT
//
// MessageText:
//
//  %2 message allocations have failed since initialization.
//
#define EVENT_STREAMS_ALLOCB_FAILURE_CNT 0x80000FA2L

//
// MessageId: EVENT_STREAMS_ESBALLOC_FAILURE
//
// MessageText:
//
//  Unable to allocate a %2 byte external message.
//
#define EVENT_STREAMS_ESBALLOC_FAILURE   0x80000FA3L

//
// MessageId: EVENT_STREAMS_ESBALLOC_FAILURE_CNT
//
// MessageText:
//
//  %2 external message allocations have failed since initialization.
//
#define EVENT_STREAMS_ESBALLOC_FAILURE_CNT 0x80000FA4L



/////////////////////////////////////////////////////////////////////////
//
// TCP/IP Events
//
// Codes 4100 - 4299
//
/////////////////////////////////////////////////////////////////////////


//
// Common TCP/IP messages
//
// Codes 4100 - 4149
//
//

//
// MessageId: EVENT_TCPIP_CREATE_DEVICE_FAILED
//
// MessageText:
//
//  Unable to create device object %2. Initialization failed.
//
#define EVENT_TCPIP_CREATE_DEVICE_FAILED 0xC0001004L

//
// MessageId: EVENT_TCPIP_NO_RESOURCES_FOR_INIT
//
// MessageText:
//
//  Unable to allocate required resources. Initialization failed.
//
#define EVENT_TCPIP_NO_RESOURCES_FOR_INIT 0xC0001005L


//
// ARP messages
//
// Codes 4150-4174


//
// IP Loopback messages
//
// Codes 4175-4184
//


//
// IP/ICMP messages
//
// Codes 4185 - 4224

//
// MessageId: EVENT_TCPIP_TOO_MANY_NETS
//
// MessageText:
//
//  IP has been bound to more than the maximum number of supported interfaces.
//  Some interfaces on adapter %2 will not be initialized.
//
#define EVENT_TCPIP_TOO_MANY_NETS        0xC0001059L

//
// MessageId: EVENT_TCPIP_NO_MASK
//
// MessageText:
//
//  No subnet mask was specified for interface %2. This interface and
//  all subsequent interfaces on adapter %3 cannot be initialized.
//
#define EVENT_TCPIP_NO_MASK              0xC000105AL

//
// MessageId: EVENT_TCPIP_INVALID_ADDRESS
//
// MessageText:
//
//  Invalid address %2 was specified for adapter %3. This interface
//  cannot be initialized.
//
#define EVENT_TCPIP_INVALID_ADDRESS      0xC000105BL

//
// MessageId: EVENT_TCPIP_INVALID_MASK
//
// MessageText:
//
//  Invalid subnet mask %2 was specified for address %3 on adapter %4.
//  This interface cannot be initialized.
//
#define EVENT_TCPIP_INVALID_MASK         0xC000105CL

//
// MessageId: EVENT_TCPIP_NO_ADAPTER_RESOURCES
//
// MessageText:
//
//  IP could not allocate some resources required to configure adapter %2.
//  Some interfaces on this adapter will not be initialized.
//
#define EVENT_TCPIP_NO_ADAPTER_RESOURCES 0xC000105DL

//
// MessageId: EVENT_TCPIP_DHCP_INIT_FAILED
//
// MessageText:
//
//  IP was unable to initialize adapter %2 for configuration by DHCP.
//  If DHCP is enabled on this adapter, the primary interface may not be
//  configured properly. Interfaces on this adapter not configured by
//  DHCP will be unaffected.
//
#define EVENT_TCPIP_DHCP_INIT_FAILED     0x8000105EL

//
// MessageId: EVENT_TCPIP_ADAPTER_REG_FAILURE
//
// MessageText:
//
//  IP could not open the registry key for adapter %2.
//  Interfaces on this adapter will not be initialized.
//
#define EVENT_TCPIP_ADAPTER_REG_FAILURE  0xC000105FL

//
// MessageId: EVENT_TCPIP_INVALID_DEFAULT_GATEWAY
//
// MessageText:
//
//  Invalid default gateway address %2 was specified for adapter %3.
//  Some remote networks may not be reachable as a result.
//
#define EVENT_TCPIP_INVALID_DEFAULT_GATEWAY 0x80001060L

//
// MessageId: EVENT_TCPIP_NO_ADDRESS_LIST
//
// MessageText:
//
//  Unable to read the configured IP addresses for adapter %2.
//  IP interfaces will not be initialized on this adapter.
//
#define EVENT_TCPIP_NO_ADDRESS_LIST      0xC0001061L

//
// MessageId: EVENT_TCPIP_NO_MASK_LIST
//
// MessageText:
//
//  Unable to read the configured subnet masks for adapter %2.
//  IP interfaces will not be initialized on this adapter.
//
#define EVENT_TCPIP_NO_MASK_LIST         0xC0001062L

//
// MessageId: EVENT_TCPIP_NO_BINDINGS
//
// MessageText:
//
//  IP was unable to read its bindings from the registry. No network interfaces
//  were configured.
//
#define EVENT_TCPIP_NO_BINDINGS          0xC0001063L

//
// MessageId: EVENT_TCPIP_IP_INIT_FAILED
//
// MessageText:
//
//  Initialization of IP failed.
//
#define EVENT_TCPIP_IP_INIT_FAILED       0xC0001064L

//
// MessageId: EVENT_TCPIP_TOO_MANY_GATEWAYS
//
// MessageText:
//
//  More than the maximum number of default gateways were specified for
//  adapter %2. Some remote networks may not be reachable as a result.
//
#define EVENT_TCPIP_TOO_MANY_GATEWAYS    0x80001065L

//
// MessageId: EVENT_TCPIP_ADDRESS_CONFLICT1
//
// MessageText:
//
//  The system detected an address conflict for IP address %2 with the system
//  having network hardware address %3. The local interface has been disabled.
//
#define EVENT_TCPIP_ADDRESS_CONFLICT1    0xC0001066L

//
// MessageId: EVENT_TCPIP_ADDRESS_CONFLICT2
//
// MessageText:
//
//  The system detected an address conflict for IP address %2 with the system
//  having network hardware address %3. Network operations on this system may
//  be disrupted as a result.
//
#define EVENT_TCPIP_ADDRESS_CONFLICT2    0xC0001067L


//
// TCP messages
//
// Codes 4225 - 4264
//

//
// MessageId: EVENT_TCPIP_TCP_INIT_FAILED
//
// MessageText:
//
//  Initialization of TCP/UDP failed.
//
#define EVENT_TCPIP_TCP_INIT_FAILED      0xC0001081L


//
// UDP messages
//
// Codes 4265 - 4299
//



/////////////////////////////////////////////////////////////////////////
//
// NBT Events
//
// Codes 4300 - 4399
//
/////////////////////////////////////////////////////////////////////////



// Don't use %1 for driver supplied insertion strings.  The IO subsystem
// supplies the first string!!

//
// MessageId: EVENT_NBT_CREATE_DRIVER
//
// MessageText:
//
//  The driver could not be created.
//
#define EVENT_NBT_CREATE_DRIVER          0xC00010CCL

//
// MessageId: EVENT_NBT_OPEN_REG_PARAMS
//
// MessageText:
//
//  Unable to open the Registry Parameters to read configuration information.
//
#define EVENT_NBT_OPEN_REG_PARAMS        0xC00010CDL

//
// MessageId: EVENT_NBT_NO_BACKUP_WINS
//
// MessageText:
//
//  The backup WINS server address is not configured in the registry.
//
#define EVENT_NBT_NO_BACKUP_WINS         0x800010CEL

//
// MessageId: EVENT_NBT_NO_WINS
//
// MessageText:
//
//  The primary WINS server address is not configured in the registry.
//
#define EVENT_NBT_NO_WINS                0x800010CFL

//
// MessageId: EVENT_NBT_BAD_BACKUP_WINS_ADDR
//
// MessageText:
//
//  The backup WINS server address is not formated correctly in the registry.
//
#define EVENT_NBT_BAD_BACKUP_WINS_ADDR   0x800010D0L

//
// MessageId: EVENT_NBT_BAD_PRIMARY_WINS_ADDR
//
// MessageText:
//
//  The primary WINS server address is not formated correctly in the registry.
//
#define EVENT_NBT_BAD_PRIMARY_WINS_ADDR  0x800010D1L

//
// MessageId: EVENT_NBT_NAME_SERVER_ADDRS
//
// MessageText:
//
//  Unable to configure the addresses of the WINS servers.
//
#define EVENT_NBT_NAME_SERVER_ADDRS      0xC00010D2L

//
// MessageId: EVENT_NBT_CREATE_ADDRESS
//
// MessageText:
//
//  Initialization failed because the transport refused to open initial Addresses.
//
#define EVENT_NBT_CREATE_ADDRESS         0xC00010D3L

//
// MessageId: EVENT_NBT_CREATE_CONNECTION
//
// MessageText:
//
//  Initialization failed because the transport refused to open initial Connections.
//
#define EVENT_NBT_CREATE_CONNECTION      0xC00010D4L

//
// MessageId: EVENT_NBT_NON_OS_INIT
//
// MessageText:
//
//  Data structure initialization failed.
//
#define EVENT_NBT_NON_OS_INIT            0xC00010D5L

//
// MessageId: EVENT_NBT_TIMERS
//
// MessageText:
//
//  Initialization failed because the timers could not be started.
//
#define EVENT_NBT_TIMERS                 0xC00010D6L

//
// MessageId: EVENT_NBT_CREATE_DEVICE
//
// MessageText:
//
//  Initialization failed because the driver device could not be created.
//
#define EVENT_NBT_CREATE_DEVICE          0xC00010D7L

//
// MessageId: EVENT_NBT_NO_DEVICES
//
// MessageText:
//
//  There are no adapters configured for this protocol stack.
//
#define EVENT_NBT_NO_DEVICES             0x800010D8L

//
// MessageId: EVENT_NBT_OPEN_REG_LINKAGE
//
// MessageText:
//
//  Unable to open the Registry Linkage to read configuration information.
//
#define EVENT_NBT_OPEN_REG_LINKAGE       0xC00010D9L

//
// MessageId: EVENT_NBT_READ_BIND
//
// MessageText:
//
//  Unable to read the driver's bindings to the transport from the registry.
//
#define EVENT_NBT_READ_BIND              0xC00010DAL

//
// MessageId: EVENT_NBT_READ_EXPORT
//
// MessageText:
//
//  Unable to read the driver's exported linkage configuration information.
//
#define EVENT_NBT_READ_EXPORT            0xC00010DBL

//
// MessageId: EVENT_NBT_OPEN_REG_NAMESERVER
//
// MessageText:
//
//  Unable to open the Registry to read the WINS server addresses.
//
#define EVENT_NBT_OPEN_REG_NAMESERVER    0x800010DCL

//
// MessageId: EVENT_SCOPE_LABEL_TOO_LONG
//
// MessageText:
//
//  The Netbios Name Scope has a component longer than 63 characters. Each label
//  in the Scope cannot be longer than 63 bytes.  Use the Control Panel, Network
//  applet to change the scope.
//
#define EVENT_SCOPE_LABEL_TOO_LONG       0x800010DDL

//
// MessageId: EVENT_SCOPE_TOO_LONG
//
// MessageText:
//
//  The Netbios Name Scope is too long. The scope cannot be longer than
//  255 bytes. Use the Control Panel, Network applet to change the scope.
//
#define EVENT_SCOPE_TOO_LONG             0x800010DEL

//
// MessageId: EVENT_NBT_DUPLICATE_NAME
//
// MessageText:
//
//  A duplicate name has been detected on the TCP network.  The IP address of
//  the machine that sent the message is in the data. Use nbtstat -n in a
//  command window to see which name is in the Conflict state.
//
#define EVENT_NBT_DUPLICATE_NAME         0xC00010DFL

//
// MessageId: EVENT_NBT_NAME_RELEASE
//
// MessageText:
//
//  Another machine has sent a name release message to this machine probably
//  because a duplicate name has been detected on the TCP network.  The IP address
//  of the node that sent the message is in the data. Use nbtstat -n in a
//  command window to see which name is in the Conflict state.
//
#define EVENT_NBT_NAME_RELEASE           0xC00010E0L


/////////////////////////////////////////////////////////////////////////
//
// NDIS Environment Events
//
// Codes 5000 - 5099
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_NDIS_RESOURCE_CONFLICT
//
// MessageText:
//
//  %2 : Has encountered a conflict in resources and could not load.
//
#define EVENT_NDIS_RESOURCE_CONFLICT     0xC0001388L

//
// MessageId: EVENT_NDIS_OUT_OF_RESOURCE
//
// MessageText:
//
//  %2 : Could not allocate the resources necessary for operation.
//
#define EVENT_NDIS_OUT_OF_RESOURCE       0xC0001389L

//
// MessageId: EVENT_NDIS_HARDWARE_FAILURE
//
// MessageText:
//
//  %2 : Has determined that the adapter is not functioning properly.
//
#define EVENT_NDIS_HARDWARE_FAILURE      0xC000138AL

//
// MessageId: EVENT_NDIS_ADAPTER_NOT_FOUND
//
// MessageText:
//
//  %2 : Could not find an adapter.
//
#define EVENT_NDIS_ADAPTER_NOT_FOUND     0xC000138BL

//
// MessageId: EVENT_NDIS_INTERRUPT_CONNECT
//
// MessageText:
//
//  %2 : Could not connect to the interrupt number supplied.
//
#define EVENT_NDIS_INTERRUPT_CONNECT     0xC000138CL

//
// MessageId: EVENT_NDIS_DRIVER_FAILURE
//
// MessageText:
//
//  %2 : Has encountered an internal error and has failed.
//
#define EVENT_NDIS_DRIVER_FAILURE        0xC000138DL

//
// MessageId: EVENT_NDIS_BAD_VERSION
//
// MessageText:
//
//  %2 : The version number is incorrect for this driver.
//
#define EVENT_NDIS_BAD_VERSION           0xC000138EL

//
// MessageId: EVENT_NDIS_TIMEOUT
//
// MessageText:
//
//  %2 : Timed out during an operation.
//
#define EVENT_NDIS_TIMEOUT               0x8000138FL

//
// MessageId: EVENT_NDIS_NETWORK_ADDRESS
//
// MessageText:
//
//  %2 : Has encountered an invalid network address.
//
#define EVENT_NDIS_NETWORK_ADDRESS       0xC0001390L

//
// MessageId: EVENT_NDIS_UNSUPPORTED_CONFIGURATION
//
// MessageText:
//
//  %2 : Does not support the configuration supplied.
//
#define EVENT_NDIS_UNSUPPORTED_CONFIGURATION 0xC0001391L

//
// MessageId: EVENT_NDIS_INVALID_VALUE_FROM_ADAPTER
//
// MessageText:
//
//  %2 : The adapter has returned an invalid value to the driver.
//
#define EVENT_NDIS_INVALID_VALUE_FROM_ADAPTER 0xC0001392L

//
// MessageId: EVENT_NDIS_MISSING_CONFIGURATION_PARAMETER
//
// MessageText:
//
//  %2 : A required parameter is missing from the Registry.
//
#define EVENT_NDIS_MISSING_CONFIGURATION_PARAMETER 0xC0001393L

//
// MessageId: EVENT_NDIS_BAD_IO_BASE_ADDRESS
//
// MessageText:
//
//  %2 : The I/O base address supplied does not match the jumpers on the adapter.
//
#define EVENT_NDIS_BAD_IO_BASE_ADDRESS   0xC0001394L

//
// MessageId: EVENT_NDIS_RECEIVE_SPACE_SMALL
//
// MessageText:
//
//  %2 : The adapter is configured such that the receive space is smaller than
//  the maximum packet size.  Some packets may be lost.
//
#define EVENT_NDIS_RECEIVE_SPACE_SMALL   0x40001395L

//
// MessageId: EVENT_NDIS_ADAPTER_DISABLED
//
// MessageText:
//
//  %2 : The adapter is disabled.  The driver cannot open the adapter.
//
#define EVENT_NDIS_ADAPTER_DISABLED      0x80001396L

//
// MessageId: EVENT_NDIS_IO_PORT_CONFLICT
//
// MessageText:
//
//  %2 : There is an I/O port conflict.
//
#define EVENT_NDIS_IO_PORT_CONFLICT      0x80001397L

//
// MessageId: EVENT_NDIS_PORT_OR_DMA_CONFLICT
//
// MessageText:
//
//  %2 : There is an I/O port or DMA channel conflict.
//
#define EVENT_NDIS_PORT_OR_DMA_CONFLICT  0x80001398L

//
// MessageId: EVENT_NDIS_MEMORY_CONFLICT
//
// MessageText:
//
//  %2 : There is a memory conflict at address 0x%3.
//
#define EVENT_NDIS_MEMORY_CONFLICT       0x80001399L

//
// MessageId: EVENT_NDIS_INTERRUPT_CONFLICT
//
// MessageText:
//
//  %2 : There is a interrupt conflict at interrupt number %3.
//
#define EVENT_NDIS_INTERRUPT_CONFLICT    0x8000139AL

//
// MessageId: EVENT_NDIS_DMA_CONFLICT
//
// MessageText:
//
//  %2 : There is a resource conflict at DMA channel %3.
//
#define EVENT_NDIS_DMA_CONFLICT          0x8000139BL

//
// MessageId: EVENT_NDIS_INVALID_DOWNLOAD_FILE_ERROR
//
// MessageText:
//
//  %2 : The download file is invalid.  The driver is unable to load.
//
#define EVENT_NDIS_INVALID_DOWNLOAD_FILE_ERROR 0xC000139CL

//
// MessageId: EVENT_NDIS_MAXRECEIVES_ERROR
//
// MessageText:
//
//  %2 : The specified Registry entry MaxReceives is out of range.  Using
//  default value.
//
#define EVENT_NDIS_MAXRECEIVES_ERROR     0x8000139DL

//
// MessageId: EVENT_NDIS_MAXTRANSMITS_ERROR
//
// MessageText:
//
//  %2 : The specified Registry entry MaxTransmits is out of range.  Using
//  default value.
//
#define EVENT_NDIS_MAXTRANSMITS_ERROR    0x8000139EL

//
// MessageId: EVENT_NDIS_MAXFRAMESIZE_ERROR
//
// MessageText:
//
//  %2 : The specified Registry entry MaxFrameSize is out of range.  Using
//  default value.
//
#define EVENT_NDIS_MAXFRAMESIZE_ERROR    0x8000139FL

//
// MessageId: EVENT_NDIS_MAXINTERNALBUFS_ERROR
//
// MessageText:
//
//  %2 : The specified Registry entry MaxInternalBufs is out of range.  Using
//  default value.
//
#define EVENT_NDIS_MAXINTERNALBUFS_ERROR 0x800013A0L

//
// MessageId: EVENT_NDIS_MAXMULTICAST_ERROR
//
// MessageText:
//
//  %2 : The specified Registry entry MaxMulticast is out of range.  Using
//  default value.
//
#define EVENT_NDIS_MAXMULTICAST_ERROR    0x800013A1L

//
// MessageId: EVENT_NDIS_PRODUCTID_ERROR
//
// MessageText:
//
//  %2 : The specified Registry entry ProductId is out of range.  Using
//  default value.
//
#define EVENT_NDIS_PRODUCTID_ERROR       0x800013A2L

//
// MessageId: EVENT_NDIS_LOBE_FAILUE_ERROR
//
// MessageText:
//
//  %2 : A Token Ring Lobe Wire Fault has occurred.  Verify cable
//  connections.  The adapter will continue to try to reinsert back
//  into the ring.
//
#define EVENT_NDIS_LOBE_FAILUE_ERROR     0x800013A3L

//
// MessageId: EVENT_NDIS_SIGNAL_LOSS_ERROR
//
// MessageText:
//
//  %2 : The adapter had detected a loss of signal on the ring.  The adapter
//  will continue to try to reinsert back into the ring.
//
#define EVENT_NDIS_SIGNAL_LOSS_ERROR     0x800013A4L

//
// MessageId: EVENT_NDIS_REMOVE_RECEIVED_ERROR
//
// MessageText:
//
//  %2 : The adapter has received a request to deinsert from the
//  ring.  The adapter will continue to try to reinsert back into the ring.
//
#define EVENT_NDIS_REMOVE_RECEIVED_ERROR 0x800013A5L

//
// MessageId: EVENT_NDIS_TOKEN_RING_CORRECTION
//
// MessageText:
//
//  %2 : The adapter has successfully reinserted back into the ring.
//
#define EVENT_NDIS_TOKEN_RING_CORRECTION 0x400013A6L

//
// MessageId: EVENT_NDIS_ADAPTER_CHECK_ERROR
//
// MessageText:
//
//  %2 : The adapter has detected an Adapter Check as a result of some
//  unrecoverable hardware of software error.  Please contact your service provider.
//
#define EVENT_NDIS_ADAPTER_CHECK_ERROR   0xC00013A7L

//
// MessageId: EVENT_NDIS_RESET_FAILURE_ERROR
//
// MessageText:
//
//  %2 : The adapter failed to reset within a specified time.  The adapter will
//  continue to try to reset.  This could be the result of a hardware failure.
//
#define EVENT_NDIS_RESET_FAILURE_ERROR   0x800013A8L

//
// MessageId: EVENT_NDIS_CABLE_DISCONNECTED_ERROR
//
// MessageText:
//
//  %2 : The adapter has detected that the Token Ring cable is disconnected from
//  the adapter.  Please reconnect the Token Ring cable.  The adapter will continue
//  to try to reset until the connection is repaired.
//
#define EVENT_NDIS_CABLE_DISCONNECTED_ERROR 0x800013A9L

//
// MessageId: EVENT_NDIS_RESET_FAILURE_CORRECTION
//
// MessageText:
//
//  %2 : The adapter has successfully completed a previously failed reset.
//
#define EVENT_NDIS_RESET_FAILURE_CORRECTION 0x800013AAL


/////////////////////////////////////////////////////////////////////////
//
// General NT System Events
//
/////////////////////////////////////////////////////////////////////////

//
// Eventlog Events 6000 - 6099
//
//
// MessageId: EVENT_LOG_FULL
//
// MessageText:
//
//  The %1 log file is full.
//
#define EVENT_LOG_FULL                   0x80001770L

//
// MessageId: EVENT_LogFileNotOpened
//
// MessageText:
//
//  The %1 log file cannot be opened.
//
#define EVENT_LogFileNotOpened           0x80001771L

//
// MessageId: EVENT_LogFileCorrupt
//
// MessageText:
//
//  The %1 log file is corrupted and will be cleared.
//
#define EVENT_LogFileCorrupt             0x80001772L

//
// MessageId: EVENT_DefaultLogCorrupt
//
// MessageText:
//
//  The Application log file could not be opened.  %1 will be used as the default
//  log file.
//
#define EVENT_DefaultLogCorrupt          0x80001773L

//
// MessageId: EVENT_BadDriverPacket
//
// MessageText:
//
//  A driver packet received from the I/O subsystem was invalid.  The data is the
//  packet.
//
#define EVENT_BadDriverPacket            0x80001774L

//
// MessageId: EVENT_EventlogStarted
//
// MessageText:
//
//  The Event log service was started.
//
#define EVENT_EventlogStarted            0x80001775L

//
// MessageId: EVENT_EventlogStopped
//
// MessageText:
//
//  The Event log service was stopped.
//
#define EVENT_EventlogStopped            0x80001776L

//
// MessageId: TITLE_EventlogMessageBox
//
// MessageText:
//
//  Eventlog Service %0
//
#define TITLE_EventlogMessageBox         0x80001777L

//
// System Events 6100 - 6199
//
//
// MessageId: EVENT_UP_DRIVER_ON_MP
//
// MessageText:
//
//  A uniprocessor-specific driver was loaded on a multiprocessor system.  The driver could not load.
//
#define EVENT_UP_DRIVER_ON_MP            0x800017D4L

//
// Service Controller Events 7000 - 7899
//
//
// MessageId: EVENT_SERVICE_START_FAILED
//
// MessageText:
//
//  The %1 service failed to start due to the following error: %n%2
//
#define EVENT_SERVICE_START_FAILED       0x80001B58L

//
// MessageId: EVENT_SERVICE_START_FAILED_II
//
// MessageText:
//
//  The %1 service depends on the %2 service which failed to start because of the following error: %n%3
//
#define EVENT_SERVICE_START_FAILED_II    0x80001B59L

//
// MessageId: EVENT_SERVICE_START_FAILED_GROUP
//
// MessageText:
//
//  The %1 service depends on the %2 group and no member of this group started.
//
#define EVENT_SERVICE_START_FAILED_GROUP 0x80001B5AL

//
// MessageId: EVENT_SERVICE_START_FAILED_NONE
//
// MessageText:
//
//  The %1 service depends on the following nonexistent service: %2
//
#define EVENT_SERVICE_START_FAILED_NONE  0x80001B5BL

//
// MessageId: EVENT_CALL_TO_FUNCTION_FAILED
//
// MessageText:
//
//  The %1 call failed with the following error: %n%2
//
#define EVENT_CALL_TO_FUNCTION_FAILED    0x80001B5DL

//
// MessageId: EVENT_CALL_TO_FUNCTION_FAILED_II
//
// MessageText:
//
//  The %1 call failed for %2 with the following error: %n%3
//
#define EVENT_CALL_TO_FUNCTION_FAILED_II 0x80001B5EL

//
// MessageId: EVENT_REVERTED_TO_LASTKNOWNGOOD
//
// MessageText:
//
//  The system reverted to its last known good configuration.  The system is restarting....
//
#define EVENT_REVERTED_TO_LASTKNOWNGOOD  0x80001B5FL

//
// MessageId: EVENT_BAD_ACCOUNT_NAME
//
// MessageText:
//
//  No backslash is in the account name.
//
#define EVENT_BAD_ACCOUNT_NAME           0x80001B60L

//
// MessageId: EVENT_CONNECTION_TIMEOUT
//
// MessageText:
//
//  Timeout (%1 milliseconds) waiting for service to connect.
//
#define EVENT_CONNECTION_TIMEOUT         0x80001B61L

//
// MessageId: EVENT_READFILE_TIMEOUT
//
// MessageText:
//
//  Timeout (%1 milliseconds) waiting for ReadFile.
//
#define EVENT_READFILE_TIMEOUT           0x80001B62L

//
// MessageId: EVENT_TRANSACT_TIMEOUT
//
// MessageText:
//
//  Timeout (%1 milliseconds) waiting for transaction response.
//
#define EVENT_TRANSACT_TIMEOUT           0x80001B63L

//
// MessageId: EVENT_TRANSACT_INVALID
//
// MessageText:
//
//  Message returned in transaction has incorrect size.
//
#define EVENT_TRANSACT_INVALID           0x80001B64L

//
// MessageId: EVENT_FIRST_LOGON_FAILED
//
// MessageText:
//
//  Logon attempt with current password failed with the following error: %n%1
//
#define EVENT_FIRST_LOGON_FAILED         0x80001B65L

//
// MessageId: EVENT_SECOND_LOGON_FAILED
//
// MessageText:
//
//  Second logon attempt with old password also failed with the following error: %n%1
//
#define EVENT_SECOND_LOGON_FAILED        0x80001B66L

//
// MessageId: EVENT_INVALID_DRIVER_DEPENDENCY
//
// MessageText:
//
//  Boot-start or system-start driver (%1) must not depend on a service.
//
#define EVENT_INVALID_DRIVER_DEPENDENCY  0x80001B67L

//
// MessageId: EVENT_BAD_SERVICE_STATE
//
// MessageText:
//
//  The %1 service has reported an invalid current state %2.
//
#define EVENT_BAD_SERVICE_STATE          0x80001B68L

//
// MessageId: EVENT_CIRCULAR_DEPENDENCY_DEMAND
//
// MessageText:
//
//  Detected circular dependencies demand starting %1.
//
#define EVENT_CIRCULAR_DEPENDENCY_DEMAND 0x80001B69L

//
// MessageId: EVENT_CIRCULAR_DEPENDENCY_AUTO
//
// MessageText:
//
//  Detected circular dependencies auto-starting services.
//
#define EVENT_CIRCULAR_DEPENDENCY_AUTO   0x80001B6AL

//
// MessageId: EVENT_DEPEND_ON_LATER_SERVICE
//
// MessageText:
//
//  Circular dependency: The %1 service depends on a service in a group which starts later.
//
#define EVENT_DEPEND_ON_LATER_SERVICE    0x80001B6BL

//
// MessageId: EVENT_DEPEND_ON_LATER_GROUP
//
// MessageText:
//
//  Circular dependency: The %1 service depends on a group which starts later.
//
#define EVENT_DEPEND_ON_LATER_GROUP      0x80001B6CL

//
// MessageId: EVENT_SEVERE_SERVICE_FAILED
//
// MessageText:
//
//  About to revert to the last known good configuration because the %1 service failed to start.
//
#define EVENT_SEVERE_SERVICE_FAILED      0x80001B6DL

//
// MessageId: EVENT_SERVICE_START_HUNG
//
// MessageText:
//
//  The %1 service hung on starting.
//
#define EVENT_SERVICE_START_HUNG         0x80001B6EL

//
// MessageId: EVENT_SERVICE_EXIT_FAILED
//
// MessageText:
//
//  The %1 service terminated with the following error: %n%2
//
#define EVENT_SERVICE_EXIT_FAILED        0x80001B6FL

//
// MessageId: EVENT_SERVICE_EXIT_FAILED_SPECIFIC
//
// MessageText:
//
//  The %1 service terminated with service-specific error %2.
//
#define EVENT_SERVICE_EXIT_FAILED_SPECIFIC 0x80001B70L

//
// MessageId: EVENT_SERVICE_START_AT_BOOT_FAILED
//
// MessageText:
//
//  At least one service or driver failed during system startup.  Use Event Viewer to examine the event log for details.
//
#define EVENT_SERVICE_START_AT_BOOT_FAILED 0x80001B71L

//
// MessageId: EVENT_BOOT_SYSTEM_DRIVERS_FAILED
//
// MessageText:
//
//  The following boot-start or system-start driver(s) failed to load: %1
//
#define EVENT_BOOT_SYSTEM_DRIVERS_FAILED 0x80001B72L

//
// MessageId: EVENT_RUNNING_LASTKNOWNGOOD
//
// MessageText:
//
//  Windows NT could not be started as configured.  A previous working configuration was used instead.
//
#define EVENT_RUNNING_LASTKNOWNGOOD      0x80001B73L

//
// MessageId: EVENT_TAKE_OWNERSHIP
//
// MessageText:
//
//  The %1 Registry key denied access to SYSTEM account programs so the Service Control Manager took ownership of the Registry key.
//
#define EVENT_TAKE_OWNERSHIP             0x80001B74L

//
// This Text is used as a title for the message box used to display
// MessageId 7027.  It is not an event or error message.
//
//
// MessageId: TITLE_SC_MESSAGE_BOX
//
// MessageText:
//
//  Service Control Manager %0
//
#define TITLE_SC_MESSAGE_BOX             0x80001B75L

//
// MessageId: EVENT_SERVICE_NOT_INTERACTIVE
//
// MessageText:
//
//  The %1 service is marked as an interactive service.  However, the system is configured to not allow interactive services.  This service may not function properly.
//
#define EVENT_SERVICE_NOT_INTERACTIVE    0x80001B76L

//
// Schedule (AT command) Service Events 7900 - 7999
//
//
// MessageId: EVENT_COMMAND_NOT_INTERACTIVE
//
// MessageText:
//
//  The %1 command is marked as an interactive command.  However, the system is
//  configured to not allow interactive command execution.  This command may not
//  function properly.
//
#define EVENT_COMMAND_NOT_INTERACTIVE    0x80001EDCL

//
// MessageId: EVENT_COMMAND_START_FAILED
//
// MessageText:
//
//  The %1 command failed to start due to the following error: %n%2
//
#define EVENT_COMMAND_START_FAILED       0x80001EDDL


/////////////////////////////////////////////////////////////////////////
//
// Lanman Bowser/Browser Events (8000-8499)
//
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_BOWSER_OTHER_MASTER_ON_NET
//
// MessageText:
//
//  The master browser has received a server announcement from the computer %2
//  that believes that it is the master browser for the domain on transport %3.
//  The master browser is stopping or an election is being forced.
//
#define EVENT_BOWSER_OTHER_MASTER_ON_NET 0xC0001F43L

//
// MessageId: EVENT_BOWSER_PROMOTED_WHILE_ALREADY_MASTER
//
// MessageText:
//
//  A request has been submitted to promote the computer to backup when it is already a
//  master browser.
//
#define EVENT_BOWSER_PROMOTED_WHILE_ALREADY_MASTER 0x80001F44L

//
// MessageId: EVENT_BOWSER_NON_MASTER_MASTER_ANNOUNCE
//
// MessageText:
//
//  The browser has received a server announcement indicating that the computer %2
//  is a master browser, but this computer is not a master browser.
//
#define EVENT_BOWSER_NON_MASTER_MASTER_ANNOUNCE 0x80001F45L

//
// MessageId: EVENT_BOWSER_ILLEGAL_DATAGRAM
//
// MessageText:
//
//  The browser has received an illegal datagram from the remote computer %2 to name %3 on transport %4.  The data is the datagram.
//
#define EVENT_BOWSER_ILLEGAL_DATAGRAM    0x80001F46L

//
// MessageId: EVENT_BROWSER_STATUS_BITS_UPDATE_FAILED
//
// MessageText:
//
//  The browser was unable to update the service status bits.  The data is the error.
//
#define EVENT_BROWSER_STATUS_BITS_UPDATE_FAILED 0xC0001F47L

//
// MessageId: EVENT_BROWSER_ROLE_CHANGE_FAILED
//
// MessageText:
//
//  The browser was unable to update its role.  The data is the error.
//
#define EVENT_BROWSER_ROLE_CHANGE_FAILED 0xC0001F48L

//
// MessageId: EVENT_BROWSER_MASTER_PROMOTION_FAILED
//
// MessageText:
//
//  The browser was unable to promote itself to master browser.  The computer that currently
//  believes it is the master browser is %1.
//
#define EVENT_BROWSER_MASTER_PROMOTION_FAILED 0xC0001F49L

//
// MessageId: EVENT_BOWSER_NAME_CONVERSION_FAILED
//
// MessageText:
//
//  The browser driver was unable to convert a character string to a unicode string.
//
#define EVENT_BOWSER_NAME_CONVERSION_FAILED 0xC0001F4AL

//
// MessageId: EVENT_BROWSER_OTHERDOMAIN_ADD_FAILED
//
// MessageText:
//
//  The browser was unable to add the configuration parameter %1.
//
#define EVENT_BROWSER_OTHERDOMAIN_ADD_FAILED 0xC0001F4BL

//
// MessageId: EVENT_BOWSER_ELECTION_RECEIVED
//
// MessageText:
//
//  The browser driver has received an election packet from computer %2 on network %3.  The data is the packet received.
//
#define EVENT_BOWSER_ELECTION_RECEIVED   0x00001F4CL

//
// MessageId: EVENT_BOWSER_ELECTION_SENT_GETBLIST_FAILED
//
// MessageText:
//
//  The browser driver has forced an election on network %2 because it was unable to find a master browser to retrieve a backup list on that network.
//
#define EVENT_BOWSER_ELECTION_SENT_GETBLIST_FAILED 0x40001F4DL

//
// MessageId: EVENT_BOWSER_ELECTION_SENT_FIND_MASTER_FAILED
//
// MessageText:
//
//  The browser driver has forced an election on network %2 because it was unable to find a master browser for that network.
//
#define EVENT_BOWSER_ELECTION_SENT_FIND_MASTER_FAILED 0x40001F4EL

//
// MessageId: EVENT_BROWSER_ELECTION_SENT_LANMAN_NT_STARTED
//
// MessageText:
//
//  The browser has forced an election on network %1 because a Windows NT Server (or domain master) browser is started.
//
#define EVENT_BROWSER_ELECTION_SENT_LANMAN_NT_STARTED 0x40001F4FL

//
// MessageId: EVENT_BOWSER_ILLEGAL_DATAGRAM_THRESHOLD
//
// MessageText:
//
//  The browser driver has received too many illegal datagrams from the remote computer %2 to name %3 on transport %4.  The data is the datagram.
//  No more events will be generated until the reset frequency has expired.
//
#define EVENT_BOWSER_ILLEGAL_DATAGRAM_THRESHOLD 0xC0001F50L

//
// MessageId: EVENT_BROWSER_DEPENDANT_SERVICE_FAILED
//
// MessageText:
//
//  The browser has failed to start because the dependent service %1 had invalid service status %2.
//  Status             Meaning
//    1              Service Stopped%n
//    2              Start Pending%n
//    3              Stop Pending%n
//    4              Running%n
//    5              Continue Pending%n
//    6              Pause Pending%n
//    7              Paused%n
//
#define EVENT_BROWSER_DEPENDANT_SERVICE_FAILED 0xC0001F51L

//
// MessageId: EVENT_BROWSER_MASTER_PROMOTION_FAILED_STOPPING
//
// MessageText:
//
//  The browser was unable to promote itself to master browser.  The browser will continue
//  to attempt to promote itself to the master browser, but will no longer log any events in the event log in Event Viewer.
//
#define EVENT_BROWSER_MASTER_PROMOTION_FAILED_STOPPING 0xC0001F53L

//
// MessageId: EVENT_BROWSER_MASTER_PROMOTION_FAILED_NO_MASTER
//
// MessageText:
//
//  The browser was unable to promote itself to master browser.  The computer that currently
//  believes it is the master browser is unknown.
//
#define EVENT_BROWSER_MASTER_PROMOTION_FAILED_NO_MASTER 0xC0001F54L

//
// MessageId: EVENT_BROWSER_SERVER_LIST_FAILED
//
// MessageText:
//
//  The browser was unable to retrieve a list of servers from the browser master %1 on the network %2.
//  The data is the error code.
//
#define EVENT_BROWSER_SERVER_LIST_FAILED 0x80001F55L

//
// MessageId: EVENT_BROWSER_DOMAIN_LIST_FAILED
//
// MessageText:
//
//  The browser was unable to retrieve a list of domains from the browser master %1 on the network %2.
//  The data is the error code.
//
#define EVENT_BROWSER_DOMAIN_LIST_FAILED 0x80001F56L

//
// MessageId: EVENT_BROWSER_ILLEGAL_CONFIG
//
// MessageText:
//
//  The value for the parameter %1 to the browser service was illegal.
//
#define EVENT_BROWSER_ILLEGAL_CONFIG     0x80001F57L

//
// MessageId: EVENT_BOWSER_OLD_BACKUP_FOUND
//
// MessageText:
//
//  The backup browser server %2 is out-of-date.  Consider upgrading this computer.
//
#define EVENT_BOWSER_OLD_BACKUP_FOUND    0x40001F58L

//
// MessageId: EVENT_BROWSER_SERVER_LIST_RETRIEVED
//
// MessageText:
//
//  The browser has retrieved a list of servers from remote computer %1 on transport %2.%n
//  There were %3 entries read, and %4 total entries.
//
#define EVENT_BROWSER_SERVER_LIST_RETRIEVED 0x00001F59L

//
// MessageId: EVENT_BROWSER_DOMAIN_LIST_RETRIEVED
//
// MessageText:
//
//  The browser has retrieved a list of domains from remote computer %1 on transport %2.%n
//  There were %3 entries read, and %4 total entries.
//
#define EVENT_BROWSER_DOMAIN_LIST_RETRIEVED 0x00001F5AL

//
// MessageId: EVENT_BOWSER_PDC_LOST_ELECTION
//
// MessageText:
//
//  The browser running on the Domain Controller has lost an election.  The computer that won the election is %2, on the transport %3.%n
//  The data contains the election version, election criteria, and remote computer time up, and the same information for
//  the current computer.
//
#define EVENT_BOWSER_PDC_LOST_ELECTION   0x40001F5BL

//
// MessageId: EVENT_BOWSER_NON_PDC_WON_ELECTION
//
// MessageText:
//
//  The browser running on this computer has won a browser election on network %2.
//  This computer is a member of a domain, so the Domain Controller should become the master
//  browser.
//
#define EVENT_BOWSER_NON_PDC_WON_ELECTION 0x40001F5CL

//
// MessageId: EVENT_BOWSER_CANT_READ_REGISTRY
//
// MessageText:
//
//  The browser driver was unable to initialize variables from the Registry.
//
#define EVENT_BOWSER_CANT_READ_REGISTRY  0x40001F5DL

//
// MessageId: EVENT_BOWSER_MAILSLOT_DATAGRAM_THRESHOLD_EXCEEDED
//
// MessageText:
//
//  The browser driver has discarded too many mailslot messages.
//
#define EVENT_BOWSER_MAILSLOT_DATAGRAM_THRESHOLD_EXCEEDED 0x40001F5EL

//
// MessageId: EVENT_BOWSER_GETBROWSERLIST_THRESHOLD_EXCEEDED
//
// MessageText:
//
//  The browser driver has discarded too many GetBrowserServerList requests.
//
#define EVENT_BOWSER_GETBROWSERLIST_THRESHOLD_EXCEEDED 0x40001F5FL

//
// MessageId: EVENT_BROWSER_BACKUP_STOPPED
//
// MessageText:
//
//  The browser service has failed to retrieve the backup list too many times on transport %1.
//  The backup browser is stopping.
//
#define EVENT_BROWSER_BACKUP_STOPPED     0xC0001F60L

//
// MessageId: EVENT_BROWSER_ELECTION_SENT_LANMAN_NT_STOPPED
//
// MessageText:
//
//  The browser has forced an election on network %1 because a master browser was stopped.
//
#define EVENT_BROWSER_ELECTION_SENT_LANMAN_NT_STOPPED 0x40001F61L

//
// MessageId: EVENT_BROWSER_GETBLIST_RECEIVED_NOT_MASTER
//
// MessageText:
//
//  The browser has received a GetBrowserServerList request when it is not the master browser.
//
#define EVENT_BROWSER_GETBLIST_RECEIVED_NOT_MASTER 0xC0001F62L

//
// MessageId: EVENT_BROWSER_ELECTION_SENT_ROLE_CHANGED
//
// MessageText:
//
//  The browser has forced an election on network %1 because the Domain Controller (or Server) has changed its role
//
#define EVENT_BROWSER_ELECTION_SENT_ROLE_CHANGED 0x40001F63L

//
// MessageId: EVENT_BROWSER_NOT_STARTED_IPX_CONFIG_MISMATCH
//
// MessageText:
//
//  The browser has failed to start because of an error in the DirectHostBinding parameter to the browser.
//
#define EVENT_BROWSER_NOT_STARTED_IPX_CONFIG_MISMATCH 0xC0001F64L


/////////////////////////////////////////////////////////////////////////
//
// Sap Agent Events (8500-8999)
//
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: NWSAP_EVENT_KEY_NOT_FOUND
//
// MessageText:
//
//  The Registry Key %1 was not present.  The Sap Agent could not start.
//
#define NWSAP_EVENT_KEY_NOT_FOUND        0xC0002134L

//
// MessageId: NWSAP_EVENT_WSASTARTUP_FAILED
//
// MessageText:
//
//  Winsock startup routine failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_WSASTARTUP_FAILED    0xC0002135L

//
// MessageId: NWSAP_EVENT_SOCKET_FAILED
//
// MessageText:
//
//  Socket create call failed for main socket. The Sap Agent cannot continue.
//
#define NWSAP_EVENT_SOCKET_FAILED        0xC0002136L

//
// MessageId: NWSAP_EVENT_SETOPTBCAST_FAILED
//
// MessageText:
//
//  Setting broadcast option on socket failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_SETOPTBCAST_FAILED   0xC0002137L

//
// MessageId: NWSAP_EVENT_BIND_FAILED
//
// MessageText:
//
//  Binding to SAP Socket failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_BIND_FAILED          0xC0002138L

//
// MessageId: NWSAP_EVENT_GETSOCKNAME_FAILED
//
// MessageText:
//
//  Getting bound address of socket failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_GETSOCKNAME_FAILED   0xC0002139L

//
// MessageId: NWSAP_EVENT_OPTEXTENDEDADDR_FAILED
//
// MessageText:
//
//  Setting option EXTENDED_ADDRESS failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_OPTEXTENDEDADDR_FAILED 0xC000213AL

//
// MessageId: NWSAP_EVENT_OPTBCASTINADDR_FAILED
//
// MessageText:
//
//  Setting NWLink option BCASTINTADDR failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_OPTBCASTINADDR_FAILED 0xC000213BL

//
// MessageId: NWSAP_EVENT_CARDMALLOC_FAILED
//
// MessageText:
//
//  Error allocating memory to hold a card structure.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_CARDMALLOC_FAILED    0xC000213CL

//
// MessageId: NWSAP_EVENT_NOCARDS
//
// MessageText:
//
//  Enumeration of cards returned 0 cards.
//
#define NWSAP_EVENT_NOCARDS              0xC000213DL

//
// MessageId: NWSAP_EVENT_THREADEVENT_FAIL
//
// MessageText:
//
//  Error creating thread counting event.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_THREADEVENT_FAIL     0xC000213EL

//
// MessageId: NWSAP_EVENT_RECVSEM_FAIL
//
// MessageText:
//
//  Error creating receive semaphore.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_RECVSEM_FAIL         0xC000213FL

//
// MessageId: NWSAP_EVENT_SENDEVENT_FAIL
//
// MessageText:
//
//  Error creating send event.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_SENDEVENT_FAIL       0xC0002140L

//
// MessageId: NWSAP_EVENT_STARTRECEIVE_ERROR
//
// MessageText:
//
//  Error starting receive thread.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_STARTRECEIVE_ERROR   0xC0002141L

//
// MessageId: NWSAP_EVENT_STARTWORKER_ERROR
//
// MessageText:
//
//  Error starting worker thread.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_STARTWORKER_ERROR    0xC0002142L

//
// MessageId: NWSAP_EVENT_TABLE_MALLOC_FAILED
//
// MessageText:
//
//  Error allocating database array.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_TABLE_MALLOC_FAILED  0xC0002143L

//
// MessageId: NWSAP_EVENT_HASHTABLE_MALLOC_FAILED
//
// MessageText:
//
//  Error allocating hash table.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_HASHTABLE_MALLOC_FAILED 0xC0002144L

//
// MessageId: NWSAP_EVENT_STARTLPCWORKER_ERROR
//
// MessageText:
//
//  Error starting LPC worker thread.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_STARTLPCWORKER_ERROR 0xC0002145L

//
// MessageId: NWSAP_EVENT_CREATELPCPORT_ERROR
//
// MessageText:
//
//  Error creating the LPC port.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_CREATELPCPORT_ERROR  0xC0002146L

//
// MessageId: NWSAP_EVENT_CREATELPCEVENT_ERROR
//
// MessageText:
//
//  Error creating the LPC thread event.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_CREATELPCEVENT_ERROR 0xC0002147L

//
// MessageId: NWSAP_EVENT_LPCLISTENMEMORY_ERROR
//
// MessageText:
//
//  Error allocating memory for an LPC Client structure.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_LPCLISTENMEMORY_ERROR 0xC0002148L

//
// MessageId: NWSAP_EVENT_LPCHANDLEMEMORY_ERROR
//
// MessageText:
//
//  Error allocating buffer to hold LPC worker thread handles.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_LPCHANDLEMEMORY_ERROR 0xC0002149L

//
// MessageId: NWSAP_EVENT_BADWANFILTER_VALUE
//
// MessageText:
//
//  The value for WANFilter in the registry must be 0-2.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_BADWANFILTER_VALUE   0xC000214AL

//
// MessageId: NWSAP_EVENT_CARDLISTEVENT_FAIL
//
// MessageText:
//
//  Error creating event for card list access synchronization.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_CARDLISTEVENT_FAIL   0xC000214BL

//
// MessageId: NWSAP_EVENT_SDMDEVENT_FAIL
//
// MessageText:
//
//  Error creating event for database access synchronization.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_SDMDEVENT_FAIL       0xC000214CL

//
// MessageId: NWSAP_EVENT_INVALID_FILTERNAME
//
// MessageText:
//
//  Name too long in key %1: Name = %s.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_INVALID_FILTERNAME   0x8000214DL

//
// MessageId: NWSAP_EVENT_WANSEM_FAIL
//
// MessageText:
//
//  Error creating WAN control semaphore.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_WANSEM_FAIL          0xC000214EL

//
// MessageId: NWSAP_EVENT_WANSOCKET_FAILED
//
// MessageText:
//
//  Socket create call failed for WAN socket.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_WANSOCKET_FAILED     0xC000214FL

//
// MessageId: NWSAP_EVENT_WANBIND_FAILED
//
// MessageText:
//
//  Binding to WAN socket failed.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_WANBIND_FAILED       0xC0002150L

//
// MessageId: NWSAP_EVENT_STARTWANWORKER_ERROR
//
// MessageText:
//
//  Error starting WAN worker thread.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_STARTWANWORKER_ERROR 0xC0002151L

//
// MessageId: NWSAP_EVENT_STARTWANCHECK_ERROR
//
// MessageText:
//
//  Error starting WAN check thread.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_STARTWANCHECK_ERROR  0xC0002152L

//
// MessageId: NWSAP_EVENT_OPTMAXADAPTERNUM_ERROR
//
// MessageText:
//
//  Error on getsockopt IPX_MAX_ADAPTER_NUM.  Data is the error code.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_OPTMAXADAPTERNUM_ERROR 0xC0002153L

//
// MessageId: NWSAP_EVENT_WANHANDLEMEMORY_ERROR
//
// MessageText:
//
//  Error allocating buffer to hold WAN notify thread handles.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_WANHANDLEMEMORY_ERROR 0xC0002154L

//
// MessageId: NWSAP_EVENT_WANEVENT_ERROR
//
// MessageText:
//
//  Error creating the WAN thread event.  The Sap Agent cannot continue.
//
#define NWSAP_EVENT_WANEVENT_ERROR       0xC0002155L


/////////////////////////////////////////////////////////////////////////
//
// Transport Events (9000-9499)
//
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_TRANSPORT_RESOURCE_POOL
//
// MessageText:
//
//  %2 could not allocate a resource of type %3 due to system resource problems.
//
#define EVENT_TRANSPORT_RESOURCE_POOL    0x80002329L

//
// MessageId: EVENT_TRANSPORT_RESOURCE_LIMIT
//
// MessageText:
//
//  %2 could not allocate a resource of type %3 due to its configured size of %4.
//
#define EVENT_TRANSPORT_RESOURCE_LIMIT   0x8000232AL

//
// MessageId: EVENT_TRANSPORT_RESOURCE_SPECIFIC
//
// MessageText:
//
//  %2 could not allocate a resource of type %3 due to a specifically configured limit of %4.
//
#define EVENT_TRANSPORT_RESOURCE_SPECIFIC 0x8000232BL

//
// MessageId: EVENT_TRANSPORT_REGISTER_FAILED
//
// MessageText:
//
//  %2 failed to register itself with the NDIS wrapper.
//
#define EVENT_TRANSPORT_REGISTER_FAILED  0xC000232CL

//
// MessageId: EVENT_TRANSPORT_BINDING_FAILED
//
// MessageText:
//
//  %2 failed to bind to adapter %3.
//
#define EVENT_TRANSPORT_BINDING_FAILED   0xC000232DL

//
// MessageId: EVENT_TRANSPORT_ADAPTER_NOT_FOUND
//
// MessageText:
//
//  %2 could not find adapter %3.
//
#define EVENT_TRANSPORT_ADAPTER_NOT_FOUND 0xC000232EL

//
// MessageId: EVENT_TRANSPORT_SET_OID_FAILED
//
// MessageText:
//
//  %2 failed while setting OID %3 on adapter %4.
//
#define EVENT_TRANSPORT_SET_OID_FAILED   0xC000232FL

//
// MessageId: EVENT_TRANSPORT_QUERY_OID_FAILED
//
// MessageText:
//
//  %2 failed while querying OID %3 on adapter %4.
//
#define EVENT_TRANSPORT_QUERY_OID_FAILED 0xC0002330L

//
// MessageId: EVENT_TRANSPORT_TRANSFER_DATA
//
// MessageText:
//
//  %2 could not transfer a packet from the adapter.  The packet was dropped.
//
#define EVENT_TRANSPORT_TRANSFER_DATA    0x40002331L

//
// MessageId: EVENT_TRANSPORT_TOO_MANY_LINKS
//
// MessageText:
//
//  %2 could not create a link to a remote computer.  Your computer has exceeded the number of connections it can make to that remote computer.
//
#define EVENT_TRANSPORT_TOO_MANY_LINKS   0x40002332L

//
// MessageId: EVENT_TRANSPORT_BAD_PROTOCOL
//
// MessageText:
//
//  %2 received an unexpected %3 packet from a remote computer.
//
#define EVENT_TRANSPORT_BAD_PROTOCOL     0x40002333L


/////////////////////////////////////////////////////////////////////////
//
// IPX/SPX Events (9500-9999)
//
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_IPX_NEW_DEFAULT_TYPE
//
// MessageText:
//
//  The default frame type for auto-detection on %2 was changed to %3.
//  This type is now the default if no frame type can be detected.
//
#define EVENT_IPX_NEW_DEFAULT_TYPE       0x4000251DL

//
// MessageId: EVENT_IPX_SAP_ANNOUNCE
//
// MessageText:
//
//  A SAP announcement was sent over %2 which is configured for multiple
//  networks, but no internal network is configured. This may prevent
//  machines on some networks from locating the advertised service.
//
#define EVENT_IPX_SAP_ANNOUNCE           0x8000251EL

//
// MessageId: EVENT_IPX_ILLEGAL_CONFIG
//
// MessageText:
//
//  The value for the %2 parameter %3 was illegal.
//
#define EVENT_IPX_ILLEGAL_CONFIG         0x8000251FL

//
// MessageId: EVENT_IPX_INTERNAL_NET_INVALID
//
// MessageText:
//
//  %2 was configured with an internal network number of %3. This network
//  number conflicts with one of the attached networks. The configured
//  internal network number will be ignored.
//
#define EVENT_IPX_INTERNAL_NET_INVALID   0xC0002520L

//
// MessageId: EVENT_IPX_NO_FRAME_TYPES
//
// MessageText:
//
//  %2 had no frame types configured for the binding to adapter %3.
//
#define EVENT_IPX_NO_FRAME_TYPES         0xC0002521L

//
// MessageId: EVENT_IPX_CREATE_DEVICE
//
// MessageText:
//
//  %2 failed to initialize because the driver device could not be created.
//
#define EVENT_IPX_CREATE_DEVICE          0xC0002522L

//
// MessageId: EVENT_IPX_NO_ADAPTERS
//
// MessageText:
//
//  %2 could not bind to any adapters. The transport could not start.
//
#define EVENT_IPX_NO_ADAPTERS            0xC0002523L


/////////////////////////////////////////////////////////////////////////
//
// DCOM Events (10000-10999)
//
//
/////////////////////////////////////////////////////////////////////////


//
// MessageId: EVENT_RPCSS_CREATEPROCESS_FAILURE
//
// MessageText:
//
//  Unable to start a DCOM Server: %3.
//  The error:%n"%%%2"%nHappened while starting this command:%n%1
//
#define EVENT_RPCSS_CREATEPROCESS_FAILURE 0xC0002710L

//
// MessageId: EVENT_RPCSS_RUNAS_CREATEPROCESS_FAILURE
//
// MessageText:
//
//  Unable to start a DCOM Server: %3 as %4/%5.
//  The error:%n"%%%2"%nHappened while starting this command:%n%1
//
#define EVENT_RPCSS_RUNAS_CREATEPROCESS_FAILURE 0xC0002711L

//
// MessageId: EVENT_RPCSS_LAUNCH_ACCESS_DENIED
//
// MessageText:
//
//  Access denied attempting to launch a DCOM Server.
//  The server is:%n%1
//
#define EVENT_RPCSS_LAUNCH_ACCESS_DENIED 0xC0002712L

//
// MessageId: EVENT_RPCSS_DEFAULT_LAUNCH_ACCESS_DENIED
//
// MessageText:
//
//  Access denied attempting to launch a DCOM Server using DefaultLaunchPermssion.
//  The server is:%n%1
//
#define EVENT_RPCSS_DEFAULT_LAUNCH_ACCESS_DENIED 0xC0002713L

//
// MessageId: EVENT_RPCSS_RUNAS_CANT_LOGIN
//
// MessageText:
//
//  DCOM got error "%%%1" and was unable to logon %2\%3
//  in order to run the server:%n%4
//
#define EVENT_RPCSS_RUNAS_CANT_LOGIN     0xC0002714L

//
// MessageId: EVENT_RPCSS_START_SERVICE_FAILURE
//
// MessageText:
//
//  DCOM got error "%%%1" attempting to start the service %2 with arguments "%3"
//  in order to run the server:%n%4
//
#define EVENT_RPCSS_START_SERVICE_FAILURE 0xC0002715L

//
// MessageId: EVENT_RPCSS_REMOTE_SIDE_ERROR
//
// MessageText:
//
//  DCOM got error "%%%1" from the computer %2 when attempting to
//  activate the server:%n%3
//
#define EVENT_RPCSS_REMOTE_SIDE_ERROR    0xC0002716L

//
// MessageId: EVENT_RPCSS_ACTIVATION_ERROR
//
// MessageText:
//
//  DCOM got error "%%%1" when attempting to
//  activate the server:%n%2
//
#define EVENT_RPCSS_ACTIVATION_ERROR     0xC0002717L

//
// MessageId: EVENT_RPCSS_REMOTE_SIDE_ERROR_WITH_FILE
//
// MessageText:
//
//  DCOM got error "%%%1" from the computer %2 when attempting to
//  the server:%n%3 with file %4.
//
#define EVENT_RPCSS_REMOTE_SIDE_ERROR_WITH_FILE 0xC0002718L

//
// MessageId: EVENT_RPCSS_REMOTE_SIDE_UNAVAILABLE
//
// MessageText:
//
//  DCOM was unable to communicate with the computer %1 using any of the configured
//  protocols.
//
#define EVENT_RPCSS_REMOTE_SIDE_UNAVAILABLE 0xC0002719L

//
// MessageId: EVENT_RPCSS_SERVER_START_TIMEOUT
//
// MessageText:
//
//  The server %1 did not register with DCOM within the required timeout.
//
#define EVENT_RPCSS_SERVER_START_TIMEOUT 0xC000271AL

//
// MessageId: EVENT_RPCSS_SERVER_NOT_RESPONDING
//
// MessageText:
//
//  The server %1 could not be contacted to establish the connection to the client
//
#define EVENT_RPCSS_SERVER_NOT_RESPONDING 0xC000271BL


#endif // _NETEVENT

