## $Id: ip-sentinel.spec.in,v 1.2 2002/11/15 23:45:27 ensc Exp $		--*- rpm-spec -*--

%{!?username:%define	username	ip-sentinel}
%define		service		ip-sentinel
%define		homedir		%{_var}/lib/ip-sentinel

Summary:	A tool to prevent unauthorized usage of IPs
Name:		ip-sentinel
Version:	0.2
Release:	1
License:	GPL
Group:		System Environment/Daemons
Packager:	Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de>
URL:		http://www.tu-chemnitz.de/~ensc/ip-sentinel
Source0:	http://www.tu-chemnitz.de/~ensc/ip-sentinel/files/%{name}-%{version}.tar.bz2
PreReq:		/sbin/chkconfig /usr/sbin/userdel /usr/sbin/adduser
PreReq:		/sbin/service
BuildRoot:	%{_tmppath}/%{name}-%{version}-buildroot

%if %{?_without_dietlibc:0}%{!?_without_dietlibc:1}
BuildRequires:	dietlibc
%endif


%description


%prep
%setup -q


%build
%configure --enable-release --with-username=%{username} %{?_without_dietlibc:--disable-dietlibc}
%{__make} all check


%install
rm -rf $RPM_BUILD_ROOT

make DESTDIR=${RPM_BUILD_ROOT} install-strip install-contrib

install -d ${RPM_BUILD_ROOT}%{_sysconfdir}
install -m750 -d ${RPM_BUILD_ROOT}%{homedir}


%clean
rm -rf $RPM_BUILD_ROOT


%pre
/usr/sbin/adduser -r -s /sbin/nologin -d %{homedir} -M		\
	 	  -c 'IP sentinel user' %{username} &>/dev/null || true

%post
/sbin/chkconfig --add %{service}

%preun
if test "$1" = "0"; then
	/sbin/chkconfig --del %{service}
fi

%postun
if test "$1" = "0"; then
	/usr/sbin/userdel %{username} &>/dev/null || true
elif test "$1" -ge 1; then
	/sbin/service %{service} condrestart >/dev/null
fi


%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README THANKS
%doc %{_mandir}/*/*
%config /etc/init.d/*
%config(noreplace) /etc/sysconfig/*
%{_sbindir}/*
%attr(-,root,%{username}) %{homedir}


%changelog
* Fri Nov 15 2002 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de> 0.1-1
- initial build
