## $id: ip-sentinel.spec.in,v 1.3 2003/05/26 21:53:02 ensc Exp $		--*- rpm-spec -*--

%{!?username:%define username	ip-sentinel}
%define		service		ip-sentinel
%define		homedir		%{_var}/lib/ip-sentinel

Summary:	A tool to prevent unauthorized usage of IPs
Name:		ip-sentinel
Version:	0.4
Release:	1
Epoch:		0
License:	GPL
Group:		System Environment/Daemons
URL:		http://www.tu-chemnitz.de/~ensc/ip-sentinel
Source0:	http://www.tu-chemnitz.de/~ensc/ip-sentinel/files/%{name}-%{version}.tar.bz2
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-buildroot
Requires(pre):		/usr/sbin/useradd /usr/sbin/groupadd
Requires(postun):	/usr/sbin/userdel /usr/sbin/groupdel
Requires(post,preun):	/sbin/chkconfig

%if %{?_without_dietlibc:0}%{!?_without_dietlibc:1}
BuildRequires:	dietlibc
%endif


%description
IP Sentinel is a tool that tries to prevent unauthorized usage of
IP addresses within an ethernet broadcast domain by answering ARP
requests. After receiving faked replies, requesting parties store
the MAC in their ARP tables and will send future packets to this
invalid MAC, rendering the IP unreachable.


%prep
%setup -q


%build
%configure --enable-release --with-username=%{username} %{?_without_dietlibc:--disable-dietlibc}
%{__make} %{?_smp_mflags} all
%{__make} check


%install
rm -rf $RPM_BUILD_ROOT

%{__make} DESTDIR=${RPM_BUILD_ROOT} install

%{__install} -d ${RPM_BUILD_ROOT}{%{_sysconfdir}/sysconfig,%{_initrddir}}
%{__install} -m755 -p contrib/ip-sentinel.init      $RPM_BUILD_ROOT%{_initrddir}/ip-sentinel
%{__install} -m644 -p contrib/ip-sentinel.sysconfig $RPM_BUILD_ROOT%{_sysconfdir}/sysconfig/ip-sentinel
%{__install} -m750 -d ${RPM_BUILD_ROOT}%{homedir}


%clean
rm -rf $RPM_BUILD_ROOT


%pre
/usr/sbin/groupadd -r %{username} &>/dev/null || :
/usr/sbin/useradd -r -s /sbin/nologin -M -d %{homedir}		\
	 	  -c 'IP sentinel user' -g %{username} %{username} &>/dev/null || :

%post
/sbin/chkconfig --add %{service}

%preun
if test "$1" = "0"; then
	%{_initrddir}/%{service} stop >/dev/null
	/sbin/chkconfig --del %{service}
fi

%postun
if test "$1" = "0"; then
	/usr/sbin/userdel  %{username} &>/dev/null || :
	/usr/sbin/groupdel %{username} &>/dev/null || :
elif test "$1" -ge 1; then
	%{_initrddir}/%{service} condrestart >/dev/null
fi


%files
%defattr(-,root,root,-)
%doc AUTHORS COPYING ChangeLog NEWS README THANKS
%doc %{_mandir}/*/*
%{_sbindir}/*
%config %{_initrddir}/*
%config(noreplace) %{_sysconfdir}/sysconfig/*
%attr(-,root,%{username}) %{homedir}


%changelog
* Sat May 24 2003 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de> 0:0.4-1
- removed dependencies on /sbin/service
- removed packager tag
- create and remove group explicitely

* Wed May 21 2003 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de> 0:0.3-1
- applied fedora.us naming scheme
- cleanups

* Fri Nov 15 2002 Enrico Scholz <enrico.scholz@informatik.tu-chemnitz.de> 0.1-1
- initial build
