/* IRPAS project - packet library
 *
 * FX <fx@phenoelit.de>
 * Phenoelit (http://www.phenoelit.de)
 * (c) 2k
 *
 * $Id: packets.h,v 1.1 2000/09/26 08:32:06 fx Exp fx $
 */

#ifndef _PACKET_H_
#define _PACKET_H_

typedef struct {
        /* Ethernet address of the interface */
        struct ether_addr   eth;
	/* IPv4 address of the interface */
	struct in_addr      ip;
	/* Maximum transfer unit for this interface */
	unsigned int        mtu;
} packet_ifconfig_t;

extern packet_ifconfig_t	 packet_ifconfig;

void    	*smalloc(size_t size);

/* network init */
int     	init_socket_eth(char *device);
int     	init_socket_IP4(char *device, int broadcast);

/* network sending */
int     	sendpack_IP4(int sfd, u_char *packet,int plength);
int     	sendpack_eth(char *device, int atsock,
			u_char *frame, int frame_length);

/* checksum */
u_int16_t 	chksum(u_char *data, unsigned long count);

#endif _PACKET_H_
