#ifndef _PROTOCOLS_H_
#define _PROTOCOLS_H_

#include <net/ethernet.h>
#include <net/if.h>

/* ************************************************************
 * Ethernet Frames
 * ************************************************************/
/* IEEE 802.3, LLC related structs */
struct eth_ieee802_3 {
    struct ether_addr   daddr;
    struct ether_addr   saddr;
    u_int16_t           length;
};

struct eth_LLC {
    u_int8_t            DSAP;
    u_int8_t            SSAP;
    u_int8_t            Control;
    u_int8_t            orgcode[3];
    u_int16_t           proto;
};

/* ************************************************************
 * CDP frames
 * ************************************************************/

/* CDP header */
struct cdphdr {
    u_int8_t            version;
    u_int8_t            ttl;
    u_int16_t           checksum;
};
/* CDP sections */
#define TYPE_DEVICE_ID          0x0001
#define TYPE_ADDRESS            0x0002
#define TYPE_PORT_ID            0x0003
#define TYPE_CAPABILITIES       0x0004
#define TYPE_IOS_VERSION        0x0005
#define TYPE_PLATFORM           0x0006

struct cdp_device {
    u_int16_t           type;           /* 0x0001 */
    u_int16_t           length;
    u_char              device;         /* pointer to device name */
};

struct cdp_address {
    u_int16_t           type;           /* 0x0002 */
    u_int16_t           length;
    u_int32_t           number;         /* number of addresses */
};

struct cdp_address_entry {
    u_int8_t            proto_type;     /* 0x1 for NLPID */
    u_int8_t            length;         /* 0x1 for IP */
    u_int8_t            proto;          /* 0xCC for IP */
    u_int8_t            addrlen[2];
    u_char              addr;
};

struct cdp_port {
    u_int16_t           type;           /* 0x0003 */
    u_int16_t           length;
    u_char              port;           /* pointer to port name */
};

#define CDP_CAP_LEVEL1          0x40
#define CDP_CAP_FORWARD_IGMP    0x20
#define CDP_CAP_NETWORK_LAYER   0x10
#define CDP_CAP_LEVEL2_SWITCH   0x08
#define CDP_CAP_LEVEL2_SRB      0x04
#define CDP_CAP_LEVEL2_TRBR     0x02
#define CDP_CAP_LEVEL3_ROUTER   0x01
struct cdp_capabilities {
    u_int16_t           type;           /* 0x0004 */
    u_int16_t           length;         /* is 8 */
    u_int32_t           capab;
};

struct cdp_software {
    u_int16_t           type;           /* 0x0005 */
    u_int16_t           length;
    u_char              software;       /* pointer to software string */
};

struct cdp_platform {
    u_int16_t           type;           /* 0x0006 */
    u_int16_t           length;
    u_char              platform;       /* pointer to platform string */
};


/* ************************************************************
 * IP version 4
 * ************************************************************/
#define IPPROTO_IGRP    0x09
#define IPPROTO_ICMP	0x01

#define IP_ADDR_LEN	4
typedef struct {
        u_int8_t        ihl:4,          /* header length */
                        version:4;      /* version */
        u_int8_t        tos;            /* type of service */
        u_int16_t       tot_len;        /* total length */
        u_int16_t       id;             /* identification */
        u_int16_t       off;            /* fragment offset field */
        u_int8_t        ttl;            /* time to live */
        u_int8_t        protocol;       /* protocol */
        u_int16_t       check;          /* checksum */
        struct in_addr  saddr;
        struct in_addr  daddr;  /* source and dest address */
} iphdr_t;

/* ************************************************************
 * IGRP 
 * ************************************************************/
#define IGRP_OPCODE_REQUEST     2
#define IGRP_OPCODE_UPDATE      1

typedef struct {
    u_int8_t            opcode:4,version:4;
    u_int8_t            edition;
    u_int16_t           autosys;
    u_int16_t           interior;       /* interior routes */
    u_int16_t           system;         /* system routes */
    u_int16_t           exterior;       /* exterior routes */
    u_int16_t           checksum;
} igrp_t;

/* 
 * comment:
 *      the thing with delay[3] ... is very ugly, but I'm not good 
 *      in representing this perhaps 3 byte long data type correctly.
 *      Cisco's documentation has still free space for improvements  ...
 */
typedef struct {
    u_int8_t            destination[3]  __attribute__ ((packed));
    u_int8_t            delay[3]        __attribute__ ((packed));
    u_int8_t            bandwith[3]     __attribute__ ((packed));
    u_int16_t           mtu             __attribute__ ((packed));
    u_int8_t            reliability     __attribute__ ((packed));
    u_int8_t            load            __attribute__ ((packed));
    u_int8_t            hopcount        __attribute__ ((packed));
} igrp_system_entry_t;


/* ************************************************************
 * ICMP
 * ************************************************************/
#define ICMP_ECHOREPLY          0       /* Echo Reply                   */
#define ICMP_DEST_UNREACH       3       /* Destination Unreachable      */
#define ICMP_SOURCE_QUENCH      4       /* Source Quench                */
#define ICMP_REDIRECT           5       /* Redirect (change route)      */
#define ICMP_ECHO               8       /* Echo Request                 */
#define ICMP_ROUTER_ADVERT	9	/* router advertisement 	*/
#define ICMP_SOLICITATION	10	/* router solicitation		*/
#define ICMP_TIME_EXCEEDED      11      /* Time Exceeded                */
#define ICMP_PARAMETERPROB      12      /* Parameter Problem            */
#define ICMP_TIMESTAMP          13      /* Timestamp Request            */
#define ICMP_TIMESTAMPREPLY     14      /* Timestamp Reply              */
#define ICMP_INFO_REQUEST       15      /* Information Request          */
#define ICMP_INFO_REPLY         16      /* Information Reply            */
#define ICMP_ADDRESS            17      /* Address Mask Request         */
#define ICMP_ADDRESSREPLY       18      /* Address Mask Reply           */
/* Codes for REDIRECT. */
#define ICMP_REDIR_NET          0       /* Redirect Net                 */
#define ICMP_REDIR_HOST         1       /* Redirect Host                */
#define ICMP_REDIR_NETTOS       2       /* Redirect Net for TOS         */
#define ICMP_REDIR_HOSTTOS      3       /* Redirect Host for TOS        */

typedef struct {
    u_int8_t type;                /* message type */
    u_int8_t code;                /* type sub-code */
    u_int16_t checksum;
} icmphdr_t;

typedef struct {
    u_int8_t	num_addr;
    u_int8_t	addrsize;
    u_int16_t	lifetime;
} irdp_t;

typedef struct {
    u_int8_t	addr[4];
    u_int32_t	pref;
} irdp_rec_t;

typedef struct {
    u_int8_t	type;                /* message type */
    u_int8_t	code;                /* type sub-code */
    u_int16_t	checksum;
    u_int32_t	reserved;
} irdp_solicitation_t;

#endif _PROTOCOLS_H_
