/*
 * route.c
 *
 * Kernel route table operations.
 *
 * Copyright (c) 2000 Dug Song <dugsong@monkey.org>
 *
 * $Id: route.h,v 1.1.1.1 2001/10/11 04:14:48 dugsong Exp $
 */

#ifndef DNET_ROUTE_H
#define DNET_ROUTE_H

typedef struct route_handle route_t;

typedef int (*route_handler)(struct addr *dst, struct addr *gw, void *arg);

route_t	*route_open(void);
int	 route_add(route_t *r, struct addr *dst, struct addr *gw);
int	 route_delete(route_t *r, struct addr *dst);
int	 route_get(route_t *r, struct addr *dst, struct addr *gw);
int	 route_loop(route_t *r, route_handler callback, void *arg);
int	 route_close(route_t *r);

#endif /* DNET_ROUTE_H */
