/*
 * fw.h
 *
 * Network firewalling operations.
 *
 * Copyright (c) 2001 Dug Song <dugsong@monkey.org>
 *
 * $Id: fw.h,v 1.7 2001/12/26 17:00:32 dugsong Exp $
 */

#ifndef DNET_FW_H
#define DNET_FW_H

struct fw_rule {
	char		device[14];	/* interface name */
	u_char		op:4,		/* operation */
			direction:4;	/* direction */
	u_char		proto;		/* IP protocol */
	struct addr	src;		/* src address / net */
	struct addr	dst;		/* dst address / net */
	u_short		sport[2];	/* range or ICMP type / mask */
	u_short		dport[2];	/* range or ICMP code / mask */
};

#define FW_OP_ALLOW	1
#define FW_OP_BLOCK	2

#define FW_DIR_IN	1
#define FW_DIR_OUT	2

typedef struct fw_handle fw_t;

typedef int (*fw_handler)(struct fw_rule *rule, void *arg);

__BEGIN_DECLS
fw_t	*fw_open(void);
int	 fw_add(fw_t *f, struct fw_rule *rule);
int	 fw_delete(fw_t *f, struct fw_rule *rule);
int	 fw_loop(fw_t *f, fw_handler callback, void *arg);
int	 fw_close(fw_t *f);

#define fw_fill_rule(rule, dev, o, dir, p, s, d, sp1, sp2, dp1, dp2) \
do {									\
	strlcpy((rule)->device, dev, sizeof((rule)->device));		\
	(rule)->op = o; (rule)->direction = dir;			\
	(rule)->proto = p;						\
	memmove(&(rule)->src, &(s), sizeof((rule)->src));		\
	memmove(&(rule)->dst, &(d), sizeof((rule)->dst));		\
	(rule)->sport[0] = sp1; (rule)->sport[1] = sp2;			\
	(rule)->dport[0] = dp1; (rule)->dport[1] = dp2;			\
} while (0)
__END_DECLS

#endif /* DNET_FW_H */
