/* Generated by Pyrex 0.9 on Fri Feb 25 18:05:12 2005 */

#include "Python.h"
#include "structmember.h"
#include "dnet.h"


static PyObject *__Pyx_UnpackItem(PyObject *, int); /*proto*/
static int __Pyx_EndUnpack(PyObject *, int); /*proto*/
static int __Pyx_PrintItem(PyObject *); /*proto*/
static int __Pyx_PrintNewline(void); /*proto*/
static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb); /*proto*/
static void __Pyx_ReRaise(void); /*proto*/
static PyObject *__Pyx_Import(PyObject *name, PyObject *from_list); /*proto*/
static PyObject *__Pyx_GetExcValue(void); /*proto*/
static PyObject *__Pyx_GetName(PyObject *dict, char *name); /*proto*/
static int __Pyx_ArgTypeTest(PyObject *obj, PyTypeObject *type, int none_allowed, char *name); /*proto*/
static int __Pyx_TypeTest(PyObject *obj, PyTypeObject *type); /*proto*/
static int __Pyx_GetStarArgs(PyObject **args, PyObject **kwds, char *kwd_list[], int nargs, PyObject **args2, PyObject **kwds2); /*proto*/
static void __Pyx_WriteUnraisable(char *name); /*proto*/
static void __Pyx_AddTraceback(char *funcname); /*proto*/
static PyTypeObject *__Pyx_ImportType(char *module_name, char *class_name, long size);  /*proto*/
static int __Pyx_SetVtable(PyObject *dict, void *vtable); /*proto*/
static int __Pyx_GetVtable(PyObject *dict, void **vtabptr); /*proto*/

static PyObject *__pyx_m;
static PyObject *__pyx_b;
static int __pyx_lineno;
static char *__pyx_filename;
staticforward char **__pyx_f;

static char __pyx_mdoc[] = "dumb networking library\n\nThis module provides a simplified interface to several low-level\nnetworking routines, including network address manipulation, kernel\narp(4) cache and route(4) table lookup and manipulation, network\nfirewalling, network interface lookup and manipulation, IP tunnelling,\nand raw IP packet and Ethernet frame transmission.\n";

/* Declarations from dnet */

enum  {
  __pyx_e_4dnet_TEADELTA = 2654435769,
  __pyx_e_4dnet_TEAROUNDS = 32,
  __pyx_e_4dnet_TEASBOXSIZE = 128,
  __pyx_e_4dnet_TEASBOXSHIFT = 7,
};

staticforward PyTypeObject __pyx_type_4dnet_eth;

struct __pyx_obj_4dnet_eth {
  PyObject_HEAD
  eth_t (*eth);
};

staticforward PyTypeObject __pyx_type_4dnet_ip;

struct __pyx_obj_4dnet_ip {
  PyObject_HEAD
  ip_t (*ip);
};

staticforward PyTypeObject __pyx_type_4dnet_addr;

struct __pyx_obj_4dnet_addr {
  PyObject_HEAD
  struct addr _addr;
};

staticforward PyTypeObject __pyx_type_4dnet___addr_ip4_iter;

struct __pyx_obj_4dnet___addr_ip4_iter {
  PyObject_HEAD
  unsigned long cur;
  unsigned long max;
};

staticforward PyTypeObject __pyx_type_4dnet_arp;

struct __pyx_obj_4dnet_arp {
  PyObject_HEAD
  arp_t (*arp);
};

staticforward PyTypeObject __pyx_type_4dnet_intf;

struct __pyx_obj_4dnet_intf {
  PyObject_HEAD
  intf_t (*intf);
};

staticforward PyTypeObject __pyx_type_4dnet_route;

struct __pyx_obj_4dnet_route {
  PyObject_HEAD
  route_t (*route);
};

staticforward PyTypeObject __pyx_type_4dnet_fw;

struct __pyx_obj_4dnet_fw {
  PyObject_HEAD
  fw_t (*fw);
};

staticforward PyTypeObject __pyx_type_4dnet_rand;

struct __pyx_obj_4dnet_rand {
  PyObject_HEAD
  rand_t (*rand);
};

staticforward PyTypeObject __pyx_type_4dnet___rand_xrange;

struct __pyx_obj_4dnet___rand_xrange {
  PyObject_HEAD
  rand_t (*rand);
  unsigned long cur;
  unsigned long enc;
  unsigned long max;
  unsigned long mask;
  unsigned long start;
  unsigned long sboxmask;
  unsigned int (sbox[128]);
  int left;
  int right;
  int kshift;
};

staticforward PyTypeObject __pyx_type_4dnet_tun;

struct __pyx_obj_4dnet_tun {
  PyObject_HEAD
  tun_t (*tun);
  char (*buf);
  int mtu;
};

static PyTypeObject *__pyx_ptype_4dnet_eth = 0;
static PyTypeObject *__pyx_ptype_4dnet_ip = 0;
static PyTypeObject *__pyx_ptype_4dnet_addr = 0;
static PyTypeObject *__pyx_ptype_4dnet___addr_ip4_iter = 0;
static PyTypeObject *__pyx_ptype_4dnet_arp = 0;
static PyTypeObject *__pyx_ptype_4dnet_intf = 0;
static PyTypeObject *__pyx_ptype_4dnet_route = 0;
static PyTypeObject *__pyx_ptype_4dnet_fw = 0;
static PyTypeObject *__pyx_ptype_4dnet_rand = 0;
static PyTypeObject *__pyx_ptype_4dnet___rand_xrange = 0;
static PyTypeObject *__pyx_ptype_4dnet_tun = 0;
static PyObject *__pyx_k16;
static PyObject *__pyx_k17;
static PyObject *__pyx_k18;
static PyObject *__pyx_k24;
static PyObject *__pyx_k25;
static PyObject *__pyx_k26;
static PyObject *__pyx_k27;
static PyObject *__pyx_k28;
static PyObject *__pyx_k29;
static PyObject *__pyx_k30;
static PyObject *__pyx_k31;
static PyObject *__pyx_k34;
static PyObject *__pyx_k35;
static PyObject *__pyx_k36;
static PyObject *__pyx_k37;
static PyObject *__pyx_k38;
static PyObject *__pyx_k39;
static PyObject *__pyx_k40;
static PyObject *__pyx_k41;
static PyObject *__pyx_k42;
static PyObject *__pyx_k43;
static PyObject *__pyx_k44;
static PyObject *__pyx_k45;
static PyObject *__pyx_k46;
static PyObject *__pyx_k47;
static PyObject *__pyx_k48;
static PyObject *__pyx_k49;
static PyObject *__pyx_k50;
static PyObject *__pyx_k51;
static PyObject *__pyx_k52;
static PyObject *__pyx_k53;
static PyObject *__pyx_k54;
static PyObject *__pyx_k55;
static PyObject *__pyx_k56;
static PyObject *__pyx_k57;
static PyObject *__pyx_k58;
static PyObject *__pyx_k59;
static PyObject *(__pyx_f_4dnet___memcpy(char (*),PyObject *,int )); /*proto*/
static PyObject *(__pyx_f_4dnet___oserror(void)); /*proto*/
static int (__pyx_f_4dnet___arp_callback(struct arp_entry (*),void (*))); /*proto*/
static PyObject *(__pyx_f_4dnet_ifent_to_dict(struct intf_entry (*))); /*proto*/
static PyObject *(__pyx_f_4dnet_dict_to_ifent(PyObject *,struct intf_entry (*))); /*proto*/
static int (__pyx_f_4dnet___intf_callback(struct intf_entry (*),void (*))); /*proto*/
static int (__pyx_f_4dnet___route_callback(struct route_entry (*),void (*))); /*proto*/
static PyObject *(__pyx_f_4dnet_rule_to_dict(struct fw_rule (*))); /*proto*/
static PyObject *(__pyx_f_4dnet_dict_to_rule(PyObject *,struct fw_rule (*))); /*proto*/
static int (__pyx_f_4dnet___fw_callback(struct fw_rule (*),void (*))); /*proto*/

/* Implementation of dnet */

static char (__pyx_k1[]) = "Address type (ADDR_TYPE_*) integer.";
static char (__pyx_k2[]) = "Address bitlength integer.";
static char (__pyx_k3[]) = "Raw address string.";
static char (__pyx_k4[]) = "Ethernet MAC address as binary string.";
static char (__pyx_k5[]) = "IPv4 address as binary string.";
static char (__pyx_k6[]) = "IPv6 address as binary string.";
static char (__pyx_k7[]) = "Tunnel interface name.";
static char (__pyx_k8[]) = "File descriptor for tunnel handle.";
static char (__pyx_k9[]) = "Dug Song <dugsong@monkey.org>";
static char (__pyx_k10[]) = "Copyright (c) 2003 Dug Song";
static char (__pyx_k11[]) = "BSD";
static char (__pyx_k12[]) = "http://libdnet.sourceforge.net/";
static char (__pyx_k13[]) = "1.10";
static char (__pyx_k14[]) = "\x000\x000\x000\x000\x000\x000";
static char (__pyx_k15[]) = "\x0ff\x0ff\x0ff\x0ff\x0ff\x0ff";
static char (__pyx_k19[]) = "\x000\x000\x000\x000";
static char (__pyx_k20[]) = "\x0ff\x0ff\x0ff\x0ff";
static char (__pyx_k21[]) = "\x07f\x000\x000\x001";
static char (__pyx_k22[]) = "\x0e0\x000\x000\x001";
static char (__pyx_k23[]) = "\x0e0\x000\x000\x0ff";
static char (__pyx_k32[]) = "\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000";
static char (__pyx_k33[]) = "\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000\x000\x001";

static char (__pyx_k60[]) = "not a %d-byte binary string: %s";

static PyObject *__pyx_f_4dnet___memcpy(char (*__pyx_v_dst),PyObject *__pyx_v_src,int __pyx_v_n) {
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  char (*__pyx_6);
  Py_INCREF(__pyx_v_src);

  /* "/misc/projects/libdnet/python/./dnet.pyx":44 */
  __pyx_1 = (PyString_Size(__pyx_v_src) != __pyx_v_n);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":45 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "ValueError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 45; goto __pyx_L1;}
    __pyx_3 = PyString_FromString(__pyx_k60); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 45; goto __pyx_L1;}
    __pyx_4 = PyInt_FromLong(__pyx_v_n); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 45; goto __pyx_L1;}
    __pyx_5 = PyTuple_New(2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 45; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_5, 0, __pyx_4);
    Py_INCREF(__pyx_v_src);
    PyTuple_SET_ITEM(__pyx_5, 1, __pyx_v_src);
    __pyx_4 = 0;
    __pyx_4 = PyNumber_Remainder(__pyx_3, __pyx_5); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 45; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    __Pyx_Raise(__pyx_2, __pyx_4, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 45; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":46 */
  __pyx_6 = PyString_AsString(__pyx_v_src); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 46; goto __pyx_L1;}
  memcpy(__pyx_v_dst,__pyx_6,__pyx_v_n);

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  __Pyx_AddTraceback("dnet.__memcpy");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_src);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet___oserror(void) {
  extern int errno;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":50 */
  __pyx_1 = PyString_FromString(strerror(errno)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 50; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.__oserror");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet___iter_append(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static PyObject *__pyx_f_4dnet___iter_append(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_entry = 0;
  PyObject *__pyx_v_l = 0;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"entry","l",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_entry, &__pyx_v_l)) return 0;
  Py_INCREF(__pyx_v_entry);
  Py_INCREF(__pyx_v_l);

  /* "/misc/projects/libdnet/python/./dnet.pyx":53 */
  __pyx_1 = PyObject_GetAttrString(__pyx_v_l, "append"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 53; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 53; goto __pyx_L1;}
  Py_INCREF(__pyx_v_entry);
  PyTuple_SET_ITEM(__pyx_2, 0, __pyx_v_entry);
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 53; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.__iter_append");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_entry);
  Py_DECREF(__pyx_v_l);
  return __pyx_r;
}


static int __pyx_f_4dnet_3eth___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_4dnet_3eth___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_device = 0;
  int __pyx_r;
  char (*__pyx_1);
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  static char *__pyx_argnames[] = {"device",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_device)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_device);

  /* "/misc/projects/libdnet/python/./dnet.pyx":110 */
  __pyx_1 = PyString_AsString(__pyx_v_device); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 110; goto __pyx_L1;}
  ((struct __pyx_obj_4dnet_eth *)__pyx_v_self)->eth = eth_open(__pyx_1);

  /* "/misc/projects/libdnet/python/./dnet.pyx":111 */
  __pyx_2 = (!(((struct __pyx_obj_4dnet_eth *)__pyx_v_self)->eth != 0));
  if (__pyx_2) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":112 */
    __pyx_3 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 112; goto __pyx_L1;}
    __pyx_4 = __pyx_f_4dnet___oserror(); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 112; goto __pyx_L1;}
    __Pyx_Raise(__pyx_3, __pyx_4, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 112; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("dnet.eth.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_device);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3eth_get(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_3eth_get[] = "Return the MAC address associated with the device as a\n        binary string.";
static PyObject *__pyx_f_4dnet_3eth_get(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  eth_addr_t __pyx_v_ea;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":118 */
  __pyx_1 = (eth_get(((struct __pyx_obj_4dnet_eth *)__pyx_v_self)->eth,(&__pyx_v_ea)) < 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":119 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 119; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 119; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 119; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":120 */
  __pyx_2 = PyString_FromStringAndSize(__pyx_v_ea.data,6); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 120; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.eth.get");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3eth_set(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_3eth_set[] = "Set the MAC address for the device, returning 0 on success,\n        -1 on failure.\n        \n        Arguments:\n        eth_addr -- 6-byte binary string (e.g. \'\\x00\\xde\\xad\\xbe\\xef\\x00\')\n        ";
static PyObject *__pyx_f_4dnet_3eth_set(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_value = 0;
  eth_addr_t __pyx_v_ea;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"value",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_value)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_value);

  /* "/misc/projects/libdnet/python/./dnet.pyx":130 */
  __pyx_1 = __pyx_f_4dnet___memcpy(__pyx_v_ea.data,__pyx_v_value,6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 130; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":131 */
  __pyx_2 = (eth_set(((struct __pyx_obj_4dnet_eth *)__pyx_v_self)->eth,(&__pyx_v_ea)) < 0);
  if (__pyx_2) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":132 */
    __pyx_1 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 132; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 132; goto __pyx_L1;}
    __Pyx_Raise(__pyx_1, __pyx_3, 0);
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 132; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.eth.set");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_value);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3eth_send(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_3eth_send[] = "Send an Ethernet frame, returning the number of bytes sent\n        or -1 on failure.\n        \n        Arguments:\n        frame -- binary string representing an Ethernet frame\n        ";
static PyObject *__pyx_f_4dnet_3eth_send(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_frame = 0;
  PyObject *__pyx_r;
  char (*__pyx_1);
  PyObject *__pyx_2 = 0;
  static char *__pyx_argnames[] = {"frame",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_frame)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_frame);

  /* "/misc/projects/libdnet/python/./dnet.pyx":141 */
  __pyx_1 = PyString_AsString(__pyx_v_frame); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 141; goto __pyx_L1;}
  __pyx_2 = PyInt_FromLong(eth_send(((struct __pyx_obj_4dnet_eth *)__pyx_v_self)->eth,__pyx_1,PyString_Size(__pyx_v_frame))); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 141; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.eth.send");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_frame);
  return __pyx_r;
}


static void __pyx_f_4dnet_3eth___dealloc__(PyObject *__pyx_v_self); /*proto*/
static void __pyx_f_4dnet_3eth___dealloc__(PyObject *__pyx_v_self) {
  int __pyx_1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":144 */
  __pyx_1 = (((struct __pyx_obj_4dnet_eth *)__pyx_v_self)->eth != 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":145 */
    eth_close(((struct __pyx_obj_4dnet_eth *)__pyx_v_self)->eth);
    goto __pyx_L2;
  }
  __pyx_L2:;

  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.eth.__dealloc__");
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
}


static PyObject *__pyx_f_4dnet_eth_ntoa(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_eth_ntoa[] = "Convert an Ethernet MAC address from 6-byte packed binary string to\n    a printable string (\'00:de:ad:be:ef:00\').";
static PyObject *__pyx_f_4dnet_eth_ntoa(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_buf = 0;
  eth_addr_t __pyx_v_ea;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {"buf",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_buf)) return 0;
  Py_INCREF(__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":151 */
  __pyx_1 = __pyx_f_4dnet___memcpy(__pyx_v_ea.data,__pyx_v_buf,6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 151; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":152 */
  __pyx_1 = PyString_FromString(eth_ntoa((&__pyx_v_ea))); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 152; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.eth_ntoa");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_buf);
  return __pyx_r;
}

static char (__pyx_k61[]) = "invalid Ethernet address";

static PyObject *__pyx_f_4dnet_eth_aton(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_eth_aton[] = "Convert an Ethernet MAC address from a printable string to a\n    packed binary string (\'\\x00\\xde\\xad\\xbe\\xef\\x00\').";
static PyObject *__pyx_f_4dnet_eth_aton(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_buf = 0;
  eth_addr_t __pyx_v_ea;
  PyObject *__pyx_r;
  char (*__pyx_1);
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  static char *__pyx_argnames[] = {"buf",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_buf)) return 0;
  Py_INCREF(__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":158 */
  __pyx_1 = PyString_AsString(__pyx_v_buf); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 158; goto __pyx_L1;}
  __pyx_2 = (eth_aton(__pyx_1,(&__pyx_v_ea)) < 0);
  if (__pyx_2) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":159 */
    __pyx_3 = __Pyx_GetName(__pyx_b, "ValueError"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 159; goto __pyx_L1;}
    __pyx_4 = PyString_FromString(__pyx_k61); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 159; goto __pyx_L1;}
    __Pyx_Raise(__pyx_3, __pyx_4, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 159; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":160 */
  __pyx_3 = PyString_FromStringAndSize(__pyx_v_ea.data,6); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 160; goto __pyx_L1;}
  __pyx_r = __pyx_3;
  __pyx_3 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("dnet.eth_aton");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_buf);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_eth_pack_hdr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_eth_pack_hdr[] = "Return a packed binary string representing an Ethernet header.\n	\n    Keyword arguments:\n    dst  -- destination address			(6-byte binary string)\n    src  -- source address			(6-byte binary string)\n    type -- Ethernet payload type (ETH_TYPE_*)	(16-bit integer)\n    ";
static PyObject *__pyx_f_4dnet_eth_pack_hdr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_dst = 0;
  PyObject *__pyx_v_src = 0;
  PyObject *__pyx_v_type = 0;
  char (__pyx_v_hdr[14]);
  eth_addr_t __pyx_v_s;
  eth_addr_t __pyx_v_d;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  static char *__pyx_argnames[] = {"dst","src","type",0};
  __pyx_v_dst = __pyx_k16;
  __pyx_v_src = __pyx_k17;
  __pyx_v_type = __pyx_k18;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "|OOO", __pyx_argnames, &__pyx_v_dst, &__pyx_v_src, &__pyx_v_type)) return 0;
  Py_INCREF(__pyx_v_dst);
  Py_INCREF(__pyx_v_src);
  Py_INCREF(__pyx_v_type);

  /* "/misc/projects/libdnet/python/./dnet.pyx":173 */
  __pyx_1 = __pyx_f_4dnet___memcpy(__pyx_v_s.data,__pyx_v_src,6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 173; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":174 */
  __pyx_1 = __pyx_f_4dnet___memcpy(__pyx_v_d.data,__pyx_v_dst,6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 174; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":175 */
  __pyx_2 = PyInt_AsLong(__pyx_v_type); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 175; goto __pyx_L1;}
  eth_pack_hdr(__pyx_v_hdr,__pyx_v_d,__pyx_v_s,__pyx_2);

  /* "/misc/projects/libdnet/python/./dnet.pyx":176 */
  __pyx_1 = PyString_FromStringAndSize(__pyx_v_hdr,14); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 176; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.eth_pack_hdr");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_dst);
  Py_DECREF(__pyx_v_src);
  Py_DECREF(__pyx_v_type);
  return __pyx_r;
}


static int __pyx_f_4dnet_2ip___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_4dnet_2ip___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return -1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":248 */
  ((struct __pyx_obj_4dnet_ip *)__pyx_v_self)->ip = ip_open();

  /* "/misc/projects/libdnet/python/./dnet.pyx":249 */
  __pyx_1 = (!(((struct __pyx_obj_4dnet_ip *)__pyx_v_self)->ip != 0));
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":250 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 250; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 250; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 250; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.ip.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_2ip_send(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_2ip_send[] = "Send an IP packet, returning the number of bytes sent\n        or -1 on failure.\n\n        Arguments:\n        pkt -- binary string representing an IP packet\n        ";
static PyObject *__pyx_f_4dnet_2ip_send(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_pkt = 0;
  PyObject *__pyx_r;
  char (*__pyx_1);
  PyObject *__pyx_2 = 0;
  static char *__pyx_argnames[] = {"pkt",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_pkt)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_pkt);

  /* "/misc/projects/libdnet/python/./dnet.pyx":259 */
  __pyx_1 = PyString_AsString(__pyx_v_pkt); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 259; goto __pyx_L1;}
  __pyx_2 = PyInt_FromLong(ip_send(((struct __pyx_obj_4dnet_ip *)__pyx_v_self)->ip,__pyx_1,PyString_Size(__pyx_v_pkt))); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 259; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.ip.send");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_pkt);
  return __pyx_r;
}


static void __pyx_f_4dnet_2ip___dealloc__(PyObject *__pyx_v_self); /*proto*/
static void __pyx_f_4dnet_2ip___dealloc__(PyObject *__pyx_v_self) {
  int __pyx_1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":262 */
  __pyx_1 = (((struct __pyx_obj_4dnet_ip *)__pyx_v_self)->ip != 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":263 */
    ip_close(((struct __pyx_obj_4dnet_ip *)__pyx_v_self)->ip);
    goto __pyx_L2;
  }
  __pyx_L2:;

  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.ip.__dealloc__");
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
}


static PyObject *__pyx_f_4dnet_ip_ntoa(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_ip_ntoa[] = "Convert an IP address from a 4-byte packed binary string or\n    integer to a printable string (\'10.0.0.1\').";
static PyObject *__pyx_f_4dnet_ip_ntoa(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_buf = 0;
  ip_addr_t __pyx_v_ia;
  unsigned int __pyx_v_i;
  PyObject *__pyx_r;
  int __pyx_1;
  unsigned long __pyx_2;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"buf",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_buf)) return 0;
  Py_INCREF(__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":271 */
  __pyx_1 = PyInt_Check(__pyx_v_buf);
  if (!__pyx_1) {
    __pyx_1 = PyLong_Check(__pyx_v_buf);
  }
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":272 */
    __pyx_2 = PyLong_AsUnsignedLong(__pyx_v_buf); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 272; goto __pyx_L1;}
    __pyx_v_i = ntohl(__pyx_2);

    /* "/misc/projects/libdnet/python/./dnet.pyx":273 */
    memcpy(((char (*))(&__pyx_v_ia)),((char (*))(&__pyx_v_i)),4);
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/misc/projects/libdnet/python/./dnet.pyx":275 */
    __pyx_3 = __pyx_f_4dnet___memcpy(((char (*))(&__pyx_v_ia)),__pyx_v_buf,4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 275; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":276 */
  __pyx_3 = PyString_FromString(ip_ntoa((&__pyx_v_ia))); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 276; goto __pyx_L1;}
  __pyx_r = __pyx_3;
  __pyx_3 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.ip_ntoa");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_buf);
  return __pyx_r;
}

static char (__pyx_k62[]) = "invalid IP address";

static PyObject *__pyx_f_4dnet_ip_aton(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_ip_aton[] = "Convert an IP address from a printable string to a\n    packed binary string (\'\\x0a\\x00\\x00\\x01\').";
static PyObject *__pyx_f_4dnet_ip_aton(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_buf = 0;
  ip_addr_t __pyx_v_ia;
  PyObject *__pyx_r;
  char (*__pyx_1);
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  static char *__pyx_argnames[] = {"buf",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_buf)) return 0;
  Py_INCREF(__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":282 */
  __pyx_1 = PyString_AsString(__pyx_v_buf); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 282; goto __pyx_L1;}
  __pyx_2 = (ip_aton(__pyx_1,(&__pyx_v_ia)) < 0);
  if (__pyx_2) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":283 */
    __pyx_3 = __Pyx_GetName(__pyx_b, "ValueError"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 283; goto __pyx_L1;}
    __pyx_4 = PyString_FromString(__pyx_k62); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 283; goto __pyx_L1;}
    __Pyx_Raise(__pyx_3, __pyx_4, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 283; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":284 */
  __pyx_3 = PyString_FromStringAndSize(((char (*))(&__pyx_v_ia)),4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 284; goto __pyx_L1;}
  __pyx_r = __pyx_3;
  __pyx_3 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("dnet.ip_aton");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_buf);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_ip_checksum(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_ip_checksum[] = "Return packed binary string representing an IP packet \n    with the IP and transport-layer checksums set.\n    \n    Arguments:\n    pkt -- binary string representing an IP packet\n    ";
static PyObject *__pyx_f_4dnet_ip_checksum(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_pkt = 0;
  char (__pyx_v_buf[2048]);
  char (*__pyx_v_p);
  int __pyx_v_n;
  PyObject *__pyx_v_s;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  char (*__pyx_3);
  static char *__pyx_argnames[] = {"pkt",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_pkt)) return 0;
  Py_INCREF(__pyx_v_pkt);
  __pyx_v_s = Py_None; Py_INCREF(__pyx_v_s);

  /* "/misc/projects/libdnet/python/./dnet.pyx":296 */
  __pyx_1 = (PyObject_AsReadBuffer(__pyx_v_pkt,(&__pyx_v_p),(&__pyx_v_n)) == 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":297 */
    __pyx_1 = (__pyx_v_n < 2048);
    if (__pyx_1) {

      /* "/misc/projects/libdnet/python/./dnet.pyx":298 */
      memcpy(__pyx_v_buf,__pyx_v_p,__pyx_v_n);

      /* "/misc/projects/libdnet/python/./dnet.pyx":299 */
      ip_checksum(__pyx_v_buf,__pyx_v_n);

      /* "/misc/projects/libdnet/python/./dnet.pyx":300 */
      __pyx_2 = PyString_FromStringAndSize(__pyx_v_buf,__pyx_v_n); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 300; goto __pyx_L1;}
      __pyx_r = __pyx_2;
      __pyx_2 = 0;
      goto __pyx_L0;
      goto __pyx_L3;
    }
    __pyx_L3:;

    /* "/misc/projects/libdnet/python/./dnet.pyx":301 */
    __pyx_v_p = malloc(__pyx_v_n);

    /* "/misc/projects/libdnet/python/./dnet.pyx":302 */
    __pyx_3 = PyString_AsString(__pyx_v_pkt); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 302; goto __pyx_L1;}
    memcpy(__pyx_v_p,__pyx_3,__pyx_v_n);

    /* "/misc/projects/libdnet/python/./dnet.pyx":303 */
    ip_checksum(__pyx_v_p,__pyx_v_n);

    /* "/misc/projects/libdnet/python/./dnet.pyx":304 */
    __pyx_2 = PyString_FromStringAndSize(__pyx_v_p,__pyx_v_n); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 304; goto __pyx_L1;}
    Py_DECREF(__pyx_v_s);
    __pyx_v_s = __pyx_2;
    __pyx_2 = 0;

    /* "/misc/projects/libdnet/python/./dnet.pyx":305 */
    free(__pyx_v_p);

    /* "/misc/projects/libdnet/python/./dnet.pyx":306 */
    Py_INCREF(__pyx_v_s);
    __pyx_r = __pyx_v_s;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":307 */
  __pyx_2 = __Pyx_GetName(__pyx_b, "TypeError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 307; goto __pyx_L1;}
  __Pyx_Raise(__pyx_2, 0, 0);
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  {__pyx_filename = __pyx_f[0]; __pyx_lineno = 307; goto __pyx_L1;}

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.ip_checksum");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_s);
  Py_DECREF(__pyx_v_pkt);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_ip_cksum_add(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static PyObject *__pyx_f_4dnet_ip_cksum_add(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_buf = 0;
  int __pyx_v_sum;
  char (*__pyx_v_p);
  int __pyx_v_n;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  static char *__pyx_argnames[] = {"buf","sum",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "Oi", __pyx_argnames, &__pyx_v_buf, &__pyx_v_sum)) return 0;
  Py_INCREF(__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":312 */
  __pyx_1 = (PyObject_AsReadBuffer(__pyx_v_buf,(&__pyx_v_p),(&__pyx_v_n)) == 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":313 */
    __pyx_2 = PyInt_FromLong(ip_cksum_add(__pyx_v_p,__pyx_v_n,__pyx_v_sum)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 313; goto __pyx_L1;}
    __pyx_r = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/misc/projects/libdnet/python/./dnet.pyx":315 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "TypeError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 315; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 315; goto __pyx_L1;}
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.ip_cksum_add");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_buf);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_ip_cksum_carry(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static PyObject *__pyx_f_4dnet_ip_cksum_carry(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  int __pyx_v_sum;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {"sum",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "i", __pyx_argnames, &__pyx_v_sum)) return 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":318 */
  __pyx_1 = PyInt_FromLong(ip_cksum_carry(__pyx_v_sum)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 318; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.ip_cksum_carry");
  __pyx_r = 0;
  __pyx_L0:;
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_ip_pack_hdr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_ip_pack_hdr[] = "Return a packed binary string representing an IP header.\n    \n    Keyword arguments:\n    tos  -- type of service			(8-bit integer)\n    len -- length (IP_HDR_LEN + payload)	(16-bit integer)\n    id   -- packet ID				(16-bit integer)\n    off  -- fragmentation offset		(16-bit integer)\n    ttl  -- time-to-live			(8-bit integer)\n    p    -- protocol (IP_PROTO_*)		(8-bit integer)\n    src  -- source address			(4-byte binary string)\n    dst  -- destination address			(4-byte binary string)\n    ";
static PyObject *__pyx_f_4dnet_ip_pack_hdr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_tos = 0;
  PyObject *__pyx_v_len = 0;
  PyObject *__pyx_v_id = 0;
  PyObject *__pyx_v_off = 0;
  PyObject *__pyx_v_ttl = 0;
  PyObject *__pyx_v_p = 0;
  PyObject *__pyx_v_src = 0;
  PyObject *__pyx_v_dst = 0;
  char (__pyx_v_hdr[20]);
  ip_addr_t __pyx_v_s;
  ip_addr_t __pyx_v_d;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  int __pyx_3;
  int __pyx_4;
  int __pyx_5;
  int __pyx_6;
  int __pyx_7;
  static char *__pyx_argnames[] = {"tos","len","id","off","ttl","p","src","dst",0};
  __pyx_v_tos = __pyx_k24;
  __pyx_v_len = __pyx_k25;
  __pyx_v_id = __pyx_k26;
  __pyx_v_off = __pyx_k27;
  __pyx_v_ttl = __pyx_k28;
  __pyx_v_p = __pyx_k29;
  __pyx_v_src = __pyx_k30;
  __pyx_v_dst = __pyx_k31;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "|OOOOOOOO", __pyx_argnames, &__pyx_v_tos, &__pyx_v_len, &__pyx_v_id, &__pyx_v_off, &__pyx_v_ttl, &__pyx_v_p, &__pyx_v_src, &__pyx_v_dst)) return 0;
  Py_INCREF(__pyx_v_tos);
  Py_INCREF(__pyx_v_len);
  Py_INCREF(__pyx_v_id);
  Py_INCREF(__pyx_v_off);
  Py_INCREF(__pyx_v_ttl);
  Py_INCREF(__pyx_v_p);
  Py_INCREF(__pyx_v_src);
  Py_INCREF(__pyx_v_dst);

  /* "/misc/projects/libdnet/python/./dnet.pyx":337 */
  __pyx_1 = __pyx_f_4dnet___memcpy(((char (*))(&__pyx_v_s)),__pyx_v_src,4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 337; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":338 */
  __pyx_1 = __pyx_f_4dnet___memcpy(((char (*))(&__pyx_v_d)),__pyx_v_dst,4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 338; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":339 */
  __pyx_2 = PyInt_AsLong(__pyx_v_tos); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; goto __pyx_L1;}
  __pyx_3 = PyInt_AsLong(__pyx_v_len); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; goto __pyx_L1;}
  __pyx_4 = PyInt_AsLong(__pyx_v_id); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; goto __pyx_L1;}
  __pyx_5 = PyInt_AsLong(__pyx_v_off); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; goto __pyx_L1;}
  __pyx_6 = PyInt_AsLong(__pyx_v_ttl); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; goto __pyx_L1;}
  __pyx_7 = PyInt_AsLong(__pyx_v_p); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 339; goto __pyx_L1;}
  ip_pack_hdr(__pyx_v_hdr,__pyx_2,__pyx_3,__pyx_4,__pyx_5,__pyx_6,__pyx_7,__pyx_v_s,__pyx_v_d);

  /* "/misc/projects/libdnet/python/./dnet.pyx":340 */
  __pyx_1 = PyString_FromStringAndSize(__pyx_v_hdr,20); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 340; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.ip_pack_hdr");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_tos);
  Py_DECREF(__pyx_v_len);
  Py_DECREF(__pyx_v_id);
  Py_DECREF(__pyx_v_off);
  Py_DECREF(__pyx_v_ttl);
  Py_DECREF(__pyx_v_p);
  Py_DECREF(__pyx_v_src);
  Py_DECREF(__pyx_v_dst);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_ip6_ntoa(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_ip6_ntoa[] = "Convert an IPv6 address from a 16-byte packed binary string to a\n    printable string (\'10.0.0.1\').";
static PyObject *__pyx_f_4dnet_ip6_ntoa(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_buf = 0;
  ip6_addr_t __pyx_v_ia;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {"buf",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_buf)) return 0;
  Py_INCREF(__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":374 */
  __pyx_1 = __pyx_f_4dnet___memcpy(((char (*))(&__pyx_v_ia)),__pyx_v_buf,16); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 374; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":375 */
  __pyx_1 = PyString_FromString(ip6_ntoa((&__pyx_v_ia))); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 375; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.ip6_ntoa");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_buf);
  return __pyx_r;
}

static char (__pyx_k63[]) = "invalid IPv6 address";

static PyObject *__pyx_f_4dnet_ip6_aton(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_ip6_aton[] = "Convert an IPv6 address from a printable string to a\n    packed binary string (\'\\x0a\\x00\\x00\\x01\').";
static PyObject *__pyx_f_4dnet_ip6_aton(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_buf = 0;
  ip6_addr_t __pyx_v_ia;
  PyObject *__pyx_r;
  char (*__pyx_1);
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  static char *__pyx_argnames[] = {"buf",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_buf)) return 0;
  Py_INCREF(__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":381 */
  __pyx_1 = PyString_AsString(__pyx_v_buf); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 381; goto __pyx_L1;}
  __pyx_2 = (ip6_aton(__pyx_1,(&__pyx_v_ia)) < 0);
  if (__pyx_2) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":382 */
    __pyx_3 = __Pyx_GetName(__pyx_b, "ValueError"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 382; goto __pyx_L1;}
    __pyx_4 = PyString_FromString(__pyx_k63); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 382; goto __pyx_L1;}
    __Pyx_Raise(__pyx_3, __pyx_4, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 382; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":383 */
  __pyx_3 = PyString_FromStringAndSize(((char (*))(&__pyx_v_ia)),16); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 383; goto __pyx_L1;}
  __pyx_r = __pyx_3;
  __pyx_3 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("dnet.ip6_aton");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_buf);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_ip6_checksum(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_ip6_checksum[] = "Return a packed binary string representing an IPv6 packet \n    with the IPv6 and transport-layer checksums set.\n\n    Arguments:\n    pkt -- binary string representing an IPv6 packet\n    ";
static PyObject *__pyx_f_4dnet_ip6_checksum(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_buf = 0;
  PyObject *__pyx_r;
  char (*__pyx_1);
  static char *__pyx_argnames[] = {"buf",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_buf)) return 0;
  Py_INCREF(__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":392 */
  __pyx_1 = PyString_AsString(__pyx_v_buf); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 392; goto __pyx_L1;}
  ip6_checksum(__pyx_1,PyString_Size(__pyx_v_buf));

  /* "/misc/projects/libdnet/python/./dnet.pyx":393 */
  Py_INCREF(__pyx_v_buf);
  __pyx_r = __pyx_v_buf;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.ip6_checksum");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_buf);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_ip6_pack_hdr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_ip6_pack_hdr[] = "Return a packed binary string representing an IPv6 header.\n    \n    Keyword arguments:\n    fc   -- flow class			(8-bit integer)\n    fl   -- flow label			(20-bit integer)\n    plen -- payload length		(16-bit integer)\n    nxt  -- next header (IP_PROTO_*)	(8-bit integer)\n    hlim -- hop limit			(8-bit integer)\n    src  -- source address		(16-byte binary string)\n    dst  -- destination address		(16-byte binary string)\n    ";
static PyObject *__pyx_f_4dnet_ip6_pack_hdr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_fc = 0;
  PyObject *__pyx_v_fl = 0;
  PyObject *__pyx_v_plen = 0;
  PyObject *__pyx_v_nxt = 0;
  PyObject *__pyx_v_hlim = 0;
  PyObject *__pyx_v_src = 0;
  PyObject *__pyx_v_dst = 0;
  char (__pyx_v_hdr[40]);
  ip6_addr_t __pyx_v_s;
  ip6_addr_t __pyx_v_d;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  int __pyx_3;
  int __pyx_4;
  int __pyx_5;
  int __pyx_6;
  static char *__pyx_argnames[] = {"fc","fl","plen","nxt","hlim","src","dst",0};
  __pyx_v_fc = __pyx_k34;
  __pyx_v_fl = __pyx_k35;
  __pyx_v_plen = __pyx_k36;
  __pyx_v_nxt = __pyx_k37;
  __pyx_v_hlim = __pyx_k38;
  __pyx_v_src = __pyx_k39;
  __pyx_v_dst = __pyx_k40;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "|OOOOOOO", __pyx_argnames, &__pyx_v_fc, &__pyx_v_fl, &__pyx_v_plen, &__pyx_v_nxt, &__pyx_v_hlim, &__pyx_v_src, &__pyx_v_dst)) return 0;
  Py_INCREF(__pyx_v_fc);
  Py_INCREF(__pyx_v_fl);
  Py_INCREF(__pyx_v_plen);
  Py_INCREF(__pyx_v_nxt);
  Py_INCREF(__pyx_v_hlim);
  Py_INCREF(__pyx_v_src);
  Py_INCREF(__pyx_v_dst);

  /* "/misc/projects/libdnet/python/./dnet.pyx":410 */
  __pyx_1 = __pyx_f_4dnet___memcpy(((char (*))(&__pyx_v_s)),__pyx_v_src,16); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 410; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":411 */
  __pyx_1 = __pyx_f_4dnet___memcpy(((char (*))(&__pyx_v_d)),__pyx_v_dst,16); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 411; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":412 */
  __pyx_2 = PyInt_AsLong(__pyx_v_fc); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; goto __pyx_L1;}
  __pyx_3 = PyInt_AsLong(__pyx_v_fl); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; goto __pyx_L1;}
  __pyx_4 = PyInt_AsLong(__pyx_v_plen); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; goto __pyx_L1;}
  __pyx_5 = PyInt_AsLong(__pyx_v_nxt); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; goto __pyx_L1;}
  __pyx_6 = PyInt_AsLong(__pyx_v_hlim); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 412; goto __pyx_L1;}
  ip6_pack_hdr(__pyx_v_hdr,__pyx_2,__pyx_3,__pyx_4,__pyx_5,__pyx_6,__pyx_v_s,__pyx_v_d);

  /* "/misc/projects/libdnet/python/./dnet.pyx":413 */
  __pyx_1 = PyString_FromStringAndSize(__pyx_v_hdr,40); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 413; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.ip6_pack_hdr");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_fc);
  Py_DECREF(__pyx_v_fl);
  Py_DECREF(__pyx_v_plen);
  Py_DECREF(__pyx_v_nxt);
  Py_DECREF(__pyx_v_hlim);
  Py_DECREF(__pyx_v_src);
  Py_DECREF(__pyx_v_dst);
  return __pyx_r;
}

static char (__pyx_k64[]) = "invalid network address";

static int __pyx_f_4dnet_4addr___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_4dnet_4addr___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_addrtxt = 0;
  PyObject *__pyx_v_type = 0;
  int __pyx_r;
  int __pyx_1;
  char (*__pyx_2);
  PyObject *__pyx_3 = 0;
  unsigned short __pyx_4;
  PyObject *__pyx_5 = 0;
  static char *__pyx_argnames[] = {"addrtxt","type",0};
  __pyx_v_addrtxt = __pyx_k41;
  __pyx_v_type = __pyx_k42;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "|OO", __pyx_argnames, &__pyx_v_addrtxt, &__pyx_v_type)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_addrtxt);
  Py_INCREF(__pyx_v_type);

  /* "/misc/projects/libdnet/python/./dnet.pyx":445 */
  if (PyObject_Cmp(__pyx_v_addrtxt, Py_None, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 445; goto __pyx_L1;}
  __pyx_1 = __pyx_1 != 0;
  if (__pyx_1) {
    __pyx_2 = PyString_AsString(__pyx_v_addrtxt); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 445; goto __pyx_L1;}
    __pyx_1 = (addr_aton(__pyx_2,(&((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr)) < 0);
  }
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":446 */
    __pyx_1 = (PyString_Size(__pyx_v_addrtxt) == 4);
    if (__pyx_1) {

      /* "/misc/projects/libdnet/python/./dnet.pyx":447 */
      __pyx_3 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_IP"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 447; goto __pyx_L1;}
      __pyx_4 = PyInt_AsLong(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 447; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type = __pyx_4;

      /* "/misc/projects/libdnet/python/./dnet.pyx":448 */
      __pyx_3 = __Pyx_GetName(__pyx_m, "IP_ADDR_BITS"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 448; goto __pyx_L1;}
      __pyx_4 = PyInt_AsLong(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 448; goto __pyx_L1;}
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_bits = __pyx_4;

      /* "/misc/projects/libdnet/python/./dnet.pyx":449 */
      if (PyObject_SetAttrString(__pyx_v_self, "ip", __pyx_v_addrtxt) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 449; goto __pyx_L1;}
      goto __pyx_L3;
    }
    /*else*/ {

      /* "/misc/projects/libdnet/python/./dnet.pyx":451 */
      __pyx_3 = __Pyx_GetName(__pyx_b, "ValueError"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 451; goto __pyx_L1;}
      __pyx_5 = PyString_FromString(__pyx_k64); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 451; goto __pyx_L1;}
      __Pyx_Raise(__pyx_3, __pyx_5, 0);
      Py_DECREF(__pyx_3); __pyx_3 = 0;
      Py_DECREF(__pyx_5); __pyx_5 = 0;
      {__pyx_filename = __pyx_f[0]; __pyx_lineno = 451; goto __pyx_L1;}
    }
    __pyx_L3:;
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_5);
  __Pyx_AddTraceback("dnet.addr.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_addrtxt);
  Py_DECREF(__pyx_v_type);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4addr_4type___get__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_4addr_4type___get__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":456 */
  __pyx_1 = PyInt_FromLong(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 456; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.addr.type.__get__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static int __pyx_f_4dnet_4addr_4type___set__(PyObject *__pyx_v_self, PyObject *__pyx_arg_value); /*proto*/
static int __pyx_f_4dnet_4addr_4type___set__(PyObject *__pyx_v_self, PyObject *__pyx_arg_value) {
  unsigned int __pyx_v_value;
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_value = PyInt_AsLong(__pyx_arg_value); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 457; goto __pyx_L1;}

  /* "/misc/projects/libdnet/python/./dnet.pyx":458 */
  __pyx_1 = (__pyx_v_value > 65535);
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, "OverflowError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 458; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 458; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":459 */
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type = __pyx_v_value;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.type.__set__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4addr_4bits___get__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_4addr_4bits___get__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":464 */
  __pyx_1 = PyInt_FromLong(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_bits); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 464; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.addr.bits.__get__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static int __pyx_f_4dnet_4addr_4bits___set__(PyObject *__pyx_v_self, PyObject *__pyx_arg_value); /*proto*/
static int __pyx_f_4dnet_4addr_4bits___set__(PyObject *__pyx_v_self, PyObject *__pyx_arg_value) {
  unsigned int __pyx_v_value;
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_value = PyInt_AsLong(__pyx_arg_value); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 465; goto __pyx_L1;}

  /* "/misc/projects/libdnet/python/./dnet.pyx":466 */
  __pyx_1 = (__pyx_v_value > 65535);
  if (__pyx_1) {
    __pyx_2 = __Pyx_GetName(__pyx_b, "OverflowError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 466; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 466; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":467 */
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_bits = __pyx_v_value;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.bits.__set__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static char (__pyx_k65[]) = "invalid network address";

static PyObject *__pyx_f_4dnet_4addr_4data___get__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_4addr_4data___get__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":472 */
  __pyx_1 = PyInt_FromLong(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 472; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_ETH"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 472; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 472; goto __pyx_L1;}
  __pyx_3 = __pyx_3 == 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":473 */
    __pyx_1 = PyObject_GetAttrString(__pyx_v_self, "eth"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 473; goto __pyx_L1;}
    __pyx_r = __pyx_1;
    __pyx_1 = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_2 = PyInt_FromLong(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 474; goto __pyx_L1;}
  __pyx_1 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_IP"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 474; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_2, __pyx_1, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 474; goto __pyx_L1;}
  __pyx_3 = __pyx_3 == 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":475 */
    __pyx_2 = PyObject_GetAttrString(__pyx_v_self, "ip"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 475; goto __pyx_L1;}
    __pyx_r = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_1 = PyInt_FromLong(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 476; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_IP6"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 476; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 476; goto __pyx_L1;}
  __pyx_3 = __pyx_3 == 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":477 */
    __pyx_1 = PyObject_GetAttrString(__pyx_v_self, "ip6"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 477; goto __pyx_L1;}
    __pyx_r = __pyx_1;
    __pyx_1 = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/misc/projects/libdnet/python/./dnet.pyx":479 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "ValueError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 479; goto __pyx_L1;}
    __pyx_1 = PyString_FromString(__pyx_k65); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 479; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_1, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 479; goto __pyx_L1;}
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.data.__get__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static char (__pyx_k66[]) = "non-Ethernet address";

static PyObject *__pyx_f_4dnet_4addr_3eth___get__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_4addr_3eth___get__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":484 */
  __pyx_1 = PyInt_FromLong(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 484; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_ETH"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 484; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 484; goto __pyx_L1;}
  __pyx_3 = __pyx_3 != 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":485 */
    __pyx_1 = __Pyx_GetName(__pyx_b, "ValueError"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 485; goto __pyx_L1;}
    __pyx_2 = PyString_FromString(__pyx_k66); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 485; goto __pyx_L1;}
    __Pyx_Raise(__pyx_1, __pyx_2, 0);
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 485; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":486 */
  __pyx_1 = PyString_FromStringAndSize(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_data8,6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 486; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.eth.__get__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static char (__pyx_k67[]) = "not a 6-byte string";

static int __pyx_f_4dnet_4addr_3eth___set__(PyObject *__pyx_v_self, PyObject *__pyx_v_value); /*proto*/
static int __pyx_f_4dnet_4addr_3eth___set__(PyObject *__pyx_v_self, PyObject *__pyx_v_value) {
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  unsigned short __pyx_4;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_value);

  /* "/misc/projects/libdnet/python/./dnet.pyx":489 */
  __pyx_1 = PyInt_FromLong(PyString_Size(__pyx_v_value)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 489; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ETH_ADDR_LEN"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 489; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 489; goto __pyx_L1;}
  __pyx_3 = __pyx_3 != 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":490 */
    __pyx_1 = __Pyx_GetName(__pyx_b, "ValueError"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 490; goto __pyx_L1;}
    __pyx_2 = PyString_FromString(__pyx_k67); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 490; goto __pyx_L1;}
    __Pyx_Raise(__pyx_1, __pyx_2, 0);
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 490; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":491 */
  __pyx_1 = __pyx_f_4dnet___memcpy(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_data8,__pyx_v_value,6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 491; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":492 */
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_ETH"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 492; goto __pyx_L1;}
  __pyx_4 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 492; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type = __pyx_4;

  /* "/misc/projects/libdnet/python/./dnet.pyx":493 */
  __pyx_1 = __Pyx_GetName(__pyx_m, "ETH_ADDR_BITS"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 493; goto __pyx_L1;}
  __pyx_4 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 493; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_bits = __pyx_4;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.eth.__set__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_value);
  return __pyx_r;
}

static char (__pyx_k68[]) = "non-IP address";

static PyObject *__pyx_f_4dnet_4addr_2ip___get__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_4addr_2ip___get__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":498 */
  __pyx_1 = PyInt_FromLong(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_IP"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 498; goto __pyx_L1;}
  __pyx_3 = __pyx_3 != 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":499 */
    __pyx_1 = __Pyx_GetName(__pyx_b, "ValueError"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 499; goto __pyx_L1;}
    __pyx_2 = PyString_FromString(__pyx_k68); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 499; goto __pyx_L1;}
    __Pyx_Raise(__pyx_1, __pyx_2, 0);
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 499; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":500 */
  __pyx_1 = PyString_FromStringAndSize(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_data8,4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 500; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.ip.__get__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static char (__pyx_k69[]) = "not a 4-byte string";

static int __pyx_f_4dnet_4addr_2ip___set__(PyObject *__pyx_v_self, PyObject *__pyx_v_value); /*proto*/
static int __pyx_f_4dnet_4addr_2ip___set__(PyObject *__pyx_v_self, PyObject *__pyx_v_value) {
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  unsigned short __pyx_4;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_value);

  /* "/misc/projects/libdnet/python/./dnet.pyx":504 */
  __pyx_1 = PyInt_Check(__pyx_v_value);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":505 */
    ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_ip = htonl(PyInt_AsLong(__pyx_v_value));
    goto __pyx_L2;
  }
  __pyx_1 = PyLong_Check(__pyx_v_value);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":507 */
    ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_ip = htonl(PyLong_AsUnsignedLong(__pyx_v_value));
    goto __pyx_L2;
  }
  __pyx_2 = PyInt_FromLong(PyString_Size(__pyx_v_value)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 508; goto __pyx_L1;}
  __pyx_3 = __Pyx_GetName(__pyx_m, "IP_ADDR_LEN"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 508; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_2, __pyx_3, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 508; goto __pyx_L1;}
  __pyx_1 = __pyx_1 != 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":509 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "ValueError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 509; goto __pyx_L1;}
    __pyx_3 = PyString_FromString(__pyx_k69); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 509; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 509; goto __pyx_L1;}
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/misc/projects/libdnet/python/./dnet.pyx":511 */
    __pyx_2 = __pyx_f_4dnet___memcpy(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_data8,__pyx_v_value,4); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 511; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":512 */
  __pyx_3 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_IP"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 512; goto __pyx_L1;}
  __pyx_4 = PyInt_AsLong(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 512; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type = __pyx_4;

  /* "/misc/projects/libdnet/python/./dnet.pyx":513 */
  __pyx_2 = __Pyx_GetName(__pyx_m, "IP_ADDR_BITS"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 513; goto __pyx_L1;}
  __pyx_4 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 513; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_bits = __pyx_4;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.addr.ip.__set__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_value);
  return __pyx_r;
}

static char (__pyx_k70[]) = "non-IPv6 address";

static PyObject *__pyx_f_4dnet_4addr_3ip6___get__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_4addr_3ip6___get__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":518 */
  __pyx_1 = PyInt_FromLong(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 518; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_IP6"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 518; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 518; goto __pyx_L1;}
  __pyx_3 = __pyx_3 != 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":519 */
    __pyx_1 = __Pyx_GetName(__pyx_b, "ValueError"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 519; goto __pyx_L1;}
    __pyx_2 = PyString_FromString(__pyx_k70); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 519; goto __pyx_L1;}
    __Pyx_Raise(__pyx_1, __pyx_2, 0);
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 519; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":520 */
  __pyx_1 = PyString_FromStringAndSize(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_data8,16); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 520; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.ip6.__get__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static char (__pyx_k71[]) = "not a 16-byte string";

static int __pyx_f_4dnet_4addr_3ip6___set__(PyObject *__pyx_v_self, PyObject *__pyx_v_value); /*proto*/
static int __pyx_f_4dnet_4addr_3ip6___set__(PyObject *__pyx_v_self, PyObject *__pyx_v_value) {
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  unsigned short __pyx_4;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_value);

  /* "/misc/projects/libdnet/python/./dnet.pyx":523 */
  __pyx_1 = PyInt_FromLong(PyString_Size(__pyx_v_value)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 523; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "IP6_ADDR_LEN"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 523; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 523; goto __pyx_L1;}
  __pyx_3 = __pyx_3 != 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":524 */
    __pyx_1 = __Pyx_GetName(__pyx_b, "ValueError"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 524; goto __pyx_L1;}
    __pyx_2 = PyString_FromString(__pyx_k71); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 524; goto __pyx_L1;}
    __Pyx_Raise(__pyx_1, __pyx_2, 0);
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 524; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":525 */
  __pyx_1 = __pyx_f_4dnet___memcpy(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_data8,__pyx_v_value,16); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 525; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":526 */
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_IP6"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 526; goto __pyx_L1;}
  __pyx_4 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 526; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type = __pyx_4;

  /* "/misc/projects/libdnet/python/./dnet.pyx":527 */
  __pyx_1 = __Pyx_GetName(__pyx_m, "IP6_ADDR_BITS"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 527; goto __pyx_L1;}
  __pyx_4 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 527; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_bits = __pyx_4;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.ip6.__set__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_value);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4addr_bcast(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4addr_bcast[] = "Return an addr object for our broadcast address.";
static PyObject *__pyx_f_4dnet_4addr_bcast(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_bcast;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_bcast = Py_None; Py_INCREF(__pyx_v_bcast);

  /* "/misc/projects/libdnet/python/./dnet.pyx":531 */
  __pyx_1 = PyTuple_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 531; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 531; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_v_bcast);
  __pyx_v_bcast = __pyx_2;
  __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":532 */
  addr_bcast((&((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr),(&((struct __pyx_obj_4dnet_addr *)__pyx_v_bcast)->_addr));

  /* "/misc/projects/libdnet/python/./dnet.pyx":533 */
  Py_INCREF(__pyx_v_bcast);
  __pyx_r = __pyx_v_bcast;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.bcast");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_bcast);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4addr_net(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4addr_net[] = "Return an addr object for our network address.";
static PyObject *__pyx_f_4dnet_4addr_net(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_net;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_net = Py_None; Py_INCREF(__pyx_v_net);

  /* "/misc/projects/libdnet/python/./dnet.pyx":537 */
  __pyx_1 = PyTuple_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 537; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 537; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_v_net);
  __pyx_v_net = __pyx_2;
  __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":538 */
  addr_net((&((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr),(&((struct __pyx_obj_4dnet_addr *)__pyx_v_net)->_addr));

  /* "/misc/projects/libdnet/python/./dnet.pyx":539 */
  Py_INCREF(__pyx_v_net);
  __pyx_r = __pyx_v_net;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.net");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_net);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4addr___add__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static PyObject *__pyx_f_4dnet_4addr___add__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  PyObject *__pyx_v_x;
  PyObject *__pyx_v_y;
  PyObject *__pyx_v_z;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  unsigned long __pyx_5;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  __pyx_v_x = Py_None; Py_INCREF(__pyx_v_x);
  __pyx_v_y = Py_None; Py_INCREF(__pyx_v_y);
  __pyx_v_z = Py_None; Py_INCREF(__pyx_v_z);

  /* "/misc/projects/libdnet/python/./dnet.pyx":543 */
  __pyx_1 = PyInt_Check(__pyx_v_self);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":544 */
    __pyx_2 = __pyx_v_other;
    Py_INCREF(__pyx_2);
    __pyx_3 = __pyx_v_self;
    Py_INCREF(__pyx_3);
    Py_DECREF(__pyx_v_x);
    __pyx_v_x = __pyx_2;
    __pyx_2 = 0;
    Py_DECREF(__pyx_v_y);
    __pyx_v_y = __pyx_3;
    __pyx_3 = 0;
    goto __pyx_L2;
  }
  __pyx_1 = PyInt_Check(__pyx_v_other);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":546 */
    __pyx_2 = __pyx_v_self;
    Py_INCREF(__pyx_2);
    __pyx_3 = __pyx_v_other;
    Py_INCREF(__pyx_3);
    Py_DECREF(__pyx_v_x);
    __pyx_v_x = __pyx_2;
    __pyx_2 = 0;
    Py_DECREF(__pyx_v_y);
    __pyx_v_y = __pyx_3;
    __pyx_3 = 0;
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/misc/projects/libdnet/python/./dnet.pyx":548 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "NotImplementedError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 548; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 548; goto __pyx_L1;}
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":549 */
  __pyx_3 = PyObject_GetAttrString(__pyx_v_x, "__copy__"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 549; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 549; goto __pyx_L1;}
  __pyx_4 = PyObject_CallObject(__pyx_3, __pyx_2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 549; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_v_z);
  __pyx_v_z = __pyx_4;
  __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":550 */
  __pyx_3 = PyLong_FromUnsignedLong(ntohl(((struct __pyx_obj_4dnet_addr *)__pyx_v_x)->_addr.addr_ip)); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 550; goto __pyx_L1;}
  __pyx_2 = PyNumber_Add(__pyx_3, __pyx_v_y); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 550; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_5 = PyLong_AsUnsignedLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 550; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_z)->_addr.addr_ip = htonl(__pyx_5);

  /* "/misc/projects/libdnet/python/./dnet.pyx":551 */
  Py_INCREF(__pyx_v_z);
  __pyx_r = __pyx_v_z;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("dnet.addr.__add__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_x);
  Py_DECREF(__pyx_v_y);
  Py_DECREF(__pyx_v_z);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4addr___copy__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static PyObject *__pyx_f_4dnet_4addr___copy__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_a;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_a = Py_None; Py_INCREF(__pyx_v_a);

  /* "/misc/projects/libdnet/python/./dnet.pyx":554 */
  __pyx_1 = PyTuple_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 554; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 554; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_v_a);
  __pyx_v_a = __pyx_2;
  __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":555 */
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_a)->_addr = ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr;

  /* "/misc/projects/libdnet/python/./dnet.pyx":556 */
  Py_INCREF(__pyx_v_a);
  __pyx_r = __pyx_v_a;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.__copy__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_a);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static int __pyx_f_4dnet_4addr___cmp__(PyObject *__pyx_v_x, PyObject *__pyx_v_y); /*proto*/
static int __pyx_f_4dnet_4addr___cmp__(PyObject *__pyx_v_x, PyObject *__pyx_v_y) {
  int __pyx_r;
  Py_INCREF(__pyx_v_x);
  Py_INCREF(__pyx_v_y);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_y), __pyx_ptype_4dnet_addr, 1, "y")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 558; goto __pyx_L1;}

  /* "/misc/projects/libdnet/python/./dnet.pyx":559 */
  __pyx_r = addr_cmp((&((struct __pyx_obj_4dnet_addr *)__pyx_v_x)->_addr),(&((struct __pyx_obj_4dnet_addr *)__pyx_v_y)->_addr));
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.addr.__cmp__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_x);
  Py_DECREF(__pyx_v_y);
  return __pyx_r;
}


static int __pyx_f_4dnet_4addr___contains__(PyObject *__pyx_v_self, PyObject *__pyx_v_other); /*proto*/
static int __pyx_f_4dnet_4addr___contains__(PyObject *__pyx_v_self, PyObject *__pyx_v_other) {
  struct addr __pyx_v_s1;
  struct addr __pyx_v_s2;
  struct addr __pyx_v_o1;
  struct addr __pyx_v_o2;
  int __pyx_r;
  int __pyx_1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_other);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_other), __pyx_ptype_4dnet_addr, 1, "other")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 561; goto __pyx_L1;}

  /* "/misc/projects/libdnet/python/./dnet.pyx":563 */
  __pyx_1 = (addr_net((&((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr),(&__pyx_v_s1)) != 0);
  if (!__pyx_1) {
    __pyx_1 = (addr_bcast((&((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr),(&__pyx_v_s2)) != 0);
    if (!__pyx_1) {
      __pyx_1 = (addr_net((&((struct __pyx_obj_4dnet_addr *)__pyx_v_other)->_addr),(&__pyx_v_o1)) != 0);
      if (!__pyx_1) {
        __pyx_1 = (addr_bcast((&((struct __pyx_obj_4dnet_addr *)__pyx_v_other)->_addr),(&__pyx_v_o2)) != 0);
      }
    }
  }
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":567 */
    __pyx_r = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":568 */
  __pyx_1 = (addr_cmp((&__pyx_v_o1),(&__pyx_v_s1)) >= 0);
  if (__pyx_1) {
    __pyx_1 = (addr_cmp((&__pyx_v_o2),(&__pyx_v_s2)) <= 0);
  }
  __pyx_r = __pyx_1;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.addr.__contains__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_other);
  return __pyx_r;
}


static long __pyx_f_4dnet_4addr___hash__(PyObject *__pyx_v_self); /*proto*/
static long __pyx_f_4dnet_4addr___hash__(PyObject *__pyx_v_self) {
  long __pyx_v_x;
  long __pyx_v_y;
  long __pyx_v_size;
  PyObject *__pyx_v_i;
  long __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  long __pyx_4;
  Py_INCREF(__pyx_v_self);
  __pyx_v_i = Py_None; Py_INCREF(__pyx_v_i);

  /* "/misc/projects/libdnet/python/./dnet.pyx":572 */
  __pyx_1 = PyInt_FromLong(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 572; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_ETH"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 572; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 572; goto __pyx_L1;}
  __pyx_3 = __pyx_3 == 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {
    __pyx_v_size = 6;
    goto __pyx_L2;
  }
  __pyx_1 = PyInt_FromLong(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 573; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_IP"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 573; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 573; goto __pyx_L1;}
  __pyx_3 = __pyx_3 == 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {
    __pyx_v_size = 4;
    goto __pyx_L2;
  }
  __pyx_1 = PyInt_FromLong(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 574; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_IP6"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 574; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 574; goto __pyx_L1;}
  __pyx_3 = __pyx_3 == 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {
    __pyx_v_size = 16;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":575 */
  __pyx_v_x = 3430008;

  /* "/misc/projects/libdnet/python/./dnet.pyx":576 */
  __pyx_v_x = (__pyx_v_x ^ ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type);

  /* "/misc/projects/libdnet/python/./dnet.pyx":577 */
  __pyx_v_x = (__pyx_v_x ^ ((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_bits);

  /* "/misc/projects/libdnet/python/./dnet.pyx":578 */
  __pyx_v_y = ((((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_data8[0]) << 7);

  /* "/misc/projects/libdnet/python/./dnet.pyx":579 */
  for (__pyx_4 = 0+1; __pyx_4 < __pyx_v_size; ++__pyx_4) {
    __pyx_1 = PyInt_FromLong(__pyx_4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 579; goto __pyx_L1;}
    Py_DECREF(__pyx_v_i);
    __pyx_v_i = __pyx_1;
    __pyx_1 = 0;

    /* "/misc/projects/libdnet/python/./dnet.pyx":580 */
    __pyx_3 = PyInt_AsLong(__pyx_v_i); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 580; goto __pyx_L1;}
    __pyx_v_y = ((1000003 * __pyx_v_y) ^ (((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_data8[__pyx_3]));
    __pyx_L3:;
  }
  __pyx_L4:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":581 */
  __pyx_v_y = (__pyx_v_y ^ __pyx_v_size);

  /* "/misc/projects/libdnet/python/./dnet.pyx":582 */
  __pyx_3 = (__pyx_v_y == (-1));
  if (__pyx_3) {
    __pyx_v_y = (-2);
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":583 */
  __pyx_v_x = (__pyx_v_x ^ __pyx_v_y);

  /* "/misc/projects/libdnet/python/./dnet.pyx":584 */
  __pyx_3 = (__pyx_v_x == (-1));
  if (__pyx_3) {
    __pyx_v_x = (-2);
    goto __pyx_L6;
  }
  __pyx_L6:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":585 */
  __pyx_r = __pyx_v_x;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.__hash__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_i);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4addr___int__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_4addr___int__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":588 */
  __pyx_1 = PyInt_FromLong(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 588; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_IP"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 588; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 588; goto __pyx_L1;}
  __pyx_3 = __pyx_3 != 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":589 */
    __pyx_1 = __Pyx_GetName(__pyx_b, "NotImplementedError"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 589; goto __pyx_L1;}
    __Pyx_Raise(__pyx_1, 0, 0);
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 589; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":590 */
  __pyx_2 = PyLong_FromUnsignedLong(ntohl(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_ip)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 590; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.__int__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4addr___long__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_4addr___long__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":593 */
  __pyx_1 = PyObject_GetAttrString(__pyx_v_self, "__int__"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 593; goto __pyx_L1;}
  __pyx_2 = PyTuple_New(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 593; goto __pyx_L1;}
  __pyx_3 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 593; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_r = __pyx_3;
  __pyx_3 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.addr.__long__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static char (__pyx_k72[]) = "XXX - i wish!\n        for i in ntohl(a.addr_ip) <= i <= ntohl(b.addr_ip):\n            next = addr()\n            next._addr.addr_type = ADDR_TYPE_IP\n            next._addr.addr_bits = IP_ADDR_BITS\n            next._addr.addr_ip = htonl(i)\n            yield next\n        ";

static PyObject *__pyx_f_4dnet_4addr___iter__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_4addr___iter__(PyObject *__pyx_v_self) {
  struct addr __pyx_v_a;
  struct addr __pyx_v_b;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":597 */
  __pyx_2 = PyInt_FromLong(((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr.addr_type); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 597; goto __pyx_L1;}
  __pyx_3 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_IP"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 597; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_2, __pyx_3, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 597; goto __pyx_L1;}
  __pyx_1 = __pyx_1 != 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  if (!__pyx_1) {
    __pyx_1 = (addr_net((&((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr),(&__pyx_v_a)) != 0);
    if (!__pyx_1) {
      __pyx_1 = (addr_bcast((&((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr),(&__pyx_v_b)) != 0);
    }
  }
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":600 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "ValueError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 600; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 600; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":601 */
  __pyx_k72;

  /* "/misc/projects/libdnet/python/./dnet.pyx":609 */
  __pyx_3 = PyLong_FromUnsignedLong(__pyx_v_a.addr_ip); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 609; goto __pyx_L1;}
  __pyx_2 = PyLong_FromUnsignedLong(__pyx_v_b.addr_ip); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 609; goto __pyx_L1;}
  __pyx_4 = PyTuple_New(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 609; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_4, 0, __pyx_3);
  PyTuple_SET_ITEM(__pyx_4, 1, __pyx_2);
  __pyx_3 = 0;
  __pyx_2 = 0;
  __pyx_3 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet___addr_ip4_iter), __pyx_4); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 609; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  __pyx_r = __pyx_3;
  __pyx_3 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("dnet.addr.__iter__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}

static char (__pyx_k73[]) = "<invalid network address>";

static PyObject *__pyx_f_4dnet_4addr___repr__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_4addr___repr__(PyObject *__pyx_v_self) {
  char (*__pyx_v_p);
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":613 */
  __pyx_v_p = addr_ntoa((&((struct __pyx_obj_4dnet_addr *)__pyx_v_self)->_addr));

  /* "/misc/projects/libdnet/python/./dnet.pyx":614 */
  __pyx_1 = (!(__pyx_v_p != 0));
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":615 */
    __pyx_2 = PyString_FromString(__pyx_k73); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 615; goto __pyx_L1;}
    __pyx_r = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":616 */
  __pyx_2 = PyString_FromString(__pyx_v_p); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 616; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.addr.__repr__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static int __pyx_f_4dnet_15__addr_ip4_iter___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_4dnet_15__addr_ip4_iter___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_cur = 0;
  PyObject *__pyx_v_max = 0;
  int __pyx_r;
  unsigned long __pyx_1;
  static char *__pyx_argnames[] = {"cur","max",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_cur, &__pyx_v_max)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_cur);
  Py_INCREF(__pyx_v_max);

  /* "/misc/projects/libdnet/python/./dnet.pyx":623 */
  __pyx_1 = PyLong_AsUnsignedLong(__pyx_v_cur); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 623; goto __pyx_L1;}
  ((struct __pyx_obj_4dnet___addr_ip4_iter *)__pyx_v_self)->cur = ntohl(__pyx_1);

  /* "/misc/projects/libdnet/python/./dnet.pyx":624 */
  __pyx_1 = PyLong_AsUnsignedLong(__pyx_v_max); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 624; goto __pyx_L1;}
  ((struct __pyx_obj_4dnet___addr_ip4_iter *)__pyx_v_self)->max = ntohl(__pyx_1);

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.__addr_ip4_iter.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_cur);
  Py_DECREF(__pyx_v_max);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_15__addr_ip4_iter___next__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_15__addr_ip4_iter___next__(PyObject *__pyx_v_self) {
  struct __pyx_obj_4dnet_addr *__pyx_v_next;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  unsigned short __pyx_4;
  Py_INCREF(__pyx_v_self);
  ((PyObject*)__pyx_v_next) = Py_None; Py_INCREF(((PyObject*)__pyx_v_next));

  /* "/misc/projects/libdnet/python/./dnet.pyx":628 */
  __pyx_1 = (((struct __pyx_obj_4dnet___addr_ip4_iter *)__pyx_v_self)->cur <= ((struct __pyx_obj_4dnet___addr_ip4_iter *)__pyx_v_self)->max);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":629 */
    __pyx_2 = PyTuple_New(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 629; goto __pyx_L1;}
    __pyx_3 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 629; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    if (!__Pyx_TypeTest(__pyx_3, __pyx_ptype_4dnet_addr)) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 629; goto __pyx_L1;}
    Py_DECREF(((PyObject *)__pyx_v_next));
    ((PyObject *)__pyx_v_next) = __pyx_3;
    __pyx_3 = 0;

    /* "/misc/projects/libdnet/python/./dnet.pyx":630 */
    __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_IP"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 630; goto __pyx_L1;}
    __pyx_4 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 630; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_v_next->_addr.addr_type = __pyx_4;

    /* "/misc/projects/libdnet/python/./dnet.pyx":631 */
    __pyx_3 = __Pyx_GetName(__pyx_m, "IP_ADDR_BITS"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 631; goto __pyx_L1;}
    __pyx_4 = PyInt_AsLong(__pyx_3); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 631; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_v_next->_addr.addr_bits = __pyx_4;

    /* "/misc/projects/libdnet/python/./dnet.pyx":632 */
    __pyx_v_next->_addr.addr_ip = htonl(((struct __pyx_obj_4dnet___addr_ip4_iter *)__pyx_v_self)->cur);

    /* "/misc/projects/libdnet/python/./dnet.pyx":633 */
    ((struct __pyx_obj_4dnet___addr_ip4_iter *)__pyx_v_self)->cur = (((struct __pyx_obj_4dnet___addr_ip4_iter *)__pyx_v_self)->cur + 1);

    /* "/misc/projects/libdnet/python/./dnet.pyx":634 */
    Py_INCREF(((PyObject *)__pyx_v_next));
    __pyx_r = ((PyObject *)__pyx_v_next);
    goto __pyx_L0;
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/misc/projects/libdnet/python/./dnet.pyx":636 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "StopIteration"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 636; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 636; goto __pyx_L1;}
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.__addr_ip4_iter.__next__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_next);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static int __pyx_f_4dnet___arp_callback(struct arp_entry (*__pyx_v_entry),void (*__pyx_v_arg)) {
  PyObject *__pyx_v_f;
  PyObject *__pyx_v_a;
  PyObject *__pyx_v_pa;
  PyObject *__pyx_v_ha;
  PyObject *__pyx_v_ret;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  int __pyx_5;
  __pyx_v_f = Py_None; Py_INCREF(__pyx_v_f);
  __pyx_v_a = Py_None; Py_INCREF(__pyx_v_a);
  __pyx_v_pa = Py_None; Py_INCREF(__pyx_v_pa);
  __pyx_v_ha = Py_None; Py_INCREF(__pyx_v_ha);
  __pyx_v_ret = Py_None; Py_INCREF(__pyx_v_ret);

  /* "/misc/projects/libdnet/python/./dnet.pyx":674 */
  __pyx_1 = (PyObject *)__pyx_v_arg;
  Py_INCREF(__pyx_1);
  __pyx_2 = __Pyx_UnpackItem(__pyx_1, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 674; goto __pyx_L1;}
  Py_DECREF(__pyx_v_f);
  __pyx_v_f = __pyx_2;
  __pyx_2 = 0;
  __pyx_3 = __Pyx_UnpackItem(__pyx_1, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 674; goto __pyx_L1;}
  Py_DECREF(__pyx_v_a);
  __pyx_v_a = __pyx_3;
  __pyx_3 = 0;
  if (__Pyx_EndUnpack(__pyx_1, 2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 674; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":675 */
  __pyx_2 = PyTuple_New(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 675; goto __pyx_L1;}
  __pyx_3 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 675; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_1 = PyTuple_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 675; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 675; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_v_pa);
  __pyx_v_pa = __pyx_3;
  __pyx_3 = 0;
  Py_DECREF(__pyx_v_ha);
  __pyx_v_ha = __pyx_2;
  __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":676 */
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_pa)->_addr = __pyx_v_entry->arp_pa;

  /* "/misc/projects/libdnet/python/./dnet.pyx":677 */
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_ha)->_addr = __pyx_v_entry->arp_ha;

  /* "/misc/projects/libdnet/python/./dnet.pyx":678 */
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 678; goto __pyx_L1;}
  Py_INCREF(__pyx_v_pa);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_pa);
  Py_INCREF(__pyx_v_ha);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_ha);
  __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 678; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
  Py_INCREF(__pyx_v_a);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_a);
  __pyx_1 = 0;
  __pyx_2 = PyObject_CallObject(__pyx_v_f, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 678; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_v_ret);
  __pyx_v_ret = __pyx_2;
  __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":679 */
  __pyx_4 = PyObject_IsTrue(__pyx_v_ret); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 679; goto __pyx_L1;}
  __pyx_5 = (!__pyx_4);
  if (__pyx_5) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":680 */
    __pyx_1 = PyInt_FromLong(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 680; goto __pyx_L1;}
    Py_DECREF(__pyx_v_ret);
    __pyx_v_ret = __pyx_1;
    __pyx_1 = 0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":681 */
  __pyx_4 = PyInt_AsLong(__pyx_v_ret); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 681; goto __pyx_L1;}
  __pyx_r = __pyx_4;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.__arp_callback");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_f);
  Py_DECREF(__pyx_v_a);
  Py_DECREF(__pyx_v_pa);
  Py_DECREF(__pyx_v_ha);
  Py_DECREF(__pyx_v_ret);
  return __pyx_r;
}


static int __pyx_f_4dnet_3arp___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_4dnet_3arp___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return -1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":691 */
  ((struct __pyx_obj_4dnet_arp *)__pyx_v_self)->arp = arp_open();

  /* "/misc/projects/libdnet/python/./dnet.pyx":692 */
  __pyx_1 = (!(((struct __pyx_obj_4dnet_arp *)__pyx_v_self)->arp != 0));
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":693 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 693; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 693; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 693; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.arp.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3arp_add(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_3arp_add[] = "Add an entry to the system ARP table.\n\n        Arguments:\n        pa -- ADDR_TYPE_IP network address object\n        ha -- ADDR_TYPE_ETH network address object\n        ";
static PyObject *__pyx_f_4dnet_3arp_add(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_4dnet_addr *__pyx_v_pa = 0;
  struct __pyx_obj_4dnet_addr *__pyx_v_ha = 0;
  struct arp_entry __pyx_v_entry;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"pa","ha",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_pa, &__pyx_v_ha)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_pa);
  Py_INCREF(__pyx_v_ha);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_pa), __pyx_ptype_4dnet_addr, 1, "pa")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 695; goto __pyx_L1;}
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_ha), __pyx_ptype_4dnet_addr, 1, "ha")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 695; goto __pyx_L1;}

  /* "/misc/projects/libdnet/python/./dnet.pyx":703 */
  __pyx_v_entry.arp_pa = __pyx_v_pa->_addr;

  /* "/misc/projects/libdnet/python/./dnet.pyx":704 */
  __pyx_v_entry.arp_ha = __pyx_v_ha->_addr;

  /* "/misc/projects/libdnet/python/./dnet.pyx":705 */
  __pyx_1 = (arp_add(((struct __pyx_obj_4dnet_arp *)__pyx_v_self)->arp,(&__pyx_v_entry)) < 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":706 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 706; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 706; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 706; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.arp.add");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_pa);
  Py_DECREF(__pyx_v_ha);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3arp_delete(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_3arp_delete[] = "Delete an entry from the system ARP table.\n\n        Arguments:\n        pa -- ADDR_TYPE_IP network address object\n        ";
static PyObject *__pyx_f_4dnet_3arp_delete(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_4dnet_addr *__pyx_v_pa = 0;
  struct arp_entry __pyx_v_entry;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"pa",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_pa)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_pa);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_pa), __pyx_ptype_4dnet_addr, 1, "pa")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 708; goto __pyx_L1;}

  /* "/misc/projects/libdnet/python/./dnet.pyx":715 */
  __pyx_v_entry.arp_pa = __pyx_v_pa->_addr;

  /* "/misc/projects/libdnet/python/./dnet.pyx":716 */
  __pyx_1 = (arp_delete(((struct __pyx_obj_4dnet_arp *)__pyx_v_self)->arp,(&__pyx_v_entry)) < 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":717 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 717; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 717; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 717; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.arp.delete");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_pa);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3arp_get(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_3arp_get[] = "Return the hardware address for a given protocol address\n        in the system ARP table.\n\n        Arguments:\n        pa -- ADDR_TYPE_IP network address object\n        ";
static PyObject *__pyx_f_4dnet_3arp_get(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_4dnet_addr *__pyx_v_pa = 0;
  struct arp_entry __pyx_v_entry;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"pa",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_pa)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_pa);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_pa), __pyx_ptype_4dnet_addr, 1, "pa")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 719; goto __pyx_L1;}

  /* "/misc/projects/libdnet/python/./dnet.pyx":727 */
  __pyx_v_entry.arp_pa = __pyx_v_pa->_addr;

  /* "/misc/projects/libdnet/python/./dnet.pyx":728 */
  __pyx_1 = (arp_get(((struct __pyx_obj_4dnet_arp *)__pyx_v_self)->arp,(&__pyx_v_entry)) == 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":729 */
    __pyx_2 = PyString_FromString(addr_ntoa((&__pyx_v_entry.arp_ha))); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 729; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 729; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
    __pyx_2 = 0;
    __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 729; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_r = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":730 */
  Py_INCREF(Py_None);
  __pyx_r = Py_None;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.arp.get");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_pa);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3arp_loop(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_3arp_loop[] = "Iterate over the system ARP table, invoking a user callback\n        with each entry, returning the status of the callback routine.\n\n        Keyword arguments:\n        callback -- callback function with ((pa, ha), arg) prototype.\n                    If this function returns a non-zero value, the loop\n                    will break early.\n        arg      -- optional callback argument\n        ";
static PyObject *__pyx_f_4dnet_3arp_loop(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_callback = 0;
  PyObject *__pyx_v_arg = 0;
  PyObject *__pyx_v__arg;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {"callback","arg",0};
  __pyx_v_arg = __pyx_k43;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O|O", __pyx_argnames, &__pyx_v_callback, &__pyx_v_arg)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_callback);
  Py_INCREF(__pyx_v_arg);
  __pyx_v__arg = Py_None; Py_INCREF(__pyx_v__arg);

  /* "/misc/projects/libdnet/python/./dnet.pyx":742 */
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 742; goto __pyx_L1;}
  Py_INCREF(__pyx_v_callback);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_callback);
  Py_INCREF(__pyx_v_arg);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_arg);
  Py_DECREF(__pyx_v__arg);
  __pyx_v__arg = __pyx_1;
  __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":743 */
  __pyx_1 = PyInt_FromLong(arp_loop(((struct __pyx_obj_4dnet_arp *)__pyx_v_self)->arp,__pyx_f_4dnet___arp_callback,((void (*))__pyx_v__arg))); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 743; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.arp.loop");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v__arg);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_callback);
  Py_DECREF(__pyx_v_arg);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3arp___iter__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_3arp___iter__(PyObject *__pyx_v_self) {
  PyObject *__pyx_v_l;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_l = Py_None; Py_INCREF(__pyx_v_l);

  /* "/misc/projects/libdnet/python/./dnet.pyx":746 */
  __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 746; goto __pyx_L1;}
  Py_DECREF(__pyx_v_l);
  __pyx_v_l = __pyx_1;
  __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":747 */
  __pyx_1 = PyObject_GetAttrString(__pyx_v_self, "loop"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 747; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "__iter_append"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 747; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 747; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
  Py_INCREF(__pyx_v_l);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_l);
  __pyx_2 = 0;
  __pyx_2 = PyObject_CallObject(__pyx_1, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 747; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":748 */
  __pyx_1 = __Pyx_GetName(__pyx_b, "iter"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 748; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 748; goto __pyx_L1;}
  Py_INCREF(__pyx_v_l);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_l);
  __pyx_2 = PyObject_CallObject(__pyx_1, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 748; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.arp.__iter__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_l);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static void __pyx_f_4dnet_3arp___dealloc__(PyObject *__pyx_v_self); /*proto*/
static void __pyx_f_4dnet_3arp___dealloc__(PyObject *__pyx_v_self) {
  int __pyx_1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":751 */
  __pyx_1 = (((struct __pyx_obj_4dnet_arp *)__pyx_v_self)->arp != 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":752 */
    arp_close(((struct __pyx_obj_4dnet_arp *)__pyx_v_self)->arp);
    goto __pyx_L2;
  }
  __pyx_L2:;

  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.arp.__dealloc__");
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
}


static PyObject *__pyx_f_4dnet_arp_pack_hdr_ethip(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_arp_pack_hdr_ethip[] = "Return a packed binary string representing an Ethernet/IP ARP message.\n    \n    Keyword arguments:\n    op  -- operation (ARP_OP_*)			(16-bit integer)\n    sha -- sender Ethernet address		(6-byte binary string)\n    spa -- sender IP address			(4-byte binary string)\n    dha -- destination Ethernet address		(6-byte binary string)\n    dpa -- destination IP address		(4-byte binary string)\n    ";
static PyObject *__pyx_f_4dnet_arp_pack_hdr_ethip(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_op = 0;
  PyObject *__pyx_v_sha = 0;
  PyObject *__pyx_v_spa = 0;
  PyObject *__pyx_v_dha = 0;
  PyObject *__pyx_v_dpa = 0;
  char (__pyx_v_buf[28]);
  eth_addr_t __pyx_v_sh;
  eth_addr_t __pyx_v_dh;
  ip_addr_t __pyx_v_sp;
  ip_addr_t __pyx_v_dp;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  static char *__pyx_argnames[] = {"op","sha","spa","dha","dpa",0};
  __pyx_v_op = __pyx_k44;
  __pyx_v_sha = __pyx_k45;
  __pyx_v_spa = __pyx_k46;
  __pyx_v_dha = __pyx_k47;
  __pyx_v_dpa = __pyx_k48;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "|OOOOO", __pyx_argnames, &__pyx_v_op, &__pyx_v_sha, &__pyx_v_spa, &__pyx_v_dha, &__pyx_v_dpa)) return 0;
  Py_INCREF(__pyx_v_op);
  Py_INCREF(__pyx_v_sha);
  Py_INCREF(__pyx_v_spa);
  Py_INCREF(__pyx_v_dha);
  Py_INCREF(__pyx_v_dpa);

  /* "/misc/projects/libdnet/python/./dnet.pyx":769 */
  __pyx_1 = __pyx_f_4dnet___memcpy(__pyx_v_sh.data,__pyx_v_sha,6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 769; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":770 */
  __pyx_1 = __pyx_f_4dnet___memcpy(__pyx_v_dh.data,__pyx_v_dha,6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 770; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":771 */
  __pyx_1 = __pyx_f_4dnet___memcpy(((char (*))(&__pyx_v_sp)),__pyx_v_spa,4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 771; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":772 */
  __pyx_1 = __pyx_f_4dnet___memcpy(((char (*))(&__pyx_v_dp)),__pyx_v_dpa,4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 772; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":773 */
  __pyx_2 = PyInt_AsLong(__pyx_v_op); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 773; goto __pyx_L1;}
  arp_pack_hdr_ethip(__pyx_v_buf,__pyx_2,__pyx_v_sh,__pyx_v_sp,__pyx_v_dh,__pyx_v_dp);

  /* "/misc/projects/libdnet/python/./dnet.pyx":774 */
  __pyx_1 = PyString_FromStringAndSize(__pyx_v_buf,28); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 774; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.arp_pack_hdr_ethip");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_op);
  Py_DECREF(__pyx_v_sha);
  Py_DECREF(__pyx_v_spa);
  Py_DECREF(__pyx_v_dha);
  Py_DECREF(__pyx_v_dpa);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_icmp_pack_hdr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_icmp_pack_hdr[] = "Return a packed binary string representing an ICMP header.\n\n    Keyword arguments:\n    type -- ICMP type		(8-bit integer)\n    code -- ICMP code		(8-bit integer)\n    ";
static PyObject *__pyx_f_4dnet_icmp_pack_hdr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_type = 0;
  PyObject *__pyx_v_code = 0;
  char (__pyx_v_buf[4]);
  PyObject *__pyx_r;
  int __pyx_1;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"type","code",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_type, &__pyx_v_code)) return 0;
  Py_INCREF(__pyx_v_type);
  Py_INCREF(__pyx_v_code);

  /* "/misc/projects/libdnet/python/./dnet.pyx":790 */
  __pyx_1 = PyInt_AsLong(__pyx_v_type); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 790; goto __pyx_L1;}
  __pyx_2 = PyInt_AsLong(__pyx_v_code); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 790; goto __pyx_L1;}
  icmp_pack_hdr(__pyx_v_buf,__pyx_1,__pyx_2);

  /* "/misc/projects/libdnet/python/./dnet.pyx":791 */
  __pyx_3 = PyString_FromStringAndSize(__pyx_v_buf,(sizeof(__pyx_v_buf))); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 791; goto __pyx_L1;}
  __pyx_r = __pyx_3;
  __pyx_3 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.icmp_pack_hdr");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_type);
  Py_DECREF(__pyx_v_code);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_tcp_pack_hdr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_tcp_pack_hdr[] = "Return a packed binary string representing a TCP header.\n\n    Keyword arguments:\n    sport -- source port		(16-bit integer)\n    dport -- destination port		(16-bit integer)\n    seq   -- sequence number		(32-bit integer)\n    ack   -- acknowledgment number	(32-bit integer)\n    flags -- control flags (TH_*)	(8-bit integer bitmask)\n    win   -- window size		(16-bit integer)\n    urp   -- urgent pointer		(16-bit integer)\n    ";
static PyObject *__pyx_f_4dnet_tcp_pack_hdr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_sport = 0;
  PyObject *__pyx_v_dport = 0;
  PyObject *__pyx_v_seq = 0;
  PyObject *__pyx_v_ack = 0;
  PyObject *__pyx_v_flags = 0;
  PyObject *__pyx_v_win = 0;
  PyObject *__pyx_v_urp = 0;
  char (__pyx_v_buf[20]);
  PyObject *__pyx_r;
  int __pyx_1;
  int __pyx_2;
  unsigned long __pyx_3;
  unsigned long __pyx_4;
  int __pyx_5;
  int __pyx_6;
  int __pyx_7;
  PyObject *__pyx_8 = 0;
  static char *__pyx_argnames[] = {"sport","dport","seq","ack","flags","win","urp",0};
  __pyx_v_seq = __pyx_k49;
  __pyx_v_ack = __pyx_k50;
  __pyx_v_flags = __pyx_k51;
  __pyx_v_win = __pyx_k52;
  __pyx_v_urp = __pyx_k53;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO|OOOOO", __pyx_argnames, &__pyx_v_sport, &__pyx_v_dport, &__pyx_v_seq, &__pyx_v_ack, &__pyx_v_flags, &__pyx_v_win, &__pyx_v_urp)) return 0;
  Py_INCREF(__pyx_v_sport);
  Py_INCREF(__pyx_v_dport);
  Py_INCREF(__pyx_v_seq);
  Py_INCREF(__pyx_v_ack);
  Py_INCREF(__pyx_v_flags);
  Py_INCREF(__pyx_v_win);
  Py_INCREF(__pyx_v_urp);

  /* "/misc/projects/libdnet/python/./dnet.pyx":856 */
  __pyx_1 = PyInt_AsLong(__pyx_v_sport); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 856; goto __pyx_L1;}
  __pyx_2 = PyInt_AsLong(__pyx_v_dport); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 856; goto __pyx_L1;}
  __pyx_3 = PyLong_AsUnsignedLong(__pyx_v_seq); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 856; goto __pyx_L1;}
  __pyx_4 = PyLong_AsUnsignedLong(__pyx_v_ack); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 856; goto __pyx_L1;}
  __pyx_5 = PyInt_AsLong(__pyx_v_flags); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 856; goto __pyx_L1;}
  __pyx_6 = PyInt_AsLong(__pyx_v_win); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 856; goto __pyx_L1;}
  __pyx_7 = PyInt_AsLong(__pyx_v_urp); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 856; goto __pyx_L1;}
  tcp_pack_hdr(__pyx_v_buf,__pyx_1,__pyx_2,__pyx_3,__pyx_4,__pyx_5,__pyx_6,__pyx_7);

  /* "/misc/projects/libdnet/python/./dnet.pyx":857 */
  __pyx_8 = PyString_FromStringAndSize(__pyx_v_buf,(sizeof(__pyx_v_buf))); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 857; goto __pyx_L1;}
  __pyx_r = __pyx_8;
  __pyx_8 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_8);
  __Pyx_AddTraceback("dnet.tcp_pack_hdr");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_sport);
  Py_DECREF(__pyx_v_dport);
  Py_DECREF(__pyx_v_seq);
  Py_DECREF(__pyx_v_ack);
  Py_DECREF(__pyx_v_flags);
  Py_DECREF(__pyx_v_win);
  Py_DECREF(__pyx_v_urp);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_udp_pack_hdr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_udp_pack_hdr[] = "Return a packed binary string representing a UDP header.\n\n    Keyword arguments:\n    sport -- source port		(16-bit integer)\n    dport -- destination port		(16-bit integer)\n    ulen  -- UDP header + data length	(16-bit integer)\n    ";
static PyObject *__pyx_f_4dnet_udp_pack_hdr(PyObject *__pyx_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_sport = 0;
  PyObject *__pyx_v_dport = 0;
  PyObject *__pyx_v_ulen = 0;
  char (__pyx_v_buf[8]);
  PyObject *__pyx_r;
  int __pyx_1;
  int __pyx_2;
  int __pyx_3;
  PyObject *__pyx_4 = 0;
  static char *__pyx_argnames[] = {"sport","dport","ulen",0};
  __pyx_v_ulen = __pyx_k54;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO|O", __pyx_argnames, &__pyx_v_sport, &__pyx_v_dport, &__pyx_v_ulen)) return 0;
  Py_INCREF(__pyx_v_sport);
  Py_INCREF(__pyx_v_dport);
  Py_INCREF(__pyx_v_ulen);

  /* "/misc/projects/libdnet/python/./dnet.pyx":877 */
  __pyx_1 = PyInt_AsLong(__pyx_v_sport); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 877; goto __pyx_L1;}
  __pyx_2 = PyInt_AsLong(__pyx_v_dport); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 877; goto __pyx_L1;}
  __pyx_3 = PyInt_AsLong(__pyx_v_ulen); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 877; goto __pyx_L1;}
  udp_pack_hdr(__pyx_v_buf,__pyx_1,__pyx_2,__pyx_3);

  /* "/misc/projects/libdnet/python/./dnet.pyx":878 */
  __pyx_4 = PyString_FromStringAndSize(__pyx_v_buf,(sizeof(__pyx_v_buf))); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 878; goto __pyx_L1;}
  __pyx_r = __pyx_4;
  __pyx_4 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("dnet.udp_pack_hdr");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_sport);
  Py_DECREF(__pyx_v_dport);
  Py_DECREF(__pyx_v_ulen);
  return __pyx_r;
}

static char (__pyx_k74[]) = "name";
static char (__pyx_k75[]) = "type";
static char (__pyx_k76[]) = "flags";
static char (__pyx_k77[]) = "mtu";
static char (__pyx_k78[]) = "addr";
static char (__pyx_k79[]) = "dst_addr";
static char (__pyx_k80[]) = "link_addr";
static char (__pyx_k81[]) = "alias_addrs";

static PyObject *__pyx_f_4dnet_ifent_to_dict(struct intf_entry (*__pyx_v_entry)) {
  PyObject *__pyx_v_d;
  PyObject *__pyx_v_l;
  PyObject *__pyx_v_i;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  long __pyx_4;
  unsigned int __pyx_5;
  PyObject *__pyx_6 = 0;
  __pyx_v_d = Py_None; Py_INCREF(__pyx_v_d);
  __pyx_v_l = Py_None; Py_INCREF(__pyx_v_l);
  __pyx_v_i = Py_None; Py_INCREF(__pyx_v_i);

  /* "/misc/projects/libdnet/python/./dnet.pyx":920 */
  __pyx_1 = PyDict_New(); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 920; goto __pyx_L1;}
  Py_DECREF(__pyx_v_d);
  __pyx_v_d = __pyx_1;
  __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":921 */
  __pyx_1 = PyString_FromString(__pyx_v_entry->intf_name); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 921; goto __pyx_L1;}
  __pyx_2 = PyString_FromString(__pyx_k74); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 921; goto __pyx_L1;}
  if (PyObject_SetItem(__pyx_v_d, __pyx_2, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 921; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":922 */
  __pyx_2 = PyInt_FromLong(__pyx_v_entry->intf_type); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 922; goto __pyx_L1;}
  __pyx_1 = PyString_FromString(__pyx_k75); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 922; goto __pyx_L1;}
  if (PyObject_SetItem(__pyx_v_d, __pyx_1, __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 922; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":923 */
  __pyx_1 = PyInt_FromLong(__pyx_v_entry->intf_flags); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 923; goto __pyx_L1;}
  __pyx_2 = PyString_FromString(__pyx_k76); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 923; goto __pyx_L1;}
  if (PyObject_SetItem(__pyx_v_d, __pyx_2, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 923; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":924 */
  __pyx_2 = PyInt_FromLong(__pyx_v_entry->intf_mtu); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 924; goto __pyx_L1;}
  __pyx_1 = PyString_FromString(__pyx_k77); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 924; goto __pyx_L1;}
  if (PyObject_SetItem(__pyx_v_d, __pyx_1, __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 924; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":925 */
  __pyx_1 = PyInt_FromLong(__pyx_v_entry->intf_addr.addr_type); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 925; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_NONE"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 925; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 925; goto __pyx_L1;}
  __pyx_3 = __pyx_3 != 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":926 */
    __pyx_1 = PyString_FromString(addr_ntoa((&__pyx_v_entry->intf_addr))); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 926; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 926; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_1);
    __pyx_1 = 0;
    __pyx_1 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 926; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyString_FromString(__pyx_k78); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 926; goto __pyx_L1;}
    if (PyObject_SetItem(__pyx_v_d, __pyx_2, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 926; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":927 */
  __pyx_2 = PyInt_FromLong(__pyx_v_entry->intf_dst_addr.addr_type); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 927; goto __pyx_L1;}
  __pyx_1 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_NONE"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 927; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_2, __pyx_1, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 927; goto __pyx_L1;}
  __pyx_3 = __pyx_3 != 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":928 */
    __pyx_2 = PyString_FromString(addr_ntoa((&__pyx_v_entry->intf_dst_addr))); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 928; goto __pyx_L1;}
    __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 928; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_2);
    __pyx_2 = 0;
    __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 928; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_1 = PyString_FromString(__pyx_k79); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 928; goto __pyx_L1;}
    if (PyObject_SetItem(__pyx_v_d, __pyx_1, __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 928; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":929 */
  __pyx_1 = PyInt_FromLong(__pyx_v_entry->intf_link_addr.addr_type); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 929; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_NONE"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 929; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 929; goto __pyx_L1;}
  __pyx_3 = __pyx_3 != 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":930 */
    __pyx_1 = PyString_FromString(addr_ntoa((&__pyx_v_entry->intf_link_addr))); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 930; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 930; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_1);
    __pyx_1 = 0;
    __pyx_1 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 930; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyString_FromString(__pyx_k80); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 930; goto __pyx_L1;}
    if (PyObject_SetItem(__pyx_v_d, __pyx_2, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 930; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":931 */
  __pyx_3 = (__pyx_v_entry->intf_alias_num > 0);
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":932 */
    __pyx_2 = PyList_New(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 932; goto __pyx_L1;}
    Py_DECREF(__pyx_v_l);
    __pyx_v_l = __pyx_2;
    __pyx_2 = 0;

    /* "/misc/projects/libdnet/python/./dnet.pyx":933 */
    __pyx_5 = __pyx_v_entry->intf_alias_num;
    for (__pyx_4 = 0; __pyx_4 < __pyx_5; ++__pyx_4) {
      __pyx_1 = PyInt_FromLong(__pyx_4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 933; goto __pyx_L1;}
      Py_DECREF(__pyx_v_i);
      __pyx_v_i = __pyx_1;
      __pyx_1 = 0;

      /* "/misc/projects/libdnet/python/./dnet.pyx":934 */
      __pyx_2 = PyObject_GetAttrString(__pyx_v_l, "append"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 934; goto __pyx_L1;}
      __pyx_3 = PyInt_AsLong(__pyx_v_i); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 934; goto __pyx_L1;}
      __pyx_1 = PyString_FromString(addr_ntoa((&(__pyx_v_entry->intf_alias_addrs[__pyx_3])))); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 934; goto __pyx_L1;}
      __pyx_6 = PyTuple_New(1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 934; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_6, 0, __pyx_1);
      __pyx_1 = 0;
      __pyx_1 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 934; goto __pyx_L1;}
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      __pyx_6 = PyTuple_New(1); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 934; goto __pyx_L1;}
      PyTuple_SET_ITEM(__pyx_6, 0, __pyx_1);
      __pyx_1 = 0;
      __pyx_1 = PyObject_CallObject(__pyx_2, __pyx_6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 934; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_6); __pyx_6 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_L6:;
    }
    __pyx_L7:;

    /* "/misc/projects/libdnet/python/./dnet.pyx":935 */
    __pyx_2 = PyString_FromString(__pyx_k81); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 935; goto __pyx_L1;}
    if (PyObject_SetItem(__pyx_v_d, __pyx_2, __pyx_v_l) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 935; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":936 */
  Py_INCREF(__pyx_v_d);
  __pyx_r = __pyx_v_d;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_6);
  __Pyx_AddTraceback("dnet.ifent_to_dict");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_d);
  Py_DECREF(__pyx_v_l);
  Py_DECREF(__pyx_v_i);
  return __pyx_r;
}

static char (__pyx_k82[]) = "name";
static char (__pyx_k83[]) = "flags";
static char (__pyx_k84[]) = "flags";
static char (__pyx_k85[]) = "mtu";
static char (__pyx_k86[]) = "mtu";
static char (__pyx_k87[]) = "addr";
static char (__pyx_k88[]) = "addr";
static char (__pyx_k89[]) = "dst_addr";
static char (__pyx_k90[]) = "dst_addr";
static char (__pyx_k91[]) = "link_addr";
static char (__pyx_k92[]) = "link_addr";
static char (__pyx_k93[]) = "alias_addrs";
static char (__pyx_k94[]) = "alias_addrs";
static char (__pyx_k95[]) = "alias_addrs";

static PyObject *__pyx_f_4dnet_dict_to_ifent(PyObject *__pyx_v_d,struct intf_entry (*__pyx_v_entry)) {
  PyObject *__pyx_v_s;
  PyObject *__pyx_v_i;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  char (*__pyx_3);
  int __pyx_4;
  unsigned short __pyx_5;
  unsigned int __pyx_6;
  PyObject *__pyx_7 = 0;
  long __pyx_8;
  Py_INCREF(__pyx_v_d);
  __pyx_v_s = Py_None; Py_INCREF(__pyx_v_s);
  __pyx_v_i = Py_None; Py_INCREF(__pyx_v_i);

  /* "/misc/projects/libdnet/python/./dnet.pyx":939 */
  __pyx_1 = PyString_FromString(__pyx_k82); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 939; goto __pyx_L1;}
  __pyx_2 = PyObject_GetItem(__pyx_v_d, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 939; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_v_s);
  __pyx_v_s = __pyx_2;
  __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":940 */
  __pyx_3 = PyString_AsString(__pyx_v_s); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 940; goto __pyx_L1;}
  strlcpy(__pyx_v_entry->intf_name,__pyx_3,16);

  /* "/misc/projects/libdnet/python/./dnet.pyx":941 */
  __pyx_1 = PyString_FromString(__pyx_k83); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 941; goto __pyx_L1;}
  __pyx_4 = PySequence_Contains(__pyx_v_d, __pyx_1); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 941; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_4) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":942 */
    __pyx_2 = PyString_FromString(__pyx_k84); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 942; goto __pyx_L1;}
    __pyx_1 = PyObject_GetItem(__pyx_v_d, __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 942; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_5 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 942; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_v_entry->intf_flags = __pyx_5;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":943 */
  __pyx_2 = PyString_FromString(__pyx_k85); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 943; goto __pyx_L1;}
  __pyx_4 = PySequence_Contains(__pyx_v_d, __pyx_2); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 943; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_4) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":944 */
    __pyx_1 = PyString_FromString(__pyx_k86); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 944; goto __pyx_L1;}
    __pyx_2 = PyObject_GetItem(__pyx_v_d, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 944; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_6 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 944; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_v_entry->intf_mtu = __pyx_6;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":945 */
  __pyx_1 = PyString_FromString(__pyx_k87); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 945; goto __pyx_L1;}
  __pyx_4 = PySequence_Contains(__pyx_v_d, __pyx_1); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 945; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_4) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":946 */
    __pyx_2 = PyString_FromString(__pyx_k88); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 946; goto __pyx_L1;}
    __pyx_1 = PyObject_GetItem(__pyx_v_d, __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 946; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_v_entry->intf_addr = ((struct __pyx_obj_4dnet_addr *)__pyx_1)->_addr;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":947 */
  __pyx_2 = PyString_FromString(__pyx_k89); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 947; goto __pyx_L1;}
  __pyx_4 = PySequence_Contains(__pyx_v_d, __pyx_2); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 947; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_4) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":948 */
    __pyx_1 = PyString_FromString(__pyx_k90); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 948; goto __pyx_L1;}
    __pyx_2 = PyObject_GetItem(__pyx_v_d, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 948; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_v_entry->intf_dst_addr = ((struct __pyx_obj_4dnet_addr *)__pyx_2)->_addr;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":949 */
  __pyx_1 = PyString_FromString(__pyx_k91); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 949; goto __pyx_L1;}
  __pyx_4 = PySequence_Contains(__pyx_v_d, __pyx_1); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 949; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_4) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":950 */
    __pyx_2 = PyString_FromString(__pyx_k92); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 950; goto __pyx_L1;}
    __pyx_1 = PyObject_GetItem(__pyx_v_d, __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 950; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_v_entry->intf_link_addr = ((struct __pyx_obj_4dnet_addr *)__pyx_1)->_addr;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    goto __pyx_L6;
  }
  __pyx_L6:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":951 */
  __pyx_2 = PyString_FromString(__pyx_k93); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 951; goto __pyx_L1;}
  __pyx_4 = PySequence_Contains(__pyx_v_d, __pyx_2); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 951; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_4) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":952 */
    __pyx_1 = __Pyx_GetName(__pyx_b, "len"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 952; goto __pyx_L1;}
    __pyx_2 = PyString_FromString(__pyx_k94); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 952; goto __pyx_L1;}
    __pyx_7 = PyObject_GetItem(__pyx_v_d, __pyx_2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 952; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 952; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_7);
    __pyx_7 = 0;
    __pyx_7 = PyObject_CallObject(__pyx_1, __pyx_2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 952; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_6 = PyInt_AsLong(__pyx_7); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 952; goto __pyx_L1;}
    Py_DECREF(__pyx_7); __pyx_7 = 0;
    __pyx_v_entry->intf_alias_num = __pyx_6;

    /* "/misc/projects/libdnet/python/./dnet.pyx":953 */
    __pyx_6 = __pyx_v_entry->intf_alias_num;
    for (__pyx_8 = 0; __pyx_8 < __pyx_6; ++__pyx_8) {
      __pyx_1 = PyInt_FromLong(__pyx_8); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 953; goto __pyx_L1;}
      Py_DECREF(__pyx_v_i);
      __pyx_v_i = __pyx_1;
      __pyx_1 = 0;

      /* "/misc/projects/libdnet/python/./dnet.pyx":954 */
      __pyx_2 = PyString_FromString(__pyx_k95); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 954; goto __pyx_L1;}
      __pyx_7 = PyObject_GetItem(__pyx_v_d, __pyx_2); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 954; goto __pyx_L1;}
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      __pyx_1 = PyObject_GetItem(__pyx_7, __pyx_v_i); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 954; goto __pyx_L1;}
      Py_DECREF(__pyx_7); __pyx_7 = 0;
      __pyx_4 = PyInt_AsLong(__pyx_v_i); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 954; goto __pyx_L1;}
      (__pyx_v_entry->intf_alias_addrs[__pyx_4]) = ((struct __pyx_obj_4dnet_addr *)__pyx_1)->_addr;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
      __pyx_L8:;
    }
    __pyx_L9:;
    goto __pyx_L7;
  }
  __pyx_L7:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_7);
  __Pyx_AddTraceback("dnet.dict_to_ifent");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_s);
  Py_DECREF(__pyx_v_i);
  Py_DECREF(__pyx_v_d);
  return __pyx_r;
}


static int __pyx_f_4dnet___intf_callback(struct intf_entry (*__pyx_v_entry),void (*__pyx_v_arg)) {
  PyObject *__pyx_v_f;
  PyObject *__pyx_v_a;
  PyObject *__pyx_v_ret;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  int __pyx_5;
  __pyx_v_f = Py_None; Py_INCREF(__pyx_v_f);
  __pyx_v_a = Py_None; Py_INCREF(__pyx_v_a);
  __pyx_v_ret = Py_None; Py_INCREF(__pyx_v_ret);

  /* "/misc/projects/libdnet/python/./dnet.pyx":957 */
  __pyx_1 = (PyObject *)__pyx_v_arg;
  Py_INCREF(__pyx_1);
  __pyx_2 = __Pyx_UnpackItem(__pyx_1, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 957; goto __pyx_L1;}
  Py_DECREF(__pyx_v_f);
  __pyx_v_f = __pyx_2;
  __pyx_2 = 0;
  __pyx_3 = __Pyx_UnpackItem(__pyx_1, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 957; goto __pyx_L1;}
  Py_DECREF(__pyx_v_a);
  __pyx_v_a = __pyx_3;
  __pyx_3 = 0;
  if (__Pyx_EndUnpack(__pyx_1, 2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 957; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":958 */
  __pyx_2 = __pyx_f_4dnet_ifent_to_dict(__pyx_v_entry); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 958; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 958; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
  Py_INCREF(__pyx_v_a);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_a);
  __pyx_2 = 0;
  __pyx_1 = PyObject_CallObject(__pyx_v_f, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 958; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_v_ret);
  __pyx_v_ret = __pyx_1;
  __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":959 */
  __pyx_4 = PyObject_IsTrue(__pyx_v_ret); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 959; goto __pyx_L1;}
  __pyx_5 = (!__pyx_4);
  if (__pyx_5) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":960 */
    __pyx_2 = PyInt_FromLong(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 960; goto __pyx_L1;}
    Py_DECREF(__pyx_v_ret);
    __pyx_v_ret = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":961 */
  __pyx_4 = PyInt_AsLong(__pyx_v_ret); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 961; goto __pyx_L1;}
  __pyx_r = __pyx_4;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.__intf_callback");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_f);
  Py_DECREF(__pyx_v_a);
  Py_DECREF(__pyx_v_ret);
  return __pyx_r;
}


static int __pyx_f_4dnet_4intf___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_4dnet_4intf___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return -1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":971 */
  ((struct __pyx_obj_4dnet_intf *)__pyx_v_self)->intf = intf_open();

  /* "/misc/projects/libdnet/python/./dnet.pyx":972 */
  __pyx_1 = (!(((struct __pyx_obj_4dnet_intf *)__pyx_v_self)->intf != 0));
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":973 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 973; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 973; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 973; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.intf.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4intf_get(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4intf_get[] = "Return the configuration for a network interface as a dict.\n        ";
static PyObject *__pyx_f_4dnet_4intf_get(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_name = 0;
  struct intf_entry (*__pyx_v_ifent);
  char (__pyx_v_buf[1024]);
  PyObject *__pyx_r;
  char (*__pyx_1);
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  static char *__pyx_argnames[] = {"name",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_name)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_name);

  /* "/misc/projects/libdnet/python/./dnet.pyx":980 */
  __pyx_v_ifent = ((struct intf_entry (*))__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":981 */
  __pyx_v_ifent->intf_len = 1024;

  /* "/misc/projects/libdnet/python/./dnet.pyx":982 */
  __pyx_1 = PyString_AsString(__pyx_v_name); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 982; goto __pyx_L1;}
  strlcpy(__pyx_v_ifent->intf_name,__pyx_1,16);

  /* "/misc/projects/libdnet/python/./dnet.pyx":983 */
  __pyx_2 = (intf_get(((struct __pyx_obj_4dnet_intf *)__pyx_v_self)->intf,__pyx_v_ifent) < 0);
  if (__pyx_2) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":984 */
    __pyx_3 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 984; goto __pyx_L1;}
    __pyx_4 = __pyx_f_4dnet___oserror(); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 984; goto __pyx_L1;}
    __Pyx_Raise(__pyx_3, __pyx_4, 0);
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    Py_DECREF(__pyx_4); __pyx_4 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 984; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":985 */
  __pyx_3 = __pyx_f_4dnet_ifent_to_dict(__pyx_v_ifent); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 985; goto __pyx_L1;}
  __pyx_r = __pyx_3;
  __pyx_3 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  __Pyx_AddTraceback("dnet.intf.get");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_name);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4intf_get_src(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4intf_get_src[] = "Return the configuration for the interface whose primary address\n        matches the specified source address.\n        ";
static PyObject *__pyx_f_4dnet_4intf_get_src(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_4dnet_addr *__pyx_v_src = 0;
  struct intf_entry (*__pyx_v_ifent);
  char (__pyx_v_buf[1024]);
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"src",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_src)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_src);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_src), __pyx_ptype_4dnet_addr, 1, "src")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 987; goto __pyx_L1;}

  /* "/misc/projects/libdnet/python/./dnet.pyx":993 */
  __pyx_v_ifent = ((struct intf_entry (*))__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":994 */
  __pyx_v_ifent->intf_len = 1024;

  /* "/misc/projects/libdnet/python/./dnet.pyx":995 */
  __pyx_1 = (intf_get_src(((struct __pyx_obj_4dnet_intf *)__pyx_v_self)->intf,__pyx_v_ifent,(&__pyx_v_src->_addr)) < 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":996 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 996; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 996; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 996; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":997 */
  __pyx_2 = __pyx_f_4dnet_ifent_to_dict(__pyx_v_ifent); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 997; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.intf.get_src");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_src);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4intf_get_dst(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4intf_get_dst[] = "Return the configuration for the best interface with which to\n        reach the specified dst address.\n        ";
static PyObject *__pyx_f_4dnet_4intf_get_dst(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_4dnet_addr *__pyx_v_dst = 0;
  struct intf_entry (*__pyx_v_ifent);
  char (__pyx_v_buf[1024]);
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"dst",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_dst)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_dst);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_dst), __pyx_ptype_4dnet_addr, 1, "dst")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 999; goto __pyx_L1;}

  /* "/misc/projects/libdnet/python/./dnet.pyx":1005 */
  __pyx_v_ifent = ((struct intf_entry (*))__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1006 */
  __pyx_v_ifent->intf_len = 1024;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1007 */
  __pyx_1 = (intf_get_dst(((struct __pyx_obj_4dnet_intf *)__pyx_v_self)->intf,__pyx_v_ifent,(&__pyx_v_dst->_addr)) < 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1008 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1008; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1008; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1008; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1009 */
  __pyx_2 = __pyx_f_4dnet_ifent_to_dict(__pyx_v_ifent); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1009; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.intf.get_dst");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_dst);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4intf_set(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4intf_set[] = "Set the configuration for an interface from a dict.\n\n        Dict values:\n        name        -- name of interface to set		(string)\n        flags       -- interface flags (INTF_FLAG_*)	(integer bitmask)\n        mtu         -- interface MTU			(integer)\n        addr        -- primary network address		(addr object)\n        dst_addr    -- point-to-point dst address	(addr object)\n        link_addr   -- link-layer address		(addr object)\n        alias_addrs -- additional network addresses	(list of addr objects)\n        ";
static PyObject *__pyx_f_4dnet_4intf_set(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_d = 0;
  struct intf_entry (*__pyx_v_ifent);
  char (__pyx_v_buf[1024]);
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"d",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_d)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_d);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1025 */
  memset(__pyx_v_buf,0,(sizeof(__pyx_v_buf)));

  /* "/misc/projects/libdnet/python/./dnet.pyx":1026 */
  __pyx_v_ifent = ((struct intf_entry (*))__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1027 */
  __pyx_v_ifent->intf_len = 1024;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1028 */
  __pyx_1 = __pyx_f_4dnet_dict_to_ifent(__pyx_v_d,__pyx_v_ifent); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1028; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1029 */
  __pyx_2 = (intf_set(((struct __pyx_obj_4dnet_intf *)__pyx_v_self)->intf,__pyx_v_ifent) < 0);
  if (__pyx_2) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1030 */
    __pyx_1 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1030; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1030; goto __pyx_L1;}
    __Pyx_Raise(__pyx_1, __pyx_3, 0);
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1030; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.intf.set");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_d);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4intf_loop(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4intf_loop[] = "Iterate over the system interface table, invoking a user callback\n        with each entry, returning the status of the callback routine.\n\n        Keyword arguments:\n        callback -- callback function with (dict, arg) prototype.\n                    If this function returns a non-zero value, the loop\n                    will break early.\n        arg      -- optional callback argument\n        ";
static PyObject *__pyx_f_4dnet_4intf_loop(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_callback = 0;
  PyObject *__pyx_v_arg = 0;
  PyObject *__pyx_v__arg;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {"callback","arg",0};
  __pyx_v_arg = __pyx_k55;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O|O", __pyx_argnames, &__pyx_v_callback, &__pyx_v_arg)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_callback);
  Py_INCREF(__pyx_v_arg);
  __pyx_v__arg = Py_None; Py_INCREF(__pyx_v__arg);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1042 */
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1042; goto __pyx_L1;}
  Py_INCREF(__pyx_v_callback);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_callback);
  Py_INCREF(__pyx_v_arg);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_arg);
  Py_DECREF(__pyx_v__arg);
  __pyx_v__arg = __pyx_1;
  __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1043 */
  __pyx_1 = PyInt_FromLong(intf_loop(((struct __pyx_obj_4dnet_intf *)__pyx_v_self)->intf,__pyx_f_4dnet___intf_callback,((void (*))__pyx_v__arg))); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1043; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.intf.loop");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v__arg);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_callback);
  Py_DECREF(__pyx_v_arg);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4intf___iter__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_4intf___iter__(PyObject *__pyx_v_self) {
  PyObject *__pyx_v_l;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_l = Py_None; Py_INCREF(__pyx_v_l);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1046 */
  __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1046; goto __pyx_L1;}
  Py_DECREF(__pyx_v_l);
  __pyx_v_l = __pyx_1;
  __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1047 */
  __pyx_1 = PyObject_GetAttrString(__pyx_v_self, "loop"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1047; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "__iter_append"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1047; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1047; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
  Py_INCREF(__pyx_v_l);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_l);
  __pyx_2 = 0;
  __pyx_2 = PyObject_CallObject(__pyx_1, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1047; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1048 */
  __pyx_1 = __Pyx_GetName(__pyx_b, "iter"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1048; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1048; goto __pyx_L1;}
  Py_INCREF(__pyx_v_l);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_l);
  __pyx_2 = PyObject_CallObject(__pyx_1, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1048; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.intf.__iter__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_l);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static void __pyx_f_4dnet_4intf___dealloc__(PyObject *__pyx_v_self); /*proto*/
static void __pyx_f_4dnet_4intf___dealloc__(PyObject *__pyx_v_self) {
  int __pyx_1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1051 */
  __pyx_1 = (((struct __pyx_obj_4dnet_intf *)__pyx_v_self)->intf != 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1052 */
    intf_close(((struct __pyx_obj_4dnet_intf *)__pyx_v_self)->intf);
    goto __pyx_L2;
  }
  __pyx_L2:;

  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.intf.__dealloc__");
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
}


static int __pyx_f_4dnet___route_callback(struct route_entry (*__pyx_v_entry),void (*__pyx_v_arg)) {
  PyObject *__pyx_v_f;
  PyObject *__pyx_v_a;
  PyObject *__pyx_v_dst;
  PyObject *__pyx_v_gw;
  PyObject *__pyx_v_ret;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  int __pyx_5;
  __pyx_v_f = Py_None; Py_INCREF(__pyx_v_f);
  __pyx_v_a = Py_None; Py_INCREF(__pyx_v_a);
  __pyx_v_dst = Py_None; Py_INCREF(__pyx_v_dst);
  __pyx_v_gw = Py_None; Py_INCREF(__pyx_v_gw);
  __pyx_v_ret = Py_None; Py_INCREF(__pyx_v_ret);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1073 */
  __pyx_1 = (PyObject *)__pyx_v_arg;
  Py_INCREF(__pyx_1);
  __pyx_2 = __Pyx_UnpackItem(__pyx_1, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1073; goto __pyx_L1;}
  Py_DECREF(__pyx_v_f);
  __pyx_v_f = __pyx_2;
  __pyx_2 = 0;
  __pyx_3 = __Pyx_UnpackItem(__pyx_1, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1073; goto __pyx_L1;}
  Py_DECREF(__pyx_v_a);
  __pyx_v_a = __pyx_3;
  __pyx_3 = 0;
  if (__Pyx_EndUnpack(__pyx_1, 2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1073; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1074 */
  __pyx_2 = PyTuple_New(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1074; goto __pyx_L1;}
  __pyx_3 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1074; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_1 = PyTuple_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1074; goto __pyx_L1;}
  __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1074; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_v_dst);
  __pyx_v_dst = __pyx_3;
  __pyx_3 = 0;
  Py_DECREF(__pyx_v_gw);
  __pyx_v_gw = __pyx_2;
  __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1075 */
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_dst)->_addr = __pyx_v_entry->route_dst;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1076 */
  ((struct __pyx_obj_4dnet_addr *)__pyx_v_gw)->_addr = __pyx_v_entry->route_gw;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1077 */
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1077; goto __pyx_L1;}
  Py_INCREF(__pyx_v_dst);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_dst);
  Py_INCREF(__pyx_v_gw);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_gw);
  __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1077; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_1);
  Py_INCREF(__pyx_v_a);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_a);
  __pyx_1 = 0;
  __pyx_2 = PyObject_CallObject(__pyx_v_f, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1077; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_v_ret);
  __pyx_v_ret = __pyx_2;
  __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1078 */
  __pyx_4 = PyObject_IsTrue(__pyx_v_ret); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1078; goto __pyx_L1;}
  __pyx_5 = (!__pyx_4);
  if (__pyx_5) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1079 */
    __pyx_1 = PyInt_FromLong(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1079; goto __pyx_L1;}
    Py_DECREF(__pyx_v_ret);
    __pyx_v_ret = __pyx_1;
    __pyx_1 = 0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1080 */
  __pyx_4 = PyInt_AsLong(__pyx_v_ret); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1080; goto __pyx_L1;}
  __pyx_r = __pyx_4;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.__route_callback");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_f);
  Py_DECREF(__pyx_v_a);
  Py_DECREF(__pyx_v_dst);
  Py_DECREF(__pyx_v_gw);
  Py_DECREF(__pyx_v_ret);
  return __pyx_r;
}


static int __pyx_f_4dnet_5route___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_4dnet_5route___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return -1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1090 */
  ((struct __pyx_obj_4dnet_route *)__pyx_v_self)->route = route_open();

  /* "/misc/projects/libdnet/python/./dnet.pyx":1091 */
  __pyx_1 = (!(((struct __pyx_obj_4dnet_route *)__pyx_v_self)->route != 0));
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1092 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1092; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1092; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1092; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.route.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_5route_add(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_5route_add[] = "Add an entry to the system routing table.\n\n        Arguments:\n        dst -- ADDR_TYPE_IP network address object\n        gw -- ADDR_TYPE_IP network address object\n        ";
static PyObject *__pyx_f_4dnet_5route_add(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_4dnet_addr *__pyx_v_dst = 0;
  struct __pyx_obj_4dnet_addr *__pyx_v_gw = 0;
  struct route_entry __pyx_v_entry;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"dst","gw",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO", __pyx_argnames, &__pyx_v_dst, &__pyx_v_gw)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_dst);
  Py_INCREF(__pyx_v_gw);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_dst), __pyx_ptype_4dnet_addr, 1, "dst")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1094; goto __pyx_L1;}
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_gw), __pyx_ptype_4dnet_addr, 1, "gw")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1094; goto __pyx_L1;}

  /* "/misc/projects/libdnet/python/./dnet.pyx":1102 */
  __pyx_v_entry.route_dst = __pyx_v_dst->_addr;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1103 */
  __pyx_v_entry.route_gw = __pyx_v_gw->_addr;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1104 */
  __pyx_1 = (route_add(((struct __pyx_obj_4dnet_route *)__pyx_v_self)->route,(&__pyx_v_entry)) < 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1105 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1105; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1105; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1105; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.route.add");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_dst);
  Py_DECREF(__pyx_v_gw);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_5route_delete(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_5route_delete[] = "Delete an entry from the system routing table.\n\n        Arguments:\n        dst -- ADDR_TYPE_IP network address object\n        ";
static PyObject *__pyx_f_4dnet_5route_delete(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_4dnet_addr *__pyx_v_dst = 0;
  struct route_entry __pyx_v_entry;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"dst",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_dst)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_dst);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_dst), __pyx_ptype_4dnet_addr, 1, "dst")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1107; goto __pyx_L1;}

  /* "/misc/projects/libdnet/python/./dnet.pyx":1114 */
  __pyx_v_entry.route_dst = __pyx_v_dst->_addr;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1115 */
  __pyx_1 = (route_delete(((struct __pyx_obj_4dnet_route *)__pyx_v_self)->route,(&__pyx_v_entry)) < 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1116 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1116; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1116; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1116; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.route.delete");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_dst);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_5route_get(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_5route_get[] = "Return the hardware address for a given protocol address\n        in the system routing table.\n\n        Arguments:\n        dst -- ADDR_TYPE_IP network address object\n        ";
static PyObject *__pyx_f_4dnet_5route_get(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_4dnet_addr *__pyx_v_dst = 0;
  struct route_entry __pyx_v_entry;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"dst",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_dst)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_dst);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_dst), __pyx_ptype_4dnet_addr, 1, "dst")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1118; goto __pyx_L1;}

  /* "/misc/projects/libdnet/python/./dnet.pyx":1126 */
  __pyx_v_entry.route_dst = __pyx_v_dst->_addr;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1127 */
  __pyx_1 = (route_get(((struct __pyx_obj_4dnet_route *)__pyx_v_self)->route,(&__pyx_v_entry)) == 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1128 */
    __pyx_2 = PyString_FromString(addr_ntoa((&__pyx_v_entry.route_gw))); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1128; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1128; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
    __pyx_2 = 0;
    __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1128; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_r = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1129 */
  Py_INCREF(Py_None);
  __pyx_r = Py_None;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.route.get");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_dst);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_5route_loop(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_5route_loop[] = "Iterate over the system routing table, invoking a user callback\n        with each entry, returning the status of the callback routine.\n\n        Keyword arguments:\n        callback -- callback function with ((dst, gw), arg) prototype.\n                    If this function returns a non-zero value, the loop\n                    will break early.\n        arg      -- optional callback argument\n        ";
static PyObject *__pyx_f_4dnet_5route_loop(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_callback = 0;
  PyObject *__pyx_v_arg = 0;
  PyObject *__pyx_v__arg;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {"callback","arg",0};
  __pyx_v_arg = __pyx_k56;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O|O", __pyx_argnames, &__pyx_v_callback, &__pyx_v_arg)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_callback);
  Py_INCREF(__pyx_v_arg);
  __pyx_v__arg = Py_None; Py_INCREF(__pyx_v__arg);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1141 */
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1141; goto __pyx_L1;}
  Py_INCREF(__pyx_v_callback);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_callback);
  Py_INCREF(__pyx_v_arg);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_arg);
  Py_DECREF(__pyx_v__arg);
  __pyx_v__arg = __pyx_1;
  __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1142 */
  __pyx_1 = PyInt_FromLong(route_loop(((struct __pyx_obj_4dnet_route *)__pyx_v_self)->route,__pyx_f_4dnet___route_callback,((void (*))__pyx_v__arg))); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1142; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.route.loop");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v__arg);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_callback);
  Py_DECREF(__pyx_v_arg);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_5route___iter__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_5route___iter__(PyObject *__pyx_v_self) {
  PyObject *__pyx_v_l;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_l = Py_None; Py_INCREF(__pyx_v_l);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1145 */
  __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1145; goto __pyx_L1;}
  Py_DECREF(__pyx_v_l);
  __pyx_v_l = __pyx_1;
  __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1146 */
  __pyx_1 = PyObject_GetAttrString(__pyx_v_self, "loop"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1146; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "__iter_append"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1146; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1146; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
  Py_INCREF(__pyx_v_l);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_l);
  __pyx_2 = 0;
  __pyx_2 = PyObject_CallObject(__pyx_1, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1146; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1147 */
  __pyx_1 = __Pyx_GetName(__pyx_b, "iter"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1147; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1147; goto __pyx_L1;}
  Py_INCREF(__pyx_v_l);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_l);
  __pyx_2 = PyObject_CallObject(__pyx_1, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1147; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.route.__iter__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_l);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static void __pyx_f_4dnet_5route___dealloc__(PyObject *__pyx_v_self); /*proto*/
static void __pyx_f_4dnet_5route___dealloc__(PyObject *__pyx_v_self) {
  int __pyx_1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1150 */
  __pyx_1 = (((struct __pyx_obj_4dnet_route *)__pyx_v_self)->route != 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1151 */
    route_close(((struct __pyx_obj_4dnet_route *)__pyx_v_self)->route);
    goto __pyx_L2;
  }
  __pyx_L2:;

  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.route.__dealloc__");
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
}

static char (__pyx_k96[]) = "device";
static char (__pyx_k97[]) = "op";
static char (__pyx_k98[]) = "dir";
static char (__pyx_k99[]) = "proto";
static char (__pyx_k100[]) = "src";
static char (__pyx_k101[]) = "dst";
static char (__pyx_k102[]) = "sport";
static char (__pyx_k103[]) = "dport";

static PyObject *__pyx_f_4dnet_rule_to_dict(struct fw_rule (*__pyx_v_rule)) {
  PyObject *__pyx_v_d;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  int __pyx_3;
  int __pyx_4;
  PyObject *__pyx_5 = 0;
  __pyx_v_d = Py_None; Py_INCREF(__pyx_v_d);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1184 */
  __pyx_1 = PyDict_New(); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1184; goto __pyx_L1;}
  Py_DECREF(__pyx_v_d);
  __pyx_v_d = __pyx_1;
  __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1185 */
  __pyx_1 = PyString_FromString(__pyx_v_rule->fw_device); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1185; goto __pyx_L1;}
  __pyx_2 = PyString_FromString(__pyx_k96); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1185; goto __pyx_L1;}
  if (PyObject_SetItem(__pyx_v_d, __pyx_2, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1185; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1186 */
  __pyx_2 = PyInt_FromLong(__pyx_v_rule->fw_op); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1186; goto __pyx_L1;}
  __pyx_1 = PyString_FromString(__pyx_k97); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1186; goto __pyx_L1;}
  if (PyObject_SetItem(__pyx_v_d, __pyx_1, __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1186; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1187 */
  __pyx_1 = PyInt_FromLong(__pyx_v_rule->fw_dir); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1187; goto __pyx_L1;}
  __pyx_2 = PyString_FromString(__pyx_k98); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1187; goto __pyx_L1;}
  if (PyObject_SetItem(__pyx_v_d, __pyx_2, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1187; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1188 */
  __pyx_3 = (__pyx_v_rule->fw_proto != 0);
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1189 */
    __pyx_2 = PyInt_FromLong(__pyx_v_rule->fw_proto); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1189; goto __pyx_L1;}
    __pyx_1 = PyString_FromString(__pyx_k99); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1189; goto __pyx_L1;}
    if (PyObject_SetItem(__pyx_v_d, __pyx_1, __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1189; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1190 */
  __pyx_1 = PyInt_FromLong(__pyx_v_rule->fw_src.addr_type); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1190; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_NONE"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1190; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_1, __pyx_2, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1190; goto __pyx_L1;}
  __pyx_3 = __pyx_3 != 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1191 */
    __pyx_1 = PyString_FromString(addr_ntoa((&__pyx_v_rule->fw_src))); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1191; goto __pyx_L1;}
    __pyx_2 = PyTuple_New(1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1191; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_2, 0, __pyx_1);
    __pyx_1 = 0;
    __pyx_1 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1191; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_2 = PyString_FromString(__pyx_k100); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1191; goto __pyx_L1;}
    if (PyObject_SetItem(__pyx_v_d, __pyx_2, __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1191; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    goto __pyx_L3;
  }
  __pyx_L3:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1192 */
  __pyx_2 = PyInt_FromLong(__pyx_v_rule->fw_dst.addr_type); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1192; goto __pyx_L1;}
  __pyx_1 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_NONE"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1192; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_2, __pyx_1, &__pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1192; goto __pyx_L1;}
  __pyx_3 = __pyx_3 != 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_3) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1193 */
    __pyx_2 = PyString_FromString(addr_ntoa((&__pyx_v_rule->fw_dst))); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1193; goto __pyx_L1;}
    __pyx_1 = PyTuple_New(1); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1193; goto __pyx_L1;}
    PyTuple_SET_ITEM(__pyx_1, 0, __pyx_2);
    __pyx_2 = 0;
    __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet_addr), __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1193; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_1 = PyString_FromString(__pyx_k101); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1193; goto __pyx_L1;}
    if (PyObject_SetItem(__pyx_v_d, __pyx_1, __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1193; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1194 */
  __pyx_3 = ((__pyx_v_rule->fw_sport[0]) == 0);
  if (__pyx_3) {
    __pyx_3 = ((__pyx_v_rule->fw_sport[1]) == 0);
  }
  __pyx_4 = (!__pyx_3);
  if (__pyx_4) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1195 */
    __pyx_1 = PyInt_FromLong((__pyx_v_rule->fw_sport[0])); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1195; goto __pyx_L1;}
    __pyx_2 = PyInt_FromLong((__pyx_v_rule->fw_sport[1])); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1195; goto __pyx_L1;}
    __pyx_5 = PyList_New(2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1195; goto __pyx_L1;}
    PyList_SET_ITEM(__pyx_5, 0, __pyx_1);
    PyList_SET_ITEM(__pyx_5, 1, __pyx_2);
    __pyx_1 = 0;
    __pyx_2 = 0;
    __pyx_1 = PyString_FromString(__pyx_k102); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1195; goto __pyx_L1;}
    if (PyObject_SetItem(__pyx_v_d, __pyx_1, __pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1195; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1196 */
  __pyx_3 = ((__pyx_v_rule->fw_dport[0]) == 0);
  if (__pyx_3) {
    __pyx_3 = ((__pyx_v_rule->fw_dport[1]) == 0);
  }
  __pyx_4 = (!__pyx_3);
  if (__pyx_4) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1197 */
    __pyx_2 = PyInt_FromLong((__pyx_v_rule->fw_dport[0])); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1197; goto __pyx_L1;}
    __pyx_1 = PyInt_FromLong((__pyx_v_rule->fw_dport[1])); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1197; goto __pyx_L1;}
    __pyx_5 = PyList_New(2); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1197; goto __pyx_L1;}
    PyList_SET_ITEM(__pyx_5, 0, __pyx_2);
    PyList_SET_ITEM(__pyx_5, 1, __pyx_1);
    __pyx_2 = 0;
    __pyx_1 = 0;
    __pyx_2 = PyString_FromString(__pyx_k103); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1197; goto __pyx_L1;}
    if (PyObject_SetItem(__pyx_v_d, __pyx_2, __pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1197; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    goto __pyx_L6;
  }
  __pyx_L6:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1198 */
  Py_INCREF(__pyx_v_d);
  __pyx_r = __pyx_v_d;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_5);
  __Pyx_AddTraceback("dnet.rule_to_dict");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_d);
  return __pyx_r;
}

static char (__pyx_k104[]) = "device";
static char (__pyx_k105[]) = "op";
static char (__pyx_k106[]) = "dir";
static char (__pyx_k107[]) = "proto";
static char (__pyx_k108[]) = "proto";
static char (__pyx_k109[]) = "src";
static char (__pyx_k110[]) = "src";
static char (__pyx_k111[]) = "dst";
static char (__pyx_k112[]) = "dst";
static char (__pyx_k113[]) = "sport";
static char (__pyx_k114[]) = "sport";
static char (__pyx_k115[]) = "sport";
static char (__pyx_k116[]) = "dport";
static char (__pyx_k117[]) = "dport";
static char (__pyx_k118[]) = "dport";

static PyObject *__pyx_f_4dnet_dict_to_rule(PyObject *__pyx_v_d,struct fw_rule (*__pyx_v_rule)) {
  PyObject *__pyx_v_s;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  char (*__pyx_3);
  int __pyx_4;
  PyObject *__pyx_5 = 0;
  Py_INCREF(__pyx_v_d);
  __pyx_v_s = Py_None; Py_INCREF(__pyx_v_s);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1201 */
  __pyx_1 = PyString_FromString(__pyx_k104); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1201; goto __pyx_L1;}
  __pyx_2 = PyObject_GetItem(__pyx_v_d, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1201; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_v_s);
  __pyx_v_s = __pyx_2;
  __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1202 */
  __pyx_3 = PyString_AsString(__pyx_v_s); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1202; goto __pyx_L1;}
  strlcpy(__pyx_v_rule->fw_device,__pyx_3,16);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1203 */
  __pyx_1 = PyString_FromString(__pyx_k105); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1203; goto __pyx_L1;}
  __pyx_2 = PyObject_GetItem(__pyx_v_d, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1203; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_4 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1203; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_v_rule->fw_op = __pyx_4;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1204 */
  __pyx_1 = PyString_FromString(__pyx_k106); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1204; goto __pyx_L1;}
  __pyx_2 = PyObject_GetItem(__pyx_v_d, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1204; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_4 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1204; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_v_rule->fw_dir = __pyx_4;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1205 */
  __pyx_1 = PyString_FromString(__pyx_k107); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1205; goto __pyx_L1;}
  __pyx_4 = PySequence_Contains(__pyx_v_d, __pyx_1); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1205; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_4) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1206 */
    __pyx_2 = PyString_FromString(__pyx_k108); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1206; goto __pyx_L1;}
    __pyx_1 = PyObject_GetItem(__pyx_v_d, __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1206; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_4 = PyInt_AsLong(__pyx_1); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1206; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_v_rule->fw_proto = __pyx_4;

    /* "/misc/projects/libdnet/python/./dnet.pyx":1207 */
    __pyx_2 = PyInt_FromLong(__pyx_v_rule->fw_proto); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1207; goto __pyx_L1;}
    __pyx_1 = __Pyx_GetName(__pyx_m, "IP_PROTO_TCP"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1207; goto __pyx_L1;}
    if (PyObject_Cmp(__pyx_2, __pyx_1, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1207; goto __pyx_L1;}
    __pyx_4 = __pyx_4 == 0;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    if (!__pyx_4) {
      __pyx_2 = PyInt_FromLong(__pyx_v_rule->fw_proto); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1207; goto __pyx_L1;}
      __pyx_1 = __Pyx_GetName(__pyx_m, "IP_PROTO_UDP"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1207; goto __pyx_L1;}
      if (PyObject_Cmp(__pyx_2, __pyx_1, &__pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1207; goto __pyx_L1;}
      __pyx_4 = __pyx_4 == 0;
      Py_DECREF(__pyx_2); __pyx_2 = 0;
      Py_DECREF(__pyx_1); __pyx_1 = 0;
    }
    if (__pyx_4) {

      /* "/misc/projects/libdnet/python/./dnet.pyx":1208 */
      (__pyx_v_rule->fw_sport[1]) = 65535;

      /* "/misc/projects/libdnet/python/./dnet.pyx":1209 */
      (__pyx_v_rule->fw_dport[1]) = 65535;
      goto __pyx_L3;
    }
    __pyx_L3:;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1210 */
  __pyx_2 = PyString_FromString(__pyx_k109); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1210; goto __pyx_L1;}
  __pyx_4 = PySequence_Contains(__pyx_v_d, __pyx_2); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1210; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_4) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1211 */
    __pyx_1 = PyString_FromString(__pyx_k110); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1211; goto __pyx_L1;}
    __pyx_2 = PyObject_GetItem(__pyx_v_d, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1211; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_v_rule->fw_src = ((struct __pyx_obj_4dnet_addr *)__pyx_2)->_addr;
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    goto __pyx_L4;
  }
  __pyx_L4:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1212 */
  __pyx_1 = PyString_FromString(__pyx_k111); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1212; goto __pyx_L1;}
  __pyx_4 = PySequence_Contains(__pyx_v_d, __pyx_1); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1212; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_4) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1213 */
    __pyx_2 = PyString_FromString(__pyx_k112); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1213; goto __pyx_L1;}
    __pyx_1 = PyObject_GetItem(__pyx_v_d, __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1213; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_v_rule->fw_dst = ((struct __pyx_obj_4dnet_addr *)__pyx_1)->_addr;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    goto __pyx_L5;
  }
  __pyx_L5:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1214 */
  __pyx_2 = PyString_FromString(__pyx_k113); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1214; goto __pyx_L1;}
  __pyx_4 = PySequence_Contains(__pyx_v_d, __pyx_2); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1214; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  if (__pyx_4) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1215 */
    __pyx_1 = PyString_FromString(__pyx_k114); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1215; goto __pyx_L1;}
    __pyx_2 = PyObject_GetItem(__pyx_v_d, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1215; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_1 = PyInt_FromLong(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1215; goto __pyx_L1;}
    __pyx_5 = PyObject_GetItem(__pyx_2, __pyx_1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1215; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_4 = PyInt_AsLong(__pyx_5); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1215; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    (__pyx_v_rule->fw_sport[0]) = __pyx_4;

    /* "/misc/projects/libdnet/python/./dnet.pyx":1216 */
    __pyx_2 = PyString_FromString(__pyx_k115); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1216; goto __pyx_L1;}
    __pyx_1 = PyObject_GetItem(__pyx_v_d, __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1216; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_5 = PyInt_FromLong(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1216; goto __pyx_L1;}
    __pyx_2 = PyObject_GetItem(__pyx_1, __pyx_5); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1216; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    __pyx_4 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1216; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    (__pyx_v_rule->fw_sport[1]) = __pyx_4;
    goto __pyx_L6;
  }
  __pyx_L6:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1217 */
  __pyx_1 = PyString_FromString(__pyx_k116); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1217; goto __pyx_L1;}
  __pyx_4 = PySequence_Contains(__pyx_v_d, __pyx_1); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1217; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_4) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1218 */
    __pyx_5 = PyString_FromString(__pyx_k117); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1218; goto __pyx_L1;}
    __pyx_2 = PyObject_GetItem(__pyx_v_d, __pyx_5); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1218; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    __pyx_1 = PyInt_FromLong(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1218; goto __pyx_L1;}
    __pyx_5 = PyObject_GetItem(__pyx_2, __pyx_1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1218; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    __pyx_4 = PyInt_AsLong(__pyx_5); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1218; goto __pyx_L1;}
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    (__pyx_v_rule->fw_dport[0]) = __pyx_4;

    /* "/misc/projects/libdnet/python/./dnet.pyx":1219 */
    __pyx_2 = PyString_FromString(__pyx_k118); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1219; goto __pyx_L1;}
    __pyx_1 = PyObject_GetItem(__pyx_v_d, __pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1219; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    __pyx_5 = PyInt_FromLong(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1219; goto __pyx_L1;}
    __pyx_2 = PyObject_GetItem(__pyx_1, __pyx_5); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1219; goto __pyx_L1;}
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_5); __pyx_5 = 0;
    __pyx_4 = PyInt_AsLong(__pyx_2); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1219; goto __pyx_L1;}
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    (__pyx_v_rule->fw_dport[1]) = __pyx_4;
    goto __pyx_L7;
  }
  __pyx_L7:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_5);
  __Pyx_AddTraceback("dnet.dict_to_rule");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_s);
  Py_DECREF(__pyx_v_d);
  return __pyx_r;
}


static int __pyx_f_4dnet___fw_callback(struct fw_rule (*__pyx_v_rule),void (*__pyx_v_arg)) {
  PyObject *__pyx_v_f;
  PyObject *__pyx_v_a;
  PyObject *__pyx_v_ret;
  int __pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  int __pyx_4;
  int __pyx_5;
  __pyx_v_f = Py_None; Py_INCREF(__pyx_v_f);
  __pyx_v_a = Py_None; Py_INCREF(__pyx_v_a);
  __pyx_v_ret = Py_None; Py_INCREF(__pyx_v_ret);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1222 */
  __pyx_1 = (PyObject *)__pyx_v_arg;
  Py_INCREF(__pyx_1);
  __pyx_2 = __Pyx_UnpackItem(__pyx_1, 0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1222; goto __pyx_L1;}
  Py_DECREF(__pyx_v_f);
  __pyx_v_f = __pyx_2;
  __pyx_2 = 0;
  __pyx_3 = __Pyx_UnpackItem(__pyx_1, 1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1222; goto __pyx_L1;}
  Py_DECREF(__pyx_v_a);
  __pyx_v_a = __pyx_3;
  __pyx_3 = 0;
  if (__Pyx_EndUnpack(__pyx_1, 2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1222; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1223 */
  __pyx_2 = __pyx_f_4dnet_rule_to_dict(__pyx_v_rule); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1223; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1223; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
  Py_INCREF(__pyx_v_a);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_a);
  __pyx_2 = 0;
  __pyx_1 = PyObject_CallObject(__pyx_v_f, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1223; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_v_ret);
  __pyx_v_ret = __pyx_1;
  __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1224 */
  __pyx_4 = PyObject_IsTrue(__pyx_v_ret); if (__pyx_4 < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1224; goto __pyx_L1;}
  __pyx_5 = (!__pyx_4);
  if (__pyx_5) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1225 */
    __pyx_2 = PyInt_FromLong(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1225; goto __pyx_L1;}
    Py_DECREF(__pyx_v_ret);
    __pyx_v_ret = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1226 */
  __pyx_4 = PyInt_AsLong(__pyx_v_ret); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1226; goto __pyx_L1;}
  __pyx_r = __pyx_4;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.__fw_callback");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_f);
  Py_DECREF(__pyx_v_a);
  Py_DECREF(__pyx_v_ret);
  return __pyx_r;
}


static int __pyx_f_4dnet_2fw___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_4dnet_2fw___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return -1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1236 */
  ((struct __pyx_obj_4dnet_fw *)__pyx_v_self)->fw = fw_open();

  /* "/misc/projects/libdnet/python/./dnet.pyx":1237 */
  __pyx_1 = (!(((struct __pyx_obj_4dnet_fw *)__pyx_v_self)->fw != 0));
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1238 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1238; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1238; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1238; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.fw.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_2fw_add(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_2fw_add[] = "Add a firewall rule specified as a dict.\n\n        Dict values:\n        device -- interface name			(string)\n        op     -- operation (FW_OP_*)			(integer)\n        dir    -- direction (FW_DIR_*)			(integer)\n        proto  -- IP protocol (IP_PROTO_*)		(integer)\n        src    -- source address / net			(addr object)\n        dst    -- destination address / net		(addr object)\n        sport  -- source port range or ICMP type/mask	(list of 2 integers)\n        dport  -- dest port range or ICMP code/mask	(list of 2 integers)\n        ";
static PyObject *__pyx_f_4dnet_2fw_add(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_d = 0;
  struct fw_rule __pyx_v_rule;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"d",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_d)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_d);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1254 */
  memset(((char (*))(&__pyx_v_rule)),0,(sizeof(__pyx_v_rule)));

  /* "/misc/projects/libdnet/python/./dnet.pyx":1255 */
  __pyx_1 = __pyx_f_4dnet_dict_to_rule(__pyx_v_d,(&__pyx_v_rule)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1255; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1256 */
  __pyx_2 = (fw_add(((struct __pyx_obj_4dnet_fw *)__pyx_v_self)->fw,(&__pyx_v_rule)) < 0);
  if (__pyx_2) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1257 */
    __pyx_1 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1257; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1257; goto __pyx_L1;}
    __Pyx_Raise(__pyx_1, __pyx_3, 0);
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1257; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.fw.add");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_d);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_2fw_delete(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_2fw_delete[] = "Delete a firewall rule specified as a dict.";
static PyObject *__pyx_f_4dnet_2fw_delete(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_d = 0;
  struct fw_rule __pyx_v_rule;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"d",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_d)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_d);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1262 */
  memset(((char (*))(&__pyx_v_rule)),0,(sizeof(__pyx_v_rule)));

  /* "/misc/projects/libdnet/python/./dnet.pyx":1263 */
  __pyx_1 = __pyx_f_4dnet_dict_to_rule(__pyx_v_d,(&__pyx_v_rule)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1263; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1264 */
  __pyx_2 = (fw_delete(((struct __pyx_obj_4dnet_fw *)__pyx_v_self)->fw,(&__pyx_v_rule)) < 0);
  if (__pyx_2) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1265 */
    __pyx_1 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1265; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1265; goto __pyx_L1;}
    __Pyx_Raise(__pyx_1, __pyx_3, 0);
    Py_DECREF(__pyx_1); __pyx_1 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1265; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.fw.delete");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_d);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_2fw_loop(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_2fw_loop[] = "Iterate over the local firewall ruleset, invoking a user callback\n        with each entry, returning the status of the callback routine.\n\n        Keyword arguments:\n        callback -- callback function with (dict, arg) prototype.\n                    If this function returns a non-zero value, the loop\n                    will break early.\n        arg      -- optional callback argument\n        ";
static PyObject *__pyx_f_4dnet_2fw_loop(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_callback = 0;
  PyObject *__pyx_v_arg = 0;
  PyObject *__pyx_v__arg;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {"callback","arg",0};
  __pyx_v_arg = __pyx_k57;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O|O", __pyx_argnames, &__pyx_v_callback, &__pyx_v_arg)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_callback);
  Py_INCREF(__pyx_v_arg);
  __pyx_v__arg = Py_None; Py_INCREF(__pyx_v__arg);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1277 */
  __pyx_1 = PyTuple_New(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1277; goto __pyx_L1;}
  Py_INCREF(__pyx_v_callback);
  PyTuple_SET_ITEM(__pyx_1, 0, __pyx_v_callback);
  Py_INCREF(__pyx_v_arg);
  PyTuple_SET_ITEM(__pyx_1, 1, __pyx_v_arg);
  Py_DECREF(__pyx_v__arg);
  __pyx_v__arg = __pyx_1;
  __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1278 */
  __pyx_1 = PyInt_FromLong(fw_loop(((struct __pyx_obj_4dnet_fw *)__pyx_v_self)->fw,__pyx_f_4dnet___fw_callback,((void (*))__pyx_v__arg))); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1278; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.fw.loop");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v__arg);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_callback);
  Py_DECREF(__pyx_v_arg);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_2fw___iter__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_2fw___iter__(PyObject *__pyx_v_self) {
  PyObject *__pyx_v_l;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  Py_INCREF(__pyx_v_self);
  __pyx_v_l = Py_None; Py_INCREF(__pyx_v_l);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1281 */
  __pyx_1 = PyList_New(0); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1281; goto __pyx_L1;}
  Py_DECREF(__pyx_v_l);
  __pyx_v_l = __pyx_1;
  __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1282 */
  __pyx_1 = PyObject_GetAttrString(__pyx_v_self, "loop"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1282; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "__iter_append"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1282; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1282; goto __pyx_L1;}
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_2);
  Py_INCREF(__pyx_v_l);
  PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_l);
  __pyx_2 = 0;
  __pyx_2 = PyObject_CallObject(__pyx_1, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1282; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1283 */
  __pyx_1 = __Pyx_GetName(__pyx_b, "iter"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1283; goto __pyx_L1;}
  __pyx_3 = PyTuple_New(1); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1283; goto __pyx_L1;}
  Py_INCREF(__pyx_v_l);
  PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_l);
  __pyx_2 = PyObject_CallObject(__pyx_1, __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1283; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.fw.__iter__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_l);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static void __pyx_f_4dnet_2fw___dealloc__(PyObject *__pyx_v_self); /*proto*/
static void __pyx_f_4dnet_2fw___dealloc__(PyObject *__pyx_v_self) {
  int __pyx_1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1286 */
  __pyx_1 = (((struct __pyx_obj_4dnet_fw *)__pyx_v_self)->fw != 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1287 */
    fw_close(((struct __pyx_obj_4dnet_fw *)__pyx_v_self)->fw);
    goto __pyx_L2;
  }
  __pyx_L2:;

  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.fw.__dealloc__");
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
}


static int __pyx_f_4dnet_4rand___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_4dnet_4rand___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return -1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1316 */
  ((struct __pyx_obj_4dnet_rand *)__pyx_v_self)->rand = rand_open();

  /* "/misc/projects/libdnet/python/./dnet.pyx":1317 */
  __pyx_1 = (!(((struct __pyx_obj_4dnet_rand *)__pyx_v_self)->rand != 0));
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1318 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1318; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1318; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1318; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.rand.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4rand_get(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4rand_get[] = "Return a string of random bytes.\n        \n        Arguments:\n        len -- number of random bytes to generate\n        ";
static PyObject *__pyx_f_4dnet_4rand_get(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_len = 0;
  char (__pyx_v_buf[1024]);
  char (*__pyx_v_p);
  PyObject *__pyx_v_s;
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  int __pyx_2;
  static char *__pyx_argnames[] = {"len",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_len)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_len);
  __pyx_v_s = Py_None; Py_INCREF(__pyx_v_s);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1328 */
  __pyx_1 = PyInt_FromLong(1024); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1328; goto __pyx_L1;}
  if (PyObject_Cmp(__pyx_v_len, __pyx_1, &__pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1328; goto __pyx_L1;}
  __pyx_2 = __pyx_2 <= 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (__pyx_2) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1329 */
    __pyx_2 = PyInt_AsLong(__pyx_v_len); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1329; goto __pyx_L1;}
    rand_get(((struct __pyx_obj_4dnet_rand *)__pyx_v_self)->rand,__pyx_v_buf,__pyx_2);

    /* "/misc/projects/libdnet/python/./dnet.pyx":1330 */
    __pyx_2 = PyInt_AsLong(__pyx_v_len); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1330; goto __pyx_L1;}
    __pyx_1 = PyString_FromStringAndSize(__pyx_v_buf,__pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1330; goto __pyx_L1;}
    __pyx_r = __pyx_1;
    __pyx_1 = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1331 */
  __pyx_2 = PyInt_AsLong(__pyx_v_len); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1331; goto __pyx_L1;}
  __pyx_v_p = malloc(__pyx_2);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1332 */
  __pyx_2 = PyInt_AsLong(__pyx_v_len); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1332; goto __pyx_L1;}
  rand_get(((struct __pyx_obj_4dnet_rand *)__pyx_v_self)->rand,__pyx_v_p,__pyx_2);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1333 */
  __pyx_2 = PyInt_AsLong(__pyx_v_len); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1333; goto __pyx_L1;}
  __pyx_1 = PyString_FromStringAndSize(__pyx_v_p,__pyx_2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1333; goto __pyx_L1;}
  Py_DECREF(__pyx_v_s);
  __pyx_v_s = __pyx_1;
  __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1334 */
  free(__pyx_v_p);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1335 */
  Py_INCREF(__pyx_v_s);
  __pyx_r = __pyx_v_s;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.rand.get");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_s);
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_len);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4rand_set(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4rand_set[] = "Initialize the PRNG from a known seed.\n        \n        Arguments:\n        string -- binary string seed value\n        ";
static PyObject *__pyx_f_4dnet_4rand_set(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_buf = 0;
  PyObject *__pyx_r;
  char (*__pyx_1);
  static char *__pyx_argnames[] = {"buf",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_buf)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1343 */
  __pyx_1 = PyString_AsString(__pyx_v_buf); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1343; goto __pyx_L1;}
  rand_set(((struct __pyx_obj_4dnet_rand *)__pyx_v_self)->rand,__pyx_1,PyString_Size(__pyx_v_buf));

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.rand.set");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_buf);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4rand_add(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4rand_add[] = "Add additional entropy into the PRNG mix.\n\n        Arguments:\n        string -- binary string\n        ";
static PyObject *__pyx_f_4dnet_4rand_add(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_buf = 0;
  PyObject *__pyx_r;
  char (*__pyx_1);
  static char *__pyx_argnames[] = {"buf",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_buf)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_buf);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1351 */
  __pyx_1 = PyString_AsString(__pyx_v_buf); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1351; goto __pyx_L1;}
  rand_add(((struct __pyx_obj_4dnet_rand *)__pyx_v_self)->rand,__pyx_1,PyString_Size(__pyx_v_buf));

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.rand.add");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_buf);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4rand_uint8(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4rand_uint8[] = "Return a random 8-bit integer.";
static PyObject *__pyx_f_4dnet_4rand_uint8(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1355 */
  __pyx_1 = PyInt_FromLong(rand_uint8(((struct __pyx_obj_4dnet_rand *)__pyx_v_self)->rand)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1355; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.rand.uint8");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4rand_uint16(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4rand_uint16[] = "Return a random 16-bit integer.";
static PyObject *__pyx_f_4dnet_4rand_uint16(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1359 */
  __pyx_1 = PyInt_FromLong(rand_uint16(((struct __pyx_obj_4dnet_rand *)__pyx_v_self)->rand)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1359; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.rand.uint16");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4rand_uint32(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4rand_uint32[] = "Return a random 32-bit integer.";
static PyObject *__pyx_f_4dnet_4rand_uint32(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1363 */
  __pyx_1 = PyLong_FromUnsignedLong(rand_uint32(((struct __pyx_obj_4dnet_rand *)__pyx_v_self)->rand)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1363; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.rand.uint32");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_4rand_xrange(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_4rand_xrange[] = "xrange([start,] stop) -> xrange object\n\n        Return a random permutation iterator to walk an unsigned integer range,\n        like xrange().\n        ";
static PyObject *__pyx_f_4dnet_4rand_xrange(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_start = 0;
  PyObject *__pyx_v_stop = 0;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"start","stop",0};
  __pyx_v_stop = __pyx_k58;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O|O", __pyx_argnames, &__pyx_v_start, &__pyx_v_stop)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_start);
  Py_INCREF(__pyx_v_stop);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1371 */
  if (PyObject_Cmp(__pyx_v_stop, Py_None, &__pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1371; goto __pyx_L1;}
  __pyx_1 = __pyx_1 == 0;
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1372 */
    __pyx_2 = PyInt_FromLong(0); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1372; goto __pyx_L1;}
    __pyx_3 = PyTuple_New(3); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1372; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_self);
    PyTuple_SET_ITEM(__pyx_3, 1, __pyx_2);
    Py_INCREF(__pyx_v_start);
    PyTuple_SET_ITEM(__pyx_3, 2, __pyx_v_start);
    __pyx_2 = 0;
    __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet___rand_xrange), __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1372; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_r = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L0;
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1374 */
    __pyx_3 = PyTuple_New(3); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1374; goto __pyx_L1;}
    Py_INCREF(__pyx_v_self);
    PyTuple_SET_ITEM(__pyx_3, 0, __pyx_v_self);
    Py_INCREF(__pyx_v_start);
    PyTuple_SET_ITEM(__pyx_3, 1, __pyx_v_start);
    Py_INCREF(__pyx_v_stop);
    PyTuple_SET_ITEM(__pyx_3, 2, __pyx_v_stop);
    __pyx_2 = PyObject_CallObject(((PyObject*)__pyx_ptype_4dnet___rand_xrange), __pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1374; goto __pyx_L1;}
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    __pyx_r = __pyx_2;
    __pyx_2 = 0;
    goto __pyx_L0;
  }
  __pyx_L2:;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.rand.xrange");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_start);
  Py_DECREF(__pyx_v_stop);
  return __pyx_r;
}


static void __pyx_f_4dnet_4rand___dealloc__(PyObject *__pyx_v_self); /*proto*/
static void __pyx_f_4dnet_4rand___dealloc__(PyObject *__pyx_v_self) {
  int __pyx_1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1377 */
  __pyx_1 = (((struct __pyx_obj_4dnet_rand *)__pyx_v_self)->rand != 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1378 */
    rand_close(((struct __pyx_obj_4dnet_rand *)__pyx_v_self)->rand);
    goto __pyx_L2;
  }
  __pyx_L2:;

  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.rand.__dealloc__");
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
}

static char (__pyx_k119[]) = "start must be an integer";
static char (__pyx_k120[]) = "stop must be an integer";

static int __pyx_f_4dnet_13__rand_xrange___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_4dnet_13__rand_xrange___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_r = 0;
  PyObject *__pyx_v_start = 0;
  PyObject *__pyx_v_stop = 0;
  unsigned int __pyx_v_bits;
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"r","start","stop",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OOO", __pyx_argnames, &__pyx_v_r, &__pyx_v_start, &__pyx_v_stop)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_r);
  Py_INCREF(__pyx_v_start);
  Py_INCREF(__pyx_v_stop);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1396 */
  ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->rand = ((struct __pyx_obj_4dnet_rand *)__pyx_v_r)->rand;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1397 */
  __pyx_1 = PyInt_Check(__pyx_v_start);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1398 */
    ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->start = PyInt_AsLong(__pyx_v_start);
    goto __pyx_L2;
  }
  __pyx_1 = PyLong_Check(__pyx_v_start);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1400 */
    ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->start = PyLong_AsUnsignedLong(__pyx_v_start);
    goto __pyx_L2;
  }
  /*else*/ {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1402 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "TypeError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1402; goto __pyx_L1;}
    __pyx_3 = PyString_FromString(__pyx_k119); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1402; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1402; goto __pyx_L1;}
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1404 */
  __pyx_1 = PyInt_Check(__pyx_v_start);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1405 */
    ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->max = (PyInt_AsLong(__pyx_v_stop) - ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->start);
    goto __pyx_L3;
  }
  __pyx_1 = PyLong_Check(__pyx_v_start);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1407 */
    ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->max = (PyLong_AsUnsignedLong(__pyx_v_stop) - ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->start);
    goto __pyx_L3;
  }
  /*else*/ {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1409 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "TypeError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1409; goto __pyx_L1;}
    __pyx_3 = PyString_FromString(__pyx_k120); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1409; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1409; goto __pyx_L1;}
  }
  __pyx_L3:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1412 */
  rand_get(((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->rand,((char (*))((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->sbox),(sizeof(((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->sbox)));

  /* "/misc/projects/libdnet/python/./dnet.pyx":1414 */
  __pyx_v_bits = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1415 */
  while (1) {
    __pyx_L4:;
    __pyx_1 = (((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->max > (1 << __pyx_v_bits));
    if (!__pyx_1) break;

    /* "/misc/projects/libdnet/python/./dnet.pyx":1416 */
    __pyx_v_bits = (__pyx_v_bits + 1);
  }
  __pyx_L5:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1418 */
  ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->left = (__pyx_v_bits / 2);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1419 */
  ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->right = (__pyx_v_bits - ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->left);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1420 */
  ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->mask = ((1 << __pyx_v_bits) - 1);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1422 */
  __pyx_1 = (__pyx_e_4dnet_TEASBOXSIZE < (1 << ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->left));
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1423 */
    ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->sboxmask = (__pyx_e_4dnet_TEASBOXSIZE - 1);

    /* "/misc/projects/libdnet/python/./dnet.pyx":1424 */
    ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->kshift = __pyx_e_4dnet_TEASBOXSHIFT;
    goto __pyx_L6;
  }
  /*else*/ {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1426 */
    ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->sboxmask = ((1 << ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->left) - 1);

    /* "/misc/projects/libdnet/python/./dnet.pyx":1427 */
    ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->kshift = ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->left;
  }
  __pyx_L6:;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.__rand_xrange.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_r);
  Py_DECREF(__pyx_v_start);
  Py_DECREF(__pyx_v_stop);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_13__rand_xrange___iter__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_13__rand_xrange___iter__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1430 */
  ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->cur = 0;
  ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->enc = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1432 */
  Py_INCREF(__pyx_v_self);
  __pyx_r = __pyx_v_self;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.__rand_xrange.__iter__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static int __pyx_f_4dnet_13__rand_xrange___len__(PyObject *__pyx_v_self); /*proto*/
static int __pyx_f_4dnet_13__rand_xrange___len__(PyObject *__pyx_v_self) {
  int __pyx_r;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1435 */
  __pyx_r = ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->max;
  goto __pyx_L0;

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.__rand_xrange.__len__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_13__rand_xrange___next__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_13__rand_xrange___next__(PyObject *__pyx_v_self) {
  unsigned long __pyx_v_c;
  unsigned long __pyx_v_sum;
  PyObject *__pyx_v_i;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  long __pyx_3;
  Py_INCREF(__pyx_v_self);
  __pyx_v_i = Py_None; Py_INCREF(__pyx_v_i);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1440 */
  __pyx_1 = (((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->cur == ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->max);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1441 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "StopIteration"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1441; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, 0, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1441; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1442 */
  ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->cur = (((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->cur + 1);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1443 */
  while (1) {
    __pyx_L3:;
    __pyx_3 = 1;
    if (!__pyx_3) break;

    /* "/misc/projects/libdnet/python/./dnet.pyx":1444 */
    __pyx_v_c = ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->enc;

    /* "/misc/projects/libdnet/python/./dnet.pyx":1445 */
    ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->enc = (((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->enc + 1);

    /* "/misc/projects/libdnet/python/./dnet.pyx":1446 */
    __pyx_v_sum = 0;

    /* "/misc/projects/libdnet/python/./dnet.pyx":1447 */
    for (__pyx_3 = 0+1; __pyx_3 < __pyx_e_4dnet_TEAROUNDS; ++__pyx_3) {
      __pyx_2 = PyInt_FromLong(__pyx_3); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1447; goto __pyx_L1;}
      Py_DECREF(__pyx_v_i);
      __pyx_v_i = __pyx_2;
      __pyx_2 = 0;

      /* "/misc/projects/libdnet/python/./dnet.pyx":1448 */
      __pyx_v_sum = (__pyx_v_sum + __pyx_e_4dnet_TEADELTA);

      /* "/misc/projects/libdnet/python/./dnet.pyx":1449 */
      __pyx_v_c = (__pyx_v_c ^ ((((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->sbox[((__pyx_v_c ^ __pyx_v_sum) & ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->sboxmask)]) << ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->kshift));

      /* "/misc/projects/libdnet/python/./dnet.pyx":1450 */
      __pyx_v_c = (__pyx_v_c + __pyx_v_sum);

      /* "/misc/projects/libdnet/python/./dnet.pyx":1451 */
      __pyx_v_c = (__pyx_v_c & ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->mask);

      /* "/misc/projects/libdnet/python/./dnet.pyx":1452 */
      __pyx_v_c = (((__pyx_v_c << ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->left) | (__pyx_v_c >> ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->right)) & ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->mask);
      __pyx_L5:;
    }
    __pyx_L6:;

    /* "/misc/projects/libdnet/python/./dnet.pyx":1453 */
    __pyx_1 = (__pyx_v_c < ((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->max);
    if (__pyx_1) {

      /* "/misc/projects/libdnet/python/./dnet.pyx":1454 */
      goto __pyx_L4;
      goto __pyx_L7;
    }
    __pyx_L7:;
  }
  __pyx_L4:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1455 */
  __pyx_2 = PyLong_FromUnsignedLong((((struct __pyx_obj_4dnet___rand_xrange *)__pyx_v_self)->start + __pyx_v_c)); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1455; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.__rand_xrange.__next__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_i);
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static int __pyx_f_4dnet_3tun___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static int __pyx_f_4dnet_3tun___init__(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  struct __pyx_obj_4dnet_addr *__pyx_v_src = 0;
  struct __pyx_obj_4dnet_addr *__pyx_v_dst = 0;
  PyObject *__pyx_v_mtu = 0;
  int __pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {"src","dst","mtu",0};
  __pyx_v_mtu = __pyx_k59;
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "OO|O", __pyx_argnames, &__pyx_v_src, &__pyx_v_dst, &__pyx_v_mtu)) return -1;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_src);
  Py_INCREF(__pyx_v_dst);
  Py_INCREF(__pyx_v_mtu);
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_src), __pyx_ptype_4dnet_addr, 1, "src")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1484; goto __pyx_L1;}
  if (!__Pyx_ArgTypeTest(((PyObject *)__pyx_v_dst), __pyx_ptype_4dnet_addr, 1, "dst")) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1484; goto __pyx_L1;}

  /* "/misc/projects/libdnet/python/./dnet.pyx":1485 */
  __pyx_1 = PyInt_AsLong(__pyx_v_mtu); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1485; goto __pyx_L1;}
  ((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->tun = tun_open((&__pyx_v_src->_addr),(&__pyx_v_dst->_addr),__pyx_1);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1486 */
  __pyx_1 = PyInt_AsLong(__pyx_v_mtu); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1486; goto __pyx_L1;}
  ((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->mtu = __pyx_1;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1487 */
  __pyx_1 = (!(((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->tun != 0));
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1488 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1488; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1488; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1488; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1489 */
  __pyx_1 = PyInt_AsLong(__pyx_v_mtu); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1489; goto __pyx_L1;}
  ((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->buf = malloc(__pyx_1);

  __pyx_r = 0;
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.tun.__init__");
  __pyx_r = -1;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_src);
  Py_DECREF(__pyx_v_dst);
  Py_DECREF(__pyx_v_mtu);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3tun_4name___get__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_3tun_4name___get__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1494 */
  __pyx_1 = PyString_FromString(tun_name(((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->tun)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1494; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.tun.name.__get__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3tun_2fd___get__(PyObject *__pyx_v_self); /*proto*/
static PyObject *__pyx_f_4dnet_3tun_2fd___get__(PyObject *__pyx_v_self) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1499 */
  __pyx_1 = PyInt_FromLong(tun_fileno(((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->tun)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1499; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.tun.fd.__get__");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3tun_fileno(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_3tun_fileno[] = "Return file descriptor for tunnel handle.";
static PyObject *__pyx_f_4dnet_3tun_fileno(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_r;
  PyObject *__pyx_1 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1503 */
  __pyx_1 = PyInt_FromLong(tun_fileno(((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->tun)); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1503; goto __pyx_L1;}
  __pyx_r = __pyx_1;
  __pyx_1 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  __Pyx_AddTraceback("dnet.tun.fileno");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3tun_send(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_3tun_send[] = "Send an IP packet, returning the number of bytes sent\n        or -1 on failure.\n\n        Arguments:\n        pkt -- binary string representing an IP packet\n        ";
static PyObject *__pyx_f_4dnet_3tun_send(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_v_pkt = 0;
  PyObject *__pyx_r;
  char (*__pyx_1);
  PyObject *__pyx_2 = 0;
  static char *__pyx_argnames[] = {"pkt",0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "O", __pyx_argnames, &__pyx_v_pkt)) return 0;
  Py_INCREF(__pyx_v_self);
  Py_INCREF(__pyx_v_pkt);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1512 */
  __pyx_1 = PyString_AsString(__pyx_v_pkt); if (PyErr_Occurred()) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1512; goto __pyx_L1;}
  __pyx_2 = PyInt_FromLong(tun_send(((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->tun,__pyx_1,PyString_Size(__pyx_v_pkt))); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1512; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  __Pyx_AddTraceback("dnet.tun.send");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  Py_DECREF(__pyx_v_pkt);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3tun_recv(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static char __pyx_doc_4dnet_3tun_recv[] = "Return the next packet delivered to the tunnel interface.";
static PyObject *__pyx_f_4dnet_3tun_recv(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  int __pyx_v_n;
  PyObject *__pyx_r;
  int __pyx_1;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1517 */
  __pyx_v_n = tun_recv(((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->tun,((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->buf,((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->mtu);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1518 */
  __pyx_1 = (__pyx_v_n < 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1519 */
    __pyx_2 = __Pyx_GetName(__pyx_b, "OSError"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1519; goto __pyx_L1;}
    __pyx_3 = __pyx_f_4dnet___oserror(); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1519; goto __pyx_L1;}
    __Pyx_Raise(__pyx_2, __pyx_3, 0);
    Py_DECREF(__pyx_2); __pyx_2 = 0;
    Py_DECREF(__pyx_3); __pyx_3 = 0;
    {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1519; goto __pyx_L1;}
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1520 */
  __pyx_2 = PyString_FromStringAndSize(((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->buf,__pyx_v_n); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1520; goto __pyx_L1;}
  __pyx_r = __pyx_2;
  __pyx_2 = 0;
  goto __pyx_L0;

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  __Pyx_AddTraceback("dnet.tun.recv");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static PyObject *__pyx_f_4dnet_3tun_close(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds); /*proto*/
static PyObject *__pyx_f_4dnet_3tun_close(PyObject *__pyx_v_self, PyObject *__pyx_args, PyObject *__pyx_kwds) {
  PyObject *__pyx_r;
  static char *__pyx_argnames[] = {0};
  if (!PyArg_ParseTupleAndKeywords(__pyx_args, __pyx_kwds, "", __pyx_argnames)) return 0;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1523 */
  ((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->tun = tun_close(((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->tun);

  __pyx_r = Py_None; Py_INCREF(__pyx_r);
  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.tun.close");
  __pyx_r = 0;
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
  return __pyx_r;
}


static void __pyx_f_4dnet_3tun___dealloc__(PyObject *__pyx_v_self); /*proto*/
static void __pyx_f_4dnet_3tun___dealloc__(PyObject *__pyx_v_self) {
  int __pyx_1;
  Py_INCREF(__pyx_v_self);

  /* "/misc/projects/libdnet/python/./dnet.pyx":1526 */
  __pyx_1 = (((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->buf != 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1527 */
    free(((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->buf);
    goto __pyx_L2;
  }
  __pyx_L2:;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1528 */
  __pyx_1 = (((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->tun != 0);
  if (__pyx_1) {

    /* "/misc/projects/libdnet/python/./dnet.pyx":1529 */
    tun_close(((struct __pyx_obj_4dnet_tun *)__pyx_v_self)->tun);
    goto __pyx_L3;
  }
  __pyx_L3:;

  goto __pyx_L0;
  __pyx_L1:;
  __Pyx_AddTraceback("dnet.tun.__dealloc__");
  __pyx_L0:;
  Py_DECREF(__pyx_v_self);
}

static PyObject *__pyx_tp_new_4dnet_eth(struct _typeobject *t, PyObject *a, PyObject *k) {
  PyObject *o = (*t->tp_alloc)(t, 0);
  struct __pyx_obj_4dnet_eth *p = (struct __pyx_obj_4dnet_eth *)o;
  return o;
}

static void __pyx_tp_dealloc_4dnet_eth(PyObject *o) {
  struct __pyx_obj_4dnet_eth *p = (struct __pyx_obj_4dnet_eth *)o;
  {
    PyObject *etype, *eval, *etb;
    PyErr_Fetch(&etype, &eval, &etb);
    ++o->ob_refcnt;
    __pyx_f_4dnet_3eth___dealloc__(o);
    if (PyErr_Occurred()) PyErr_WriteUnraisable(o);
    --o->ob_refcnt;
    PyErr_Restore(etype, eval, etb);
  }
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_4dnet_eth(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_4dnet_eth *p = (struct __pyx_obj_4dnet_eth *)o;
  return 0;
}

static int __pyx_tp_clear_4dnet_eth(PyObject *o) {
  struct __pyx_obj_4dnet_eth *p = (struct __pyx_obj_4dnet_eth *)o;
  return 0;
}

static struct PyMethodDef __pyx_methods_4dnet_eth[] = {
  {"get", (PyCFunction)__pyx_f_4dnet_3eth_get, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_3eth_get},
  {"set", (PyCFunction)__pyx_f_4dnet_3eth_set, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_3eth_set},
  {"send", (PyCFunction)__pyx_f_4dnet_3eth_send, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_3eth_send},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_eth = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
};

static PySequenceMethods __pyx_tp_as_sequence_eth = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_eth = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_eth = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

statichere PyTypeObject __pyx_type_4dnet_eth = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "dnet.eth", /*tp_name*/
  sizeof(struct __pyx_obj_4dnet_eth), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_4dnet_eth, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_eth, /*tp_as_number*/
  &__pyx_tp_as_sequence_eth, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_eth, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_eth, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE, /*tp_flags*/
  "eth(device) -> Ethernet device object\n\n    Open the specified Ethernet device for sending.\n    ", /*tp_doc*/
  __pyx_tp_traverse_4dnet_eth, /*tp_traverse*/
  __pyx_tp_clear_4dnet_eth, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_4dnet_eth, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_4dnet_3eth___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_4dnet_eth, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_4dnet_ip(struct _typeobject *t, PyObject *a, PyObject *k) {
  PyObject *o = (*t->tp_alloc)(t, 0);
  struct __pyx_obj_4dnet_ip *p = (struct __pyx_obj_4dnet_ip *)o;
  return o;
}

static void __pyx_tp_dealloc_4dnet_ip(PyObject *o) {
  struct __pyx_obj_4dnet_ip *p = (struct __pyx_obj_4dnet_ip *)o;
  {
    PyObject *etype, *eval, *etb;
    PyErr_Fetch(&etype, &eval, &etb);
    ++o->ob_refcnt;
    __pyx_f_4dnet_2ip___dealloc__(o);
    if (PyErr_Occurred()) PyErr_WriteUnraisable(o);
    --o->ob_refcnt;
    PyErr_Restore(etype, eval, etb);
  }
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_4dnet_ip(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_4dnet_ip *p = (struct __pyx_obj_4dnet_ip *)o;
  return 0;
}

static int __pyx_tp_clear_4dnet_ip(PyObject *o) {
  struct __pyx_obj_4dnet_ip *p = (struct __pyx_obj_4dnet_ip *)o;
  return 0;
}

static struct PyMethodDef __pyx_methods_4dnet_ip[] = {
  {"send", (PyCFunction)__pyx_f_4dnet_2ip_send, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_2ip_send},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_ip = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
};

static PySequenceMethods __pyx_tp_as_sequence_ip = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_ip = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_ip = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

statichere PyTypeObject __pyx_type_4dnet_ip = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "dnet.ip", /*tp_name*/
  sizeof(struct __pyx_obj_4dnet_ip), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_4dnet_ip, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_ip, /*tp_as_number*/
  &__pyx_tp_as_sequence_ip, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_ip, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_ip, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE, /*tp_flags*/
  "ip() -> Raw IP object\n\n    Open a raw IP socket for sending.\n    ", /*tp_doc*/
  __pyx_tp_traverse_4dnet_ip, /*tp_traverse*/
  __pyx_tp_clear_4dnet_ip, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_4dnet_ip, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_4dnet_2ip___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_4dnet_ip, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_4dnet_addr(struct _typeobject *t, PyObject *a, PyObject *k) {
  PyObject *o = (*t->tp_alloc)(t, 0);
  struct __pyx_obj_4dnet_addr *p = (struct __pyx_obj_4dnet_addr *)o;
  return o;
}

static void __pyx_tp_dealloc_4dnet_addr(PyObject *o) {
  struct __pyx_obj_4dnet_addr *p = (struct __pyx_obj_4dnet_addr *)o;
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_4dnet_addr(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_4dnet_addr *p = (struct __pyx_obj_4dnet_addr *)o;
  return 0;
}

static int __pyx_tp_clear_4dnet_addr(PyObject *o) {
  struct __pyx_obj_4dnet_addr *p = (struct __pyx_obj_4dnet_addr *)o;
  return 0;
}

static PyObject *__pyx_getprop_4dnet_4addr_type(PyObject *o, void *x) {
  return __pyx_f_4dnet_4addr_4type___get__(o);
}

static int __pyx_setprop_4dnet_4addr_type(PyObject *o, PyObject *v, void *x) {
  if (v) {
    return __pyx_f_4dnet_4addr_4type___set__(o, v);
  }
  else {
    PyErr_SetString(PyExc_NotImplementedError, "__del__");
    return -1;
  }
}

static PyObject *__pyx_getprop_4dnet_4addr_bits(PyObject *o, void *x) {
  return __pyx_f_4dnet_4addr_4bits___get__(o);
}

static int __pyx_setprop_4dnet_4addr_bits(PyObject *o, PyObject *v, void *x) {
  if (v) {
    return __pyx_f_4dnet_4addr_4bits___set__(o, v);
  }
  else {
    PyErr_SetString(PyExc_NotImplementedError, "__del__");
    return -1;
  }
}

static PyObject *__pyx_getprop_4dnet_4addr_data(PyObject *o, void *x) {
  return __pyx_f_4dnet_4addr_4data___get__(o);
}

static PyObject *__pyx_getprop_4dnet_4addr_eth(PyObject *o, void *x) {
  return __pyx_f_4dnet_4addr_3eth___get__(o);
}

static int __pyx_setprop_4dnet_4addr_eth(PyObject *o, PyObject *v, void *x) {
  if (v) {
    return __pyx_f_4dnet_4addr_3eth___set__(o, v);
  }
  else {
    PyErr_SetString(PyExc_NotImplementedError, "__del__");
    return -1;
  }
}

static PyObject *__pyx_getprop_4dnet_4addr_ip(PyObject *o, void *x) {
  return __pyx_f_4dnet_4addr_2ip___get__(o);
}

static int __pyx_setprop_4dnet_4addr_ip(PyObject *o, PyObject *v, void *x) {
  if (v) {
    return __pyx_f_4dnet_4addr_2ip___set__(o, v);
  }
  else {
    PyErr_SetString(PyExc_NotImplementedError, "__del__");
    return -1;
  }
}

static PyObject *__pyx_getprop_4dnet_4addr_ip6(PyObject *o, void *x) {
  return __pyx_f_4dnet_4addr_3ip6___get__(o);
}

static int __pyx_setprop_4dnet_4addr_ip6(PyObject *o, PyObject *v, void *x) {
  if (v) {
    return __pyx_f_4dnet_4addr_3ip6___set__(o, v);
  }
  else {
    PyErr_SetString(PyExc_NotImplementedError, "__del__");
    return -1;
  }
}

static struct PyMethodDef __pyx_methods_4dnet_addr[] = {
  {"bcast", (PyCFunction)__pyx_f_4dnet_4addr_bcast, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4addr_bcast},
  {"net", (PyCFunction)__pyx_f_4dnet_4addr_net, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4addr_net},
  {"__copy__", (PyCFunction)__pyx_f_4dnet_4addr___copy__, METH_VARARGS|METH_KEYWORDS, 0},
  {0, 0, 0, 0}
};

static struct PyGetSetDef __pyx_getsets_4dnet_addr[] = {
  {"type", __pyx_getprop_4dnet_4addr_type, __pyx_setprop_4dnet_4addr_type, __pyx_k1, 0},
  {"bits", __pyx_getprop_4dnet_4addr_bits, __pyx_setprop_4dnet_4addr_bits, __pyx_k2, 0},
  {"data", __pyx_getprop_4dnet_4addr_data, 0, __pyx_k3, 0},
  {"eth", __pyx_getprop_4dnet_4addr_eth, __pyx_setprop_4dnet_4addr_eth, __pyx_k4, 0},
  {"ip", __pyx_getprop_4dnet_4addr_ip, __pyx_setprop_4dnet_4addr_ip, __pyx_k5, 0},
  {"ip6", __pyx_getprop_4dnet_4addr_ip6, __pyx_setprop_4dnet_4addr_ip6, __pyx_k6, 0},
  {0, 0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_addr = {
  __pyx_f_4dnet_4addr___add__, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  __pyx_f_4dnet_4addr___int__, /*nb_int*/
  __pyx_f_4dnet_4addr___long__, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
};

static PySequenceMethods __pyx_tp_as_sequence_addr = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  __pyx_f_4dnet_4addr___contains__, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_addr = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_addr = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

statichere PyTypeObject __pyx_type_4dnet_addr = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "dnet.addr", /*tp_name*/
  sizeof(struct __pyx_obj_4dnet_addr), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_4dnet_addr, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  __pyx_f_4dnet_4addr___cmp__, /*tp_compare*/
  __pyx_f_4dnet_4addr___repr__, /*tp_repr*/
  &__pyx_tp_as_number_addr, /*tp_as_number*/
  &__pyx_tp_as_sequence_addr, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_addr, /*tp_as_mapping*/
  __pyx_f_4dnet_4addr___hash__, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_addr, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE, /*tp_flags*/
  "addr(addrtxt=None, type=ADDR_TYPE_NONE) -> network address object\n\n    Create a network address object, optionally initialized from a\n    human-readable Ethernet, IP, or IPv6 address string.\n    ", /*tp_doc*/
  __pyx_tp_traverse_4dnet_addr, /*tp_traverse*/
  __pyx_tp_clear_4dnet_addr, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  __pyx_f_4dnet_4addr___iter__, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_4dnet_addr, /*tp_methods*/
  0, /*tp_members*/
  __pyx_getsets_4dnet_addr, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_4dnet_4addr___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_4dnet_addr, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_4dnet___addr_ip4_iter(struct _typeobject *t, PyObject *a, PyObject *k) {
  PyObject *o = (*t->tp_alloc)(t, 0);
  struct __pyx_obj_4dnet___addr_ip4_iter *p = (struct __pyx_obj_4dnet___addr_ip4_iter *)o;
  return o;
}

static void __pyx_tp_dealloc_4dnet___addr_ip4_iter(PyObject *o) {
  struct __pyx_obj_4dnet___addr_ip4_iter *p = (struct __pyx_obj_4dnet___addr_ip4_iter *)o;
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_4dnet___addr_ip4_iter(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_4dnet___addr_ip4_iter *p = (struct __pyx_obj_4dnet___addr_ip4_iter *)o;
  return 0;
}

static int __pyx_tp_clear_4dnet___addr_ip4_iter(PyObject *o) {
  struct __pyx_obj_4dnet___addr_ip4_iter *p = (struct __pyx_obj_4dnet___addr_ip4_iter *)o;
  return 0;
}

static struct PyMethodDef __pyx_methods_4dnet___addr_ip4_iter[] = {
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number___addr_ip4_iter = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
};

static PySequenceMethods __pyx_tp_as_sequence___addr_ip4_iter = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping___addr_ip4_iter = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer___addr_ip4_iter = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

statichere PyTypeObject __pyx_type_4dnet___addr_ip4_iter = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "dnet.__addr_ip4_iter", /*tp_name*/
  sizeof(struct __pyx_obj_4dnet___addr_ip4_iter), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_4dnet___addr_ip4_iter, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number___addr_ip4_iter, /*tp_as_number*/
  &__pyx_tp_as_sequence___addr_ip4_iter, /*tp_as_sequence*/
  &__pyx_tp_as_mapping___addr_ip4_iter, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer___addr_ip4_iter, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_4dnet___addr_ip4_iter, /*tp_traverse*/
  __pyx_tp_clear_4dnet___addr_ip4_iter, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  __pyx_f_4dnet_15__addr_ip4_iter___next__, /*tp_iternext*/
  __pyx_methods_4dnet___addr_ip4_iter, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_4dnet_15__addr_ip4_iter___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_4dnet___addr_ip4_iter, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_4dnet_arp(struct _typeobject *t, PyObject *a, PyObject *k) {
  PyObject *o = (*t->tp_alloc)(t, 0);
  struct __pyx_obj_4dnet_arp *p = (struct __pyx_obj_4dnet_arp *)o;
  return o;
}

static void __pyx_tp_dealloc_4dnet_arp(PyObject *o) {
  struct __pyx_obj_4dnet_arp *p = (struct __pyx_obj_4dnet_arp *)o;
  {
    PyObject *etype, *eval, *etb;
    PyErr_Fetch(&etype, &eval, &etb);
    ++o->ob_refcnt;
    __pyx_f_4dnet_3arp___dealloc__(o);
    if (PyErr_Occurred()) PyErr_WriteUnraisable(o);
    --o->ob_refcnt;
    PyErr_Restore(etype, eval, etb);
  }
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_4dnet_arp(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_4dnet_arp *p = (struct __pyx_obj_4dnet_arp *)o;
  return 0;
}

static int __pyx_tp_clear_4dnet_arp(PyObject *o) {
  struct __pyx_obj_4dnet_arp *p = (struct __pyx_obj_4dnet_arp *)o;
  return 0;
}

static struct PyMethodDef __pyx_methods_4dnet_arp[] = {
  {"add", (PyCFunction)__pyx_f_4dnet_3arp_add, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_3arp_add},
  {"delete", (PyCFunction)__pyx_f_4dnet_3arp_delete, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_3arp_delete},
  {"get", (PyCFunction)__pyx_f_4dnet_3arp_get, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_3arp_get},
  {"loop", (PyCFunction)__pyx_f_4dnet_3arp_loop, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_3arp_loop},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_arp = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
};

static PySequenceMethods __pyx_tp_as_sequence_arp = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_arp = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_arp = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

statichere PyTypeObject __pyx_type_4dnet_arp = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "dnet.arp", /*tp_name*/
  sizeof(struct __pyx_obj_4dnet_arp), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_4dnet_arp, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_arp, /*tp_as_number*/
  &__pyx_tp_as_sequence_arp, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_arp, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_arp, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE, /*tp_flags*/
  "arp() -> ARP table object\n\n    Open a handle to the system ARP table.\n    ", /*tp_doc*/
  __pyx_tp_traverse_4dnet_arp, /*tp_traverse*/
  __pyx_tp_clear_4dnet_arp, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  __pyx_f_4dnet_3arp___iter__, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_4dnet_arp, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_4dnet_3arp___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_4dnet_arp, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_4dnet_intf(struct _typeobject *t, PyObject *a, PyObject *k) {
  PyObject *o = (*t->tp_alloc)(t, 0);
  struct __pyx_obj_4dnet_intf *p = (struct __pyx_obj_4dnet_intf *)o;
  return o;
}

static void __pyx_tp_dealloc_4dnet_intf(PyObject *o) {
  struct __pyx_obj_4dnet_intf *p = (struct __pyx_obj_4dnet_intf *)o;
  {
    PyObject *etype, *eval, *etb;
    PyErr_Fetch(&etype, &eval, &etb);
    ++o->ob_refcnt;
    __pyx_f_4dnet_4intf___dealloc__(o);
    if (PyErr_Occurred()) PyErr_WriteUnraisable(o);
    --o->ob_refcnt;
    PyErr_Restore(etype, eval, etb);
  }
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_4dnet_intf(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_4dnet_intf *p = (struct __pyx_obj_4dnet_intf *)o;
  return 0;
}

static int __pyx_tp_clear_4dnet_intf(PyObject *o) {
  struct __pyx_obj_4dnet_intf *p = (struct __pyx_obj_4dnet_intf *)o;
  return 0;
}

static struct PyMethodDef __pyx_methods_4dnet_intf[] = {
  {"get", (PyCFunction)__pyx_f_4dnet_4intf_get, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4intf_get},
  {"get_src", (PyCFunction)__pyx_f_4dnet_4intf_get_src, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4intf_get_src},
  {"get_dst", (PyCFunction)__pyx_f_4dnet_4intf_get_dst, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4intf_get_dst},
  {"set", (PyCFunction)__pyx_f_4dnet_4intf_set, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4intf_set},
  {"loop", (PyCFunction)__pyx_f_4dnet_4intf_loop, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4intf_loop},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_intf = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
};

static PySequenceMethods __pyx_tp_as_sequence_intf = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_intf = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_intf = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

statichere PyTypeObject __pyx_type_4dnet_intf = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "dnet.intf", /*tp_name*/
  sizeof(struct __pyx_obj_4dnet_intf), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_4dnet_intf, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_intf, /*tp_as_number*/
  &__pyx_tp_as_sequence_intf, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_intf, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_intf, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE, /*tp_flags*/
  "intf() -> Interface table object\n\n    Open a handle to the system network interface table.\n    ", /*tp_doc*/
  __pyx_tp_traverse_4dnet_intf, /*tp_traverse*/
  __pyx_tp_clear_4dnet_intf, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  __pyx_f_4dnet_4intf___iter__, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_4dnet_intf, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_4dnet_4intf___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_4dnet_intf, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_4dnet_route(struct _typeobject *t, PyObject *a, PyObject *k) {
  PyObject *o = (*t->tp_alloc)(t, 0);
  struct __pyx_obj_4dnet_route *p = (struct __pyx_obj_4dnet_route *)o;
  return o;
}

static void __pyx_tp_dealloc_4dnet_route(PyObject *o) {
  struct __pyx_obj_4dnet_route *p = (struct __pyx_obj_4dnet_route *)o;
  {
    PyObject *etype, *eval, *etb;
    PyErr_Fetch(&etype, &eval, &etb);
    ++o->ob_refcnt;
    __pyx_f_4dnet_5route___dealloc__(o);
    if (PyErr_Occurred()) PyErr_WriteUnraisable(o);
    --o->ob_refcnt;
    PyErr_Restore(etype, eval, etb);
  }
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_4dnet_route(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_4dnet_route *p = (struct __pyx_obj_4dnet_route *)o;
  return 0;
}

static int __pyx_tp_clear_4dnet_route(PyObject *o) {
  struct __pyx_obj_4dnet_route *p = (struct __pyx_obj_4dnet_route *)o;
  return 0;
}

static struct PyMethodDef __pyx_methods_4dnet_route[] = {
  {"add", (PyCFunction)__pyx_f_4dnet_5route_add, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_5route_add},
  {"delete", (PyCFunction)__pyx_f_4dnet_5route_delete, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_5route_delete},
  {"get", (PyCFunction)__pyx_f_4dnet_5route_get, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_5route_get},
  {"loop", (PyCFunction)__pyx_f_4dnet_5route_loop, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_5route_loop},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_route = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
};

static PySequenceMethods __pyx_tp_as_sequence_route = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_route = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_route = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

statichere PyTypeObject __pyx_type_4dnet_route = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "dnet.route", /*tp_name*/
  sizeof(struct __pyx_obj_4dnet_route), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_4dnet_route, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_route, /*tp_as_number*/
  &__pyx_tp_as_sequence_route, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_route, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_route, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE, /*tp_flags*/
  "route() -> Routing table object\n\n    Open a handle to the system routing table.\n    ", /*tp_doc*/
  __pyx_tp_traverse_4dnet_route, /*tp_traverse*/
  __pyx_tp_clear_4dnet_route, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  __pyx_f_4dnet_5route___iter__, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_4dnet_route, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_4dnet_5route___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_4dnet_route, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_4dnet_fw(struct _typeobject *t, PyObject *a, PyObject *k) {
  PyObject *o = (*t->tp_alloc)(t, 0);
  struct __pyx_obj_4dnet_fw *p = (struct __pyx_obj_4dnet_fw *)o;
  return o;
}

static void __pyx_tp_dealloc_4dnet_fw(PyObject *o) {
  struct __pyx_obj_4dnet_fw *p = (struct __pyx_obj_4dnet_fw *)o;
  {
    PyObject *etype, *eval, *etb;
    PyErr_Fetch(&etype, &eval, &etb);
    ++o->ob_refcnt;
    __pyx_f_4dnet_2fw___dealloc__(o);
    if (PyErr_Occurred()) PyErr_WriteUnraisable(o);
    --o->ob_refcnt;
    PyErr_Restore(etype, eval, etb);
  }
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_4dnet_fw(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_4dnet_fw *p = (struct __pyx_obj_4dnet_fw *)o;
  return 0;
}

static int __pyx_tp_clear_4dnet_fw(PyObject *o) {
  struct __pyx_obj_4dnet_fw *p = (struct __pyx_obj_4dnet_fw *)o;
  return 0;
}

static struct PyMethodDef __pyx_methods_4dnet_fw[] = {
  {"add", (PyCFunction)__pyx_f_4dnet_2fw_add, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_2fw_add},
  {"delete", (PyCFunction)__pyx_f_4dnet_2fw_delete, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_2fw_delete},
  {"loop", (PyCFunction)__pyx_f_4dnet_2fw_loop, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_2fw_loop},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_fw = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
};

static PySequenceMethods __pyx_tp_as_sequence_fw = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_fw = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_fw = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

statichere PyTypeObject __pyx_type_4dnet_fw = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "dnet.fw", /*tp_name*/
  sizeof(struct __pyx_obj_4dnet_fw), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_4dnet_fw, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_fw, /*tp_as_number*/
  &__pyx_tp_as_sequence_fw, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_fw, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_fw, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE, /*tp_flags*/
  "fw() -> Firewall ruleset object\n    \n    Open a handle to the local network firewall configuration.\n    ", /*tp_doc*/
  __pyx_tp_traverse_4dnet_fw, /*tp_traverse*/
  __pyx_tp_clear_4dnet_fw, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  __pyx_f_4dnet_2fw___iter__, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_4dnet_fw, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_4dnet_2fw___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_4dnet_fw, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_4dnet_rand(struct _typeobject *t, PyObject *a, PyObject *k) {
  PyObject *o = (*t->tp_alloc)(t, 0);
  struct __pyx_obj_4dnet_rand *p = (struct __pyx_obj_4dnet_rand *)o;
  return o;
}

static void __pyx_tp_dealloc_4dnet_rand(PyObject *o) {
  struct __pyx_obj_4dnet_rand *p = (struct __pyx_obj_4dnet_rand *)o;
  {
    PyObject *etype, *eval, *etb;
    PyErr_Fetch(&etype, &eval, &etb);
    ++o->ob_refcnt;
    __pyx_f_4dnet_4rand___dealloc__(o);
    if (PyErr_Occurred()) PyErr_WriteUnraisable(o);
    --o->ob_refcnt;
    PyErr_Restore(etype, eval, etb);
  }
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_4dnet_rand(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_4dnet_rand *p = (struct __pyx_obj_4dnet_rand *)o;
  return 0;
}

static int __pyx_tp_clear_4dnet_rand(PyObject *o) {
  struct __pyx_obj_4dnet_rand *p = (struct __pyx_obj_4dnet_rand *)o;
  return 0;
}

static struct PyMethodDef __pyx_methods_4dnet_rand[] = {
  {"get", (PyCFunction)__pyx_f_4dnet_4rand_get, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4rand_get},
  {"set", (PyCFunction)__pyx_f_4dnet_4rand_set, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4rand_set},
  {"add", (PyCFunction)__pyx_f_4dnet_4rand_add, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4rand_add},
  {"uint8", (PyCFunction)__pyx_f_4dnet_4rand_uint8, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4rand_uint8},
  {"uint16", (PyCFunction)__pyx_f_4dnet_4rand_uint16, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4rand_uint16},
  {"uint32", (PyCFunction)__pyx_f_4dnet_4rand_uint32, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4rand_uint32},
  {"xrange", (PyCFunction)__pyx_f_4dnet_4rand_xrange, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_4rand_xrange},
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_rand = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
};

static PySequenceMethods __pyx_tp_as_sequence_rand = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_rand = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_rand = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

statichere PyTypeObject __pyx_type_4dnet_rand = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "dnet.rand", /*tp_name*/
  sizeof(struct __pyx_obj_4dnet_rand), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_4dnet_rand, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_rand, /*tp_as_number*/
  &__pyx_tp_as_sequence_rand, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_rand, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_rand, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE, /*tp_flags*/
  "rand() -> Pseudo-random number generator\n\n    Obtain a handle for fast, cryptographically strong pseudo-random\n    number generation. The starting seed is derived from the system\n    random data source device (if one exists), or from the current time\n    and random stack contents.\n    ", /*tp_doc*/
  __pyx_tp_traverse_4dnet_rand, /*tp_traverse*/
  __pyx_tp_clear_4dnet_rand, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_4dnet_rand, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_4dnet_4rand___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_4dnet_rand, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_4dnet___rand_xrange(struct _typeobject *t, PyObject *a, PyObject *k) {
  PyObject *o = (*t->tp_alloc)(t, 0);
  struct __pyx_obj_4dnet___rand_xrange *p = (struct __pyx_obj_4dnet___rand_xrange *)o;
  return o;
}

static void __pyx_tp_dealloc_4dnet___rand_xrange(PyObject *o) {
  struct __pyx_obj_4dnet___rand_xrange *p = (struct __pyx_obj_4dnet___rand_xrange *)o;
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_4dnet___rand_xrange(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_4dnet___rand_xrange *p = (struct __pyx_obj_4dnet___rand_xrange *)o;
  return 0;
}

static int __pyx_tp_clear_4dnet___rand_xrange(PyObject *o) {
  struct __pyx_obj_4dnet___rand_xrange *p = (struct __pyx_obj_4dnet___rand_xrange *)o;
  return 0;
}

static struct PyMethodDef __pyx_methods_4dnet___rand_xrange[] = {
  {0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number___rand_xrange = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
};

static PySequenceMethods __pyx_tp_as_sequence___rand_xrange = {
  __pyx_f_4dnet_13__rand_xrange___len__, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping___rand_xrange = {
  __pyx_f_4dnet_13__rand_xrange___len__, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer___rand_xrange = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

statichere PyTypeObject __pyx_type_4dnet___rand_xrange = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "dnet.__rand_xrange", /*tp_name*/
  sizeof(struct __pyx_obj_4dnet___rand_xrange), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_4dnet___rand_xrange, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number___rand_xrange, /*tp_as_number*/
  &__pyx_tp_as_sequence___rand_xrange, /*tp_as_sequence*/
  &__pyx_tp_as_mapping___rand_xrange, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer___rand_xrange, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE, /*tp_flags*/
  0, /*tp_doc*/
  __pyx_tp_traverse_4dnet___rand_xrange, /*tp_traverse*/
  __pyx_tp_clear_4dnet___rand_xrange, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  __pyx_f_4dnet_13__rand_xrange___iter__, /*tp_iter*/
  __pyx_f_4dnet_13__rand_xrange___next__, /*tp_iternext*/
  __pyx_methods_4dnet___rand_xrange, /*tp_methods*/
  0, /*tp_members*/
  0, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_4dnet_13__rand_xrange___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_4dnet___rand_xrange, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static PyObject *__pyx_tp_new_4dnet_tun(struct _typeobject *t, PyObject *a, PyObject *k) {
  PyObject *o = (*t->tp_alloc)(t, 0);
  struct __pyx_obj_4dnet_tun *p = (struct __pyx_obj_4dnet_tun *)o;
  return o;
}

static void __pyx_tp_dealloc_4dnet_tun(PyObject *o) {
  struct __pyx_obj_4dnet_tun *p = (struct __pyx_obj_4dnet_tun *)o;
  {
    PyObject *etype, *eval, *etb;
    PyErr_Fetch(&etype, &eval, &etb);
    ++o->ob_refcnt;
    __pyx_f_4dnet_3tun___dealloc__(o);
    if (PyErr_Occurred()) PyErr_WriteUnraisable(o);
    --o->ob_refcnt;
    PyErr_Restore(etype, eval, etb);
  }
  (*o->ob_type->tp_free)(o);
}

static int __pyx_tp_traverse_4dnet_tun(PyObject *o, visitproc v, void *a) {
  int e;
  struct __pyx_obj_4dnet_tun *p = (struct __pyx_obj_4dnet_tun *)o;
  return 0;
}

static int __pyx_tp_clear_4dnet_tun(PyObject *o) {
  struct __pyx_obj_4dnet_tun *p = (struct __pyx_obj_4dnet_tun *)o;
  return 0;
}

static PyObject *__pyx_getprop_4dnet_3tun_name(PyObject *o, void *x) {
  return __pyx_f_4dnet_3tun_4name___get__(o);
}

static PyObject *__pyx_getprop_4dnet_3tun_fd(PyObject *o, void *x) {
  return __pyx_f_4dnet_3tun_2fd___get__(o);
}

static struct PyMethodDef __pyx_methods_4dnet_tun[] = {
  {"fileno", (PyCFunction)__pyx_f_4dnet_3tun_fileno, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_3tun_fileno},
  {"send", (PyCFunction)__pyx_f_4dnet_3tun_send, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_3tun_send},
  {"recv", (PyCFunction)__pyx_f_4dnet_3tun_recv, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_3tun_recv},
  {"close", (PyCFunction)__pyx_f_4dnet_3tun_close, METH_VARARGS|METH_KEYWORDS, 0},
  {0, 0, 0, 0}
};

static struct PyGetSetDef __pyx_getsets_4dnet_tun[] = {
  {"name", __pyx_getprop_4dnet_3tun_name, 0, __pyx_k7, 0},
  {"fd", __pyx_getprop_4dnet_3tun_fd, 0, __pyx_k8, 0},
  {0, 0, 0, 0, 0}
};

static PyNumberMethods __pyx_tp_as_number_tun = {
  0, /*nb_add*/
  0, /*nb_subtract*/
  0, /*nb_multiply*/
  0, /*nb_divide*/
  0, /*nb_remainder*/
  0, /*nb_divmod*/
  0, /*nb_power*/
  0, /*nb_negative*/
  0, /*nb_positive*/
  0, /*nb_absolute*/
  0, /*nb_nonzero*/
  0, /*nb_invert*/
  0, /*nb_lshift*/
  0, /*nb_rshift*/
  0, /*nb_and*/
  0, /*nb_xor*/
  0, /*nb_or*/
  0, /*nb_coerce*/
  0, /*nb_int*/
  0, /*nb_long*/
  0, /*nb_float*/
  0, /*nb_oct*/
  0, /*nb_hex*/
  0, /*nb_inplace_add*/
  0, /*nb_inplace_subtract*/
  0, /*nb_inplace_multiply*/
  0, /*nb_inplace_divide*/
  0, /*nb_inplace_remainder*/
  0, /*nb_inplace_power*/
  0, /*nb_inplace_lshift*/
  0, /*nb_inplace_rshift*/
  0, /*nb_inplace_and*/
  0, /*nb_inplace_xor*/
  0, /*nb_inplace_or*/
  0, /*nb_floor_divide*/
  0, /*nb_true_divide*/
  0, /*nb_inplace_floor_divide*/
  0, /*nb_inplace_true_divide*/
};

static PySequenceMethods __pyx_tp_as_sequence_tun = {
  0, /*sq_length*/
  0, /*sq_concat*/
  0, /*sq_repeat*/
  0, /*sq_item*/
  0, /*sq_slice*/
  0, /*sq_ass_item*/
  0, /*sq_ass_slice*/
  0, /*sq_contains*/
  0, /*sq_inplace_concat*/
  0, /*sq_inplace_repeat*/
};

static PyMappingMethods __pyx_tp_as_mapping_tun = {
  0, /*mp_length*/
  0, /*mp_subscript*/
  0, /*mp_ass_subscript*/
};

static PyBufferProcs __pyx_tp_as_buffer_tun = {
  0, /*bf_getreadbuffer*/
  0, /*bf_getwritebuffer*/
  0, /*bf_getsegcount*/
  0, /*bf_getcharbuffer*/
};

statichere PyTypeObject __pyx_type_4dnet_tun = {
  PyObject_HEAD_INIT(0)
  0, /*ob_size*/
  "dnet.tun", /*tp_name*/
  sizeof(struct __pyx_obj_4dnet_tun), /*tp_basicsize*/
  0, /*tp_itemsize*/
  __pyx_tp_dealloc_4dnet_tun, /*tp_dealloc*/
  0, /*tp_print*/
  0, /*tp_getattr*/
  0, /*tp_setattr*/
  0, /*tp_compare*/
  0, /*tp_repr*/
  &__pyx_tp_as_number_tun, /*tp_as_number*/
  &__pyx_tp_as_sequence_tun, /*tp_as_sequence*/
  &__pyx_tp_as_mapping_tun, /*tp_as_mapping*/
  0, /*tp_hash*/
  0, /*tp_call*/
  0, /*tp_str*/
  0, /*tp_getattro*/
  0, /*tp_setattro*/
  &__pyx_tp_as_buffer_tun, /*tp_as_buffer*/
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_BASETYPE, /*tp_flags*/
  "tun(src, dst[, mtu]) -> Network tunnel interface handle\n    \n    Obtain a handle to a network tunnel interface, to which packets\n    destined for dst are delivered (with source addresses rewritten to\n    src), where they may be read by a userland process and processed\n    as desired. Packets written back to the handle are injected into\n    the kernel networking subsystem.\n    ", /*tp_doc*/
  __pyx_tp_traverse_4dnet_tun, /*tp_traverse*/
  __pyx_tp_clear_4dnet_tun, /*tp_clear*/
  0, /*tp_richcompare*/
  0, /*tp_weaklistoffset*/
  0, /*tp_iter*/
  0, /*tp_iternext*/
  __pyx_methods_4dnet_tun, /*tp_methods*/
  0, /*tp_members*/
  __pyx_getsets_4dnet_tun, /*tp_getset*/
  0, /*tp_base*/
  0, /*tp_dict*/
  0, /*tp_descr_get*/
  0, /*tp_descr_set*/
  0, /*tp_dictoffset*/
  __pyx_f_4dnet_3tun___init__, /*tp_init*/
  0, /*tp_alloc*/
  __pyx_tp_new_4dnet_tun, /*tp_new*/
  0, /*tp_free*/
  0, /*tp_is_gc*/
  0, /*tp_bases*/
  0, /*tp_mro*/
  0, /*tp_cache*/
  0, /*tp_subclasses*/
  0, /*tp_weaklist*/
};

static struct PyMethodDef __pyx_methods[] = {
  {"__iter_append", (PyCFunction)__pyx_f_4dnet___iter_append, METH_VARARGS|METH_KEYWORDS, 0},
  {"eth_ntoa", (PyCFunction)__pyx_f_4dnet_eth_ntoa, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_eth_ntoa},
  {"eth_aton", (PyCFunction)__pyx_f_4dnet_eth_aton, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_eth_aton},
  {"eth_pack_hdr", (PyCFunction)__pyx_f_4dnet_eth_pack_hdr, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_eth_pack_hdr},
  {"ip_ntoa", (PyCFunction)__pyx_f_4dnet_ip_ntoa, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_ip_ntoa},
  {"ip_aton", (PyCFunction)__pyx_f_4dnet_ip_aton, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_ip_aton},
  {"ip_checksum", (PyCFunction)__pyx_f_4dnet_ip_checksum, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_ip_checksum},
  {"ip_cksum_add", (PyCFunction)__pyx_f_4dnet_ip_cksum_add, METH_VARARGS|METH_KEYWORDS, 0},
  {"ip_cksum_carry", (PyCFunction)__pyx_f_4dnet_ip_cksum_carry, METH_VARARGS|METH_KEYWORDS, 0},
  {"ip_pack_hdr", (PyCFunction)__pyx_f_4dnet_ip_pack_hdr, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_ip_pack_hdr},
  {"ip6_ntoa", (PyCFunction)__pyx_f_4dnet_ip6_ntoa, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_ip6_ntoa},
  {"ip6_aton", (PyCFunction)__pyx_f_4dnet_ip6_aton, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_ip6_aton},
  {"ip6_checksum", (PyCFunction)__pyx_f_4dnet_ip6_checksum, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_ip6_checksum},
  {"ip6_pack_hdr", (PyCFunction)__pyx_f_4dnet_ip6_pack_hdr, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_ip6_pack_hdr},
  {"arp_pack_hdr_ethip", (PyCFunction)__pyx_f_4dnet_arp_pack_hdr_ethip, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_arp_pack_hdr_ethip},
  {"icmp_pack_hdr", (PyCFunction)__pyx_f_4dnet_icmp_pack_hdr, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_icmp_pack_hdr},
  {"tcp_pack_hdr", (PyCFunction)__pyx_f_4dnet_tcp_pack_hdr, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_tcp_pack_hdr},
  {"udp_pack_hdr", (PyCFunction)__pyx_f_4dnet_udp_pack_hdr, METH_VARARGS|METH_KEYWORDS, __pyx_doc_4dnet_udp_pack_hdr},
  {0, 0, 0, 0}
};

DL_EXPORT(void) initdnet(void); /*proto*/
DL_EXPORT(void) initdnet(void) {
  PyObject *__pyx_1 = 0;
  PyObject *__pyx_2 = 0;
  PyObject *__pyx_3 = 0;
  PyObject *__pyx_4 = 0;
  PyObject *__pyx_5 = 0;
  PyObject *__pyx_6 = 0;
  PyObject *__pyx_7 = 0;
  PyObject *__pyx_8 = 0;
  PyObject *__pyx_9 = 0;
  PyObject *__pyx_10 = 0;
  PyObject *__pyx_11 = 0;
  PyObject *__pyx_12 = 0;
  PyObject *__pyx_13 = 0;
  PyObject *__pyx_14 = 0;
  PyObject *__pyx_15 = 0;
  PyObject *__pyx_16 = 0;
  PyObject *__pyx_17 = 0;
  PyObject *__pyx_18 = 0;
  PyObject *__pyx_19 = 0;
  PyObject *__pyx_20 = 0;
  PyObject *__pyx_21 = 0;
  PyObject *__pyx_22 = 0;
  PyObject *__pyx_23 = 0;
  PyObject *__pyx_24 = 0;
  PyObject *__pyx_25 = 0;
  PyObject *__pyx_26 = 0;
  PyObject *__pyx_27 = 0;
  PyObject *__pyx_28 = 0;
  PyObject *__pyx_29 = 0;
  PyObject *__pyx_30 = 0;
  PyObject *__pyx_31 = 0;
  __pyx_m = Py_InitModule4("dnet", __pyx_methods, __pyx_mdoc, 0, PYTHON_API_VERSION);
  __pyx_b = PyImport_AddModule("__builtin__");
  PyObject_SetAttrString(__pyx_m, "__builtins__", __pyx_b);
  if (PyType_Ready(&__pyx_type_4dnet_eth) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 102; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "eth", (PyObject *)&__pyx_type_4dnet_eth) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 102; goto __pyx_L1;}
  __pyx_ptype_4dnet_eth = &__pyx_type_4dnet_eth;
  if (PyType_Ready(&__pyx_type_4dnet_ip) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 240; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ip", (PyObject *)&__pyx_type_4dnet_ip) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 240; goto __pyx_L1;}
  __pyx_ptype_4dnet_ip = &__pyx_type_4dnet_ip;
  if (PyType_Ready(&__pyx_type_4dnet_addr) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 436; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "addr", (PyObject *)&__pyx_type_4dnet_addr) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 436; goto __pyx_L1;}
  __pyx_ptype_4dnet_addr = &__pyx_type_4dnet_addr;
  if (PyType_Ready(&__pyx_type_4dnet___addr_ip4_iter) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 618; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "__addr_ip4_iter", (PyObject *)&__pyx_type_4dnet___addr_ip4_iter) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 618; goto __pyx_L1;}
  __pyx_ptype_4dnet___addr_ip4_iter = &__pyx_type_4dnet___addr_ip4_iter;
  if (PyType_Ready(&__pyx_type_4dnet_arp) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 683; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "arp", (PyObject *)&__pyx_type_4dnet_arp) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 683; goto __pyx_L1;}
  __pyx_ptype_4dnet_arp = &__pyx_type_4dnet_arp;
  if (PyType_Ready(&__pyx_type_4dnet_intf) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 963; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "intf", (PyObject *)&__pyx_type_4dnet_intf) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 963; goto __pyx_L1;}
  __pyx_ptype_4dnet_intf = &__pyx_type_4dnet_intf;
  if (PyType_Ready(&__pyx_type_4dnet_route) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1082; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "route", (PyObject *)&__pyx_type_4dnet_route) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1082; goto __pyx_L1;}
  __pyx_ptype_4dnet_route = &__pyx_type_4dnet_route;
  if (PyType_Ready(&__pyx_type_4dnet_fw) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1228; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "fw", (PyObject *)&__pyx_type_4dnet_fw) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1228; goto __pyx_L1;}
  __pyx_ptype_4dnet_fw = &__pyx_type_4dnet_fw;
  if (PyType_Ready(&__pyx_type_4dnet_rand) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1305; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "rand", (PyObject *)&__pyx_type_4dnet_rand) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1305; goto __pyx_L1;}
  __pyx_ptype_4dnet_rand = &__pyx_type_4dnet_rand;
  if (PyType_Ready(&__pyx_type_4dnet___rand_xrange) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1387; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "__rand_xrange", (PyObject *)&__pyx_type_4dnet___rand_xrange) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1387; goto __pyx_L1;}
  __pyx_ptype_4dnet___rand_xrange = &__pyx_type_4dnet___rand_xrange;
  if (PyType_Ready(&__pyx_type_4dnet_tun) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1471; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "tun", (PyObject *)&__pyx_type_4dnet_tun) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1471; goto __pyx_L1;}
  __pyx_ptype_4dnet_tun = &__pyx_type_4dnet_tun;

  /* "/misc/projects/libdnet/python/./dnet.pyx":15 */
  __pyx_1 = PyString_FromString(__pyx_k9); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 15; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "__author__", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 15; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":16 */
  __pyx_1 = PyString_FromString(__pyx_k10); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 16; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "__copyright__", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 16; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":17 */
  __pyx_1 = PyString_FromString(__pyx_k11); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "__license__", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 17; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":18 */
  __pyx_1 = PyString_FromString(__pyx_k12); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 18; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "__url__", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 18; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":19 */
  __pyx_1 = PyString_FromString(__pyx_k13); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 19; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "__version__", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 19; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":75 */
  __pyx_1 = PyInt_FromLong(6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 75; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_ADDR_LEN", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 75; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":76 */
  __pyx_1 = PyInt_FromLong(48); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 76; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_ADDR_BITS", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 76; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":77 */
  __pyx_1 = PyInt_FromLong(2); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 77; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_TYPE_LEN", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 77; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":78 */
  __pyx_1 = PyInt_FromLong(4); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_CRC_LEN", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 78; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":79 */
  __pyx_1 = PyInt_FromLong(14); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 79; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_HDR_LEN", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 79; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":81 */
  __pyx_1 = PyInt_FromLong(64); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 81; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_LEN_MIN", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 81; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":82 */
  __pyx_1 = PyInt_FromLong(1518); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 82; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_LEN_MAX", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 82; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":84 */
  __pyx_1 = __Pyx_GetName(__pyx_m, "ETH_LEN_MAX"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 84; goto __pyx_L1;}
  __pyx_2 = __Pyx_GetName(__pyx_m, "ETH_HDR_LEN"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 84; goto __pyx_L1;}
  __pyx_3 = PyNumber_Subtract(__pyx_1, __pyx_2); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 84; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  __pyx_1 = __Pyx_GetName(__pyx_m, "ETH_CRC_LEN"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 84; goto __pyx_L1;}
  __pyx_2 = PyNumber_Subtract(__pyx_3, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 84; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  if (PyObject_SetAttrString(__pyx_m, "ETH_MTU", __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 84; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":85 */
  __pyx_3 = __Pyx_GetName(__pyx_m, "ETH_LEN_MIN"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 85; goto __pyx_L1;}
  __pyx_1 = __Pyx_GetName(__pyx_m, "ETH_HDR_LEN"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 85; goto __pyx_L1;}
  __pyx_2 = PyNumber_Subtract(__pyx_3, __pyx_1); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 85; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  Py_DECREF(__pyx_1); __pyx_1 = 0;
  __pyx_3 = __Pyx_GetName(__pyx_m, "ETH_CRC_LEN"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 85; goto __pyx_L1;}
  __pyx_1 = PyNumber_Subtract(__pyx_2, __pyx_3); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 85; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;
  Py_DECREF(__pyx_3); __pyx_3 = 0;
  if (PyObject_SetAttrString(__pyx_m, "ETH_MIN", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 85; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":87 */
  __pyx_2 = PyInt_FromLong(512); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 87; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_TYPE_PUP", __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 87; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":88 */
  __pyx_3 = PyInt_FromLong(2048); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 88; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_TYPE_IP", __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 88; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":89 */
  __pyx_1 = PyInt_FromLong(2054); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 89; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_TYPE_ARP", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 89; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":90 */
  __pyx_2 = PyInt_FromLong(32821); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 90; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_TYPE_REVARP", __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 90; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":91 */
  __pyx_3 = PyInt_FromLong(33024); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 91; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_TYPE_8021Q", __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 91; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":92 */
  __pyx_1 = PyInt_FromLong(34525); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 92; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_TYPE_IPV6", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 92; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":93 */
  __pyx_2 = PyInt_FromLong(34887); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 93; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_TYPE_MPLS", __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 93; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":94 */
  __pyx_3 = PyInt_FromLong(34888); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 94; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_TYPE_MPLS_MCAST", __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 94; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":95 */
  __pyx_1 = PyInt_FromLong(34915); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 95; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_TYPE_PPPOEDISC", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 95; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":96 */
  __pyx_2 = PyInt_FromLong(34916); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 96; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_TYPE_PPPOE", __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 96; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":97 */
  __pyx_3 = PyInt_FromLong(36864); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 97; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_TYPE_LOOPBACK", __pyx_3) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 97; goto __pyx_L1;}
  Py_DECREF(__pyx_3); __pyx_3 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":99 */
  __pyx_1 = PyString_FromStringAndSize(__pyx_k14,6); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 99; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_ADDR_UNSPEC", __pyx_1) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 99; goto __pyx_L1;}
  Py_DECREF(__pyx_1); __pyx_1 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":100 */
  __pyx_2 = PyString_FromStringAndSize(__pyx_k15,6); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 100; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ETH_ADDR_BROADCAST", __pyx_2) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 100; goto __pyx_L1;}
  Py_DECREF(__pyx_2); __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":162 */
  __pyx_3 = __Pyx_GetName(__pyx_m, "ETH_ADDR_BROADCAST"); if (!__pyx_3) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L1;}
  __pyx_k16 = __pyx_3;
  __pyx_3 = 0;
  __pyx_1 = __Pyx_GetName(__pyx_m, "ETH_ADDR_BROADCAST"); if (!__pyx_1) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 162; goto __pyx_L1;}
  __pyx_k17 = __pyx_1;
  __pyx_1 = 0;
  __pyx_2 = __Pyx_GetName(__pyx_m, "ETH_TYPE_IP"); if (!__pyx_2) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 163; goto __pyx_L1;}
  __pyx_k18 = __pyx_2;
  __pyx_2 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":199 */
  __pyx_4 = PyInt_FromLong(4); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 199; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_ADDR_LEN", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 199; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":200 */
  __pyx_4 = PyInt_FromLong(32); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 200; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_ADDR_BITS", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 200; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":202 */
  __pyx_4 = PyInt_FromLong(20); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 202; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_HDR_LEN", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 202; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":203 */
  __pyx_4 = PyInt_FromLong(2); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 203; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_OPT_LEN", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 203; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":204 */
  __pyx_4 = PyInt_FromLong(40); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 204; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_OPT_LEN_MAX", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 204; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":205 */
  __pyx_4 = __Pyx_GetName(__pyx_m, "IP_HDR_LEN"); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 205; goto __pyx_L1;}
  __pyx_5 = __Pyx_GetName(__pyx_m, "IP_OPT_LEN_MAX"); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 205; goto __pyx_L1;}
  __pyx_6 = PyNumber_Add(__pyx_4, __pyx_5); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 205; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;
  Py_DECREF(__pyx_5); __pyx_5 = 0;
  if (PyObject_SetAttrString(__pyx_m, "IP_HDR_LEN_MAX", __pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 205; goto __pyx_L1;}
  Py_DECREF(__pyx_6); __pyx_6 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":207 */
  __pyx_4 = PyInt_FromLong(65535); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 207; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_LEN_MAX", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 207; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":208 */
  __pyx_5 = __Pyx_GetName(__pyx_m, "IP_HDR_LEN"); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 208; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_LEN_MIN", __pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 208; goto __pyx_L1;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":210 */
  __pyx_6 = PyInt_FromLong(0); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 210; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_TOS_DEFAULT", __pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 210; goto __pyx_L1;}
  Py_DECREF(__pyx_6); __pyx_6 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":212 */
  __pyx_4 = PyInt_FromLong(32768); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 212; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_RF", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 212; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":213 */
  __pyx_5 = PyInt_FromLong(16384); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 213; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_DF", __pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 213; goto __pyx_L1;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":214 */
  __pyx_6 = PyInt_FromLong(8192); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 214; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_MF", __pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 214; goto __pyx_L1;}
  Py_DECREF(__pyx_6); __pyx_6 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":215 */
  __pyx_4 = PyInt_FromLong(8191); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 215; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_OFFMASK", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 215; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":217 */
  __pyx_5 = PyInt_FromLong(64); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 217; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_TTL_DEFAULT", __pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 217; goto __pyx_L1;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":218 */
  __pyx_6 = PyInt_FromLong(255); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 218; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_TTL_MAX", __pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 218; goto __pyx_L1;}
  Py_DECREF(__pyx_6); __pyx_6 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":220 */
  __pyx_4 = PyInt_FromLong(0); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 220; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_PROTO_IP", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 220; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":221 */
  __pyx_5 = PyInt_FromLong(1); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 221; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_PROTO_ICMP", __pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 221; goto __pyx_L1;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":222 */
  __pyx_6 = PyInt_FromLong(2); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 222; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_PROTO_IGMP", __pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 222; goto __pyx_L1;}
  Py_DECREF(__pyx_6); __pyx_6 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":223 */
  __pyx_4 = PyInt_FromLong(6); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 223; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_PROTO_TCP", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 223; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":224 */
  __pyx_5 = PyInt_FromLong(17); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 224; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_PROTO_UDP", __pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 224; goto __pyx_L1;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":225 */
  __pyx_6 = PyInt_FromLong(41); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 225; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_PROTO_IPV6", __pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 225; goto __pyx_L1;}
  Py_DECREF(__pyx_6); __pyx_6 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":226 */
  __pyx_4 = PyInt_FromLong(47); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 226; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_PROTO_GRE", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 226; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":227 */
  __pyx_5 = PyInt_FromLong(50); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 227; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_PROTO_ESP", __pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 227; goto __pyx_L1;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":228 */
  __pyx_6 = PyInt_FromLong(51); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 228; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_PROTO_AH", __pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 228; goto __pyx_L1;}
  Py_DECREF(__pyx_6); __pyx_6 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":229 */
  __pyx_4 = PyInt_FromLong(58); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 229; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_PROTO_ICMPV6", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 229; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":230 */
  __pyx_5 = PyInt_FromLong(255); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 230; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_PROTO_RAW", __pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 230; goto __pyx_L1;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":231 */
  __pyx_6 = __Pyx_GetName(__pyx_m, "IP_PROTO_RAW"); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 231; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_PROTO_RESERVED", __pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 231; goto __pyx_L1;}
  Py_DECREF(__pyx_6); __pyx_6 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":232 */
  __pyx_4 = PyInt_FromLong(255); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 232; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_PROTO_MAX", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 232; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":234 */
  __pyx_5 = PyString_FromStringAndSize(__pyx_k19,4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 234; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_ADDR_ANY", __pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 234; goto __pyx_L1;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":235 */
  __pyx_6 = PyString_FromStringAndSize(__pyx_k20,4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 235; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_ADDR_BROADCAST", __pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 235; goto __pyx_L1;}
  Py_DECREF(__pyx_6); __pyx_6 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":236 */
  __pyx_4 = PyString_FromStringAndSize(__pyx_k21,4); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 236; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_ADDR_LOOPBACK", __pyx_4) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 236; goto __pyx_L1;}
  Py_DECREF(__pyx_4); __pyx_4 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":237 */
  __pyx_5 = PyString_FromStringAndSize(__pyx_k22,4); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 237; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_ADDR_MCAST_ALL", __pyx_5) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 237; goto __pyx_L1;}
  Py_DECREF(__pyx_5); __pyx_5 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":238 */
  __pyx_6 = PyString_FromStringAndSize(__pyx_k23,4); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 238; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP_ADDR_MCAST_LOCAL", __pyx_6) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 238; goto __pyx_L1;}
  Py_DECREF(__pyx_6); __pyx_6 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":320 */
  __pyx_4 = __Pyx_GetName(__pyx_m, "IP_TOS_DEFAULT"); if (!__pyx_4) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 320; goto __pyx_L1;}
  __pyx_k24 = __pyx_4;
  __pyx_4 = 0;
  __pyx_5 = __Pyx_GetName(__pyx_m, "IP_HDR_LEN"); if (!__pyx_5) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 320; goto __pyx_L1;}
  __pyx_k25 = __pyx_5;
  __pyx_5 = 0;
  __pyx_6 = PyInt_FromLong(0); if (!__pyx_6) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 320; goto __pyx_L1;}
  __pyx_k26 = __pyx_6;
  __pyx_6 = 0;
  __pyx_7 = PyInt_FromLong(0); if (!__pyx_7) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 320; goto __pyx_L1;}
  __pyx_k27 = __pyx_7;
  __pyx_7 = 0;
  __pyx_8 = __Pyx_GetName(__pyx_m, "IP_TTL_DEFAULT"); if (!__pyx_8) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 321; goto __pyx_L1;}
  __pyx_k28 = __pyx_8;
  __pyx_8 = 0;
  __pyx_9 = __Pyx_GetName(__pyx_m, "IP_PROTO_IP"); if (!__pyx_9) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 321; goto __pyx_L1;}
  __pyx_k29 = __pyx_9;
  __pyx_9 = 0;
  __pyx_10 = __Pyx_GetName(__pyx_m, "IP_ADDR_ANY"); if (!__pyx_10) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 322; goto __pyx_L1;}
  __pyx_k30 = __pyx_10;
  __pyx_10 = 0;
  __pyx_11 = __Pyx_GetName(__pyx_m, "IP_ADDR_ANY"); if (!__pyx_11) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 322; goto __pyx_L1;}
  __pyx_k31 = __pyx_11;
  __pyx_11 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":355 */
  __pyx_12 = PyInt_FromLong(16); if (!__pyx_12) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 355; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP6_ADDR_LEN", __pyx_12) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 355; goto __pyx_L1;}
  Py_DECREF(__pyx_12); __pyx_12 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":356 */
  __pyx_12 = PyInt_FromLong(128); if (!__pyx_12) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 356; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP6_ADDR_BITS", __pyx_12) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 356; goto __pyx_L1;}
  Py_DECREF(__pyx_12); __pyx_12 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":358 */
  __pyx_12 = PyInt_FromLong(40); if (!__pyx_12) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 358; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP6_HDR_LEN", __pyx_12) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 358; goto __pyx_L1;}
  Py_DECREF(__pyx_12); __pyx_12 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":359 */
  __pyx_12 = __Pyx_GetName(__pyx_m, "IP6_HDR_LEN"); if (!__pyx_12) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 359; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP6_LEN_MIN", __pyx_12) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 359; goto __pyx_L1;}
  Py_DECREF(__pyx_12); __pyx_12 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":360 */
  __pyx_12 = PyInt_FromLong(65535); if (!__pyx_12) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 360; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP6_LEN_MAX", __pyx_12) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 360; goto __pyx_L1;}
  Py_DECREF(__pyx_12); __pyx_12 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":362 */
  __pyx_12 = PyInt_FromLong(1280); if (!__pyx_12) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 362; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP6_MTU_MIN", __pyx_12) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 362; goto __pyx_L1;}
  Py_DECREF(__pyx_12); __pyx_12 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":364 */
  __pyx_12 = PyInt_FromLong(64); if (!__pyx_12) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 364; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP6_HLIM_DEFAULT", __pyx_12) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 364; goto __pyx_L1;}
  Py_DECREF(__pyx_12); __pyx_12 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":365 */
  __pyx_12 = PyInt_FromLong(255); if (!__pyx_12) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 365; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP6_HLIM_MAX", __pyx_12) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 365; goto __pyx_L1;}
  Py_DECREF(__pyx_12); __pyx_12 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":367 */
  __pyx_12 = PyString_FromStringAndSize(__pyx_k32,16); if (!__pyx_12) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 367; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP6_ADDR_UNSPEC", __pyx_12) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 367; goto __pyx_L1;}
  Py_DECREF(__pyx_12); __pyx_12 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":368 */
  __pyx_12 = PyString_FromStringAndSize(__pyx_k33,16); if (!__pyx_12) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 368; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "IP6_ADDR_LOOPBACK", __pyx_12) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 368; goto __pyx_L1;}
  Py_DECREF(__pyx_12); __pyx_12 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":395 */
  __pyx_12 = PyInt_FromLong(0); if (!__pyx_12) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 395; goto __pyx_L1;}
  __pyx_k34 = __pyx_12;
  __pyx_12 = 0;
  __pyx_13 = PyInt_FromLong(0); if (!__pyx_13) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 395; goto __pyx_L1;}
  __pyx_k35 = __pyx_13;
  __pyx_13 = 0;
  __pyx_14 = PyInt_FromLong(0); if (!__pyx_14) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 395; goto __pyx_L1;}
  __pyx_k36 = __pyx_14;
  __pyx_14 = 0;
  __pyx_15 = __Pyx_GetName(__pyx_m, "IP_PROTO_IPV6"); if (!__pyx_15) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 395; goto __pyx_L1;}
  __pyx_k37 = __pyx_15;
  __pyx_15 = 0;
  __pyx_16 = __Pyx_GetName(__pyx_m, "IP6_HLIM_DEFAULT"); if (!__pyx_16) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 395; goto __pyx_L1;}
  __pyx_k38 = __pyx_16;
  __pyx_16 = 0;
  __pyx_17 = __Pyx_GetName(__pyx_m, "IP6_ADDR_UNSPEC"); if (!__pyx_17) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 396; goto __pyx_L1;}
  __pyx_k39 = __pyx_17;
  __pyx_17 = 0;
  __pyx_18 = __Pyx_GetName(__pyx_m, "IP6_ADDR_UNSPEC"); if (!__pyx_18) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 396; goto __pyx_L1;}
  __pyx_k40 = __pyx_18;
  __pyx_18 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":431 */
  __pyx_19 = PyInt_FromLong(0); if (!__pyx_19) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 431; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ADDR_TYPE_NONE", __pyx_19) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 431; goto __pyx_L1;}
  Py_DECREF(__pyx_19); __pyx_19 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":432 */
  __pyx_19 = PyInt_FromLong(1); if (!__pyx_19) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 432; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ADDR_TYPE_ETH", __pyx_19) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 432; goto __pyx_L1;}
  Py_DECREF(__pyx_19); __pyx_19 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":433 */
  __pyx_19 = PyInt_FromLong(2); if (!__pyx_19) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 433; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ADDR_TYPE_IP", __pyx_19) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 433; goto __pyx_L1;}
  Py_DECREF(__pyx_19); __pyx_19 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":434 */
  __pyx_19 = PyInt_FromLong(3); if (!__pyx_19) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 434; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ADDR_TYPE_IP6", __pyx_19) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 434; goto __pyx_L1;}
  Py_DECREF(__pyx_19); __pyx_19 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":444 */
  Py_INCREF(Py_None);
  __pyx_k41 = Py_None;
  __pyx_19 = __Pyx_GetName(__pyx_m, "ADDR_TYPE_NONE"); if (!__pyx_19) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 444; goto __pyx_L1;}
  __pyx_k42 = __pyx_19;
  __pyx_19 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":660 */
  __pyx_20 = PyInt_FromLong(8); if (!__pyx_20) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 660; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ARP_HDR_LEN", __pyx_20) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 660; goto __pyx_L1;}
  Py_DECREF(__pyx_20); __pyx_20 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":661 */
  __pyx_20 = PyInt_FromLong(20); if (!__pyx_20) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 661; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ARP_ETHIP_LEN", __pyx_20) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 661; goto __pyx_L1;}
  Py_DECREF(__pyx_20); __pyx_20 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":663 */
  __pyx_20 = PyInt_FromLong(1); if (!__pyx_20) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 663; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ARP_HRD_ETH", __pyx_20) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 663; goto __pyx_L1;}
  Py_DECREF(__pyx_20); __pyx_20 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":664 */
  __pyx_20 = PyInt_FromLong(6); if (!__pyx_20) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 664; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ARP_HRD_IEEE802", __pyx_20) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 664; goto __pyx_L1;}
  Py_DECREF(__pyx_20); __pyx_20 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":666 */
  __pyx_20 = PyInt_FromLong(2048); if (!__pyx_20) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 666; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ARP_PRO_IP", __pyx_20) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 666; goto __pyx_L1;}
  Py_DECREF(__pyx_20); __pyx_20 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":668 */
  __pyx_20 = PyInt_FromLong(1); if (!__pyx_20) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 668; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ARP_OP_REQUEST", __pyx_20) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 668; goto __pyx_L1;}
  Py_DECREF(__pyx_20); __pyx_20 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":669 */
  __pyx_20 = PyInt_FromLong(2); if (!__pyx_20) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 669; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ARP_OP_REPLY", __pyx_20) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 669; goto __pyx_L1;}
  Py_DECREF(__pyx_20); __pyx_20 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":670 */
  __pyx_20 = PyInt_FromLong(3); if (!__pyx_20) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 670; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ARP_OP_REVREQUEST", __pyx_20) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 670; goto __pyx_L1;}
  Py_DECREF(__pyx_20); __pyx_20 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":671 */
  __pyx_20 = PyInt_FromLong(4); if (!__pyx_20) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 671; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "ARP_OP_REVREPLY", __pyx_20) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 671; goto __pyx_L1;}
  Py_DECREF(__pyx_20); __pyx_20 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":732 */
  Py_INCREF(Py_None);
  __pyx_k43 = Py_None;

  /* "/misc/projects/libdnet/python/./dnet.pyx":754 */
  __pyx_20 = __Pyx_GetName(__pyx_m, "ARP_OP_REQUEST"); if (!__pyx_20) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 754; goto __pyx_L1;}
  __pyx_k44 = __pyx_20;
  __pyx_20 = 0;
  __pyx_21 = __Pyx_GetName(__pyx_m, "ETH_ADDR_UNSPEC"); if (!__pyx_21) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 755; goto __pyx_L1;}
  __pyx_k45 = __pyx_21;
  __pyx_21 = 0;
  __pyx_22 = __Pyx_GetName(__pyx_m, "IP_ADDR_ANY"); if (!__pyx_22) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 755; goto __pyx_L1;}
  __pyx_k46 = __pyx_22;
  __pyx_22 = 0;
  __pyx_23 = __Pyx_GetName(__pyx_m, "ETH_ADDR_UNSPEC"); if (!__pyx_23) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 756; goto __pyx_L1;}
  __pyx_k47 = __pyx_23;
  __pyx_23 = 0;
  __pyx_24 = __Pyx_GetName(__pyx_m, "IP_ADDR_ANY"); if (!__pyx_24) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 756; goto __pyx_L1;}
  __pyx_k48 = __pyx_24;
  __pyx_24 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":800 */
  __pyx_25 = PyInt_FromLong(20); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_HDR_LEN", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 800; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":802 */
  __pyx_25 = PyInt_FromLong(1); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 802; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TH_FIN", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 802; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":803 */
  __pyx_25 = PyInt_FromLong(2); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 803; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TH_SYN", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 803; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":804 */
  __pyx_25 = PyInt_FromLong(4); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 804; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TH_RST", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 804; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":805 */
  __pyx_25 = PyInt_FromLong(8); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 805; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TH_PUSH", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 805; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":806 */
  __pyx_25 = PyInt_FromLong(16); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 806; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TH_ACK", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 806; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":807 */
  __pyx_25 = PyInt_FromLong(32); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 807; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TH_URG", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 807; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":808 */
  __pyx_25 = PyInt_FromLong(64); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 808; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TH_ECE", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 808; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":809 */
  __pyx_25 = PyInt_FromLong(128); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 809; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TH_CWR", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 809; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":811 */
  __pyx_25 = PyInt_FromLong(65535); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 811; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_PORT_MAX", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 811; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":812 */
  __pyx_25 = PyInt_FromLong(65535); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 812; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_WIN_MAX", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 812; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":814 */
  __pyx_25 = PyInt_FromLong(0); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 814; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_EOL", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 814; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":815 */
  __pyx_25 = PyInt_FromLong(1); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 815; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_NOP", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 815; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":816 */
  __pyx_25 = PyInt_FromLong(2); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 816; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_MSS", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 816; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":817 */
  __pyx_25 = PyInt_FromLong(3); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 817; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_WSCALE", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 817; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":818 */
  __pyx_25 = PyInt_FromLong(4); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 818; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_SACKOK", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 818; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":819 */
  __pyx_25 = PyInt_FromLong(5); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 819; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_SACK", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 819; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":820 */
  __pyx_25 = PyInt_FromLong(6); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 820; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_ECHO", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 820; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":821 */
  __pyx_25 = PyInt_FromLong(7); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 821; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_ECHOREPLY", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 821; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":822 */
  __pyx_25 = PyInt_FromLong(8); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 822; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_TIMESTAMP", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 822; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":823 */
  __pyx_25 = PyInt_FromLong(9); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 823; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_POCONN", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 823; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":824 */
  __pyx_25 = PyInt_FromLong(10); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 824; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_POSVC", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 824; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":825 */
  __pyx_25 = PyInt_FromLong(11); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 825; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_CC", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 825; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":826 */
  __pyx_25 = PyInt_FromLong(12); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 826; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_CCNEW", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 826; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":827 */
  __pyx_25 = PyInt_FromLong(13); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 827; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_CCECHO", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 827; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":828 */
  __pyx_25 = PyInt_FromLong(14); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 828; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_ALTSUM", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 828; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":829 */
  __pyx_25 = PyInt_FromLong(15); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 829; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_ALTSUMDATA", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 829; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":830 */
  __pyx_25 = PyInt_FromLong(16); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 830; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_SKEETER", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 830; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":831 */
  __pyx_25 = PyInt_FromLong(17); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 831; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_BUBBA", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 831; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":832 */
  __pyx_25 = PyInt_FromLong(18); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 832; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_TRAILSUM", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 832; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":833 */
  __pyx_25 = PyInt_FromLong(19); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 833; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_MD5", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 833; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":834 */
  __pyx_25 = PyInt_FromLong(20); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 834; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_SCPS", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 834; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":835 */
  __pyx_25 = PyInt_FromLong(21); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 835; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_SNACK", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 835; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":836 */
  __pyx_25 = PyInt_FromLong(22); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 836; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_REC", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 836; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":837 */
  __pyx_25 = PyInt_FromLong(23); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 837; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_CORRUPT", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 837; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":838 */
  __pyx_25 = PyInt_FromLong(24); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 838; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_SNAP", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 838; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":839 */
  __pyx_25 = PyInt_FromLong(26); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 839; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_TCPCOMP", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 839; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":840 */
  __pyx_25 = PyInt_FromLong(27); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 840; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "TCP_OPT_MAX", __pyx_25) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 840; goto __pyx_L1;}
  Py_DECREF(__pyx_25); __pyx_25 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":842 */
  __pyx_25 = PyInt_FromLong(1); if (!__pyx_25) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 842; goto __pyx_L1;}
  __pyx_k49 = __pyx_25;
  __pyx_25 = 0;
  __pyx_26 = PyInt_FromLong(0); if (!__pyx_26) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 842; goto __pyx_L1;}
  __pyx_k50 = __pyx_26;
  __pyx_26 = 0;
  __pyx_27 = __Pyx_GetName(__pyx_m, "TH_SYN"); if (!__pyx_27) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 842; goto __pyx_L1;}
  __pyx_k51 = __pyx_27;
  __pyx_27 = 0;
  __pyx_28 = __Pyx_GetName(__pyx_m, "TCP_WIN_MAX"); if (!__pyx_28) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 843; goto __pyx_L1;}
  __pyx_k52 = __pyx_28;
  __pyx_28 = 0;
  __pyx_29 = PyInt_FromLong(0); if (!__pyx_29) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 843; goto __pyx_L1;}
  __pyx_k53 = __pyx_29;
  __pyx_29 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":865 */
  __pyx_30 = PyInt_FromLong(8); if (!__pyx_30) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 865; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "UDP_HDR_LEN", __pyx_30) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 865; goto __pyx_L1;}
  Py_DECREF(__pyx_30); __pyx_30 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":866 */
  __pyx_30 = PyInt_FromLong(65535); if (!__pyx_30) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 866; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "UDP_PORT_MAX", __pyx_30) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 866; goto __pyx_L1;}
  Py_DECREF(__pyx_30); __pyx_30 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":868 */
  __pyx_30 = __Pyx_GetName(__pyx_m, "UDP_HDR_LEN"); if (!__pyx_30) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 868; goto __pyx_L1;}
  __pyx_k54 = __pyx_30;
  __pyx_30 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":907 */
  __pyx_31 = PyInt_FromLong(1); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 907; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "INTF_TYPE_OTHER", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 907; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":908 */
  __pyx_31 = PyInt_FromLong(6); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 908; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "INTF_TYPE_ETH", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 908; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":909 */
  __pyx_31 = PyInt_FromLong(24); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 909; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "INTF_TYPE_LOOPBACK", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 909; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":910 */
  __pyx_31 = PyInt_FromLong(53); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 910; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "INTF_TYPE_TUN", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 910; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":912 */
  __pyx_31 = PyInt_FromLong(1); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 912; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "INTF_FLAG_UP", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 912; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":913 */
  __pyx_31 = PyInt_FromLong(2); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 913; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "INTF_FLAG_LOOPBACK", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 913; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":914 */
  __pyx_31 = PyInt_FromLong(4); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 914; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "INTF_FLAG_POINTOPOINT", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 914; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":915 */
  __pyx_31 = PyInt_FromLong(8); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 915; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "INTF_FLAG_NOARP", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 915; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":916 */
  __pyx_31 = PyInt_FromLong(16); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 916; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "INTF_FLAG_BROADCAST", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 916; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":917 */
  __pyx_31 = PyInt_FromLong(32); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 917; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "INTF_FLAG_MULTICAST", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 917; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1032 */
  Py_INCREF(Py_None);
  __pyx_k55 = Py_None;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1131 */
  Py_INCREF(Py_None);
  __pyx_k56 = Py_None;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1177 */
  __pyx_31 = PyInt_FromLong(1); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1177; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "FW_OP_ALLOW", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1177; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1178 */
  __pyx_31 = PyInt_FromLong(2); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1178; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "FW_OP_BLOCK", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1178; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1180 */
  __pyx_31 = PyInt_FromLong(1); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1180; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "FW_DIR_IN", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1180; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1181 */
  __pyx_31 = PyInt_FromLong(2); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1181; goto __pyx_L1;}
  if (PyObject_SetAttrString(__pyx_m, "FW_DIR_OUT", __pyx_31) < 0) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1181; goto __pyx_L1;}
  Py_DECREF(__pyx_31); __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1267 */
  Py_INCREF(Py_None);
  __pyx_k57 = Py_None;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1365 */
  Py_INCREF(Py_None);
  __pyx_k58 = Py_None;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1484 */
  __pyx_31 = PyInt_FromLong(1500); if (!__pyx_31) {__pyx_filename = __pyx_f[0]; __pyx_lineno = 1484; goto __pyx_L1;}
  __pyx_k59 = __pyx_31;
  __pyx_31 = 0;

  /* "/misc/projects/libdnet/python/./dnet.pyx":1525 */
  return;
  __pyx_L1:;
  Py_XDECREF(__pyx_1);
  Py_XDECREF(__pyx_2);
  Py_XDECREF(__pyx_3);
  Py_XDECREF(__pyx_4);
  Py_XDECREF(__pyx_5);
  Py_XDECREF(__pyx_6);
  Py_XDECREF(__pyx_7);
  Py_XDECREF(__pyx_8);
  Py_XDECREF(__pyx_9);
  Py_XDECREF(__pyx_10);
  Py_XDECREF(__pyx_11);
  Py_XDECREF(__pyx_12);
  Py_XDECREF(__pyx_13);
  Py_XDECREF(__pyx_14);
  Py_XDECREF(__pyx_15);
  Py_XDECREF(__pyx_16);
  Py_XDECREF(__pyx_17);
  Py_XDECREF(__pyx_18);
  Py_XDECREF(__pyx_19);
  Py_XDECREF(__pyx_20);
  Py_XDECREF(__pyx_21);
  Py_XDECREF(__pyx_22);
  Py_XDECREF(__pyx_23);
  Py_XDECREF(__pyx_24);
  Py_XDECREF(__pyx_25);
  Py_XDECREF(__pyx_26);
  Py_XDECREF(__pyx_27);
  Py_XDECREF(__pyx_28);
  Py_XDECREF(__pyx_29);
  Py_XDECREF(__pyx_30);
  Py_XDECREF(__pyx_31);
  __Pyx_AddTraceback("dnet");
}

static char *__pyx_filenames[] = {
  "/misc/projects/libdnet/python/./dnet.pyx",
};
statichere char **__pyx_f = __pyx_filenames;

/* Runtime support code */

static int __Pyx_ArgTypeTest(PyObject *obj, PyTypeObject *type, int none_allowed, char *name) {
	if (!type) {
		PyErr_Format(PyExc_SystemError, "Missing type object");
		return 0;
	}
	if ((none_allowed && obj == Py_None) || PyObject_TypeCheck(obj, type))
		return 1;
	PyErr_Format(PyExc_TypeError,
		"Argument '%s' has incorrect type (expected %s, got %s)",
		name, type->tp_name, obj->ob_type->tp_name);
	return 0;
}

static PyObject *__Pyx_GetName(PyObject *dict, char *name) {
	PyObject *result;
	result = PyObject_GetAttrString(dict, name);
	if (!result)
		PyErr_SetString(PyExc_NameError, name);
	return result;
}

static void __Pyx_Raise(PyObject *type, PyObject *value, PyObject *tb) {
	Py_XINCREF(type);
	Py_XINCREF(value);
	Py_XINCREF(tb);
	/* First, check the traceback argument, replacing None with NULL. */
	if (tb == Py_None) {
		Py_DECREF(tb);
		tb = 0;
	}
	else if (tb != NULL && !PyTraceBack_Check(tb)) {
		PyErr_SetString(PyExc_TypeError,
			"raise: arg 3 must be a traceback or None");
		goto raise_error;
	}
	/* Next, replace a missing value with None */
	if (value == NULL) {
		value = Py_None;
		Py_INCREF(value);
	}
	/* Next, repeatedly, replace a tuple exception with its first item */
	while (PyTuple_Check(type) && PyTuple_Size(type) > 0) {
		PyObject *tmp = type;
		type = PyTuple_GET_ITEM(type, 0);
		Py_INCREF(type);
		Py_DECREF(tmp);
	}
	if (PyString_Check(type))
		;
	else if (PyClass_Check(type))
		; /*PyErr_NormalizeException(&type, &value, &tb);*/
	else if (PyInstance_Check(type)) {
		/* Raising an instance.  The value should be a dummy. */
		if (value != Py_None) {
			PyErr_SetString(PyExc_TypeError,
			  "instance exception may not have a separate value");
			goto raise_error;
		}
		else {
			/* Normalize to raise <class>, <instance> */
			Py_DECREF(value);
			value = type;
			type = (PyObject*) ((PyInstanceObject*)type)->in_class;
			Py_INCREF(type);
		}
	}
	else {
		/* Not something you can raise.  You get an exception
		   anyway, just not what you specified :-) */
		PyErr_Format(PyExc_TypeError,
			     "exceptions must be strings, classes, or "
			     "instances, not %s", type->ob_type->tp_name);
		goto raise_error;
	}
	PyErr_Restore(type, value, tb);
	return;
raise_error:
	Py_XDECREF(value);
	Py_XDECREF(type);
	Py_XDECREF(tb);
	return;
}

static int __Pyx_TypeTest(PyObject *obj, PyTypeObject *type) {
	if (!type) {
		PyErr_Format(PyExc_SystemError, "Missing type object");
		return 0;
	}
	if (obj == Py_None || PyObject_TypeCheck(obj, type))
		return 1;
	PyErr_Format(PyExc_TypeError, "Cannot convert %s to %s",
		obj->ob_type->tp_name, type->tp_name);
	return 0;
}

static void __Pyx_UnpackError(void) {
	PyErr_SetString(PyExc_ValueError, "unpack sequence of wrong size");
}

static PyObject *__Pyx_UnpackItem(PyObject *seq, int i) {
  PyObject *item;
  if (!(item = PySequence_GetItem(seq, i))) {
    if (PyErr_ExceptionMatches(PyExc_IndexError))
    	__Pyx_UnpackError();
  }
  return item;
}

static int __Pyx_EndUnpack(PyObject *seq, int i) {
  PyObject *item;
  if (item = PySequence_GetItem(seq, i)) {
    Py_DECREF(item);
    __Pyx_UnpackError();
    return -1;
  }
  PyErr_Clear();
	return 0;
}

#include "compile.h"
#include "frameobject.h"
#include "traceback.h"

static void __Pyx_AddTraceback(char *funcname) {
	PyObject *py_srcfile = 0;
	PyObject *py_funcname = 0;
	PyObject *py_globals = 0;
	PyObject *empty_tuple = 0;
	PyObject *empty_string = 0;
	PyCodeObject *py_code = 0;
	PyFrameObject *py_frame = 0;
	
	py_srcfile = PyString_FromString(__pyx_filename);
	if (!py_srcfile) goto bad;
	py_funcname = PyString_FromString(funcname);
	if (!py_funcname) goto bad;
	py_globals = PyModule_GetDict(__pyx_m);
	if (!py_globals) goto bad;
	empty_tuple = PyTuple_New(0);
	if (!empty_tuple) goto bad;
	empty_string = PyString_FromString("");
	if (!empty_string) goto bad;
	py_code = PyCode_New(
		0,            /*int argcount,*/
		0,            /*int nlocals,*/
		0,            /*int stacksize,*/
		0,            /*int flags,*/
		empty_string, /*PyObject *code,*/
		empty_tuple,  /*PyObject *consts,*/
		empty_tuple,  /*PyObject *names,*/
		empty_tuple,  /*PyObject *varnames,*/
		empty_tuple,  /*PyObject *freevars,*/
		empty_tuple,  /*PyObject *cellvars,*/
		py_srcfile,   /*PyObject *filename,*/
		py_funcname,  /*PyObject *name,*/
		__pyx_lineno,   /*int firstlineno,*/
		empty_string  /*PyObject *lnotab*/
	);
	if (!py_code) goto bad;
	py_frame = PyFrame_New(
		PyThreadState_Get(), /*PyThreadState *tstate,*/
		py_code,             /*PyCodeObject *code,*/
		py_globals,          /*PyObject *globals,*/
		0                    /*PyObject *locals*/
	);
	if (!py_frame) goto bad;
	py_frame->f_lineno = __pyx_lineno;
	PyTraceBack_Here(py_frame);
bad:
	Py_XDECREF(py_srcfile);
	Py_XDECREF(py_funcname);
	Py_XDECREF(empty_tuple);
	Py_XDECREF(empty_string);
	Py_XDECREF(py_code);
	Py_XDECREF(py_frame);
}
