/*
 *  $Id: arp.c,v 1.1.1.1 1998/11/27 06:04:10 route Exp $
 *
 *  libnet
 *  arp.c - Build an ARP packet
 *
 *  Copyright (c) 1998, 1999 route|daemon9 <route@infonexus.com>
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include "../libnet_test.h"

int
main(int argc, char *argv[])
{
    int  c;
    char errbuf[256];
    char *device = NULL;
    struct link_int *l;

    while ((c = getopt(argc, argv, "i:")) != EOF)
    {
        switch (c)
        {
            case 'i':
                device = optarg;
                break;
            default:
                exit(EXIT_FAILURE);
        }
    }

    if (!device)
    {
        fprintf(stderr, "Specify a device\n");
        exit(EXIT_FAILURE);
    }
    if ((l = open_link_interface(device, errbuf)) == NULL)
    {
        fprintf(stderr, "open_link_interface: %s\n", errbuf);
        exit(EXIT_FAILURE);
    }
    send_arp(l, device);
    exit(EXIT_SUCCESS);
}


void
send_arp(struct link_int *l, u_char *device)
{
    int n;
    u_char *buf;

    buf = (u_char *)malloc(ARP_H + ETH_H);
    if (!buf)
    {
        perror("no packet memory");
        exit(EXIT_FAILURE);
    }
    memset(buf, 0, ARP_H + ETH_H);

    /*
     *  Ethernet header
     */
    build_ethernet(enet_dst, enet_src, ETHERTYPE_ARP, NULL, 0, buf);

    /*
     *  ARP header
     */
    build_arp(ARPHRD_ETHER,
        ETHERTYPE_IP,
        6,
        4,
        ARPOP_REQUEST,
        enet_src,
        ip_src,
        enet_dst,
        ip_dst,
        NULL,
        0,
        buf + ETH_H);

    n = write_link_layer(l, device, buf, ARP_H + ETH_H);

    printf("Wrote %d byte ARP packet through linktype %d\n", n, l->linktype);
}
