/*
 *  $Id: 4_udp_and_data.c,v 1.1.1.1 1998/11/27 06:04:10 route Exp $
 *
 *  libnet
 *  test4 client
 *  test4.c - UDP + payload Packet assembly tester
 *
 *  Copyright (c) 1998, 1999 route|daemon9 <route@infonexus.com>
 */

#include "../libnet_test.h"

int
main(int argc, char **argv)
{
    int sock, c;
    u_char *buf;
    u_char *payload = "hello world";
    int payload_s = strlen(payload);

    printf("Test 4: UDP + payload packet building/writing test\n");

    buf = malloc(UDP_H + IP_H + payload_s);
    if (!buf)
    {
        perror("No memory for packet");
        exit(EXIT_FAILURE);
    }

    sock = open_raw_sock(IPPROTO_RAW);
    if (sock == -1)
    {
        perror("No socket");
        exit(EXIT_FAILURE);
    }
    
    build_ip(UDP_H + payload_s,
            0,
            242,
            0,
            64,
            IPPROTO_UDP,
            name_resolve(IP1, 1),
            name_resolve(IP2 ,1),
            NULL,
            0,
            buf);

    build_udp(1025, 22, payload, payload_s, buf + IP_H);

    do_checksum(buf, IPPROTO_UDP, UDP_H + payload_s);

    c = write_ip(sock, buf, UDP_H + IP_H + payload_s);
    if (c < UDP_H + IP_H + payload_s)
    {
        fprintf(stderr, "write_ip\n");
    }
    printf("Completed, wrote %d bytes\n", c);

    free(buf);
    return (EXIT_SUCCESS);
}

