/*
 *  $Id$
 *
 *  libnet.h    -   Network routine library
 *
 *  route|daemon9 <route@infonexus.com>
 *
 */

#ifndef __LIBNET_H
#define __LIBNET_H

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <ctype.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <sys/socket.h>


/*
 *  Network byte order into IP address
 *  Previous versions had a memory leak (returned a strdup'd pointer -- strdup
 *  has an implicit malloc which wasn't getting freed).  This static var hack
 *  thingy was used to preserve existing code without having to change much.
 *  You can simply use the return value of the function directly allowing you
 *  to write tighter, more obvious code (rather then having to do allocate an
 *  additional buffer for the output).
 *  Thanks to Red for the idea.
 */

u_char *                /* Pointer the hostname or dotted decimal IP address */
host_lookup(
        u_long          /* Network byte ordered (big endian) IP address */
        );


/*
 *  IP address into network byte order
 */

u_long                  /* Network byte ordered (big endian) IP address or -1 on error */
name_resolve(
    u_char *            /* Pointer the hostname or dotted decimal IP address */
    );


/*
 *  Fast TCP checksum.
 */
 
u_short                 /* Standard TCP checksum of header and data */
tcp_check(
    struct tcphdr *,    /* TCP header pointer */
    int len,            /* packet length */
    u_long,             /* source IP address */
    u_long              /* destination IP address */
    );

/*
 *  Fast IP checksum.
 */

u_short                 /* Standard IP checksum of header and data */
ip_check(
    u_short *,          /* pointer to the buffer to be sumed */
    int len             /* packet length */
    );


/*
 *  Opens a socket for writing raw IP datagrams to.  Set IP_HDRINCL to let the 
 *  kernel know we've got it all under control.
 */

int                     /* Opened file desciptor, or -1 on error */
open_raw_sock(
    int                 /* Protocol of raw socket (from /etc/protocols) */
    );


/*
 *  Standard Stevens daemon code
 */

int                     /* 1 if successful, -1 on error */
daemon();

#endif  /* __LIBNET_H */

/* EOF */
