/*
 *  $Id$
 *
 *  build_ip.c - Crude IP packet assembler
 *
 *  route|daemon9 <route@infonexus.com>
 *
 *  $Log$
 */

#include "../include/libnet.h"

void
build_ip(u_short len, u_short id, u_short frag, u_char ttl,
        u_char prot, u_long src, u_long dst, const u_char *payload,
        u_char *buf)
{
    struct ip *ip_hdr;

    ip_hdr = (struct ip *)(buf);

    ip_hdr->ip_v        = 4;
    ip_hdr->ip_hl       = 5;
    ip_hdr->ip_tos      = 0;        /* UNSUP */
    ip_hdr->ip_len      = FIX(IP_H + len);
    ip_hdr->ip_id       = htons(id);
    ip_hdr->ip_off      = FIX(frag);
    ip_hdr->ip_ttl      = ttl;
    ip_hdr->ip_p        = prot;
    ip_hdr->ip_sum      = 0;
    ip_hdr->ip_src.s_addr = src;
    ip_hdr->ip_dst.s_addr = dst;

    if (payload)
    {
        /* ... */
    }
}


/* EOF */
