/*
 *  $Id$
 *
 *  libnet.h    -   Network routine library
 *
 *  route|daemon9 <route@infonexus.com>
 *
 */

#ifndef __LIBNET_H
#define __LIBNET_H

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <ctype.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>
#include <netdb.h>
#include <errno.h>

#if (__DEBUG)
#define DEBUG(fmt, arg...) fprintf(stderr, fmt, ##arg)
#else
#define DEBUG(fmt, arg...) do {} while (0)
#endif

#if (LINUX)
#define uh_sport source 
#define uh_dport dest
#define uh_ulen  len
#define uh_sum   check
#endif

#ifdef BSD_BYTE_SWAP
#define FIX(n)  (n)
#else
#define FIX(n)  htons(n)
#endif

#define UDP_H   sizeof(struct udphdr)
#define TCP_H   sizeof(struct tcphdr)
#define IP_H    sizeof(struct ip)
#define P_H     sizeof(struct psuedohdr)

struct psuedohdr
{
    u_long ip_src;
    u_long ip_dst;
    u_char null;
    u_char protocol;
    u_short len;
};

/*
 *  Calculates IPv4 family checksum on packet headers.
 */

void
do_checksum(
    u_char *,           /* Pointer to the packet buffer */
    int,                /* Protocol */
    int                 /* Packet size */
    );
/*
 *  Network byte order into IP address
 *  Previous versions had a memory leak (returned a strdup'd pointer -- strdup
 *  has an implicit malloc which wasn't getting freed).  This static var hack
 *  thingy was used to preserve existing code without having to change much.
 *  You can simply use the return value of the function directly allowing you
 *  to write tighter, more obvious code (rather then having to do allocate an
 *  additional buffer for the output).
 *  Thanks to Red for the idea.
 */

u_char *                /* Pointer to hostname or dotted decimal IP address */
host_lookup(
    u_long,             /* Network byte ordered (big endian) IP address */
    u_short             /* Use domain names or no */
    );


/*
 *  Network byte order into IP address
 *  Threadsafe version.
 */

void
host_lookup_r(
    u_long,         /* Network byte ordered (big endian) IP address */
    u_short,        /* Use domain names or no */
    u_char *        /* Pointer to hostname or dotted decimal IP address */
    );


/*
 *  IP address into network byte order
 */

u_long                  /* Network byte ordered IP address or -1 on error */
name_resolve(
    u_char *,           /* Pointer the hostname or dotted decimal IP address */
    u_short             /* Use domain names or no */
    );


/*
 *  Fast x86 TCP checksum.  This function builds it's own psuedoheader.
 */
 
u_short                 /* Standard TCP checksum of header and data */
tcp_check(
    struct tcphdr *,    /* TCP header pointer */
    int,                /* Packet length */
    u_long,             /* Source IP address */
    u_long              /* Destination IP address */
    );

/*
 *  Fast x86 IP checksum.
 */

u_short                 /* Standard IP checksum of header and data */
ip_check(
    u_short *,          /* Pointer to the buffer to be summed */
    int len             /* Packet length */
    );


/*
 *  Opens a socket for writing raw IP datagrams to.  Set IP_HDRINCL to let the 
 *  kernel know we've got it all under control.
 */

int                     /* Opened file desciptor, or -1 on error */
open_raw_sock(
    int                 /* Protocol of raw socket (from /etc/protocols) */
    );


/*
 *  Standard Stevens daemon code
 */

void
daemon();


/*
 *  TCP packet assembler.
 */

void
build_tcp(
    u_short,            /* Source port */
    u_short,            /* Destination port */
    u_long,             /* Sequence Number */
    u_long,             /* Acknowledgement Number */
    u_char,             /* Control bits */
    u_short,            /* Advertised Window Size */
    u_short,            /* Urgent Pointer */
    const u_char *,     /* Pointer to packet data (or NULL) */
    u_char *            /* Pointer to packet header memory */
    );

/*
 * UDP packet assembler.
 */

void
build_udp(
    u_short,            /* Packet length */
    u_short,            /* Source port */
    u_short,            /* Destination port */
    const u_char *,     /* Pointer to packet data (or NULL) */
    u_char *            /* Pointer to packet header memory */
    );


/*
 *  IP packet assembler.
 */

void
build_ip(
    u_short,            /* Total packet length */
    u_short,            /* IP ID */
    u_short,            /* Fragmentation flags and offset */
    u_char,             /* TTL */
    u_char,             /* Protocol */
    u_long,             /* Source IP Address */
    u_long,             /* Destination IP Address */
    const u_char *,     /* Pointer to packet data (or NULL) */
    u_char *            /* Pointer to packet header memory */
    );

int                     /* 1 if successful, -1 on error */
write_ip(
    int sock,           /* Previously opened raw socket */
    const u_char *,     /* Pointer a complete IP datagram */
    int                 /* Packet size */
    );


#endif  /* __LIBNET_H */

/* EOF */
