/*
 *  $Id$
 *
 *  resolve.c - Various Internet network-type routines
 *
 *  route|daemon9 <route@infonexus.com>
 *
 *  $Log$
 */

#include "../include/libnet.h"

u_char *
host_lookup(u_long in, u_short use_name)
{
    static u_char hostname[512], hostname2[512];
    static u_short which;
    u_char *p;

    struct hostent *host_ent = NULL;
    struct in_addr addr;

    /*
     *  Swap to the other buffer.  We swap static buffers to avoid having to
     *  pass in a char *.  This makes the code that calls this function more
     *  intuitive, but makes this function ugly.  This function is seriously
     *  non-rentrant.  For threaded applications (or for signal handler code)
     *  use host_lookup_r().
     */
    which++;

    
    if (use_name)
    {
        addr.s_addr = in;
        host_ent = gethostbyaddr((char *)&addr, sizeof(struct in_addr), AF_INET);
    }
    if (!host_ent)
    {

        p = (u_char *)&in;
        sprintf(((which % 2) ? hostname : hostname2),  "%d.%d.%d.%d",
                (p[0] & 255), (p[1] & 255), (p[2] & 255), (p[3] & 255));
    }
    else if (use_name)
    {
        strncpy(((which % 2) ? hostname : hostname2), host_ent->h_name, 
                                                        sizeof(hostname));
    }
    return (which % 2) ? (hostname) : (hostname2);
}


void
host_lookup_r(u_long in, u_short use_name, u_char *hostname)
{
    u_char *p;
    struct hostent *host_ent = NULL;
    struct in_addr addr;

    if (use_name)
    {    
        addr.s_addr = in;
        host_ent = gethostbyaddr((char *)&addr, sizeof(struct in_addr), AF_INET);
    }
    if (!host_ent)
    {

        p = (u_char *)&in;
        sprintf(hostname, "%d.%d.%d.%d",
                (p[0] & 255), (p[1] & 255), (p[2] & 255), (p[3] & 255));
    }
    else
    {
        strncpy(hostname, host_ent->h_name, sizeof(hostname));
    }
}


u_long
name_resolve(u_char *host_name, u_short use_name)
{

    struct in_addr addr;
    struct hostent *host_ent; 
    u_long l;
    u_int val;
    int i;
   
    if (use_name)
    {
        if ((addr.s_addr = inet_addr(host_name)) == -1)
        {
            if (!(host_ent = gethostbyname(host_name))) return (-1);
            bcopy(host_ent->h_addr, (char *)&addr.s_addr, host_ent->h_length);
        }
        return (addr.s_addr);
    }
    else
    {
        /*
         *  We only want dots 'n decimals.
         */
        if (!isdigit(host_name[0])) return (-1L);

        l = 0;
        for (i = 0; i < 4; i++)
        {
            l <<= 8;
            if (*host_name)
            {
                val = 0;
                while (*host_name && *host_name != '.')
                {   
                    val *= 10;
                    val += *host_name - '0';
                    host_name++;
                }
                l |= val;
                if (*host_name) host_name++;
            }
        }
        return (htonl(l));
    }
}


/* EOF */
