/*
 *  $Id$
 *
 *  libnet
 *  test1 client
 *  test1.c - TCP Packet assembly tester
 *
 *  route|daemon9 <route@infonexus.com>
 */

#include "../../include/libnet.h"
#include <string.h>

#define IP1 "10.0.0.1"
#define IP2 "10.0.0.2"

int
main(int argc, char **argv)
{
    int sock, c;
    u_char *buf;

    printf("Test 1: TCP packet building/writing test\n");

    /*
     *  Get our block of memory for the packet.  In this case, we only need
     *  memory for the packet headers.
     */
    buf = malloc(TCP_H + IP_H);
    if (!buf)
    {
        perror("No memory for packet header");
        exit(1);
    }

    /*
     *  Open our raw IP socket and set IP_HDRINCL.
     */
    sock = open_raw_sock(IPPROTO_RAW);
    if (sock == -1)
    {
        perror("No socket");
        exit(1);
    }
    
    /*
     *  Build the IP header (shown exploded for commenting).
     */
    build_ip(TCP_H,                         /* Size of the payload */
            242,                            /* IP ID */
            0,                              /* Frag stuff */
            48,                             /* TTL */
            IPPROTO_TCP,                    /* Transport protocol */
            name_resolve(IP1, 1),            /* Source IP */
            name_resolve(IP2, 1),            /* Destination IP */
            NULL,                           /* Pointer to payload (none) */
            0,
            buf);                           /* Packet header memory */

    /*
     *  Build the TCP header.
     */
    build_tcp(1025,                         /* Source TCP port */
            22,                             /* Destination TCP port */
            11111,                          /* Sequence number */
            99999,                          /* Acknowledgement number */
            TH_SYN|TH_ACK,                  /* Control flags */
            1024,                           /* Window size */
            0,                              /* Urgent pointer */
            NULL,                           /* Pointer to payload (none) */
            0,
            buf + IP_H);                    /* Packet header memory */

    /*
     *  Calculate the TCP header checksum (IP header checksum is *always* done
     *  by the kernel.
     */
    do_checksum(buf, IPPROTO_TCP, TCP_H);

    /*
     *  Write the packet to the network.
     */
    c = write_ip(sock, buf, TCP_H + IP_H);
    if (c < TCP_H + IP_H)
    {
        fprintf(stderr, "write_ip\n");
    }
    printf("Completed, wrote %d bytes\n", c);
    free(buf);

    return (0);
}

/* EOF */
