/*
 *  $Id$
 *
 *  libnet
 *  prand implemenation
 *  prand.c - pseudo-random number generation
 *
 *  route|daemon9 <route@infonexus.com>
 */
 
#include "../include/libnet.h"

int
seed_prand()
{
    struct timeval seed;

    if (gettimeofday(&seed, NULL) == -1)
    {
        perror("seed_rand: cannot gettimeofday");
        return (-1);
    }

    /*
     *  More entropy then just seeding with time(2).
     */
    srandom((unsigned)(seed.tv_sec ^ seed.tv_usec));
    return (1);
}


u_long
get_prand(int mod)
{
    u_long n;

    n = random();

    switch(mod)
    {
        case PR2:
            return (n % 0x2);
        case PR8:
            return (n % 0xff);
        case PR16:
            return (n % 0x7fff);
        case PRu16:
            return (n % 0xffff);
        case PR32:
            return (n % 0x7fffffff);
        case PRu32:
            return (n);
    }
    return (0);     /* NOTTREACHED */
}

/* EOF */
