/*
 *  $Id$
 *
 *  libnet
 *  socket implementation
 *  socket.c - Opens a raw socket of type `prot` and sets the IP_HDRINCL
 *  socket option
 *
 *  route|daemon9 <route@infonexus.com>
 */

#include "../include/libnet.h"

int
open_raw_sock(prot)
{
    int fd, one = 1;

    if ((fd = socket(AF_INET, SOCK_RAW, prot)) < 0)
    {
        fprintf(stderr,
                "open_raw_socket: error: SOCK_RAW allocation: %s",
                strerror(errno));
        return (-1);
    }
    if (setsockopt(fd, IPPROTO_IP, IP_HDRINCL, &one, sizeof(one)) < 0)
    {
        fprintf(stderr,
                "open_raw_socket: error: setting IP_HDRINCL: %s",
                strerror(errno));
        return (-1);
    }
    DEBUG("Successfully opened a type %d socket and set IP_HDRINCL\n", prot);
    return (fd);
}


/* EOF */
