/*
 *  $Id: 6_prand_trials.c,v 1.1 1998/11/10 22:09:43 route Exp $
 *
 *  libnet
 *  test6 client
 *  test6.c - psuedorandom number generation
 *
 *  route|daemon9 <route@infonexus.com>
 */

#include "libnet_test.h"

int
main(int argc, char **argv)
{

    int i, j;

    printf("Test 6: Psuedorandom number generation\n");
    printf("Test 6: For each trial, 1000 numbers will be generated\n");
    seed_prand();

    printf("\n\nPress return for trial 1 (0 - 1)\n\n");
    getc(stdin);
    for (i = 1000; i; i--)
    {
        printf("%ld ", get_prand(PR2));
    }

    printf("\n\nPress return for trial 2 (0 - 255)\n\n");
    getc(stdin);
    for (i = 1000; i; i--)
    {
        printf("%3ld ", get_prand(PR8));
    }

    printf("\n\nPress return for trial 3 (0 - 32767)\n\n");
    getc(stdin);
    for (j = 13, i = 1000; i; i--, j--)
    {
        if (!j)
        {
            printf("\n");
            j = 13;
        }
        printf("%5ld ", get_prand(PR16));
    }

    printf("\n\nPress return for trial 4 (0 - 65535)\n\n");
    getc(stdin);
    for (j = 13, i = 1000; i; i--, j--)
    {
        if (!j)
        {
            printf("\n");
            j = 13;
        }
        printf("%5ld ", get_prand(PRu16));
    }

    printf("\n\nPress return for trial 5 (0 - 2147483647)\n\n");
    getc(stdin);
    for (j = 7, i = 1000; i; i--, j--)
    {
        if (!j)
        {
            printf("\n");
            j = 7;
        }
        printf("%10ld ", get_prand(PR32));
    }

    printf("\n\nPress return for trial 6 (0 - 4294967295)\n\n");
    getc(stdin);
    for (j = 7, i = 1000; i; i--, j--)
    {
        if (!j)
        {
            printf("\n");
            j = 7;
        }
        printf("%10ld ", get_prand(PRu32));
    }

    printf("\nCompleted\n");
    return (EXIT_SUCCESS);
}

/* EOF */
