/*
 *  $Id: snoop.c,v 1.1 1998/11/27 19:54:58 route Exp $
 *
 *  libnet
 *  snoop.c
 *
 *  Copyright (c) 1998 route|daemon9 <route@infonexus.com>
 *  All rights reserved.
 *
 * Copyright (c) 1993, 1994, 1995, 1996, 1997
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <sys/param.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>

#include <net/raw.h>
#include <net/if.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/if_ether.h>
#include <netinet/ip_var.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "../include/libnet.h"

#include "../include/gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "../include/os-proto.h"
#endif


struct link_int *
open_link_interface(char *device, char *ebuf)
{
    int fd;
    struct sockaddr_raw sr;
    struct snoopfilter sf;
    u_int v;
    struct link_int *l;

    l = (struct link_int *)malloc(sizeof(*l));
    if (l == NULL)
    {
        sprintf(ebuf, "malloc: %s", ll_strerror(errno));
        return (NULL);
    }
    memset(l, 0, sizeof(*l));
    l->fd = socket(PF_RAW, SOCK_RAW, RAWPROTO_SNOOP);
    if (l->fd < 0)
    {
        sprintf(ebuf, "snoop socket: %s", ll_strerror(errno));
        goto bad;
    }

    memset(&sr, 0, sizeof(sr));
    sr.sr_family = AF_RAW;
    strncpy(sr.sr_ifname, device, sizeof(sr.sr_ifname));

    if (bind(l->fd, (struct sockaddr *)&sr, sizeof(sr)))
    {
        sprintf(ebuf, "snoop bind: %s", ll_strerror(errno));
        goto bad;
    }

    memset(&sf, 0, sizeof(sf));
    if (ioctl(l->fd, SIOCADDSNOOP, &sf) < 0)
    {
        sprintf(ebuf, "SIOCADDSNOOP: %s", ll_strerror(errno));
        goto bad;
    }

    v = 64 * 1024;
    v = 1;
    if (ioctl(fd, SIOCSNOOPING, &v) < 0)
    {
        sprintf(ebuf, "SIOCSNOOPING: %s", ll_strerror(errno));
        goto bad;
    }

    /*
     * XXX hack - map device name to link layer type
     */
    if (strncmp("et", device, 2) == 0      ||    /* Challenge 10 Mbit */
	    strncmp("ec", device, 2) == 0  ||    /* Indigo/Indy 10 Mbit, O2 10/100 */
            strncmp("ef", device, 2) == 0 ||    /* O200/2000 10/100 Mbit */
            strncmp("gfe", device, 3) == 0 ||   /* GIO 100 Mbit */
            strncmp("fxp", device, 3) == 0 ||   /* Challenge VME Enet */
            strncmp("ep", device, 2) == 0 ||    /* Challenge 8x10 Mbit EPLEX */
            strncmp("vfe", device, 3) == 0 ||   /* Challenge VME 100Mbit */
            strncmp("fa", device, 2) == 0 ||
            strncmp("qaa", device, 3) == 0)
    {
        p->linktype = DLT_EN10MB;
    }
    else if (strncmp("ipg", device, 3) == 0 ||
            strncmp("rns", device, 3) == 0 ||	/* O2/200/2000 FDDI */
            strncmp("xpi", device, 3) == 0)
        {
            p->linktype = DLT_FDDI;
	}
    else if (strncmp("ppp", device, 3) == 0) {
		p->linktype = DLT_RAW;
	} else if (strncmp("lo", device, 2) == 0) {
		p->linktype = DLT_NULL;
	} else {
		sprintf(ebuf, "snoop: unknown physical layer type");
		goto bad;
	}

	p->bufsize = 4096;				/* XXX */
	p->buffer = (u_char *)malloc(p->bufsize);
	if (p->buffer == NULL) {
		sprintf(ebuf, "malloc: %s", ll_strerror(errno));
		goto bad;
	}

	return (p);
 bad:
	(void)close(fd);
	free(p);
	return (NULL);
}
