/*
 * Demonstration of how to build a OSPF Hello packet.
 *
 * Andrew Reiter 
 * <areiter@bindview.com>
 * Bindview Development
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <libnet.h>

void	help(char *);

int
main(int argc, char **argv)
{
    int sock, warn, len;
    u_char *pack, *to, *from, *neighbor;
    u_long src, dst, addaid, addrid, nbr,  auth[2];

    if (argc != 4) 
	help(argv[0]);

    from = argv[1];
    to = argv[2];
    neighbor = argv[3];

    len = OSPF_H + HELLO_H + IP_H + AUTH_H;
    pack = (u_char *)malloc(len);

    sock = libnet_open_raw_sock(IPPROTO_RAW);
    if (sock == -1) {
	perror("socket");
   	free(pack);
	exit(-1);
    }


    src = libnet_name_resolve(from, 0);
    dst = libnet_name_resolve(to, 0);
    nbr = libnet_name_resolve(neighbor, 0);

    addrid = 0x23696969;
    addaid = 0xc0ffee00;	/* GENERIC : FAKE : ETC */

    libnet_build_ip(OSPF_H + AUTH_H + HELLO_H, 0x00, 101, IP_DF, 254,
		    	IPPROTO_OSPF, src, dst, NULL, 0, pack);

    auth[0] = 0;
    auth[1] = 0;

    libnet_build_ospf(HELLO_H + AUTH_H, OSPF_HELLO, addrid, addaid, 
		    OSPF_AUTH_NULL, NULL, 0, pack + IP_H); 
  
    LIBNET_OSPF_AUTHCPY(pack + IP_H + OSPF_H, auth);

    libnet_build_ospf_hello(0xffffffff, 2, 0x00, 0x00, 30, src, src, nbr, 
				NULL, 0, pack + IP_H + OSPF_H + AUTH_H);

    libnet_do_checksum(pack, IPPROTO_OSPF, len);

    warn = libnet_write_ip(sock, pack, len);
    if (warn != len) {
  	printf("Error sending: %d bytes written : %s\n", warn, strerror(errno));
	free(pack);
	exit(warn);
    } else {
	printf("%d bytes written\n", warn); 
    }
    free(pack);
}

void
help(char *pname)
{
    printf("Usage: %s <source ip> <dest. ip> <neighbor>\n", pname);
    printf("[Use x.x.x.x format]\n");
    exit(0);
}
