/*
 * THE NEMESIS PROJECT
 * Copyright (C) 2002, 2003 Jeff Nathan <jeff@snort.org>
 *
 * nemesis-ethernet.h (Ethernet Packet Injector)
 *
 */

#ifndef __NEMESIS_ETHERNET_H__
#define __NEMESIS_ETHERNET_H__

#ifdef HAVE_CONFIG_H
    #include "config.h"
#endif

#include <stdio.h>
#include <strings.h>
#include <stdlib.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <libnet.h>
#include "nemesis.h"

#ifndef ETHERTYPE_8021Q
#define ETHERTYPE_8021Q         0x8100  /* IEEE 802.1Q VLAN tagging */
#endif

#ifndef ETHERTYPE_IPV6
#define ETHERTYPE_IPV6          0x86DD  /* IPv6 protocol */
#endif

#ifndef ETHERTYPE_PPOEDISC
#define ETHERTYPE_PPPOEDISC     0x8863  /* PPP Over Ethernet Discovery Stage */
#endif

#ifndef ETHERTYPE_PPOE
#define ETHERTYPE_PPPOE         0x8864  /* PPP Over Ethernet Session Stage */
#endif

int verbose;    /* verbosity */

int buildether(ETHERhdr *, PayloadData *, char *);
void ethernet_cmdline(int, char **);
void ethernet_initdata(void);
void ethernet_usage(char *);
void ethernet_validatedata(void);
void ethernet_verbose(void);

#endif /* __NEMESIS_ETHERNET_H__ */
