/*
 * THE NEMESIS PROJECT
 * Copyright (C) 1999, 2000 Mark Grimes <obecian@packetninja.net>
 * Copyright (C) 2001 - 2003 Jeff Nathan <jeff@snort.org>
 * 
 * nemesis-ospf.h (OSPF Packet Injector)
 * 
 */

#ifndef __NEMESIS_OSPF_H__
#define __NEMESIS_OSPF_H__

#ifdef HAVE_CONFIG_H
    #include "config.h"
#endif

#include <stdio.h>
#include <strings.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#if defined(HAVE_MACHINE_ENDIAN_H)
    #include <machine/endian.h>
#endif
#include <netinet/in.h>
#include <libnet.h>
#include "nemesis.h"

u_short id,            /* IP id */
        frag,          /* frag shit */
        mtusize,       /* Max dgram length (DBD) */
        num,           /* LSA_RTR num */
        interval,      /* secs since last pkt sent */
        rtr_flags,     /* LSA_RTR flags */
        metric,        /* OSPF metric */
        ospf_age;      /* OSPF advertisement age */

u_long source,         /* source address */
       dest,           /* destination address */
       neighbor,       /* neighbor router */
       as_fwd,         /* AS_EXT forward address */
       addrid,         /* advertising router id */
       addaid,         /* advertising area id */
       router,         /* advertising router */
       auth[2],        /* authentication type */
       mask;           /* subnet mask (icmp_mask) */

u_char enet_src[6],    /* source MAC address */
       enet_dst[6],    /* destination MAC address */
       ttl,            /* time to live */
       tos,            /* type of service */
       *payload,       /* payload pointer */
       options[40],    /* IP options pointer */
       priority,       /* OSPF priority */
       exchange,       /* DBD exchange type */
       rtrtype,        /* LSA_RTR type */
       ooptions;       /* OSPF options */

u_int dead_int,        /* dead router interval in secs */
      as_tag,          /* AS_EXT tag */
      seqnum,          /* seqnum for LSA */
      bcastnum,        /* num of LSAs to bcast (LSU) */
      rtrdata,         /* LSA_RTR router data */
      rtrid;           /* router id for LSA */

struct ether_addr *e;
struct libnet_link_int *l2;

int got_ipoptions;

int got_link, 
    got_options, 
    got_payload;       /* sanity checks */

int option_s;          /* IP options size */
int payload_s;         /* payload size */
int ospftype;          /* which OSPF packet to launch */

char *device;          /* network device */

int verbose;           /* verbosity */

int buildospf();       /* OSPF Protocol wrapper */
int build_hello();     /* Hello (discover/maintain neighbors) */
int build_dbd();       /* Database Description (summarize db
                        * contents)
                        */

int build_lsr();       /* Link State Request (db d/l) */
int build_lsu();       /* Link State Update (db update) */
int build_lsartr();    /* Router Links Advertisment */
int build_lsanet();    /* Network Links Advertisement */
int build_lsasum_ip(); /* Summary Links Advertisement */
int build_lsaas();     /* AS Ext Link Advertisement */

void ospf_usage(char *);
void defaults();       /* defaults for packet fields */

int nbytes;

#endif /* __NEMESIS_OSPF_H__ */
