/*
 * THE NEMESIS PROJECT
 * Copyright (C) 1999, 2000, 2001 Mark Grimes <obecian@packetninja.net>
 * Copyright (C) 2001 - 2003 Jeff Nathan <jeff@snort.org>
 *
 * nemesis-proto_arp.c (ARP Packet Generator)
 *
 */

#include "nemesis-arp.h"

int buildarp(ETHERhdr *eth, ARPhdr *arp, PayloadData *pd, char *device, 
        int reply)
{
    int n = 0;
    u_int32_t arp_packetlen;
    static u_int8_t *pkt;
    struct libnet_link_int *l2 = NULL;

    /* validation tests */
    if (pd->payload == NULL)
        pd->payload_s = 0;

    arp_packetlen = LIBNET_ARP_H + LIBNET_ETH_H + pd->payload_s; 
#ifdef DEBUG
    printf("pd->payload_s is %u.\n", pd->payload_s);
#endif

    if ((l2 = libnet_open_link_interface(device, errbuf)) == NULL)
    {
        fprintf(stderr, "ERROR: Unable to open layer 2 device for writing: "
                "%s.\n", errbuf);
        return -1;
    }

    if (libnet_init_packet(arp_packetlen, &pkt) == -1)
    {
        fprintf(stderr, "ERROR: Unable to allocate packet memory.\n");
        return -1;
    }

    libnet_build_ethernet(eth->ether_dhost, eth->ether_shost, eth->ether_type,
            NULL, 0, pkt);

    libnet_build_arp(arp->ar_hrd, arp->ar_pro, arp->ar_hln, arp->ar_pln, 
            arp->ar_op, arp->ar_sha, arp->ar_spa, arp->ar_tha, arp->ar_tpa,
            pd->payload, pd->payload_s, pkt + LIBNET_ETH_H);

    n = libnet_write_link_layer(l2, device, pkt, LIBNET_ETH_H + 
                LIBNET_ARP_H + pd->payload_s);
#ifdef DEBUG
    printf("arp_packetlen is %u.\n", arp_packetlen);
#endif
    if (verbose == 2)
        hexdump(pkt, arp_packetlen);

    if (n != arp_packetlen)
    {
        fprintf(stderr, "ERROR: Incomplete packet injection.  Only "
                "wrote %d bytes.\n", n);
    }
    else
    {
        if (verbose)
        {
            if (memcmp(eth->ether_dhost, (void *)&one, 6))
            {
                printf("Wrote %d byte unicast ARP request packet through "
                        "linktype %s.\n", n, 
                        nemesis_lookup_linktype(l2->linktype));
            } 
            else
            { 
                printf("Wrote %d byte %s packet through linktype %s.\n", n, 
                        (eth->ether_type == ETHERTYPE_ARP ? "ARP" : "RARP"),
                        nemesis_lookup_linktype(l2->linktype));
            }
        }
    }

    libnet_destroy_packet(&pkt);
    if (l2 != NULL)
        libnet_close_link_interface(l2);
    return (n);
}
