/*
 * THE NEMESIS PROJECT
 * Copyright (C) 1999, 2000, 2001 Mark Grimes <obecian@packetninja.net>
 * Copyright (C) 2001 - 2003 Jeff Nathan <jeff@snort.org>
 *
 * nemesis-proto_dns.c (DNS Packet Generator)
 *
 */


#include "nemesis-dns.h"

int builddns(ETHERhdr *eth, IPhdr *ip, TCPhdr *tcp, UDPhdr *udp, DNShdr *dns, 
        PayloadData *pd, OptionsData *ipod, OptionsData *tcpod, char *device) 
{
    int n;
    u_int32_t dns_packetlen = 0, dns_meta_packetlen = 0;
    static u_int8_t *pkt;
    static int sockfd = -1;
    struct libnet_link_int *l2 = NULL;

    if (pd->payload == NULL)
        pd->payload_s = 0;

    if (ipod->options == NULL)
        ipod->options_s = 0;

    if (tcpod->options == NULL)
        tcpod->options_s = 0;

    if (got_link)    /* data link layer transport */
    {
        if ((l2 = libnet_open_link_interface(device, errbuf)) == NULL)
        {
            fprintf(stderr, 
                    "ERROR: Unable to open layer 2 device for writing: "
                    "%s.\n", errbuf);
            return -1;
        }

        if (state == 0)    /* UDP */
        {
            dns_packetlen = LIBNET_ETH_H + LIBNET_IP_H + LIBNET_UDP_H + 
                    LIBNET_DNS_H + pd->payload_s + ipod->options_s;

            dns_meta_packetlen = dns_packetlen - (LIBNET_ETH_H + LIBNET_IP_H);

            if (libnet_init_packet(dns_packetlen, &pkt) == -1)
            {
                fprintf(stderr, "ERROR: Unable to allocate packet memory.\n");
                return -1;
            }

            libnet_build_ethernet(eth->ether_dhost, eth->ether_shost, 
                    ETHERTYPE_IP, NULL, 0, pkt);

            libnet_build_ip(dns_meta_packetlen, ip->ip_tos, ip->ip_id, 
                    ip->ip_off, ip->ip_ttl, IPPROTO_UDP, ip->ip_src.s_addr, 
                    ip->ip_dst.s_addr, NULL, 0, pkt + LIBNET_ETH_H);

            libnet_build_udp(udp->uh_sport, udp->uh_dport, NULL, 0, 
                    pkt + LIBNET_ETH_H + LIBNET_IP_H);

            libnet_build_dns(dns->id, dns->flags, dns->num_q, dns->num_answ_rr, 
                    dns->num_auth_rr, dns->num_addi_rr, pd->payload, 
                    pd->payload_s, pkt + LIBNET_ETH_H + LIBNET_IP_H + 
                    LIBNET_UDP_H);

            if (got_ipoptions)
            {
                if ((libnet_insert_ipo((struct ipoption *)ipod->options, 
                                ipod->options_s, pkt + LIBNET_ETH_H)) == -1)
                {
                    fprintf(stderr, 
                            "ERROR: Unable to add IP options, discarding "
                            "them.\n");
                }
            }

            libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H +
                    ipod->options_s);
            libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_UDP, LIBNET_UDP_H +
                    LIBNET_DNS_H + pd->payload_s + ipod->options_s);

            n = libnet_write_link_layer(l2, device, pkt, dns_packetlen);
#ifdef DEBUG
            printf("dns_packetlen (link - UDP) is %u.\n", dns_packetlen);
#endif
            if (verbose == 2)
                hexdump(pkt, dns_packetlen);

            if (n != dns_packetlen)
            {
                fprintf(stderr, 
                        "ERROR: Incomplete packet injection.  Only wrote %d "
                        "bytes.\n", n);
            }
            else
            {
                if (verbose)
                    printf("Wrote %d byte DNS (UDP) packet through linktype "
                            "%d.\n", n, l2->linktype);
            }

            libnet_destroy_packet(&pkt);
            libnet_close_link_interface(l2);
            return n;
        }    /* end of UDP */
        else if (state == 1)    /* TCP */
        {
            dns_packetlen = LIBNET_ETH_H + LIBNET_IP_H + LIBNET_TCP_H + 
                    LIBNET_DNS_H + pd->payload_s + ipod->options_s + 
                    tcpod->options_s;

            dns_meta_packetlen = dns_packetlen - (LIBNET_ETH_H + LIBNET_IP_H);
            
            if (libnet_init_packet(dns_packetlen, &pkt) == -1)
            {
                fprintf(stderr, "ERROR: Unable to allocate packet memory.\n");
                return -1;
            }

            libnet_build_ethernet(eth->ether_dhost, eth->ether_shost,
                                  ETHERTYPE_IP, NULL, 0, pkt);

            libnet_build_ip(dns_meta_packetlen, ip->ip_tos, ip->ip_id, 
                    ip->ip_off, ip->ip_ttl, IPPROTO_UDP, ip->ip_src.s_addr, 
                    ip->ip_dst.s_addr, NULL, 0, pkt + LIBNET_ETH_H);

            libnet_build_tcp(tcp->th_sport, tcp->th_dport, tcp->th_seq, 
                    tcp->th_ack, tcp->th_flags, tcp->th_win, tcp->th_urp, 
                    NULL, 0, pkt + LIBNET_ETH_H + LIBNET_IP_H);

            libnet_build_dns(dns->id, dns->flags, dns->num_q, dns->num_answ_rr,
                             dns->num_auth_rr, dns->num_addi_rr, pd->payload,
                             pd->payload_s, pkt + LIBNET_ETH_H + LIBNET_IP_H + 
                             LIBNET_TCP_H);

            if (got_ipoptions)
            {
                if ((libnet_insert_ipo((struct ipoption *)ipod->options, 
                                ipod->options_s, pkt + 14)) == -1)
                {
                    fprintf(stderr, 
                            "ERROR: Unable to add IP options, discarding "
                            "them.\n");
                }
            }

            if (got_tcpoptions)
            {
                if ((libnet_insert_tcpo((struct tcpoption *)tcpod->options, 
                                tcpod->options_s, pkt + LIBNET_ETH_H)) == -1)
                {
                    fprintf(stderr, 
                            "ERROR: Unable to add TCP options, discarding "
                            "them.\n");
                }
            }

            libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H +
                    ipod->options_s);
            libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_TCP, LIBNET_TCP_H + 
                    LIBNET_DNS_H + pd->payload_s + tcpod->options_s);

            n = libnet_write_link_layer(l2, device, pkt, dns_packetlen);
#ifdef DEBUG
            printf("dns_packetlen (link - TCP) is %u.\n", dns_packetlen);
#endif
            if (verbose == 2)
                hexdump(pkt, dns_packetlen);

            if (n != dns_packetlen)
            {
                fprintf(stderr, "ERROR: Incomplete packet injection.  Only "
                        "wrote %d bytes.\n", n);
            }
            else
            {
                if (verbose)
                    printf("Wrote %d byte DNS (TCP) packet through linktype "
                            "%d.\n", n, l2->linktype);
            }

            libnet_destroy_packet(&pkt);
            libnet_close_raw_sock(sockfd);
            return n;
        }    /* end of TCP */
    }    /* end of datalink */ 
    else    /* IP layer transport */
    {
        int sockbuff = IP_MAXPACKET;

        sockfd = libnet_open_raw_sock(IPPROTO_RAW);

        if (sockfd < 0)
        {
            fprintf(stderr, "ERROR: Unable to allocate a socket descriptor.\n");
            return -1;
        }

        if ((setsockopt(sockfd, SOL_SOCKET, SO_SNDBUF, &sockbuff, 
                sizeof(sockbuff))) < 0)
        {
            fprintf(stderr, "ERROR: setsockopt() failed.\n");
            return -1;
        }

        if (state == 0)    /* UDP */
        {
            dns_packetlen = LIBNET_IP_H + LIBNET_UDP_H + LIBNET_DNS_H + 
                    pd->payload_s + ipod->options_s;

            dns_meta_packetlen = dns_packetlen - LIBNET_IP_H;        

            if (libnet_init_packet(dns_packetlen, &pkt) == -1)
            {
                fprintf(stderr, "ERROR: Unable to allocate packet memory.\n");
                return -1;
            }

            libnet_build_ip(dns_meta_packetlen, ip->ip_tos, ip->ip_id, 
                    ip->ip_off, ip->ip_ttl, IPPROTO_UDP, ip->ip_src.s_addr, 
                    ip->ip_dst.s_addr, NULL, 0, pkt);

            libnet_build_udp(udp->uh_sport, udp->uh_dport, NULL, 0, 
                    pkt + LIBNET_IP_H);

            libnet_build_dns(dns->id, dns->flags, dns->num_q, dns->num_answ_rr,
                             dns->num_auth_rr, dns->num_addi_rr, pd->payload,
                             pd->payload_s, pkt + LIBNET_IP_H + LIBNET_UDP_H);

            libnet_build_dns(dns->id, dns->flags, dns->num_q, dns->num_answ_rr,
                             dns->num_auth_rr, dns->num_addi_rr, pd->payload,
                             pd->payload_s, pkt + LIBNET_IP_H + LIBNET_UDP_H);

            if (got_ipoptions)
            {
                if ((libnet_insert_ipo((struct ipoption *)ipod->options, 
                                ipod->options_s, pkt)) == -1)
                {
                    fprintf(stderr, 
                            "ERROR: Unable to add IP options, discarding "
                            "them.\n");
                }
            }

            libnet_do_checksum(pkt, IPPROTO_UDP, LIBNET_UDP_H + LIBNET_DNS_H + 
                    pd->payload_s);

            n = libnet_write_ip(sockfd, pkt, dns_packetlen);
#ifdef DEBUG
            printf("dns_packetlen (raw - UDP) is %u.\n", dns_packetlen);
#endif
            if (verbose == 2)
                hexdump(pkt, dns_packetlen);

            if (n != dns_packetlen)
            {
                fprintf(stderr, 
                        "ERROR: Incomplete packet injection.  Only wrote %d "
                        "bytes.\n", n);
            }
            else
            {
                if (verbose)
                    printf("Wrote %d byte DNS (UDP) packet\n", n);
            }
            libnet_destroy_packet(&pkt);
            libnet_close_raw_sock(sockfd);
            return n;
        }   /* end of UDP */ 
        else if (state == 1)    /* TCP */
        {
            dns_packetlen = LIBNET_IP_H + LIBNET_TCP_H + LIBNET_DNS_H +
                    pd->payload_s + ipod->options_s;

            dns_meta_packetlen = dns_packetlen - LIBNET_IP_H;        

            if (libnet_init_packet(dns_packetlen, &pkt) == -1)
            {
                fprintf(stderr, "ERROR: Unable to allocate packet memory.\n");
                return -1;
            }

            libnet_build_ip(dns_meta_packetlen, ip->ip_tos, ip->ip_id, 
                    ip->ip_off, ip->ip_ttl, IPPROTO_UDP, ip->ip_src.s_addr, 
                    ip->ip_dst.s_addr, NULL, 0, pkt);

            libnet_build_tcp(tcp->th_sport, tcp->th_dport, tcp->th_seq, 
                    tcp->th_ack, tcp->th_flags, tcp->th_win, tcp->th_urp, 
                    NULL, 0, pkt + LIBNET_IP_H);

            libnet_build_dns(dns->id, dns->flags, dns->num_q, dns->num_answ_rr,
                             dns->num_auth_rr, dns->num_addi_rr, pd->payload,
                             pd->payload_s, pkt + LIBNET_IP_H + LIBNET_TCP_H);

            if (got_ipoptions)
            {
                if ((libnet_insert_ipo((struct ipoption *)ipod->options, 
                                ipod->options_s, pkt)) == -1)
                {
                    fprintf(stderr, 
                            "ERROR: Unable to add IP options, discarding "
                            "them.\n");
                }
            }

            if (got_tcpoptions)
            {
                if ((libnet_insert_tcpo((struct tcpoption *)tcpod->options, 
                                tcpod->options_s, pkt)) == -1)
                {
                    fprintf(stderr, 
                            "ERROR: Unable to add TCP options, discarding "
                            "them.\n");
                }
            }

            libnet_do_checksum(pkt, IPPROTO_TCP, LIBNET_TCP_H + LIBNET_DNS_H + 
                    pd->payload_s + tcpod->options_s);

            n = libnet_write_ip(sockfd, pkt, dns_packetlen);
#ifdef DEBUG
            printf("dns_packetlen (raw - TCP) is %u.\n", dns_packetlen);
#endif
            if (verbose == 2)
                hexdump(pkt, dns_packetlen);

            if (n != dns_packetlen)
            {
                fprintf(stderr, 
                        "ERROR: Incomplete packet injection.  Only wrote %d "
                        "bytes.\n", n);
            }
            else
            {
                if (verbose)
                    printf("Wrote %d byte DNS (TCP) packet\n", n);
            }
            libnet_destroy_packet(&pkt);
            libnet_close_raw_sock(sockfd);
            return n;
        }   /* end of TCP */
    }    /* end of IP layer */
    fprintf(stderr, "ERROR: fatal error - end of protocol builder reached.\n");
    return -1;
}
