/*
 * THE NEMESIS PROJECT
 * Copyright (C) 1999, 2000, 2001 Mark Grimes <obecian@packetninja.net>
 * Copyright (C) 2001 - 2003 Jeff Nathan <jeff@snort.org>
 *
 * nemesis-proto_igmp.c (IGMP Packet Generator)
 *
 */

#include "nemesis-igmp.h"

int buildigmp(ETHERhdr *eth, IPhdr *ip, IGMPhdr *igmp, PayloadData *pd,
        OptionsData *ipod, char *device)
{
    int n;
    u_int32_t igmp_packetlen = 0, igmp_meta_packetlen = 0;
    static int sockfd = -1;
    static u_int8_t *pkt;
    struct libnet_link_int *l2;

    if (pd->payload == NULL)
        pd->payload_s = 0;

    if (ipod->options == NULL)
        ipod->options_s = 0;

    if (got_link)    /* data link layer transport */
    {
        if ((l2 = libnet_open_link_interface(device, errbuf)) == NULL)
        {
            fprintf(stderr, 
                    "ERROR: Unable to open layer 2 device for writing: "
                    "%s.\n", errbuf);
            return -1;
        }

        /* calculate igmp_packetlen before allocating packet memory */
        igmp_packetlen = LIBNET_ETH_H + LIBNET_IP_H + LIBNET_IGMP_H + 
                pd->payload_s + ipod->options_s;

        igmp_meta_packetlen = igmp_packetlen - (LIBNET_ETH_H + LIBNET_IP_H);

        if (libnet_init_packet(igmp_packetlen, &pkt) == -1)
        {
            fprintf(stderr, "ERROR: Unable to allocate packet memory.\n");
            return -1;
        }

        libnet_build_ethernet(eth->ether_dhost, eth->ether_shost, ETHERTYPE_IP, 
                NULL, 0, pkt);

        libnet_build_ip(igmp_meta_packetlen, ip->ip_tos, ip->ip_id, ip->ip_off, 
                ip->ip_ttl, IPPROTO_IGMP, ip->ip_src.s_addr, ip->ip_dst.s_addr, 
                NULL, 0, pkt + LIBNET_ETH_H);

        libnet_build_igmp(igmp->igmp_type, igmp->igmp_code, 
                igmp->igmp_group.s_addr, pd->payload, pd->payload_s, pkt + 
                LIBNET_ETH_H + LIBNET_IP_H);

        if (got_ipoptions)
        {
            if ((libnet_insert_ipo((struct ipoption *)ipod->options, 
                    ipod->options_s, pkt + LIBNET_ETH_H)) == -1)
            {
                fprintf(stderr, "ERROR: Unable to add IP options, discarding "
                    "them.\n");
            }
        }
        libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, LIBNET_IP_H + 
                ipod->options_s);

        libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IGMP, LIBNET_IGMP_H + 
                pd->payload_s + ipod->options_s);

                n = libnet_write_link_layer(l2, device, pkt, igmp_packetlen);
#ifdef DEBUG
        printf("igmp_packetlen is %u.\n", igmp_packetlen);
#endif
        if (verbose == 2)
            hexdump(pkt, igmp_packetlen);

        if (n != igmp_packetlen)
        {
            fprintf(stderr, "ERROR: Incomplete packet injection.  Only wrote "
                    "%d bytes.\n", n);
        }
        else
        {
            if (verbose)
                printf("Wrote %d byte IGMP packet through linktype %s.\n", 
                        n, nemesis_lookup_linktype(l2->linktype));
        } 

        libnet_destroy_packet(&pkt);
        libnet_close_link_interface(l2);
        return (n);

    }   /* end of data link layer */
    else    /* IP layer transport */
    {
        int sockbuff = IP_MAXPACKET;

        sockfd = libnet_open_raw_sock(IPPROTO_RAW);

        if (sockfd < 0)
        {
            fprintf(stderr, "ERROR: Unable to allocate a socket descriptor.\n");
            return -1;
        }

        if ((setsockopt(sockfd, SOL_SOCKET, SO_SNDBUF, &sockbuff,
                sizeof(sockbuff))) < 0)
        {
            fprintf(stderr, "ERROR: setsockopt() failed.\n");
            return -1;
        }

        /* calculate igmp_packetlen before allocating packet memory */
        igmp_packetlen = LIBNET_IP_H + LIBNET_IGMP_H + pd->payload_s + 
                ipod->options_s;

        igmp_meta_packetlen = igmp_packetlen - LIBNET_IP_H;

        if (libnet_init_packet(igmp_packetlen, &pkt) == -1)
        {
            fprintf(stderr, "ERROR: Unable to allocate packet memory.\n");
            return -1;
        }

        libnet_build_ip(igmp_meta_packetlen, ip->ip_tos, ip->ip_id, ip->ip_off, 
                ip->ip_ttl, IPPROTO_IGMP, ip->ip_src.s_addr, ip->ip_dst.s_addr, 
                NULL, 0, pkt);

        libnet_build_igmp(igmp->igmp_type, igmp->igmp_code, 
                igmp->igmp_group.s_addr, pd->payload, pd->payload_s, pkt + 
                LIBNET_IP_H);

        if (got_ipoptions)
        {
            if ((libnet_insert_ipo((struct ipoption *)ipod->options, 
                    ipod->options_s, pkt)) == -1)
            {
                fprintf(stderr, "ERROR: Unable to add IP options, discarding "
                    "them.\n");
            }
        }

        libnet_do_checksum(pkt, IPPROTO_IGMP, LIBNET_IGMP_H + pd->payload_s + 
                ipod->options_s);

        n = libnet_write_ip(sockfd, pkt, igmp_packetlen);
#ifdef DEBUG
        printf("igmp_packetlen is %u.\n", igmp_packetlen);
#endif
        if (verbose == 2)
            hexdump(pkt, igmp_packetlen);

        if (n != igmp_packetlen)
        {
            fprintf(stderr, "ERROR: Incomplete packet injection.  Only wrote "
                    "%d bytes.\n", n);
        }
        else
        {
            if (verbose)
                printf("Wrote %d byte IGMP packet.\n", n);
        }
        libnet_destroy_packet(&pkt);
        libnet_close_raw_sock(sockfd);
        return n;
    }   /* end of IP layer */
    fprintf(stderr, "ERROR: fatal error - end of protocol builder reached.\n");
    return -1;
}
