/*
 * THE NEMESIS PROJECT
 * Copyright (C) 2002, 2003 Jeff Nathan <jeff@snort.org>
 * Original version submitted by ocsic <pisco@private.as>
 *
 * nemesis-proto_ip.c (IP Packet Generator)
 *
 */


#include "nemesis-ip.h"

int buildip(ETHERhdr *eth, IPhdr *ip, PayloadData *pd, OptionsData *ipod, 
        char *device) 
{
    int n = 0;
    u_int32_t ip_packetlen;
    static u_int8_t *pkt;
    static int sockfd = -1;
    char errbuf[256];
    struct libnet_link_int *l2 = NULL;

    if (pd->payload == NULL)
        pd->payload_s = 0;

    if (ipod->options == NULL)
        ipod->options_s = 0;

    if (got_link)    /* data link layer transport */
    {
        if ((l2 = libnet_open_link_interface(device, errbuf)) == NULL)
        {
            fprintf(stderr, 
                    "ERROR: Unable to open layer 2 device for writing: "
                    "%s.\n", errbuf);
            return -1;
        }

        ip_packetlen = LIBNET_ETH_H + LIBNET_IP_H + pd->payload_s + 
            ipod->options_s;

        if (libnet_init_packet(ip_packetlen, &pkt) == -1)
        {
            fprintf(stderr, "ERROR: Unable to allocate packet memory.\n");
            return -1;
        }

        libnet_build_ethernet(eth->ether_dhost, eth->ether_shost, 
                ETHERTYPE_IP, NULL, 0, pkt);

        libnet_build_ip(pd->payload_s, ip->ip_tos, ip->ip_id, ip->ip_off, 
                ip->ip_ttl, ip->ip_p, ip->ip_src.s_addr, ip->ip_dst.s_addr, 
                pd->payload, pd->payload_s, pkt + LIBNET_ETH_H);

        if (got_ipoptions)
        {
            if ((libnet_insert_ipo((struct ipoption *)ipod->options, 
                    ipod->options_s, pkt + LIBNET_ETH_H)) == -1)
            {
                fprintf(stderr, "ERROR: Unable to add IP options, discarding "
                        "them.\n");
            }
        }

        libnet_do_checksum(pkt + LIBNET_ETH_H, IPPROTO_IP, ip_packetlen);

        n = libnet_write_link_layer(l2, device, pkt, ip_packetlen);
#ifdef DEBUG
        printf("ip_packetlen is %u.\n", ip_packetlen);
#endif
        if (verbose == 2)
            hexdump(pkt, ip_packetlen);

        if (n != ip_packetlen)
        {
            fprintf(stderr, "ERROR: Incomplete packet injection.  Only wrote "
                    "%d bytes.\n", n);
        }
        else
        {
            if (verbose)
                printf("Wrote %d byte IP packet through linktype %s.\n", 
                        n, nemesis_lookup_linktype(l2->linktype));
        }

        libnet_destroy_packet(&pkt);
        libnet_close_link_interface(l2);
        return n;
    }   /* end of data link */
    else    /* IP layer transport */
    {
        int sockbuff = IP_MAXPACKET;

        sockfd = libnet_open_raw_sock(IPPROTO_RAW);

        if (sockfd < 0)
        {
            fprintf(stderr, "ERROR: Unable to allocate a socket descriptor.\n");
            return -1;
        }

        if ((setsockopt(sockfd, SOL_SOCKET, SO_SNDBUF, &sockbuff, 
                sizeof(sockbuff))) < 0)
        {
            fprintf(stderr, "ERROR: setsockopt() failed.\n");
            return -1;
        }

        ip_packetlen = LIBNET_IP_H + pd->payload_s + ipod->options_s;

        if (libnet_init_packet(ip_packetlen, &pkt) == -1)
        {
            fprintf(stderr, "ERROR: Unable to allocate packet memory.\n");
            return -1;
        }

        libnet_build_ip(pd->payload_s, ip->ip_tos, ip->ip_id, ip->ip_off, 
                ip->ip_ttl, ip->ip_p, (u_int32_t)ip->ip_src.s_addr, 
                (u_int32_t)ip->ip_dst.s_addr, pd->payload, pd->payload_s, pkt);

        if (got_ipoptions)
        {
            if ((libnet_insert_ipo((struct ipoption *)ipod->options, 
                            ipod->options_s, pkt)) == -1)
            {
                fprintf(stderr, "ERROR: Unable to add IP options, discarding "
                        "them.\n");
            }
        }

        n = libnet_write_ip(sockfd, pkt, ip_packetlen);
#ifdef DEBUG
        printf("ip_packetlen is %u.\n", ip_packetlen);
#endif
        if (verbose == 2)
            hexdump(pkt, ip_packetlen);

        if (n != ip_packetlen)
        {
            fprintf(stderr, "ERROR: Incomplete packet injection.  Only wrote "
                    "%d bytes.\n", n);
        }
        else
        {
            if (verbose)
                printf("Wrote %d byte IP packet\n", n);
        }
        libnet_destroy_packet(&pkt);
        libnet_close_raw_sock(sockfd);
        return n;
    }    /* end of IP layer */
    fprintf(stderr, "ERROR: fatal error - end of protocol builder reached.\n");
    return -1;
}
