/* THE NEMESIS PROJECT
 * Copyright (C) 2001 - 2003 Jeff Nathan <jeff@snort.org>
 *
 * nemesis.h
 *
 */

#ifndef __NEMESIS_H__
#define __NEMESIS_H__

#include <libnet.h>

#ifdef HAVE_CONFIG_H
    #include "config.h"
#endif

#define BUILD 15
#define PAYLOADMODE 0
#define OPTIONSMODE 1
#define OPTIONSBUFFSIZE 40

#define ARPBUFFSIZE 1472
#define DNSTCPBUFFSIZE 65403    /* plan for IP and TCP options */
#define DNSUDPBUFFSIZE 65455    /* plan for IP options */
#define ETHERBUFFSIZE 1500      /* max frame size */
#define ICMPBUFFSIZE 65387      /* plan for IP options & max ICMP header len */
#define IGMPBUFFSIZE 65467      /* plan for IP options */
#define IPBUFFSIZE 65475        /* plan for IP options */
#define RIPBUFFSIZE 65451       /* plan for IP options */
#define TCPBUFFSIZE 65415       /* plan for IP and TCP options */
#define UDPBUFFSIZE 65467       /* plan for IP options */

#define ECHO        0x01
#define MASK        0x02
#define UNREACH     0x04
#define TIMEEXCEED  0x08
#define REDIRECT    0x10
#define TIMESTAMP   0x20

typedef struct libnet_arp_hdr ARPhdr;
typedef struct libnet_as_lsa_hdr ASLSAhdr;
typedef struct libnet_auth_hdr AUTHhdr;
typedef struct libnet_dbd_hdr DBDhdr;
typedef struct libnet_dns_hdr DNShdr;
typedef struct libnet_ethernet_hdr ETHERhdr;
typedef struct libnet_icmp_hdr ICMPhdr;
typedef struct libnet_igmp_hdr IGMPhdr;
typedef struct libnet_ip_hdr IPhdr;
typedef struct libnet_lsa_hdr LSAhdr;
typedef struct libnet_lsr_hdr LSRhdr;
typedef struct libnet_lsu_hdr LSUhdr;
typedef struct libnet_ospf_hdr OSPFhdr;
typedef struct libnet_ospf_hello_hdr OSPFHELLOhdr;
typedef struct libnet_net_lsa_hdr NETLSAhdr;
typedef struct libnet_rip_hdr RIPhdr;
typedef struct libnet_rtr_lsa_hdr RTRLSAhdr;
typedef struct libnet_sum_lsa_hdr SUMLSAhdr;
typedef struct libnet_tcp_hdr TCPhdr;
typedef struct libnet_udp_hdr UDPhdr;
typedef struct libnet_vrrp_hdr VRRPhdr;

extern char zero[6];
extern char one[6];
extern char title[81];
extern char errbuf[256];
extern char *pcap_outfile;
extern const char *version;

typedef struct _PayloadData
{
    int32_t payload_s;      /* payload size */
    u_int8_t *payload;    /* pointer to payload memory */
} PayloadData;

typedef struct _OptionsData
{
    int32_t options_s;      /* options size */
    u_int8_t *options;    /* pointer to options memory */
} OptionsData;

typedef struct _ICMPtypecode
{
    int8_t itype[81];    /* ICMP type string */
    int8_t icode[81];    /* ICMP code string */
} ICMPtypecode;

/* support functions */
u_int32_t xgetint32(const char *);
u_int16_t xgetint16(const char *);
u_int8_t xgetint8(const char *);
void hexdump(char *, u_int32_t);
int readfile(u_int8_t *, char *, u_int32_t, u_int32_t);
int nemesis_name_resolve(char *, u_int32_t *);
int nemesis_check_link(ETHERhdr *, char *);
char *nemesis_lookup_linktype(int);
int nemesis_seedrand(void);
int gmt2local(time_t);

void maketitle(char *, const char *, const char *);
void nemesis_usage(char *);

/* printout functions */
void printmac(ETHERhdr);
void printip(IPhdr);
void printtcp(TCPhdr);
void printicmp(ICMPhdr, int);

/* injection functions */
int nemesis_arp(int, char **);
int nemesis_dns(int, char **);
int nemesis_ethernet(int, char **);
int nemesis_icmp(int, char **);
int nemesis_igmp(int, char **);
int nemesis_ip(int, char **);
int nemesis_ospf(int, char **);
int nemesis_rip(int, char **);
int nemesis_tcp(int, char **);
int nemesis_udp(int, char **);

#endif /* __NEMESIS_H__ */
