/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_die.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_die.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_die.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:26  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"


extern void 
DieWithVersion(void) {
  printf("You are using Rain %s, Compiled %s %s\n", RAIN_VERSION, __DATE__, __TIME__);
  exit(0);
}

extern void 
DieWithError(char *error) {
  fprintf(stderr,"\n- - Error: %s", error);
  if(errno != 0) fprintf(stderr," (%s)\n", strerror(errno));
  else fprintf(stderr,"\n");
  exit(1);
}

extern void
DieWithIncompatible(char *arg1, char *arg2) {
  fprintf(stderr,"- - Error: %s is not compatible with %s\n", arg1, arg2); 
  exit(1);
}

extern void 
DieWithBadArg(char *arg) {
    fprintf(stderr,"- - Error: %s is not recognized\n", arg);
    exit(1);
}

extern void 
DieWithRequire(char *arg) {
    fprintf(stderr,"- - Error: %s requires an argument\n", arg);
    exit(1);
}

extern void 
DieWithUsage(char *program) {
  fprintf(stderr,"Usage: %s [options] -t <target-host>\n"
                 "Try %s --help for a list of options.\n", program, program);
  exit(1);
}

/* help menu */
extern void 
DieWithHelp(char *program, char *topic) {
  int i = 0;
  static unsigned char siminfo[4][16] = {
    "fawx2.c",
    "bloop.c",
    "jolt2.c",
    "trash2.c"
  };

  if(topic == NULL) {
    printf("Usage: %s [options] -t <target-host>\n", program);
    printf("options:\n"
	   "  -c      <value>             Specifies how many packets to send; 0 for infinite; Default is 0\n"
           "  -d      <delay>             Specifies delay (in microseconds) between sends; Default is 15000\n"
           "  -s      <spoofed-hostname>  Specifies source address (--help -s); Default is random IP\n"
           "  -t      <target-hostname>   Specifies target address\n"
           "  --size  <bytes>             Specifies packet size in bytes; Default is 1024\n"
           "  --dport <target-port>       Specifies port on target host; Default is 138\n"
           "  --sport <source-port>       Specifies port on local host; Default is 420\n"
           "  --sim   <sim-type>          Simulate other known attacks (--help --sim for a list of attacks)\n"     
           "\n"
           "  --udp                       Use UDP shower\n"
           "\n"
           "  --tcp                       Use TCP shower (Default)\n"
           "    --win <value>             Specifies the TCP window size; Default is 56\n"
           "    --urg                     Use TCP URG shower\n"
           "    --ack                     Use TCP ACK shower\n"
           "    --psh                     Use TCP PSH shower\n"
           "    --rst                     Use TCP RST shower\n"
           "    --syn                     Use TCP SYN shower (Default)\n"
           "    --fin                     Use TCP FIN shower\n"
           "\n"
           "  --icmp                      Use ICMP shower\n"
           "    --icmp-type <value>       Set ICMP type (--help --icmp-type)\n"
           "    --icmp-code <value>       Set ICMP code (--help --icmp-code)\n"
           "\n"
           "  --igmp                      Use IGMP shower\n"
           "    --igmp-type <value>       Set IGMP type (--help --igmp-type)\n"
           "    --igmp-code <value>       Set IGMP code (--help --igmp-code)\n"
           "    --id-of                   When specified, rain will overflow the id field of the packet by\n"
           "                              increasing it with each send by one (used with -c 0). IGMP only.\n"
           "\n"
           "  --frag  <value>             Set fragment offset; Default is 0 (--help --frag)\n"
           "  --tos   <value>             Specifies Type of Service value (--help --tos)\n"
           "  --ttl   <value>             Specifies the Time to Live of the packet; Default is 64\n"
           "  --id    <value>             Specifies the id sequence of the packet; Default is the process ID\n"
           "\n"
           "  --version | -v              Prints version information\n"
           "  --help                      Prints this help menu\n"
           "Try %s --help <option> for more information about specific options.\n",
           program);
  }
  else {
    if(strcmp(topic,"--sim") == 0) { /* -s */
      printf("\nUsage: --sim <sim-type>\n"
             "This option causes rain to simulate the specified attack.\n"
             "Possible values are:\n");
      for(; i < 4; i++) printf("\t%d - %s\n", i, siminfo[i]);
      printf("\n");
      exit(0);
    }
    if(strcmp(topic,"-s") == 0) { /* -s */
      printf("\nUsage: -s <spoofed-hostname>\n"
             "This specifies the source address to use in packet sending.\n"
             "Be aware that alot of routers will not forward packets with a source "
             "address is not a node in the sender's subnet address, \n"
             "in which case the packets will never arrive at the target host.\n\n");
      exit(0);
    }
    if(strcmp(topic,"--icmp-type") == 0) {
      printf("\nUsage: --icmp-type <ICMP-type>\n"
             "This specifies the type of ICMP packet to send.\n"
             "Please see RFC 792 (http://www.rfc-editor.org/rfcsearch.html) for a list of"
             " available types and an explanation of each.\n\n");
      exit(0);
    }
    if(strcmp(topic,"--icmp-code") == 0) {
      printf("\nUsage: --icmp-code <ICMP-code>\n"
             "This specifies the code in the ICMP packet to send.\n"
             "Please see RFC 792 (http://www.rfc-editor.org/rfcsearch.html) for a list of"
             " available codes and an explanation of each."
             "\nEach ICMP type has a set of codes.\n"
             "If an invalid code or type is specified, rain will exit.\n\n");
      exit(0);
    }
    if(strcmp(topic,"--igmp-type") == 0) {
      printf("\nUsage: --igmp-type <IGMP-type>\n"
             "This specifies the type of IGMP packet to send.\n"
             "Please see RFC 2236 (http://www.rfc-editor.org/rfcsearch.html) for a list of"
             " available types and an explanation of each.\n\n");
      exit(0);
    }
    if(strcmp(topic,"--igmp-code") == 0) {
      printf("\nUsage: --igmp-code <IGMP-code>\n"
             "This specifies the code in the ICMP packet to send.\n"
             "Please see RFC 2236 (http://www.rfc-editor.org/rfcsearch.html) for a list of"
             " available codes and an explanation of each."
             "\nEach IGMP type has a set of codes.\n"
             "If an invalid code or type is specified, rain will exit.\n\n");
      exit(0);
    }
    if(strcmp(topic,"--frag") == 0) { /* --frag */
      printf("\nUsage: --frag <fragment-offset>\n"
             "This specifies where in the IP datagram each fragment belongs.\n"
             "It is recommended you do not use this option unless you are confident "
             "with what you are doing.\n\n");
     exit(0);
    }
    if(strcmp(topic,"--tos") == 0) {  /* --tos */
      printf("\nUsage: --tos <type-of-service>\n"
             "This specifies the value of the tos field in the IP header.\n"
             "It is recommended you do not use this option unless you are confident "
             "with what you are doing.\n\n");
      exit(0);
    }
    else { fprintf(stderr,"\n- - No help available for %s\n", topic); }
  }
  exit(0);
}


/* EOF */
