/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_icmp.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_icmp.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_icmp.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:26  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"

extern void
icmp_info_init(struct pkt_info_icmp *pkticmp) {

  switch(pkticmp->type) {
    case 0:
    case 3:
    case 4:
    case 5:
    case 8:
    case 11:
    case 12:
    case 13:
    case 15:
    case 16:{ break; }
    default: { DieWithError("unknown ICMP type"); }
  }


/* type 0: echo reply */
  if((pkticmp->type == 0) && (pkticmp->code != 0))
    DieWithError("ICMP type 0 must have code 0");
  strcpy(icmpinfo[0][0]," echo reply"); 


/* type: 3 (unreachable) */
  if((pkticmp->type == 3) && (pkticmp->code > 5))
    DieWithError("unknown ICMP code (Unreachable must be 0-5)");
  strcpy(icmpinfo[3][0], " network unreachable");
  strcpy(icmpinfo[3][1], " host unreachable");
  strcpy(icmpinfo[3][2], " protocol unreachable");
  strcpy(icmpinfo[3][3], " port unreachable");
  strcpy(icmpinfo[3][4], " frag needed&DF set");
  strcpy(icmpinfo[3][5], " source route failed");

/* type 4: source quench */
  if((pkticmp->type == 4) && (pkticmp->code != 0))
    DieWithError("ICMP type 4 must have code 0");
  strcpy(icmpinfo[4][0], " source quench message");

/* type 5: redirect */
  if((pkticmp->type == 5) && (pkticmp->code > 3))
    DieWithError("unknown ICMP code (Redirect must be 0-3)");
  strcpy(icmpinfo[5][0]," redirect dgrams for network");
  strcpy(icmpinfo[5][1]," redirect dgrams for host");
  strcpy(icmpinfo[5][2]," redirect dgrams for ToS and network");
  strcpy(icmpinfo[5][3]," redirect dgrams for Tos and host");

/* type 8: echo or echo reply */
  if((pkticmp->type == 8) && (pkticmp->code != 0))
    DieWithError("ICMP type 8 must have code 0");
  strcpy(icmpinfo[8][0]," echo request"); 

/* type 11: time exceeded */
  strcpy(icmpinfo[11][0], " ttl exceeded in transit");
  strcpy(icmpinfo[11][1], " fragment reassembly time exceeded");

/* type 12: parameter problem */
  if((pkticmp->type == 12) && (pkticmp->code != 0))
    DieWithError("ICMP type 12 must have code 0");
  strcpy(icmpinfo[12][0]," parameter problem message");

/* type 13: timestamp message */
  if((pkticmp->type == 13) && (pkticmp->code != 0))
    DieWithError("ICMP type 13 must have code 0");
  strcpy(icmpinfo[13][0]," timestamp");

/* type 14: timestamp reply */
  if((pkticmp->type == 14) && (pkticmp->code != 0))
    DieWithError("ICMP type 14 must have code 0");
  strcpy(icmpinfo[14][0]," timestamp reply");

/* type 15: info request */
  if((pkticmp->type == 15) && (pkticmp->code != 0))
    DieWithError("ICMP type 15 must have code 0");
  strcpy(icmpinfo[15][0]," information request");

/* type 16: info reply */
  if((pkticmp->type == 16) && (pkticmp->code != 0))
    DieWithError("ICMP type 16 must have code 0");
  strcpy(icmpinfo[16][0]," information reply");
  

  if (errno != 0) DieWithError("could not initialize icmpinfo array");
}

extern int
icmp_shower(int raw_socket, struct sockaddr_in *source, struct sockaddr_in *target, struct pkt_info *pkt, struct pkt_info_icmp *pkticmp) {
  char *buffer = malloc(sizeof(char)*packetsize);
  struct ipicmp *ip_icmp = (struct ipicmp*)buffer;  
  struct iphdr *ip  = &ip_icmp->ip;
  struct icmphdr *icmp = &ip_icmp->icmp;

  memset(buffer, 0xFF, (sizeof(char)*packetsize));

  pkt->tot_len = (sizeof(struct icmp) + strlen(buffer));

  icmp->type    = pkticmp->type;
  icmp->code    = pkticmp->code;
  if((icmp->type == 13) || (icmp->code == 14)) {
    icmp->un.echo.id = htons(getpid());
    icmp->un.echo.sequence = htons(getpid());
  }
  icmp->checksum = in_cksum((u_short*)icmp, sizeof(struct icmp));

  pkt->tot_len += (sizeof(struct iphdr));
  
  ip->version  = 4;
  ip->ihl      = (sizeof(struct iphdr) >> 2);
  ip->tos      = pkt->tos;
  ip->tot_len  = htons(pkt->tot_len);
  ip->id       = htons(pkt->id);
  if(pkt->frag == 1) {
    ip->frag_off  = htons(pkt->frag_off); /* set fragment offset */
    ip->frag_off |= htons(0x2000);  /* set fragment bit */
  } else {
    ip->frag_off = 0x0;  /* don't fragment */
  }
  ip->ttl      = pkt->ttl;
  ip->protocol = IPPROTO_ICMP;
  ip->saddr    = source->sin_addr.s_addr;
  ip->daddr    = target->sin_addr.s_addr;
  ip->check    = in_cksum((u_short*)ip,sizeof(ip));

 
  while(packets_sent < pkt->num) {
    if(sendto(raw_socket,
              ip_icmp,
              pkt->tot_len,
              0,
              (struct sockaddr*)target,
              sizeof(struct sockaddr_in)) < 0) return -1;
    packets_sent++;
    usleep(pkt->delay);
  }

  return 0;
}




/* EOF */
