/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_command_line.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_command_line.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_command_line.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:26  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"

void parse_command_line(int argc, char **argv,
                        struct pkt_info *pkt,
                        struct pkt_info_tcp  *pkttcp,
                        struct pkt_info_icmp *pkticmp,
                        struct pkt_info_igmp *pktigmp,
                        u_short *have_target_host)
{
  int i = 0;
  
  while(i < argc) {
    if( (argv[i][0] == '-')  && (strlen(argv[i]) == 2) ) {
      switch(argv[i][1]) {
	case 'C':
	case 'c':{
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
	  pkt->num = atoi(argv[i + 1]);
	  if(pkt->num == 0) pkt->num = -1;
	  break;
	}
        case 'D':
        case 'd':{
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pkt->delay = (u_long)atol(argv[i + 1]);
          break;
        }
        case 'P':
        case 'p':{
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pkt->dport = (u_int16_t)atoi(argv[i + 1]);
          break;
        }          

        case 'S':
        case 's':{
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          strcpy(pkt->saddr, argv[i + 1]);
          pkt->randip = 0;
          break;
        }
        case 'T':
        case 't':{
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          strcpy(pkt->daddr, argv[i + 1]);
          *have_target_host = TRUE;
          break;
        }
        case 'V':
        case 'v':{
          DieWithVersion();
        }
        default:{
          DieWithBadArg(argv[i]);
        }
      }
    } else if ( (argv[i][0] == '-')  && (strlen(argv[i]) > 2) ) {
        if(strcmp(argv[i], "--help") == 0) {
          if(argv[i + 1] == NULL) DieWithHelp(argv[0], NULL);
          else DieWithHelp(argv[0], argv[i + 1]);
        }
        else if(strcmp(argv[i], "--size") == 0) {
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          packetsize = (u_int16_t)atoi(argv[i + 1]);
        }
        else if(strcmp(argv[i], "--dport") == 0) {
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pkt->dport = (u_int16_t)atoi(argv[i + 1]);
        }
        else if(strcmp(argv[i], "--sport") == 0) {
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pkt->sport = (u_int16_t)atoi(argv[i + 1]);
        }
        else if(strcmp(argv[i], "--sim") == 0) {
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pkt->simulate = 1;
          pkt->simtype  = atoi(argv[i + 1]);
          switch(pkt->simtype) {

            /* fawx2.c */
            case 0: { pkt->type = IGMP; pktigmp->type = 2; pktigmp->code = 31; pkt->frag = 1; 
                      pkt->frag_off = htons(0|0x2000); pkt->id = 27565; pkt->tos = 0; 
            break; }

            /* bloop.c */
            case 1: { pkt->type = ICMP; pkticmp->type = 12; pkticmp->code = 0; pkt->frag = 1; pkt->frag_off = (8>>3); 
            pkt->tos = 0; break; }

            /* jolt2.c */
            case 2: { pkt->type = ICMP; pkticmp->type = 8; pkticmp->code = 0; pkt->frag = 1; pkt->frag_off = 8190;
            pkt->tos = 0; break; }
            
            /* trash2.c */
            case 3: { pkt->type = IGMP; pktigmp->type = 0; pktigmp->code = 0; pkt->randip = 1; pkt->frag = 1; 
                      pkt->frag_off = 0x2000; 
            pkt->tos = 0; break; }
           
            default: { DieWithError("Uncrecognized simulation type. Try --help --sim\n"); }
          }
        }
        else if(strcmp(argv[i], "--udp") == 0) {
          if(pkt->type != DEFAULT) DieWithError("conflicting protocol types");
          pkt->type = UDP;
        }
        else if(strcmp(argv[i], "--tcp") == 0) {
          if(pkt->type != DEFAULT) DieWithError("conflicting protocol types");
          pkt->type = TCP;
        }
        else if(strcmp(argv[i], "--win") == 0) {
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pkt->type = TCP;
          pkt->window = (u_int16_t)atoi(argv[i + 1]);
        }
        else if(strcmp(argv[i], "--urg") == 0) {
          if(pkttcp->beenset == 1) DieWithError("conflicting TCP flags");
          pkt->type = TCP;
          pkttcp->syn = 0; /* turn off default */
          pkttcp->beenset = 1;
          pkttcp->urg = 1;
        }
        else if(strcmp(argv[i], "--ack") == 0) {
          if(pkttcp->beenset == 1) DieWithError("conflicting TCP flags");
          if(pkt->simulate == 1) DieWithError("arguments conflict with simulation mode");
          pkt->type = TCP;
          pkttcp->syn = 0; /* turn off default */
          pkttcp->beenset = 1;
          pkttcp->ack = 1;
        }
        else if(strcmp(argv[i], "--psh") == 0) {
          if(pkttcp->beenset == 1) DieWithError("conflicting TCP flags");
          pkt->type = TCP;
          pkttcp->syn = 0; /* turn off default */
          pkttcp->beenset = 1;
          pkttcp->psh = 1;
        }
        else if(strcmp(argv[i], "--rst") == 0) {
          if(pkttcp->beenset == 1) DieWithError("conflicting TCP flags");
          pkt->type = TCP;
          pkttcp->syn = 0; /* turn off default */
          pkttcp->beenset = 1;
          pkttcp->rst = 1;
        }
        else if(strcmp(argv[i], "--syn") == 0) {
          if(pkttcp->beenset == 1) DieWithError("conflicting TCP flags");
          pkt->type = TCP;
          pkttcp->syn = 0; /* turn off default */
          pkttcp->beenset = 1;
          pkttcp->syn = 1;
        }
        else if(strcmp(argv[i], "--fin") == 0) {
          if(pkttcp->beenset == 1) DieWithError("conflicting TCP flags");
          pkt->type = TCP;
          pkttcp->syn = 0; /* turn off default */
          pkttcp->beenset = 1;
          pkttcp->fin = 1;
        }      
        else if(strcmp(argv[i], "--icmp") == 0) {
          if(pkt->type != DEFAULT) DieWithError("conflicting protocol types");
          pkt->type = ICMP;
        }
        else if(strcmp(argv[i], "--icmp-type") == 0) {
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pkticmp->type = atoi(argv[i + 1]);
        }
        else if(strcmp(argv[i], "--icmp-code") == 0) {
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pkticmp->code = atoi(argv[i + 1]);
        }
        else if(strcmp(argv[i], "--igmp") == 0) {
          if(pkt->type != DEFAULT) DieWithError("conflicting protocol types");
          pkt->type = IGMP;
        }
        else if(strcmp(argv[i], "--igmp-type") == 0) {
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pktigmp->type = atoi(argv[i + 1]);
        }
        else if(strcmp(argv[i], "--igmp-code") == 0) {
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pktigmp->code = (u_int8_t)atoi(argv[i + 1]);
        }
        else if(strcmp(argv[i], "--frag") == 0) {
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pkt->frag = 1;
          pkt->frag_off = (u_int16_t)atoi(argv[i + 1]);
        }
        else if(strcmp(argv[i], "--tos") == 0) {
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pkt->tos = (u_short)atoi(argv[i + 1]);
        }
        else if(strcmp(argv[i], "--ttl") == 0) {
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pkt->ttl = (u_int8_t)atoi(argv[i + 1]);
        }
        else if(strcmp(argv[i], "--id") == 0) {
          if((argv[i + 1] == NULL) || (argv[i + 1][0] == '-')) DieWithRequire(argv[i]);
          pkt->id = atoi(argv[i + 1]);
        }
        else if(strcmp(argv[i], "--id-of") == 0) {
          pkt->id_of = 1;
        }
        else if(strcmp(argv[i], "--version") == 0) {
          DieWithVersion();
        } 
        else { DieWithBadArg(argv[i]); } 
      }
    i++;
  }

  return;
}
