/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_signal.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_signal.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_signal.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:26  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"

extern void 
signal_init(void) {
  struct sigaction sa_old, sa_new;
  /* signal handling */
  sa_new.sa_handler = catch_signal;
  sigemptyset(&sa_new.sa_mask);
  sa_new.sa_flags = 0;
  sigaction(SIGINT,&sa_new,&sa_old);
  sigaction(SIGHUP,&sa_new,&sa_old);
  sigaction(SIGPIPE,&sa_new,&sa_old);
  sigaction(SIGALRM,&sa_new,&sa_old);
}

extern void 
catch_signal(int signo) {
  time_t total;
  float kbps = 0.0;
  u_long total_size;

  switch(signo) {
    case SIGINT: {
      send_finish = time(NULL);
      total = (send_finish - send_start);
      if(packets_sent > 100) {
        /* We must do this to avoid a floating point exception */
        total_size = (packetsize*packets_sent);
        kbps  = (float)(total_size/total)/1024;
      }
      printf("\tThe rain has stopped. %lu drops fell in %ld minutes, %ld seconds (%.1fkBps)\n}\n",
             packets_sent, (total/60), (total%60), kbps);
      exit(0);
    }
    default: {
      fprintf(stderr,"- - Caught signal %d; Exiting...\n", signo);
      exit(1);
    }
  }
}

/* EOF */
