/*--------------------------------------------------*
 * $Header: /usr/src/Projects/rain/RCS/rain_icmpv6.c,v 1.1 2001/06/11 20:44:09 root Exp root $
 * $Author: root $
 * rain_icmpv6.c
 * rain - by Evil (mystic@tenebrous.com)
 * A flexible packet flooder for testing stability.
 * Copyright(c) 2001
 * Licensed under the GNU General Public License
 *
 * $Log: rain_icmp.c,v $
 * Revision 1.1  2001/06/11 20:44:09  root
 * Initial revision
 *
 * Revision 1.1  2001/06/11 02:59:26  root
 * Initial revision
 *
 *-------------------------------------------------*/

#include "rain_common.h"

#if defined(RAIN_IPV6)

extern void
icmp6_info_init(struct pkt_info_icmp6 *pkticmp6) {

  switch(pkticmp6->type) {
    case 1:
    case 2:
    case 3:
    case 4:
    case 128:
    case 129:
    case 130:
    case 131:
    case 132: { break; }
    default: { DieWithError("unknown ICMPv6 type"); }
  }

}

extern int
icmp6_shower(int raw_socket,
 struct sockaddr_in *source, 
 struct sockaddr_in6 *target, 
 struct pkt_info *pkt, 
 struct pkt_info_icmp6 *pkticmp6) 
{

  struct ipicmp6 *ip_icmp6 = (struct ipicmp6*)buffer;  
  struct ip6_hdr *ip6      = &ip_icmp6->ip6;
  struct icmp6_hdr *icmp6  = &ip_icmp6->icmp6;

  buffer   = malloc(sizeof(char)*packetsize);
  ip_icmp6 = (struct ipicmp6*)buffer;
  ip6      = &ip_icmp6->ip6;
  icmp6    = &ip_icmp6->icmp6;

  memset(buffer, 0xFF, (sizeof(char)*packetsize));

  pkt->tot_len = (sizeof(struct icmp6_hdr) + (sizeof(char)*packetsize));


  ip6->ip6_vfc  = 6; /* IPv6 */
  ip6->ip6_hops = htons(pkt->ttl);
  ip6->ip6_nxt  = IPPROTO_ICMP;

  return 0;
}

#endif



/* EOF */
